//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_MBWS_HH 
#define BMP_MBWS_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glibmm.h>
#include <glibmm/markup.h>

#include <boost/format.hpp>
#include <boost/optional.hpp>

#include "library.hh"

namespace Bmp
{
  namespace MusicBrainzXML
  {
    struct MBTrack
    {
      Glib::ustring track_id;
      Glib::ustring track_title;

      Glib::ustring artist_name;
      Glib::ustring artist_id;

      boost::optional<Glib::ustring> artist_sort_name; 
      boost::optional<Glib::ustring> release_id; 

      guint64 tracknumber;
      guint64 duration;
    };
    typedef std::vector < MBTrack > MBTrackV;
 
    struct MBRelease
    {
      Glib::ustring release_id;
      Glib::ustring release_title;

      Glib::ustring artist_id;
      Glib::ustring artist_name;

      boost::optional<guint64>        disc_list;
      boost::optional<guint64>        track_list;
      boost::optional<guint64>        score;
      boost::optional<Glib::ustring>  asin;
      boost::optional<Glib::ustring>  date;
      boost::optional<MBTrackV>       tracks;
      boost::optional<Glib::ustring>  artist_sort_name;
    };
    typedef std::vector < MBRelease > MBReleaseV;

    void
    mb_releases_by_id  (Glib::ustring const& mb_release_id,
                        MBReleaseV& releases);

    void
    mb_tracks_by_puid  (Glib::ustring const& puid,
                        MBTrackV& tracks);

    void
    mb_query_releases  (Glib::ustring const& artist,
                        Glib::ustring const& album,
                        MBReleaseV& releases);


    class MBReleaseParser 
    : public Glib::Markup::Parser
    {
      public:

        MBReleaseParser (MBReleaseV& releases); 
        virtual ~MBReleaseParser ();

        void
        check_sanity ();

      protected:

        virtual void
        on_start_element  (Glib::Markup::ParseContext& context,
                           Glib::ustring const& elementname,
                           const AttributeMap& attributes);
        virtual void
        on_end_element    (Glib::Markup::ParseContext& context,
                           Glib::ustring const& elementname);
        virtual void
        on_text	          (Glib::Markup::ParseContext& context,
                           Glib::ustring const& text);
        virtual void
        on_passtrough     (Glib::Markup::ParseContext& context,
                           Glib::ustring const& text);
        virtual void
        on_error	        (Glib::Markup::ParseContext& context,
                           const Glib::MarkupError& error);
      private:

        MBReleaseV &m_releases;

        enum Element
        {
          E_NONE	              = 0, 
          E_TRACK_LIST          = 1 << 0,
          E_TRACK               = 1 << 1,
          E_TITLE               = 1 << 2,
          E_DURATION            = 1 << 3,
          E_ARTIST              = 1 << 4,
          E_NAME                = 1 << 5,
          E_SORT_NAME           = 1 << 6,
          E_RELEASE_LIST        = 1 << 7,
          E_RELEASE             = 1 << 8,
          E_DISC_LIST           = 1 << 9,
          E_ASIN                = 1 << 10,
          E_RELEASE_EVENT_LIST  = 1 << 11,
          E_EVENT               = 1 << 12
        };

        MBRelease c_release;
        MBTrack   c_track;

        int   state;
        int   tracknum;
        bool  has_offset;
    };

    class MBTracksParser 
    : public Glib::Markup::Parser
    {
      public:

        MBTracksParser (MBTrackV& tracks); 
        virtual ~MBTracksParser ();

        void
        check_sanity ();

      protected:

        virtual void
        on_start_element  (Glib::Markup::ParseContext& context,
                           Glib::ustring const& elementname,
                           const AttributeMap& attributes);
        virtual void
        on_end_element    (Glib::Markup::ParseContext& context,
                           Glib::ustring const& elementname);
        virtual void
        on_text	          (Glib::Markup::ParseContext& context,
                           Glib::ustring const& text);
        virtual void
        on_passtrough     (Glib::Markup::ParseContext& context,
                           Glib::ustring const& text);
        virtual void
        on_error	        (Glib::Markup::ParseContext& context,
                           const Glib::MarkupError& error);
      private:

        MBTrackV &m_tracks;

        enum Element
        {
          E_NONE	        = 0, 
          E_TRACK_LIST    = 1 << 0,
          E_TRACK         = 1 << 1,
          E_TITLE         = 1 << 2,
          E_DURATION      = 1 << 3,
          E_ARTIST        = 1 << 4,
          E_NAME          = 1 << 5,
          E_SORT_NAME     = 1 << 6,
          E_RELEASE_LIST  = 1 << 7,
          E_RELEASE       = 1 << 8,
        };

        MBTrack c_track;

        int   state;
        int   tracknum;
        bool  has_offset;
    };
  }
}

/// Auxilliaries

namespace Bmp
{
  namespace MusicBrainzXML
  {
    void mb_track_to_update_track (MBTrack const& track, Bmp::Library::UTrack &update_track);
    void mb_release_to_update_track (MBRelease const& release, Bmp::Library::UTrack &update_track);
  }
}


#endif
