//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glibmm.h>
#include <glibmm/i18n.h>
#include <gtkmm.h>
#include <libglademm.h>

#include <cstring>
#include <iostream>
#include <sstream>
#include <string>

#include "dialog-gsterror.hh"
#include "paths.hh"
#include "util.hh"
#include "ui_toolbox.hh"


namespace Bmp
{

  DialogGSTError::~DialogGSTError ()
  {
  }

  DialogGSTError*
  DialogGSTError::create ()
  {
      const std::string path = BMP_GLADE_DIR G_DIR_SEPARATOR_S "dialog-gsterror.glade";

      Glib::RefPtr<Gnome::Glade::Xml> glade_xml = Gnome::Glade::Xml::create (path);
      DialogGSTError *dialog = 0;
      glade_xml->get_widget_derived ("dialog-gsterror", dialog);
      return dialog;
  }

  DialogGSTError::DialogGSTError (BaseObjectType                        *cobject,
                                  const Glib::RefPtr<Gnome::Glade::Xml> &xml)
      : Gtk::Dialog     (cobject),
        m_ref_xml         (xml)
  {
      Util::window_set_icon_list (GTK_WIDGET (this->gobj()), "player");
  }

  int
  DialogGSTError::run (Glib::ustring const& main,
                       Glib::ustring const& element,
                       Glib::ustring const& uri,
                       Glib::ustring const& details,
                       Glib::ustring const& helpstring)

  {
      dynamic_cast<Gtk::Label *>(m_ref_xml->get_widget ("label-main"))->set_markup ("<b>"+Glib::Markup::escape_text(main)+"</b>");
      dynamic_cast<Gtk::Label *>(m_ref_xml->get_widget ("label-element"))->set_markup ("<i>"+Glib::Markup::escape_text(element)+"</i>");
      dynamic_cast<Gtk::Label *>(m_ref_xml->get_widget ("label-uri"))->set_markup ("<i>"+Glib::Markup::escape_text(uri)+"</i>");
      dynamic_cast<Gtk::Label *>(m_ref_xml->get_widget ("label-details"))->set_markup ("<i>"+Glib::Markup::escape_text(details)+"</i>");
      if (!helpstring.empty()) dynamic_cast<Gtk::Label *>(m_ref_xml->get_widget ("label-helptext"))->set_text (helpstring);

      return Gtk::Dialog::run ();
  }

} // namespace Bmp
