#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>

#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <taglib/fileref.h>

// Plugin-specific include
#include <taglib/taglib.h>
#include <taglib/fileref.h>
#include <taglib/tfile.h>
#include <taglib/tag.h>

#include <taglib/oggfile.h>
#include <taglib/vorbisfile.h>
#include <taglib/vorbisproperties.h>
#include <taglib/xiphcomment.h>

#include <taglib/flacfile.h>
#include <taglib/mpegfile.h>
#include <taglib/id3v2tag.h>

#include <boost/format.hpp>
static boost::format fsizefmt ("%llu");

extern "C" int  _plugin_has_accessors; 
int  _plugin_has_accessors = 1;

#include <bmp/database_types.hh>
#include <bmp/library_types.hh>
#include <src/util_string.hh>

extern "C" bool _set (std::string const& name, Bmp::Library::UTrack & track)
{
  using namespace Bmp::Library;
  using namespace TagLib;

  FLAC::File opfile (name.c_str());

  if (!(opfile.isOpen() && opfile.isValid() && !opfile.readOnly()))
    return false;

  Bmp::Library::metadata_set_common (track, opfile.tag());

  Ogg::XiphComment * comment = opfile.xiphComment();

  if (comment)
    {
      if (track.mb_album_artist)
        comment->addField (String ("MUSICBRAINZ_ALBUMARTIST",             String::UTF8),
                           String (track.mb_album_artist.get(),           String::UTF8));

      if (track.mb_album_artist_id)
        comment->addField (String ("MUSICBRAINZ_ALBUMARTISTID",           String::UTF8),
                           String (track.mb_album_artist_id.get(),        String::UTF8));

      if (track.mb_album_artist_sort_name)
        comment->addField (String ("MUSICBRAINZ_ALBUMARTISTSORTNAME",     String::UTF8),
                           String (track.mb_album_artist_sort_name.get(), String::UTF8));

      if (track.mb_track_id)
        comment->addField (String ("MUSICBRAINZ_TRACKID",                 String::UTF8),
                           String (track.mb_track_id.get(),               String::UTF8));

      if (track.mb_album_id)
        comment->addField (String ("MUSICBRAINZ_ALBUMID",                 String::UTF8),
                           String(track.mb_album_id.get(),                String::UTF8));

      if (track.mb_artist_id)
        comment->addField (String ("MUSICBRAINZ_ARTISTID",                String::UTF8),
                           String (track.mb_artist_id.get(),              String::UTF8));

      if (track.mb_artist_sort_name)
        comment->addField (String ("MUSICBRAINZ_SORTNAME",                String::UTF8),
                           String (track.mb_artist_sort_name.get(),        String::UTF8));

      if (track.mb_release_date)
        comment->addField (String ("DATE", String::UTF8),
                           String (track.mb_release_date.get(), String::UTF8));

      if (track.asin)
        comment->addField (String ("AMAZON_ASIN",    String::UTF8),
                           String (track.asin.get(), String::UTF8));

      if (track.puid)
        comment->addField (String ("MUSICIP_PUID",   String::UTF8),
                           String (track.puid.get(), String::UTF8));


      opfile.save();
      comment = opfile.xiphComment();
      struct stat tagstat;
      stat (name.c_str(), &tagstat);
      TagLib::ByteVector tagData (comment->render());

      track.hash = Bmp::Util::md5_hex ((char*)(tagData.data()), tagData.size())+(fsizefmt % (unsigned long long int)(tagstat.st_size)).str();

      return true;
    }
  else
    {
      return false;
    }
}

extern "C" bool _get (TagLib::File * p, Bmp::DB::Row & row, std::string const& name)  
{
  using namespace Bmp::Library;
  using namespace TagLib;

  struct { 

      Datum     datum;
      char    * id;

  } mb_metadata_xiph[] = {

    { DATUM_MB_ALBUM_ARTIST,                "MUSICBRAINZ_ALBUMARTIST"           },
    { DATUM_MB_ALBUM_ARTIST_ID,             "MUSICBRAINZ_ALBUMARTISTID"         },
    { DATUM_MB_ALBUM_ARTIST_SORTNAME,       "MUSICBRAINZ_ALBUMARTISTSORTNAME"   },
    { DATUM_MB_TRACK_ID,                    "MUSICBRAINZ_TRACKID"               },
    { DATUM_MB_ALBUM_ID,                    "MUSICBRAINZ_ALBUMID"               },
    { DATUM_MB_ARTIST_ID,                   "MUSICBRAINZ_ARTISTID"              },
    { DATUM_MB_ARTIST_SORTNAME,             "MUSICBRAINZ_SORTNAME"              },
    { DATUM_MB_RELEASE_DATE,                "DATE"                              },
    { DATUM_ASIN,                           "AMAZON_ASIN"                       },
    { DATUM_MUSICIP_PUID,                   "MUSICIP_PUID"                      },

  };

  FLAC::File * file = 0;

  if (!(file = dynamic_cast<FLAC::File*> (p)))
    return false;

  Ogg::XiphComment * comment = file->xiphComment();

  if (comment)
    {
      TagLib::Map<TagLib::String, TagLib::StringList> const& map = comment->fieldListMap();
      TagLib::Map<TagLib::String, TagLib::StringList>::ConstIterator iter;

      for (unsigned int n = 0; n < G_N_ELEMENTS (mb_metadata_xiph); ++n)
      {
        iter = map.find (mb_metadata_xiph[n].id);
        if (iter != map.end())
          {
            TagLib::StringList const& list (iter->second);
            row.insert (std::make_pair (Bmp::MetadatumId(mb_metadata_xiph[n].datum), Glib::ustring(list[0].to8Bit(true))));
          }
      }

      struct stat tagstat;
      stat (name.c_str(), &tagstat);

      TagLib::ByteVector tagData (comment->render());
      std::string hash =
          Bmp::Util::md5_hex ((char*)(tagData.data()), tagData.size())+(fsizefmt % (unsigned long long int)(tagstat.st_size)).str();
      row.insert (std::make_pair (Bmp::MetadatumId(DATUM_HASH), Glib::ustring(hash))); 

    }
  else
    {
      ID3v2::Tag * tag = file->ID3v2Tag (false);
      if (tag)
        Bmp::Library::metadata_get_id3v2 (tag, row, name); 
    }

  return true;
}
