/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2005-2008  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>

#include "client.h"

static BluetoothClient *client;

static GtkWidget *statusbar;

static void delete_callback(GtkWidget *window, GdkEvent *event,
						gpointer user_data)
{
	gtk_widget_destroy(window);

	gtk_main_quit();
}

static void default_adapter_changed (GObject    *gobject,
				     GParamSpec *arg1,
				     gpointer    user_data)
{
	char *adapter;

	g_object_get (gobject, "default-adapter", &adapter, NULL);
	g_message ("default adapter changed: %s", adapter);
	g_free (adapter);
}

static void create_window(void)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *scrolled;
	GtkWidget *tree;
	GtkTreeModel *model;

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	gtk_window_set_title(GTK_WINDOW(window), "Test client");

	gtk_window_set_icon_name(GTK_WINDOW(window), "bluetooth");

	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);

	gtk_window_set_default_size(GTK_WINDOW(window), 920, 500);

	vbox = gtk_vbox_new(FALSE, 6);

	scrolled = gtk_scrolled_window_new(NULL, NULL);

	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
				GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	gtk_container_add(GTK_CONTAINER(vbox), scrolled);

	tree = gtk_tree_view_new();

	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(tree), TRUE);

	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(tree), TRUE);

	model = bluetooth_client_get_model(client);
	//model = bluetooth_client_get_model_adapter_list(client);

	gtk_tree_view_set_model(GTK_TREE_VIEW(tree), model);

	g_object_unref(model);

	gtk_tree_view_expand_all(GTK_TREE_VIEW(tree));

	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree), -1,
					"Path", gtk_cell_renderer_text_new(),
						"text", COLUMN_PATH, NULL);

	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree), -1,
					"Active", gtk_cell_renderer_text_new(),
						"text", COLUMN_ACTIVE, NULL);

	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree), -1,
					"Address", gtk_cell_renderer_text_new(),
						"text", COLUMN_ADDRESS, NULL);

	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree), -1,
					"Class", gtk_cell_renderer_text_new(),
						"text", COLUMN_CLASS, NULL);

	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree), -1,
					"RSSI", gtk_cell_renderer_text_new(),
						"text", COLUMN_RSSI, NULL);

	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree), -1,
					"Name", gtk_cell_renderer_text_new(),
						"text", COLUMN_NAME, NULL);

	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree), -1,
					"Type", gtk_cell_renderer_text_new(),
						"text", COLUMN_TYPE, NULL);

	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree), -1,
					"Bonded", gtk_cell_renderer_text_new(),
						"text", COLUMN_BONDED, NULL);

	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree), -1,
					"Trusted", gtk_cell_renderer_text_new(),
						"text", COLUMN_TRUSTED, NULL);

	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree), -1,
					"Connected", gtk_cell_renderer_text_new(),
						"text", COLUMN_CONNECTED, NULL);

	gtk_widget_grab_focus(GTK_WIDGET(tree));

	gtk_container_add(GTK_CONTAINER(scrolled), tree);

	gtk_container_add(GTK_CONTAINER(window), vbox);

	statusbar = gtk_statusbar_new();

	gtk_box_pack_start(GTK_BOX(vbox), statusbar, FALSE, FALSE, 0);

	g_signal_connect(G_OBJECT(window), "delete-event",
					G_CALLBACK(delete_callback), NULL);
	g_signal_connect(G_OBJECT(client), "notify::default-adapter",
			 G_CALLBACK(default_adapter_changed), client);

	gtk_widget_show_all(window);
}

int main(int argc, char *argv[])
{
	gtk_init(&argc, &argv);

	client = bluetooth_client_new();

	create_window();

	gtk_main();

	g_object_unref(client);

	return 0;
}
