#ifndef INTL_H
#define INTL_H

#include "config.h"

#include <glib.h>
#ifdef ENABLE_NLS
# include <libintl.h>
# define _(String) gettext(String)
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif
#else
#  define _(String) (String)
#  define N_(String) (String)
#  define textdomain(Domain)
#  define bindtextdomain(Package, Directory)
#endif
/*
 * Bluefish builds fine without these, why are they included ? (Olivier)
 * I also removed intl.c from the Makefile, the functions in it where never 
 * used by bluefish
 *
GList *intl_get_language_list(void);
int intl_score_locale(const gchar * locale);
*/
#endif
