(*pp cpp $ARCH_FLAGS *)

(* File: sw_arg.ml

    Copyright (C) 2007-

      Jane Street Holding, LLC
      Author: Markus Mottl
      email: mmottl\@janestcapital.com
      WWW: http://www.janestcapital.com/ocaml

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

(* Sw_arg: sizer and writer combination *)

open Common
open Size
open Unsafe_write_c

type 'a sw_arg = 'a sizer * 'a writer
type ('a, 'b) sw_arg1 = 'a sw_arg -> 'b sw_arg
type ('a, 'b, 'c) sw_arg2 = 'a sw_arg -> ('b, 'c) sw_arg1
type ('a, 'b, 'c, 'd) sw_arg3 = 'a sw_arg -> ('b, 'c, 'd) sw_arg2

let bin_sw_arg_unit = bin_size_unit, bin_write_unit
let bin_sw_arg_bool = bin_size_bool, bin_write_bool
let bin_sw_arg_string = bin_size_string, bin_write_string
let bin_sw_arg_char = bin_size_char, bin_write_char
let bin_sw_arg_int = bin_size_int, bin_write_int
let bin_sw_arg_float = bin_size_float, bin_write_float
let bin_sw_arg_int32 = bin_size_int32, bin_write_int32
let bin_sw_arg_int64 = bin_size_int64, bin_write_int64
let bin_sw_arg_nativeint = bin_size_nativeint, bin_write_nativeint
let bin_sw_arg_nat0 = bin_size_nat0, bin_write_nat0

let bin_sw_arg_ref (bin_size_el, bin_write_el) =
  bin_size_ref bin_size_el, bin_write_ref bin_write_el

let bin_sw_arg_lazy (bin_size_el, bin_write_el) =
  bin_size_lazy bin_size_el, bin_write_lazy bin_write_el

let bin_sw_arg_option (bin_size_el, bin_write_el) =
  bin_size_option bin_size_el, bin_write_option bin_write_el

let bin_sw_arg_pair (bin_size_el1, bin_write_el1) (bin_size_el2, bin_write_el2) =
  bin_size_pair bin_size_el1 bin_size_el2,
  bin_write_pair bin_write_el1 bin_write_el2

let bin_sw_arg_triple
      (bin_size_el1, bin_write_el1)
      (bin_size_el2, bin_write_el2)
      (bin_size_el3, bin_write_el3) =
  bin_size_triple bin_size_el1 bin_size_el2 bin_size_el3,
  bin_write_triple bin_write_el1 bin_write_el2 bin_write_el3

let bin_sw_arg_list (bin_size_el, bin_write_el) =
  bin_size_list bin_size_el, bin_write_list bin_write_el

let bin_sw_arg_array (bin_size_el, bin_write_el) =
  bin_size_array bin_size_el, bin_write_array bin_write_el

let bin_sw_arg_hashtbl (bin_size_key, bin_write_key) (bin_size_val, bin_write_val) =
  bin_size_hashtbl bin_size_key bin_size_val,
  bin_write_hashtbl bin_write_key bin_write_val

let bin_sw_arg_float32_vec = bin_size_float32_vec, bin_write_float32_vec
let bin_sw_arg_float64_vec = bin_size_float64_vec, bin_write_float64_vec
let bin_sw_arg_vec = bin_size_vec, bin_write_vec
let bin_sw_arg_float32_mat = bin_size_float32_mat, bin_write_float32_mat
let bin_sw_arg_float64_mat = bin_size_float64_mat, bin_write_float64_mat
let bin_sw_arg_mat = bin_size_mat, bin_write_mat
let bin_sw_arg_float_array = bin_size_float_array, bin_write_float_array
let bin_sw_arg_variant_tag = bin_size_variant_tag, bin_write_variant_tag
let bin_sw_arg_int_8bit = bin_size_int_8bit, bin_write_int_8bit
let bin_sw_arg_int_16bit = bin_size_int_16bit, bin_write_int_16bit
let bin_sw_arg_int_32bit = bin_size_int_32bit, bin_write_int_32bit

#ifdef ARCH_SIXTYFOUR
let bin_sw_arg_int_64bit = bin_size_int_64bit, bin_write_int_64bit
#endif

let bin_sw_arg_int64_bits = bin_size_int64_bits, bin_write_int64_bits

let bin_sw_arg_array_no_length (bin_size_el, bin_write_el) =
  bin_size_array_no_length bin_size_el, bin_write_array_no_length bin_write_el
