package bigloo;

import java.lang.*;
import java.net.*;
import java.io.*;
import java.nio.channels.*;
import java.lang.reflect.*;

public class JDK13 extends JDK {

   // JDK1.3 methods
   
   public Method getDeclaredMethodImpl( Class c, byte[] m ) throws Exception {
      return c.getDeclaredMethod( new String( m ), null );
   }
   
   public Object invokeImpl( Method m ) throws Exception {
      return m.invoke( null, null );
   }
   
   public ServerSocket makeServerSocketImpl(String name, int port)
      throws IOException  {

      if(name == null)
	 return new ServerSocket( port );
      else{
	 // the default backlog in Java is 50 (per javadocs)
	 InetAddress host = InetAddress.getByName(name);
	 return new ServerSocket( port, 50, host);
      }
   }

   public Socket acceptImpl(ServerSocket sock, boolean blocking)
      throws IOException {
      return sock.accept();
   }
}
