##############################################################################
#   MAKEFILE.INC - this file is part of Binary vIEW project (BIEW)           #
##############################################################################
#   Copyrights:           1998, 2000 Nick Kurshev                            #
#   License:              See below                                          #
#   Author and developer: Nick Kurshev                                       #
#   Requirement:          GNU make                                           #
#   Original file name:   makefile                                           #
####################### [ D e s c r i p t i o n ] ############################
#  This include file is script for make utility of GNU development system.   #
########################### [ L i c e n c e ] ################################
# The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.                 #
# All rights reserved. This software is redistributable under the licence    #
# given in the file "Licence.en" ("Licence.ru" in russian translation)       #
# distributed in the BIEW archive.                                           #
##############################################################################

##############################################################################
# ATTENTION!!! I use manual method configuring of BIEW project rather than   #
# 'configure' script technology, because 'configure' script does not work    #
# propertly on non *NIX systems (like Cygwin, EMX,...).                      #
##############################################################################

##############################################################################
# HOST determines host operating system                                      #
##############################################################################
# Please write name of any desired operating system if this name is present  #
# in biewlib/sysdep/$(MACHINE) as subfolder, or port BIEW for your OS        #
# manully and please bring to author your version (with changes list)        #
# NOTE: I use file name model: 8.3 + all character in lowercase +            #
#       no symlinks (project must be compatible with DOS compilers)          #
##############################################################################
bad_os = no
bad_machine = no

ifeq ($(TARGET_OS),dos)
 HOST=dos
 CDEFOS=-D__MSDOS__ -D__OS_NAME__='"DOS"' -D__OS__="dos" -Udos
 OSLDEF=--force-exe-suffix
 OS_LIBS=
endif
ifeq ($(TARGET_OS),os2)
 HOST=os2
 CDEFOS=-D__OS2__ -D__OS_NAME__='"OS/2"' -Zomf -D__OS__="os2" -Uos2
 # here I want to have static link of glibc instead emx.dll
 OSLDEF=-Zexe -Zsmall-conv -Zsys -Zomf -Zstack 1024
 OS_LIBS=
endif
ifeq ($(TARGET_OS),win32)
 HOST=win32
 # I named this as win32 because of exists Win386 by Watcom.
 # here I link crtdll.dll instead cygwin1.dll (it's safe)
 CDEFOS= -D__WIN32__ -D__OS_NAME__='"Win32"' -mno-cygwin -D__OS__="win32" -Uwin32
 OSLDEF= -mno-cygwin --force-exe-suffix
 OS_LIBS= -lwinmm
endif
ifeq ($(TARGET_OS),beos)
 HOST=beos
 CDEFOS=-D__BEOS__ -D__UNIX__ -D__OS_NAME__='"BeOS"' -D_VT100_ -D__OS__="beos" -Ubeos
 OSLDEF=
 OS_LIBS=
endif
ifeq ($(TARGET_OS),linux)
 HOST=linux
 CDEFOS=-D__LINUX__ -D__UNIX__ -D__OS_NAME__='"Linux"' -D_VT100_ -D__OS__="linux" -Ulinux
 OSLDEF=
 OS_LIBS=
 ifeq ($(USE_MOUSE),n)
 else
  CDEFOS += -DHAVE_MOUSE
  OS_LIBS += -lgpm
 endif
endif
ifeq ($(TARGET_OS),unix)
 HOST=unix
 CDEFOS = -D__UNIX__ -D__OS__="unix" -Uunix
 OSLDEF=
 ifeq ($(TARGET_SCREEN_LIB),vt100)
  CDEFOS += -D_VT100_
  OSNAME=Unix/VT100
 else
   ifeq ($(TARGET_SCREEN_LIB),slang)
     CDEFOS += -D_SLANG_
     OS_LIBS += -lslang
     OSNAME=Unix/Slang
   else
     CDEFOS += -D_CURSES_
     OS_LIBS += -lncurses
     OSNAME=Unix/Curses
   endif
 endif

 ifeq ($(USE_MOUSE),y)
  CDEFOS += -DHAVE_MOUSE
 else
 endif
 ifeq ($(USE_SELECT),n)
 else
  CDEFOS += -DHAVE_SELECT
 endif
  CDEFOS += -D__OS_NAME__='"$(OSNAME)"'
endif
ifndef HOST
bad_os = yes
endif
##############################################################################
# MACHINE determines hardware platform                                       #
##############################################################################
# WARNING!!!                                                                 #
# BIEW is designed for ia-16/ia-32 platforms and was not tested on non       #
# LITTLE ENDIAN platforms. Project also was not tested on non 16/32 bits     #
# systems. If you want you may port project by hand and please bring to      #
# author your version (with changes list)                                    #
##############################################################################
ifeq ($(TARGET_PLATFORM),i386)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32 -D__CPU_NAME__='"i386"' -D__CPU__=386\
         -D__DEFAULT_DISASM=0 -m386 -fno-builtin
endif
ifeq ($(TARGET_PLATFORM),i486)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"i486"' -D__CPU__=486\
         -D__DEFAULT_DISASM=0 -m486
endif
ifeq ($(TARGET_PLATFORM),i586)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"i586"' -D__CPU__=586\
         -D__DEFAULT_DISASM=0 -march=pentium -mcpu=pentium -fschedule-insns2
endif
ifeq ($(TARGET_PLATFORM),i586mmx)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"i586mmx"' -D__CPU__=586\
         -D__DEFAULT_DISASM=0 -march=pentium -mcpu=pentium -mmmx\
         -fschedule-insns2
endif
ifeq ($(TARGET_PLATFORM),i686)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"i686"' -D__CPU__=686\
         -D__DEFAULT_DISASM=0 -march=pentiumpro -mcpu=pentiumpro\
         -fschedule-insns2
endif
ifeq ($(TARGET_PLATFORM),i686mmx)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"i686mmx"' -D__CPU__=686\
         -D__DEFAULT_DISASM=0 -march=pentiumpro -mcpu=pentiumpro -mmmx\
         -fschedule-insns2
endif
ifeq ($(TARGET_PLATFORM),k5)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"amdk5"' -D__CPU__=586\
         -D__DEFAULT_DISASM=0 -march=k5 -mcpu=k5 -fschedule-insns2
endif
ifeq ($(TARGET_PLATFORM),k6)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"amdk6"' -D__CPU__=586\
         -D__DEFAULT_DISASM=0 -march=k6 -mcpu=k6 -fschedule-insns2
endif
ifeq ($(TARGET_PLATFORM),athlon)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"athlon"' -D__CPU__=686\
         -D__DEFAULT_DISASM=0 -march=athlon -mcpu=athlon\
         -fschedule-insns2
endif
ifeq ($(TARGET_PLATFORM),athlon_mmx)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"athlon"' -D__CPU__=686\
         -D__DEFAULT_DISASM=0 -march=athlon -mcpu=athlon -mmmx\
         -fschedule-insns2
endif
ifeq ($(TARGET_PLATFORM),k6mmx)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"k6mmx"' -D__CPU__=586\
         -D__DEFAULT_DISASM=0 -march=k6 -mcpu=k6 -mmmx -fschedule-insns2
endif
ifeq ($(TARGET_PLATFORM),6x86)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"cyrix6x86"' -D_CPU__=586\
         -D__DEFAULT_DISASM=0 -march=6x86 -mcpu=6x86 -mmmx -fschedule-insns2
endif
ifeq ($(TARGET_PLATFORM),6x86mx)
 MACHINE=ia32
 CDEFSYS=-D__MACHINE__=ia32  -D__CPU_NAME__='"cyrix6x86mx"' -D__CPU__=586\
         -D__DEFAULT_DISASM=0 -march=6x86mx -mcpu=6x86mx -mmmx\
         -fschedule-insns2
endif
ifeq ($(TARGET_PLATFORM),i86)
 MACHINE=ia16
 CDEFSYS=-D__MACHINE__=ia16  -D__CPU_NAME__='"i86"' -D__CPU__=86\
         -D__DEFAULT_DISASM=0
endif
ifeq ($(TARGET_PLATFORM),generic)
 MACHINE=generic
 CDEFSYS=-D__MACHINE__=generic  -D__CPU_NAME__='"generic"'\
         -D__DEFAULT_DISASM=1 -fno-builtin
endif
ifndef MACHINE
bad_machine = yes
endif
ifeq ($(MACHINE),ia32)
CDEFSYS += -fshort-enums
ifeq ($(compilation),advance)
CDEFSYS += -mschedule-prologue -momit-leaf-frame-pointer -mmove
endif
endif
##############################################################################
# If you do not have GNU development system, modify RM CC LD variables       #
##############################################################################
RM=rm -f
CC=gcc
LD=gcc
###########################################################################
#  CFLAGS set it for optimization                                         #
#  LDFLAGS set it for link method                                         #
###########################################################################
CFLAGS = -Wall -D__HAVE_PRAGMA_PACK__=1 $(CDEFOS) $(CDEFSYS) $(HOST_CFLAGS)
ifeq ($(findstring debug,$(compilation)),debug)
CFLAGS += -g3 -p -ax
ifeq ($(compilation),max_debug)
CFLAGS += -fcheck-memory-usage -fstack-check
endif
else
CFLAGS += -O2 -fomit-frame-pointer -DNDEBUG=1
endif
adv_warn = -W -Winline -Wuninitialized -Wcast-align\
 -Wswitch -Wshadow -Wbad-function-cast -Wmissing-noreturn -Wcast-qual\
 -Wchar-subscripts -Wcomment -Wformat -Wimplicit-function-declaration\
 -Wimplicit-int -Wimport -Wmain -Wmissing-braces -Wmissing-prototypes\
 -Wmultichar -Wnested-externs -Wparentheses -Wpointer-arith -Wsign-compare\
 -Wunknown-pragmas -Wstrict-prototypes -Wtrigraphs -Wwrite-strings
adv_keys = -fmove-all-movables -freduce-all-givs -fexpensive-optimizations\
 -fregmove -foptimize-register-move
ifeq ($(compilation),advance)
CFLAGS += $(adv_keys) $(adv_warn)
endif
ifeq ($(compilation),master)
CFLAGS += -pedantic -Wconversion -Wredundant-decls\
 -Wtraditional -Wunused -ffunction-sections -fdata-sections\
  $(adv_keys) $(adv_warn)
#-ansi
endif
LDFLAGS = $(OSLDEF) $(HOST_LDFLAGS)
ifeq ($(findstring debug,$(compilation)),debug)
LDFLAGS += -g
else
LDFLAGS += -s
endif
ifeq ($(compilation),advance)
LDFLAGS += --sort-common
endif
