/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_ORBITER_DBUS_H__
#define __BKL_ORBITER_DBUS_H__

#include <glib-object.h>


G_BEGIN_DECLS

#define BKL_TYPE_ORBITER_DBUS                                           \
   (bkl_orbiter_dbus_get_type())
#define BKL_ORBITER_DBUS(obj)                                           \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BKL_TYPE_ORBITER_DBUS,                  \
                                BklOrbiterDBus))
#define BKL_ORBITER_DBUS_CLASS(klass)                                   \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BKL_TYPE_ORBITER_DBUS,                     \
                             BklOrbiterDBusClass))
#define IS_BKL_ORBITER_DBUS(obj)                                        \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BKL_TYPE_ORBITER_DBUS))
#define IS_BKL_ORBITER_DBUS_CLASS(klass)                                \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BKL_TYPE_ORBITER_DBUS))
#define BKL_ORBITER_DBUS_GET_CLASS(obj)                                 \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BKL_TYPE_ORBITER_DBUS,                   \
                               BklOrbiterDBusClass))

typedef struct _BklOrbiterDBusPrivate BklOrbiterDBusPrivate;
typedef struct _BklOrbiterDBus      BklOrbiterDBus;
typedef struct _BklOrbiterDBusClass BklOrbiterDBusClass;

struct _BklOrbiterDBus
{
    GObject parent;

    BklOrbiterDBusPrivate *priv;
};

struct _BklOrbiterDBusClass
{
    GObjectClass parent_class;
};

GType bkl_orbiter_dbus_get_type (void) G_GNUC_CONST;
BklOrbiterDBus *bkl_orbiter_dbus_new (void);
void bkl_orbiter_dbus_source_added (BklOrbiterDBus *dbus,
                                    const char     *name,
                                    const char     *uri);
void bkl_orbiter_dbus_source_removed (BklOrbiterDBus *dbus,
                                      const char     *name,
                                      const char     *uri);
void bkl_orbiter_dbus_index_in_progress (BklOrbiterDBus *dbus,
                                         const char     *name);
void bkl_orbiter_dbus_index_complete (BklOrbiterDBus *dbus,
                                      const char     *name);


G_END_DECLS

#endif /* __BKL_ORBITER_DBUS_H__ */
