/*
** Copyright (C) 2003-2005 The Free Software Foundation.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>


/*
This helper program executes shell commands on behalf of bibledit.
If bibledit were to execute the shell commands themselves, that would cost
relatively much time because of the expensive fork command. Fork is expensive
with bibledit, because bibledit uses a lot of memory, and each fork copies all
this and then destroys it: a waste of time. If a program that uses little memory 
does it on behalf of bibledit, that is much and much faster.

bibledit-shell waits for a line to appear on stdin. It then executes the 
script given on the commandline. When ready it returns the result of that.

When it reads an EOF, it exits.
*/


int main(int argc, char *argv[])
{
  char buf[10];
  while (read (0, buf, 9)) {
    int result = system (argv[1]);
    printf ("%d\n", result);
  }
  return 0;
}
