#!/bin/sh

if [ "$EUID" -ne 0 ]; then
  echo "Root access is required to set ownership of files."
  exec sudo ./mkinst.sh
fi

DMGDIR=`readlink -f ./DmgDir`
BUILDDIR=`readlink -f ./build`
PREFIX=`readlink -f ./build/install-prefix`
if [ $? -ne 0 ]; then
  echo "Have you run ./build-deps.sh and ./build.sh?"
  exit 1
fi

PREPARED_PACKAGE="$BUILDDIR/PreparedPackage"
STARTUP_ITEMS="$PREPARED_PACKAGE/Contents/StartupItems"
APP_SUPPORT="$PREPARED_PACKAGE/Contents/Application Support"
RESOURCES="$PREPARED_PACKAGE/Resources"

rm -rf "$PREPARED_PACKAGE" || exit 1
cp -pR ./Package "$PREPARED_PACKAGE" || exit 1
find -d "$PREPARED_PACKAGE" -name "CVS" -o -name ".*" -exec rm -rf {} \; || exit 1
cp -p ../../COPYING "$PREPARED_PACKAGE/License.txt" || exit 1
cp -p "$PREFIX/bin/bfilter" "$STARTUP_ITEMS/BFilter/BFilterDaemon" || exit 1
cp -p "$PREFIX/etc/bfilter/config.default" "$APP_SUPPORT/BFilter/config" || exit 1
cp -p "$PREFIX/etc/bfilter/urls" "$APP_SUPPORT/BFilter/urls" || exit 1
cp -p "$PREFIX/etc/bfilter/urls.local" "$APP_SUPPORT/BFilter/urls.local" || exit 1
cp -pR "$PREFIX/etc/bfilter/filters" "$APP_SUPPORT/BFilter/filters" || exit 1
chown -R root:wheel "$STARTUP_ITEMS" || exit 1
chmod +x "$STARTUP_ITEMS/BFilter" || exit 1
chmod -R u+rw,g+r-w,o+r-w "$STARTUP_ITEMS" || exit 1
chown -R root:admin "$APP_SUPPORT" || exit 1
chmod -R u+rw,g+rw,o+r-w "$APP_SUPPORT" || exit 1

rm -rf "$DMGDIR/BFilter.pkg" || exit 1
touch "$PREPARED_PACKAGE/.tag" || exit 1

echo
echo "Adjust BFilter's version in \"Installer Interface\" and \"Package Version\" tabs."

package_ok=""
while [ -z "$package_ok" ]; do
  sudo -u "#$UID" open "$PREPARED_PACKAGE/BFilter.pmproj" || exit 1
  echo "Do Project -> Build and save the package here:"
  echo "$DMGDIR"
  echo "When done, press <Enter>"
  read
  out=`find "$DMGDIR" -name BFilter.pkg -newer "$PREPARED_PACKAGE/.tag"`
  if [ -z "$out" ]; then
    echo "Package not found.  Did you save it at the correct location?"
  else
    package_ok="ok"
  fi
done

rm -rf "$PREPARED_PACKAGE" || exit 1

read VERSION < ../../VERSION

FINALDIR="$BUILDDIR/BFilter ${VERSION}"
rm -rf "$FINALDIR" || exit 1
cp -pR "$DMGDIR" "$FINALDIR" || exit 1
find -d "$FINALDIR" -name "CVS" -o -name ".svn" -exec rm -rf {} \; || exit 1
cp -p "$PREFIX/bin/bfilter-uninstaller" "$FINALDIR/Uninstaller" || exit 1
rm -rf "BFilter-${VERSION}.dmg" || exit 1
hdiutil create -srcfolder "$FINALDIR" "BFilter-${VERSION}.dmg"
rm -rf "$FINALDIR" || exit 1

