/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SOCKSERROR_H_
#define SOCKSERROR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class SocksError
{
public:
	enum Code {
		GENERIC_ERROR,
		CONNECTION_CLOSED,
		PROTOCOL_VIOLATION,
		SOCKS_SERVER_FAILURE,
		SOCKS_SERVER_TIMEOUT,
		UNSUPPORTED_AUTH_METHOD,
		UNSUPPORTED_ADDRESS_TYPE,
		UNSUPPORTED_COMMAND,
		AUTH_REQUIRED,
		AUTH_FAILURE,
		FORBIDDEN_BY_RULESET,
		REJECTED_OR_FAILED,
		DESTINATION_UNREACHABLE,
		CONNECTION_REFUSED,
		LOCAL_DNS_FAILED
	};
	
	SocksError(Code code) : m_code(code) {}
	
	Code getCode() const { return m_code; }
	
	char const* toString() const;
private:
	Code m_code;
};

#endif
