/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ServiceContext.h"
#include "ServerTimeouts.h"
#include "TimeDelta.h"

ServiceContext::ServiceContext(Reactor& reactor)
:	m_rReactor(reactor),
	m_server(*this, getServerTimeouts()),
	m_cachingServer(m_server, /* dont_create = */true),
	m_filteringServer(*this, m_cachingServer),
	m_scriptServer(*this, getScriptServerTimeouts()),
	m_cachingScriptServer(m_scriptServer),
	m_htmlProcessor(*this)
{
}

ServiceContext::~ServiceContext()
{
}

void
ServiceContext::reset()
{
	m_server.reset();
	m_scriptServer.reset();
	//m_htmlProcessor.reset(); // HtmlResponseFilter resets it
}

ServerTimeouts
ServiceContext::getServerTimeouts()
{
	ServerTimeouts st;
	st.setReadTimeout(TimeDelta::fromSec(500));
	st.setWriteTimeout(TimeDelta::fromSec(100));
	st.setConnectTimeout(TimeDelta::fromSec(34));
	st.setSocksConnectTimeout(TimeDelta::fromSec(37));
	return st;
}

ServerTimeouts
ServiceContext::getScriptServerTimeouts()
{
	ServerTimeouts st;
	st.setReadTimeout(TimeDelta::fromSec(14));
	st.setWriteTimeout(TimeDelta::fromSec(14));
	st.setConnectTimeout(TimeDelta::fromSec(18));
	st.setSocksConnectTimeout(TimeDelta::fromSec(21));
	return st;
}
