/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ReplacementJs.h"
#include "ImmediateResponse.h"
#include "CraftedResponse.h"
#include "HttpStatusLine.h"
#include "HttpResponseMetadata.h"
#include "HttpHeadersCollection.h"
#include "HttpHeader.h"
#include "Date.h"

using namespace std;

std::auto_ptr<ImmediateResponse>
ReplacementJs::createHttpResponse()
{
	auto_ptr<CraftedResponse> response(new CraftedResponse(HttpStatusLine::SC_OK));
	response->metadata().headers().setHeader(
		HttpHeader(BString("Content-Type"), BString("text/x-javascript"))
	);
	response->metadata().headers().setHeader(
		HttpHeader(BString("Date"), Date::formatCurrentTime())
	);
	response->metadata().setBodyStatus(HttpResponseMetadata::BODY_SIZE_KNOWN);
	response->metadata().setBodySize(0);
	return auto_ptr<ImmediateResponse>(response);
}
