/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef REGEXRESPONSEFILTER_H_
#define REGEXRESPONSEFILTER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ResponseFilterBase.h"
#include "ResponseFilterChain.h"
#include "NonCopyable.h"
#include "IntrusivePtr.h"
#include "SplittableBuffer.h"
#include "SBOutStream.h"
#include <memory>

class ResponseFilterChain;
class RegexFilterDescriptor;
class RequestStatus;

class RegexResponseFilter : public ResponseFilterBase
{
	DECLARE_NON_COPYABLE(RegexResponseFilter)
public:
	RegexResponseFilter(ResponseFilterChain& filter_chain,
		IntrusivePtr<RegexFilterDescriptor const> const& filter_desc);
	
	virtual ~RegexResponseFilter();
	
	virtual void processMetadata(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processBodyData(
		RequestStatus& status, SplittableBuffer& data, bool eof);
private:
	bool isMatchingAllowed() const;
	
	void registerMatch();
	
	// template because we don't want to expose <boost/regex.hpp> here.
	template<typename R, typename P>
	R getReplacement(P const& mr);
	
	IntrusivePtr<RegexFilterDescriptor const> m_ptrFilterDescriptor;
	SplittableBuffer m_data;
	SBOutStream m_outStream;
	int m_matchCount;
	bool m_isDataBegin;
	bool m_isDataEnd;
};

#endif
