/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef WRAPPEDERRORRESPONSE_H_
#define WRAPPEDERRORRESPONSE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <memory>

class ImmediateResponse;
class ErrorDescriptor;

/**
 * \brief Wraps an ErrorDescriptor into ImmediateResponse.
 *
 * The resulting ImmediateResponse may be passed to
 * AbstractServer::submitRequest().  An alternative approach
 * would be using ErrorDescriptor::retrieveResponse(), but such
 * a response would be treated as a normal, non-error response.
 */
class ErrorWrapper
{
public:
	static std::auto_ptr<ImmediateResponse> wrap(
		std::auto_ptr<ErrorDescriptor> edesc);
private:
	class Response;
	
	ErrorWrapper(); // forbid construction
};

#endif
