/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DNSRESOLVER_H_
#define DNSRESOLVER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

class InetAddr;
class SymbolicInetAddr;

/*
We roll our own dns resolver because the one in ACE_INET_Addr doesn't return
secondary addresses. And not, ACE_Multihomed_INET_Addr doesn't do it either.
*/

class DnsResolver
{
public:
	enum ErrorCode {
		SUCCESS,
		NO_ADDRESSES,
		TEMPORARY_ERROR,
		MISC_ERROR
	};
	
	static std::vector<InetAddr> resolve(
		SymbolicInetAddr const& symbolic_addr, ErrorCode* err = 0);
private:
	class AddrInfoHolder;
	
	static std::vector<InetAddr> resolveWithCache(
		SymbolicInetAddr const& symbolic_addr, ErrorCode* err = 0);
	
	static std::vector<InetAddr> realResolve(
		SymbolicInetAddr const& symbolic_addr, ErrorCode* err = 0);
	
	static ErrorCode translateEAI(int err);
	
	static ErrorCode translateHERR(int err);
};

#endif
