/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef OBSERVER_H_
#define OBSERVER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IntrusiveList.h"

template<typename T> class ObserverNodeAccessor;

class ObserverBase
{
	template<typename T> friend class ObserverNodeAccessor;
private:
	IntrusiveListNode m_listNode;
};


// May be specialized.
template<typename T>
class ObserverNodeAccessor
{
public:
	static IntrusiveListNode& node(T& observer);
private:
	static ObserverBase& base(T& observer);
};


template<typename T>
class SingleObserverLink
{
public:
	void setObserver(T* observer);
	
	T* getObserver() const;
private:
	IntrusiveList<T> m_observerList;
};


template<typename T>
class MultiObserverLink
{
public:
	void pushFrontObserver(T& observer);
	
	void pushBackObserver(T& observer);
	
	void removeObserver(T& observer);
	
	IntrusiveList<T> const& observerList() const;
private:
	IntrusiveList<T> m_observerList;
};


template<typename T>
inline ObserverBase&
ObserverNodeAccessor<T>::base(T& observer)
{
	return static_cast<ObserverBase&>(observer);
}

template<typename T>
inline IntrusiveListNode&
ObserverNodeAccessor<T>::node(T& observer)
{
	return base(observer).m_listNode;
}

template<typename T>
void
SingleObserverLink<T>::setObserver(T* observer)
{
	m_observerList.clear();
	if (observer) {
		IntrusiveListNode& node = ObserverNodeAccessor<T>::node(*observer);
		m_observerList.push_back(*observer, node);
	}
}

template<typename T>
inline T*
SingleObserverLink<T>::getObserver() const
{
	if (m_observerList.empty()) {
		return 0;
	}
	return &m_observerList.front();
}

template<typename T>
inline void
MultiObserverLink<T>::pushFrontObserver(T& observer)
{
	IntrusiveListNode& node = ObserverNodeAccessor<T>::node(*observer);
	m_observerList.push_front(observer, node);
}

template<typename T>
inline void
MultiObserverLink<T>::pushBackObserver(T& observer)
{
	IntrusiveListNode& node = ObserverNodeAccessor<T>::node(*observer);
	m_observerList.push_back(observer, node);
}

template<typename T>
inline void
MultiObserverLink<T>::removeObserver(T& observer)
{
	IntrusiveListNode& node = ObserverNodeAccessor<T>::node(*observer);
	node.unlink();
}

template<typename T>
inline IntrusiveList<T> const&
MultiObserverLink<T>::observerList() const
{
	return m_observerList;
}

#endif
