/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HEXENCODER_H_
#define HEXENCODER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <iosfwd>
#include <stddef.h>

class HexEncoder
{
public:
	/**
	 * Each byte is encoded as a pair of characters.
	 * Alpha characters are in lower case.
	 */
	static std::string hexEncode(unsigned char const* bytes, size_t len);
	
	/**
	 * Each byte is encoded as a pair of characters.
	 * Alpha characters are in lower case.
	 */
	static void hexEncode(
		unsigned char const* bytes, size_t len, std::ostream& out);
private:
	static char const m_sHexChars[];
};

#endif
