/*
    BFilter - a web proxy which removes banner ads
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HEADERPARSERLISTENER_H_
#define HEADERPARSERLISTENER_H_

#include "SplittableBuffer.h"

class HeaderParserListener
{
public:
	typedef SplittableBuffer::ByteIterator Iterator;
	
	virtual ~HeaderParserListener() {}
	
	virtual void processError(size_t position) = 0;
	
	virtual void processElementName(Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processElementValue(Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processElementNullValue() = 0;
	
	virtual void processParamName(Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processParamValue(Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processParamNullValue() = 0;
};

#endif
