/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "TrayMenu.h"
#include "Application.h"

enum {
	ID_ACTIVE,
	ID_CONFIG,
	ID_CONFIG_BASIC,
	ID_CONFIG_ADVANCED,
	ID_CONFIG_FILTERS,
	ID_LOG,
	ID_LOG_OPERATIONS,
	ID_LOG_REQUESTS,
	ID_QUIT
};

BEGIN_EVENT_TABLE(TrayMenu, wxMenu)
	EVT_MENU(ID_ACTIVE, onActive)
	EVT_MENU(ID_CONFIG_BASIC, onConfigBasic)
	EVT_MENU(ID_CONFIG_ADVANCED, onConfigAdvanced)
	EVT_MENU(ID_CONFIG_FILTERS, onConfigFilters)
	EVT_MENU(ID_LOG_OPERATIONS, onOperationLog)
	EVT_MENU(ID_LOG_REQUESTS, onRequestLog)
	EVT_MENU(ID_QUIT, onQuit)
END_EVENT_TABLE()

TrayMenu::TrayMenu()
:	wxMenu(_T("BFilter " BFILTER_VERSION))
{
	AppendCheckItem(ID_ACTIVE, _T("Active"));
	Check(ID_ACTIVE, true);
	
	AppendSeparator();
	
	wxMenu* config_submenu = new wxMenu;
	Append(ID_CONFIG, _T("Configuration"), config_submenu);
	config_submenu->Append(ID_CONFIG_BASIC, _T("Basic"));
	config_submenu->Append(ID_CONFIG_ADVANCED, _T("Advanced"));
	config_submenu->Append(ID_CONFIG_FILTERS, _T("Filters"));
	
	wxMenu* log_submenu = new wxMenu;
	Append(ID_LOG, _T("Log"), log_submenu);
	log_submenu->Append(ID_LOG_OPERATIONS, _T("Operations"));
	log_submenu->Append(ID_LOG_REQUESTS, _T("Requests"));
	
	AppendSeparator();
	
	Append(ID_QUIT, _T("Quit"));
}

void
TrayMenu::onActive(wxCommandEvent& evt)
{
	bool const checked = !IsChecked(ID_ACTIVE);
	Check(ID_ACTIVE, checked);
	SetLabel(ID_ACTIVE, checked ? _T("Active") : _T("Passive"));
	wxGetApp().setFilteringEnabled(checked);
}

void
TrayMenu::onConfigBasic(wxCommandEvent& evt)
{
	wxGetApp().showBasicConfigDialog();
}

void
TrayMenu::onConfigAdvanced(wxCommandEvent& evt)
{
	wxGetApp().showAdvancedConfigWindow();
}

void
TrayMenu::onConfigFilters(wxCommandEvent& evt)
{
	wxGetApp().showFilterConfigWindow();
}

void
TrayMenu::onOperationLog(wxCommandEvent& evt)
{
	wxGetApp().showLogDialog();
}

void
TrayMenu::onRequestLog(wxCommandEvent& evt)
{
	wxGetApp().showRequestLogWindow();
}

void
TrayMenu::onQuit(wxCommandEvent& evt)
{
	wxGetApp().requestAppExit();
}
