/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "LogDialog.h"
#include "LogWidget.h"
#include "OperationLog.h"
#include "Application.h"
#include <ace/config-lite.h>
#include <wx/event.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/button.h>

using namespace std;

BEGIN_EVENT_TABLE(LogDialog, wxFrame)
	EVT_ACTIVATE(onWindowActivate)
	EVT_CLOSE(onWindowClose)
	EVT_BUTTON(wxID_CLOSE, onClose)
	EVT_BUTTON(wxID_CLEAR, onClearLog)
END_EVENT_TABLE()

LogDialog* LogDialog::m_spInstance = 0;

LogDialog::LogDialog()
:	wxFrame(wxGetApp().GetTopWindow(), wxID_ANY, _T("BFilter Operation Log")),
	AbstractLogView(*OperationLog::instance()),
	m_pLogWidget(0)
{
	SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
	SetIcon(wxIcon(_T("AppIcon"), wxBITMAP_TYPE_ICO_RESOURCE, 16, 16));

	wxBoxSizer* top_vbox = new wxBoxSizer(wxVERTICAL);
	SetSizer(top_vbox);

	wxPanel* top_panel = new wxPanel(this);
	top_vbox->Add(top_panel, 1, wxGROW);

	wxBoxSizer* panel_vbox = new wxBoxSizer(wxVERTICAL);
	top_panel->SetSizer(panel_vbox);
	
	m_pLogWidget = new LogWidget(
		OperationLog::instance(),
		top_panel, -1, wxEmptyString,
		wxDefaultPosition, wxSize(450, 150)
	);
	panel_vbox->Add(m_pLogWidget, 1, wxGROW|wxALL, 5);
	
	wxBoxSizer *hsz2 = new wxBoxSizer(wxHORIZONTAL);
	panel_vbox->Add(hsz2, 0, wxALIGN_CENTRE|wxALL, 5);
	
	wxButton* clear_btn = new wxButton(top_panel, wxID_CLEAR, _T("Clear"));
	hsz2->Add(clear_btn, 0, wxALIGN_CENTRE|wxLEFT|wxRIGHT|wxBOTTOM, 5);
	
	wxButton* close_btn = new wxButton(top_panel, wxID_CLOSE, _T("Close"));
	hsz2->Add(close_btn, 0, wxALIGN_CENTRE|wxLEFT|wxRIGHT|wxBOTTOM, 5);
	close_btn->SetDefault();
	
	panel_vbox->SetSizeHints(top_panel);
	top_vbox->SetSizeHints(this);
}

LogDialog::~LogDialog()
{
}

void
LogDialog::show()
{
	if (!m_spInstance) {
		m_spInstance = new LogDialog;
		m_spInstance->Show();
	} else {
		m_spInstance->Show();
		m_spInstance->Raise();
	}
}

void
LogDialog::onWindowActivate(wxActivateEvent& evt)
{
	AbstractLogView::reportVisibility(evt.GetActive());
}

void
LogDialog::onWindowClose(wxCloseEvent& evt)
{
	if (m_spInstance == this) {
		m_spInstance = 0;
	}
	Destroy();
}

void
LogDialog::onClose(wxCommandEvent& evt)
{
	Close();
}

void
LogDialog::onClearLog(wxCommandEvent& evt)
{
	OperationLog::instance()->clear();
}
