/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AutoIndentingTextCtrl.h"
#include <wx/event.h>
#include <wx/accel.h>

enum {
	ID_TEXT_ENTER = wxID_HIGHEST + 1
};

BEGIN_EVENT_TABLE(AutoIndentingTextCtrl, wxTextCtrl)
	EVT_MENU(ID_TEXT_ENTER, onEnter)
END_EVENT_TABLE()

AutoIndentingTextCtrl::AutoIndentingTextCtrl(
	wxWindow* parent, wxWindowID id, wxString const& value,
	wxPoint const& pos, wxSize const& size, long style,
	wxValidator const& validator, wxString const& name)
:	wxTextCtrl(parent, id, value, pos, size, style, validator, name)
{
	wxAcceleratorEntry accel(wxACCEL_NORMAL, WXK_RETURN, ID_TEXT_ENTER);
	// It also handles the keypad enter key.
	
	wxAcceleratorTable accel_tbl(1, &accel);
	SetAcceleratorTable(accel_tbl);
}

AutoIndentingTextCtrl::~AutoIndentingTextCtrl()
{
}

void
AutoIndentingTextCtrl::onEnter(wxCommandEvent& evt)
{
	long ins_pos = GetInsertionPoint();
	long line = 0, col = 0;
	PositionToXY(ins_pos, &col, &line);
	wxString text_line = GetLineText(line);
	size_t const len = text_line.Len();
	size_t i = 0;
	for (; i < len && wxIsspace(text_line.GetChar(i)); ++i) {
		// skip spaces
	}
	wxString ins_text("\n");
	ins_text.Append(text_line.substr(0, i));
	WriteText(ins_text);
}
