/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef LOG_H_
#define LOG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include <glibmm/ustring.h>
#include <gtkmm/textbuffer.h>
#include <gtkmm/texttag.h>
#include <stddef.h>

class LogObserver;

class Log
{
	DECLARE_NON_COPYABLE(Log)
public:
	typedef Glib::RefPtr<Gtk::TextTag> StylePtr;
	
	Log();

	~Log();
	
	void appendRecord(Glib::ustring const& text);
	
	void appendRecord(Glib::ustring const& text, StylePtr const& style);
	
	void appendToLastRecord(Glib::ustring const& text);

	void appendToLastRecord(Glib::ustring const& text, StylePtr const& style);

	void clear();
	
	bool hasUnseenWarnings() const { return m_haveUnseenWarnings; }
	
	sigc::slot<void, bool>& getViewVisibilityReporter() {
		return m_visibilityReporter;
	}
	
	sigc::signal<void, bool>& getUnseenWarningsSignal() {
		return m_unseenWarningsSignal;
	}
	
	StylePtr const& getDefaultStyle() const { return m_ptrDefaultStyle; }
	
	StylePtr const& getSuccessStyle() const { return m_ptrSuccessStyle; }

	StylePtr const& getWarningStyle() const { return m_ptrWarningStyle; }

	StylePtr const& getErrorStyle() const { return m_ptrErrorStyle; }
	
	size_t getNumRecords() const { return m_numRecords; }

	Glib::RefPtr<Gtk::TextBuffer> getTextBuffer() { return m_ptrBuffer; }
protected:
	StylePtr& defaultStyle() { return m_ptrDefaultStyle; }
	
	StylePtr& successStyle() { return m_ptrSuccessStyle; }

	StylePtr& warningStyle() { return m_ptrWarningStyle; }

	StylePtr& errorStyle() { return m_ptrErrorStyle; }
private:
	void appendText(
		Glib::ustring const& text, StylePtr const& style,
		bool prepend_newline);
	
	void onViewVisibilityChange(bool visible);
	
	size_t m_numRecords;
	int m_numVisibleViews;
	bool m_haveUnseenWarnings; // or errors
	sigc::slot<void, bool> m_visibilityReporter;
	sigc::signal<void, bool> m_unseenWarningsSignal;
	Glib::RefPtr<Gtk::TextBuffer> m_ptrBuffer;
	StylePtr m_ptrDefaultStyle;
	StylePtr m_ptrSuccessStyle;
	StylePtr m_ptrWarningStyle;
	StylePtr m_ptrErrorStyle;
};


inline void
Log::appendRecord(Glib::ustring const& text)
{
	appendRecord(text, m_ptrDefaultStyle);
}

inline void
Log::appendToLastRecord(Glib::ustring const& text)
{
	appendToLastRecord(text, m_ptrDefaultStyle);
}

#endif
