/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef REGEXFILTERDESCRIPTOR_H_
#define REGEXFILTERDESCRIPTOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "RefCountable.h"
#include "RefCounter.h"
#include "IntrusivePtr.h"
#include "FilterTag.h"
#include "FilterGroupTag.h"
#include <memory>
#include <string>

class BString;
class TextPattern;

class RegexFilterDescriptor
:	public RefCountable<RefCounter<ACE_MT_SYNCH> >
{
public: 
	enum ReplacementType { TEXT, EXPRESSION, JS };
	typedef IntrusivePtr<TextPattern const> PatternPtr;
	typedef std::auto_ptr<std::string const> TextPtr;
	
	RegexFilterDescriptor(
		FilterTag const& tag, FilterGroupTag const& group_tag,
		std::string const& name);
	
	RegexFilterDescriptor(RegexFilterDescriptor const& other);
	
	~RegexFilterDescriptor();
	
	RegexFilterDescriptor& operator=(RegexFilterDescriptor const& other);
	
	void swap(RegexFilterDescriptor& other);
	
	FilterTag const& getTag() const { return m_tag; }
	
	FilterGroupTag const& getGroupTag() const { return m_groupTag; }
	
	std::string& name() { return m_name; }
	
	std::string const& name() const { return m_name; }
	
	int& order() { return m_order; }
	
	int const& order() const { return m_order; }
	
	int& matchCountLimit() { return m_matchCountLimit; }
	
	int const& matchCountLimit() const { return m_matchCountLimit; }
	
	PatternPtr& urlPattern() {
		return m_ptrUrlPattern;
	}
	
	PatternPtr const& urlPattern() const {
		return m_ptrUrlPattern;
	}
	
	PatternPtr& contentTypePattern() {
		return m_ptrContentTypePattern;
	}
	
	PatternPtr const& contentTypePattern() const {
		return m_ptrContentTypePattern;
	}
	
	PatternPtr& searchPattern() {
		return m_ptrSearchPattern;
	}
	
	PatternPtr const& searchPattern() const {
		return m_ptrSearchPattern;
	}
	
	TextPtr& replacement() {
		return m_ptrReplacement;
	}
	
	TextPtr const& replacement() const {
		return m_ptrReplacement;
	}
	
	ReplacementType& replacementType() { return m_replacementType; }
	
	ReplacementType const& replacementType() const { return m_replacementType; }
	
	std::string& ifFlag() { return m_ifFlag; }
	
	std::string const& ifFlag() const { return m_ifFlag; }
	
	std::string& setFlag() { return m_setFlag; }
	
	std::string const& setFlag() const { return m_setFlag; }
	
	std::string& clearFlag() { return m_clearFlag; }
	
	std::string const& clearFlag() const { return m_clearFlag; }
	
	bool urlMatches(BString const& url) const;
	
	bool contentTypeMatches(BString const& ctype) const;
	
	bool isEnabled() const { return m_isEnabled; }
	
	void setEnabled(bool val = true) { m_isEnabled = val; }
	
	bool isValid() const;
private:
	struct ApSwap;
	
	FilterTag m_tag;
	FilterGroupTag m_groupTag;
	std::string m_name;
	int m_order;
	int m_matchCountLimit;
	PatternPtr m_ptrUrlPattern;
	PatternPtr m_ptrContentTypePattern;
	PatternPtr m_ptrSearchPattern;
	TextPtr m_ptrReplacement;
	ReplacementType m_replacementType;
	std::string m_ifFlag;
	std::string m_setFlag;
	std::string m_clearFlag;
	bool m_isEnabled;
};


inline RegexFilterDescriptor&
RegexFilterDescriptor::operator=(RegexFilterDescriptor const& other)
{
	RegexFilterDescriptor(other).swap(*this);
	return *this;
}

inline void swap(RegexFilterDescriptor& o1, RegexFilterDescriptor& o2)
{
	o1.swap(o2);
}

#endif
