/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SERVERTIMEOUTS_H_
#define SERVERTIMEOUTS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "TimeDelta.h"

class ServerTimeouts
{
public:
	ServerTimeouts() {}
	
	TimeDelta const& getReadTimeout() const { return m_readTimeout; }
	
	void setReadTimeout(TimeDelta const& t) { m_readTimeout = t; }
	
	TimeDelta const& getWriteTimeout() const { return m_writeTimeout; }
	
	void setWriteTimeout(TimeDelta const& t) { m_writeTimeout = t; }
	
	TimeDelta const& getConnectTimeout() const { return m_connectTimeout; }
	
	void setConnectTimeout(TimeDelta const& t) { m_connectTimeout = t; }
	
	TimeDelta const& getSocksConnectTimeout() const { return m_socksConnectTimeout; }
	
	void setSocksConnectTimeout(TimeDelta const& t) { m_socksConnectTimeout = t; }
private:
	TimeDelta m_readTimeout;
	TimeDelta m_writeTimeout;
	TimeDelta m_connectTimeout;
	TimeDelta m_socksConnectTimeout;
};

#endif
