/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HEURISTICSCORE_H_
#define HEURISTICSCORE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class URI;
class BString;

class HeuristicScore
{
public:
	virtual ~HeuristicScore() {}
	
	enum Status { NOT_AD, PROBABLY_NOT_AD, PROBABLY_AD, AD };
	
	enum UrlStatus { URL_INNOCENT, URL_MEDIOCRE, URL_SUSPICIOUS };
	
	enum UrlRelationship { URLS_SAME_HOST, URLS_RELATED, URLS_UNRELATED };
	
	virtual int getNumericScore() const = 0;
	
	virtual int getNumericSizeScore() const = 0;
	
	virtual Status getStatus() const;
	
	static UrlStatus getUrlStatus(URI const& url);
	
	static UrlRelationship getUrlRelationship(URI const& url, URI const& base);
	
	static bool isCommonAdSize(int width, int height);
	
	static int getSizeScore(int width, int height);
	
	static int getHintModifier(URI const& url);
	
	static bool checkFileExtension(BString const& file, BString const& ext);
private:
	struct SizeRecord;
	struct SizeRecordComparator;

	static UrlRelationship getDomainRelationship(
		char const* d1_begin, char const* d1_end,
		char const* d2_begin, char const* d2_end);
	
	static void chopLeadingWWW(char const*& begin, char const* d1_end);
	
	static void chopTopLevelDomain(char const* begin, char const*& end);
	
	static SizeRecord const* findSizeRecord(int width, int height);
	
	static SizeRecord const m_sCommonSizes[];
};

#endif
