/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef COMPRESSORRESPONSEFILTER_H_
#define COMPRESSORRESPONSEFILTER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ResponseFilterBase.h"
#include "NonCopyable.h"
#include "GzipCompressor.h"
#include <string>

class ResponseErrorInitiator;
class HttpResponseMetadata;
class HttpHeader;
class BString;

class CompressorResponseFilter : public ResponseFilterBase
{
	DECLARE_NON_COPYABLE(CompressorResponseFilter)
public:
	CompressorResponseFilter(ResponseFilterChain& filter_chain);
	
	virtual ~CompressorResponseFilter();
	
	virtual void processMetadata(std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processBodyData(SplittableBuffer& data, bool eof);
private:
	enum { OUTPUT_LIMIT = 8192 };
	
	bool m_isEOF;
	GzipCompressor m_compressor;
};

#endif
