/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AcceptEncoding.h"
#include "StringUtils.h"
#include "InsensitiveEqual.h"
#include "HttpHeader.h"
#include "HttpHeaderStructure.h"
#include "HttpHeaderElement.h"
#include <list>

using namespace std;

AcceptEncoding::AcceptEncoding(HttpHeader const& header)
:	m_hasAsterisk(false),
	m_asteriskQuality(0.0)
{
	BString const q("q");
	BString const ast("*");
	HttpHeaderStructure structure(header);
	list<HttpHeaderElement>::const_iterator it = structure.elements().begin();
	list<HttpHeaderElement>::const_iterator const end = structure.elements().end();
	for (; it != end; ++it) {
		float qval =  StringUtils::toNumber<float>(
			it->getParameterByName(q).value.toStdString(), 1.0
		);
		if (it->getName() != ast) {
			m_items[it->getName()] = qval;
		} else {
			m_hasAsterisk = true;
			m_asteriskQuality = qval;
		}
	}
}

AcceptEncoding::~AcceptEncoding()
{
}

float
AcceptEncoding::getQuality(BString const& item) const
{
	BString const identity("identity");
	
	Map::const_iterator it = m_items.find(item);
	if (it != m_items.end()) {
		return it->second;
	}
	if (m_hasAsterisk) {
		return m_asteriskQuality;
	}
	if (InsensitiveEqual()(item, identity)) {
		return 1.0;
	}
	return 0.0;
}
