/* json_soup.c generated by valac 0.14.0, the Vala compiler
 * generated from json_soup.vala, do not modify */

/* -*- coding: utf-8; indent-tabs-mode: nil; tab-width: 4; c-basic-offset: 4; -*- */
/* vim:set fileencodings=utf-8 tabstop=4 expandtab shiftwidth=4 softtabstop=4: */

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <float.h>
#include <math.h>


#define TYPE_JSON_SOUP (json_soup_get_type ())
#define JSON_SOUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_JSON_SOUP, JsonSoup))
#define JSON_SOUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_JSON_SOUP, JsonSoupClass))
#define IS_JSON_SOUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_JSON_SOUP))
#define IS_JSON_SOUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_JSON_SOUP))
#define JSON_SOUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_JSON_SOUP, JsonSoupClass))

typedef struct _JsonSoup JsonSoup;
typedef struct _JsonSoupClass JsonSoupClass;
typedef struct _JsonSoupPrivate JsonSoupPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define __vala_JsonObject_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonObject_free (var), NULL)))
#define __vala_JsonArray_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonArray_free (var), NULL)))

struct _JsonSoup {
	GObject parent_instance;
	JsonSoupPrivate * priv;
};

struct _JsonSoupClass {
	GObjectClass parent_class;
};

struct _JsonSoupPrivate {
	JsonParser* parser;
	JsonNode* node;
};


static gpointer json_soup_parent_class = NULL;

GType json_soup_get_type (void) G_GNUC_CONST;
#define JSON_SOUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_JSON_SOUP, JsonSoupPrivate))
enum  {
	JSON_SOUP_DUMMY_PROPERTY
};
JsonSoup* json_soup_new_buffer (const gchar* buffer);
JsonSoup* json_soup_construct_buffer (GType object_type, const gchar* buffer);
JsonSoup* json_soup_new_file (const gchar* file);
JsonSoup* json_soup_construct_file (GType object_type, const gchar* file);
JsonSoup* json_soup_new_http (const gchar* url);
JsonSoup* json_soup_construct_http (GType object_type, const gchar* url);
static void _vala_SoupURI_free (SoupURI* self);
JsonSoup* json_soup_object (JsonSoup* self, const gchar* name);
static JsonObject* _vala_JsonObject_copy (JsonObject* self);
static void _vala_JsonObject_free (JsonObject* self);
JsonSoup* json_soup_sibling (JsonSoup* self, const gchar* name);
JsonSoup* json_soup_parent (JsonSoup* self);
JsonSoup* json_soup_array (JsonSoup* self, gint idx);
static JsonArray* _vala_JsonArray_copy (JsonArray* self);
static void _vala_JsonArray_free (JsonArray* self);
JsonSoup* json_soup_grandparent (JsonSoup* self);
JsonSoup* json_soup_reset (JsonSoup* self);
static gboolean json_soup_is_value (JsonSoup* self);
gboolean json_soup_is_object (JsonSoup* self);
gboolean json_soup_is_array (JsonSoup* self);
gboolean json_soup_is_string (JsonSoup* self);
gboolean json_soup_is_int (JsonSoup* self);
gboolean json_soup_is_double (JsonSoup* self);
gboolean json_soup_is_bool (JsonSoup* self);
gchar* json_soup_get_string (JsonSoup* self);
gint64 json_soup_get_int (JsonSoup* self);
gdouble json_soup_get_double (JsonSoup* self);
gboolean json_soup_get_bool (JsonSoup* self);
gint json_soup_length (JsonSoup* self);
JsonSoup* json_soup_new (void);
JsonSoup* json_soup_construct (GType object_type);
static void json_soup_finalize (GObject* obj);


JsonSoup* json_soup_construct_buffer (GType object_type, const gchar* buffer) {
	JsonSoup * self = NULL;
	JsonParser* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (buffer != NULL, NULL);
	self = (JsonSoup*) g_object_new (object_type, NULL);
	_tmp0_ = json_parser_new ();
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = _tmp0_;
	{
		JsonParser* _tmp1_;
		const gchar* _tmp2_;
		JsonParser* _tmp3_;
		JsonNode* _tmp4_ = NULL;
		_tmp1_ = self->priv->parser;
		_tmp2_ = buffer;
		json_parser_load_from_data (_tmp1_, _tmp2_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp3_ = self->priv->parser;
		_tmp4_ = json_parser_get_root (_tmp3_);
		self->priv->node = _tmp4_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("json_soup.vala:34: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


JsonSoup* json_soup_new_buffer (const gchar* buffer) {
	return json_soup_construct_buffer (TYPE_JSON_SOUP, buffer);
}


JsonSoup* json_soup_construct_file (GType object_type, const gchar* file) {
	JsonSoup * self = NULL;
	JsonParser* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (JsonSoup*) g_object_new (object_type, NULL);
	_tmp0_ = json_parser_new ();
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = _tmp0_;
	{
		JsonParser* _tmp1_;
		const gchar* _tmp2_;
		JsonParser* _tmp3_;
		JsonNode* _tmp4_ = NULL;
		_tmp1_ = self->priv->parser;
		_tmp2_ = file;
		json_parser_load_from_file (_tmp1_, _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_tmp3_ = self->priv->parser;
		_tmp4_ = json_parser_get_root (_tmp3_);
		self->priv->node = _tmp4_;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("json_soup.vala:43: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


JsonSoup* json_soup_new_file (const gchar* file) {
	return json_soup_construct_file (TYPE_JSON_SOUP, file);
}


static void _vala_SoupURI_free (SoupURI* self) {
	g_boxed_free (soup_uri_get_type (), self);
}


JsonSoup* json_soup_construct_http (GType object_type, const gchar* url) {
	JsonSoup * self = NULL;
	SoupSessionSync* _tmp0_;
	SoupSessionSync* session;
	const gchar* _tmp1_;
	SoupURI* _tmp2_;
	SoupURI* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* message;
	SoupSessionSync* _tmp6_;
	SoupMessage* _tmp7_;
	guint _tmp8_ = 0U;
	JsonParser* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (url != NULL, NULL);
	self = (JsonSoup*) g_object_new (object_type, NULL);
	_tmp0_ = (SoupSessionSync*) soup_session_sync_new ();
	session = _tmp0_;
	_tmp1_ = url;
	_tmp2_ = soup_uri_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = soup_message_new_from_uri ("GET", _tmp3_);
	_tmp5_ = _tmp4_;
	__vala_SoupURI_free0 (_tmp3_);
	message = _tmp5_;
	_tmp6_ = session;
	_tmp7_ = message;
	_tmp8_ = soup_session_send_message ((SoupSession*) _tmp6_, _tmp7_);
	if (_tmp8_ != ((guint) 200)) {
		const gchar* _tmp9_;
		_tmp9_ = url;
		g_warning ("json_soup.vala:50: Can not connect to %s", _tmp9_);
	}
	_tmp10_ = json_parser_new ();
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = _tmp10_;
	{
		JsonParser* _tmp11_;
		SoupMessage* _tmp12_;
		SoupMessageBody* _tmp13_;
		guint8* _tmp14_;
		gint _tmp14__length1;
		JsonParser* _tmp15_;
		JsonNode* _tmp16_ = NULL;
		_tmp11_ = self->priv->parser;
		_tmp12_ = message;
		_tmp13_ = _tmp12_->response_body;
		_tmp14_ = _tmp13_->data;
		_tmp14__length1 = (gint) _tmp13_->length;
		json_parser_load_from_data (_tmp11_, (const gchar*) _tmp14_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_tmp15_ = self->priv->parser;
		_tmp16_ = json_parser_get_root (_tmp15_);
		self->priv->node = _tmp16_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("json_soup.vala:57: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (message);
	_g_object_unref0 (session);
	return self;
}


JsonSoup* json_soup_new_http (const gchar* url) {
	return json_soup_construct_http (TYPE_JSON_SOUP, url);
}


static JsonObject* _vala_JsonObject_copy (JsonObject* self) {
	return g_boxed_copy (json_object_get_type (), self);
}


static gpointer __vala_JsonObject_copy0 (gpointer self) {
	return self ? _vala_JsonObject_copy (self) : NULL;
}


static void _vala_JsonObject_free (JsonObject* self) {
	g_boxed_free (json_object_get_type (), self);
}


JsonSoup* json_soup_object (JsonSoup* self, const gchar* name) {
	JsonSoup* result = NULL;
	JsonNode* _tmp0_;
	JsonNodeType _tmp1_ = 0;
	JsonNode* _tmp2_;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_;
	JsonObject* object;
	JsonObject* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	JsonObject* _tmp9_;
	const gchar* _tmp10_;
	JsonNode* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->node;
	_tmp1_ = json_node_get_node_type (_tmp0_);
	if (_tmp1_ != JSON_NODE_OBJECT) {
		g_warning ("json_soup.vala:70: This is not a object.");
		result = self;
		return result;
	}
	_tmp2_ = self->priv->node;
	_tmp3_ = json_node_get_object (_tmp2_);
	_tmp4_ = __vala_JsonObject_copy0 (_tmp3_);
	object = _tmp4_;
	_tmp5_ = object;
	_tmp6_ = name;
	_tmp7_ = json_object_has_member (_tmp5_, _tmp6_);
	if (_tmp7_ == FALSE) {
		const gchar* _tmp8_;
		_tmp8_ = name;
		g_warning ("json_soup.vala:75: There is no such member as %s.", _tmp8_);
		result = self;
		__vala_JsonObject_free0 (object);
		return result;
	}
	_tmp9_ = object;
	_tmp10_ = name;
	_tmp11_ = json_object_get_member (_tmp9_, _tmp10_);
	self->priv->node = _tmp11_;
	result = self;
	__vala_JsonObject_free0 (object);
	return result;
}


JsonSoup* json_soup_sibling (JsonSoup* self, const gchar* name) {
	JsonSoup* result = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	json_soup_parent (self);
	_tmp0_ = name;
	json_soup_object (self, _tmp0_);
	result = self;
	return result;
}


static JsonArray* _vala_JsonArray_copy (JsonArray* self) {
	return g_boxed_copy (json_array_get_type (), self);
}


static gpointer __vala_JsonArray_copy0 (gpointer self) {
	return self ? _vala_JsonArray_copy (self) : NULL;
}


static void _vala_JsonArray_free (JsonArray* self) {
	g_boxed_free (json_array_get_type (), self);
}


JsonSoup* json_soup_array (JsonSoup* self, gint idx) {
	JsonSoup* result = NULL;
	JsonNode* _tmp0_;
	JsonNodeType _tmp1_ = 0;
	JsonNode* _tmp2_;
	JsonArray* _tmp3_ = NULL;
	JsonArray* _tmp4_;
	JsonArray* array;
	JsonArray* _tmp5_;
	guint _tmp6_ = 0U;
	gint length;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp11_;
	JsonArray* _tmp13_;
	gint _tmp14_;
	JsonNode* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->node;
	_tmp1_ = json_node_get_node_type (_tmp0_);
	if (_tmp1_ != JSON_NODE_ARRAY) {
		g_warning ("json_soup.vala:88: This is not a array.");
		result = self;
		return result;
	}
	_tmp2_ = self->priv->node;
	_tmp3_ = json_node_get_array (_tmp2_);
	_tmp4_ = __vala_JsonArray_copy0 (_tmp3_);
	array = _tmp4_;
	_tmp5_ = array;
	_tmp6_ = json_array_get_length (_tmp5_);
	length = (gint) _tmp6_;
	_tmp8_ = idx;
	_tmp9_ = length;
	if (_tmp8_ > _tmp9_) {
		_tmp7_ = TRUE;
	} else {
		gint _tmp10_;
		_tmp10_ = idx;
		_tmp7_ = _tmp10_ < 0;
	}
	_tmp11_ = _tmp7_;
	if (_tmp11_) {
		gint _tmp12_;
		_tmp12_ = idx;
		g_warning ("json_soup.vala:94: Out of index. %d", _tmp12_);
		result = self;
		__vala_JsonArray_free0 (array);
		return result;
	}
	_tmp13_ = array;
	_tmp14_ = idx;
	_tmp15_ = json_array_get_element (_tmp13_, (guint) _tmp14_);
	self->priv->node = _tmp15_;
	result = self;
	__vala_JsonArray_free0 (array);
	return result;
}


JsonSoup* json_soup_parent (JsonSoup* self) {
	JsonSoup* result = NULL;
	JsonNode* _tmp0_;
	JsonNode* _tmp1_ = NULL;
	JsonNode* parent_node;
	JsonNode* _tmp2_;
	JsonNode* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->node;
	_tmp1_ = json_node_get_parent (_tmp0_);
	parent_node = _tmp1_;
	_tmp2_ = parent_node;
	if (_tmp2_ == NULL) {
		g_warning ("json_soup.vala:103: Already be root.");
		result = self;
		return result;
	}
	_tmp3_ = parent_node;
	self->priv->node = _tmp3_;
	result = self;
	return result;
}


JsonSoup* json_soup_grandparent (JsonSoup* self) {
	JsonSoup* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	json_soup_parent (self);
	json_soup_parent (self);
	result = self;
	return result;
}


JsonSoup* json_soup_reset (JsonSoup* self) {
	JsonSoup* result = NULL;
	JsonParser* _tmp0_;
	JsonNode* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->parser;
	_tmp1_ = json_parser_get_root (_tmp0_);
	self->priv->node = _tmp1_;
	result = self;
	return result;
}


static gboolean json_soup_is_value (JsonSoup* self) {
	gboolean result = FALSE;
	JsonNode* _tmp0_;
	JsonNodeType _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->node;
	_tmp1_ = json_node_get_node_type (_tmp0_);
	if (_tmp1_ == JSON_NODE_VALUE) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


gboolean json_soup_is_object (JsonSoup* self) {
	gboolean result = FALSE;
	JsonNode* _tmp0_;
	JsonNodeType _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->node;
	_tmp1_ = json_node_get_node_type (_tmp0_);
	result = _tmp1_ == JSON_NODE_OBJECT;
	return result;
}


gboolean json_soup_is_array (JsonSoup* self) {
	gboolean result = FALSE;
	JsonNode* _tmp0_;
	JsonNodeType _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->node;
	_tmp1_ = json_node_get_node_type (_tmp0_);
	result = _tmp1_ == JSON_NODE_ARRAY;
	return result;
}


gboolean json_soup_is_string (JsonSoup* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	JsonNode* _tmp1_;
	GType _tmp2_ = 0UL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_soup_is_value (self);
	if (_tmp0_ == FALSE) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->node;
	_tmp2_ = json_node_get_value_type (_tmp1_);
	result = _tmp2_ == G_TYPE_STRING;
	return result;
}


gboolean json_soup_is_int (JsonSoup* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	JsonNode* _tmp1_;
	GType _tmp2_ = 0UL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_soup_is_value (self);
	if (_tmp0_ == FALSE) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->node;
	_tmp2_ = json_node_get_value_type (_tmp1_);
	result = _tmp2_ == G_TYPE_INT64;
	return result;
}


gboolean json_soup_is_double (JsonSoup* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	JsonNode* _tmp1_;
	GType _tmp2_ = 0UL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_soup_is_value (self);
	if (_tmp0_ == FALSE) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->node;
	_tmp2_ = json_node_get_value_type (_tmp1_);
	result = _tmp2_ == G_TYPE_DOUBLE;
	return result;
}


gboolean json_soup_is_bool (JsonSoup* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	JsonNode* _tmp1_;
	GType _tmp2_ = 0UL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = json_soup_is_value (self);
	if (_tmp0_ == FALSE) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->node;
	_tmp2_ = json_node_get_value_type (_tmp1_);
	result = _tmp2_ == G_TYPE_BOOLEAN;
	return result;
}


gchar* json_soup_get_string (JsonSoup* self) {
	gchar* result = NULL;
	JsonNode* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->node;
	_tmp1_ = json_node_get_string (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


gint64 json_soup_get_int (JsonSoup* self) {
	gint64 result = 0LL;
	JsonNode* _tmp0_;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->node;
	_tmp1_ = json_node_get_int (_tmp0_);
	result = _tmp1_;
	return result;
}


gdouble json_soup_get_double (JsonSoup* self) {
	gdouble result = 0.0;
	JsonNode* _tmp0_;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->node;
	_tmp1_ = json_node_get_double (_tmp0_);
	result = _tmp1_;
	return result;
}


gboolean json_soup_get_bool (JsonSoup* self) {
	gboolean result = FALSE;
	JsonNode* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->node;
	_tmp1_ = json_node_get_boolean (_tmp0_);
	result = _tmp1_;
	return result;
}


gint json_soup_length (JsonSoup* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	JsonNode* _tmp1_;
	JsonArray* _tmp2_ = NULL;
	JsonArray* _tmp3_;
	JsonArray* array;
	JsonArray* _tmp4_;
	guint _tmp5_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = json_soup_is_array (self);
	if (_tmp0_ == FALSE) {
		result = 0;
		return result;
	}
	_tmp1_ = self->priv->node;
	_tmp2_ = json_node_get_array (_tmp1_);
	_tmp3_ = __vala_JsonArray_copy0 (_tmp2_);
	array = _tmp3_;
	_tmp4_ = array;
	_tmp5_ = json_array_get_length (_tmp4_);
	result = (gint) _tmp5_;
	__vala_JsonArray_free0 (array);
	return result;
}


JsonSoup* json_soup_construct (GType object_type) {
	JsonSoup * self = NULL;
	self = (JsonSoup*) g_object_new (object_type, NULL);
	return self;
}


JsonSoup* json_soup_new (void) {
	return json_soup_construct (TYPE_JSON_SOUP);
}


static void json_soup_class_init (JsonSoupClass * klass) {
	json_soup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (JsonSoupPrivate));
	G_OBJECT_CLASS (klass)->finalize = json_soup_finalize;
}


static void json_soup_instance_init (JsonSoup * self) {
	self->priv = JSON_SOUP_GET_PRIVATE (self);
	self->priv->parser = NULL;
	self->priv->node = NULL;
}


static void json_soup_finalize (GObject* obj) {
	JsonSoup * self;
	self = JSON_SOUP (obj);
	self->priv->node = NULL;
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = NULL;
	_g_object_unref0 (self->priv->parser);
	G_OBJECT_CLASS (json_soup_parent_class)->finalize (obj);
}


/**
 * Copyright (C) 2010 Shih-Yuan Lee (FourDollars) <fourdollars@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
GType json_soup_get_type (void) {
	static volatile gsize json_soup_type_id__volatile = 0;
	if (g_once_init_enter (&json_soup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (JsonSoupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) json_soup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (JsonSoup), 0, (GInstanceInitFunc) json_soup_instance_init, NULL };
		GType json_soup_type_id;
		json_soup_type_id = g_type_register_static (G_TYPE_OBJECT, "JsonSoup", &g_define_type_info, 0);
		g_once_init_leave (&json_soup_type_id__volatile, json_soup_type_id);
	}
	return json_soup_type_id__volatile;
}



