#!/bin/bash

# java 1.4.2 is not supported any more since oct 2008
MINJAVAVER=1.5
MACHINETYPE=i386
OSXVER=10.5

#########################################
# we must be running on intel
#########################################
echo "[Info ] Verifying machine type..."
MACHINE=`uname -p`
if [ "$MACHINE" != "i386" ]
then
	echo "[Error] Incorrect machine type. Must be $MACHINETYPE."
	exit -1
else
	echo "[Info ] Machine type: $MACHINE."
fi

#########################################
# we must be on a 10.5
#########################################
echo "[Info ] Verifying OSX version..."
IFS=$'\n' ver=($(sw_vers))
ver=(${ver[1]})

if [[ $ver != *$OSXVER* ]]
then
	echo "[Error] Incorrect OS version: $ver. Must be $OSXVER."
	exit -1	
else
	echo "[Info ] OSX version: $ver[1]."
fi


#########################################
# check gcc compiler installed
#########################################
GCC=`which gcc 2> /dev/null | wc -l`
echo "[Info ] Verifying gcc compiler..."
if [[ $GCC -eq 0 ]]
then
	echo "[Error] gcc compiler not found. Please verify or install."
	exit -1

else
	GCCVER=`gcc --version`
	echo "[Info ] Installed. gcc version: $GCCVER"
fi

#########################################
# check g++ compiler installed
#########################################
echo "[Info ] Verifying g++ compiler..."
GPP=`which g++ 2> /dev/null | wc -l`
if [ $GPP -eq 0  ]
then
	echo "[Error] g++ compiler not found. Please verify or install."
	exit -1
else
	GPPVER=`g++ --version`
	echo "[Info ] Installed. g++ version: $GPPVER"
fi

#########################################
# check xerces installed
#########################################
XERCESCLIB=libxerces-c.28.0.dylib
XERCESCPATH=../_src/ThirdParty/Xerces/Xerces-2.8.0-mac
echo "[Info ] Verifying xerces libraries..."
if [ ! -e $XERCESCPATH/lib/$XERCESCLIB ]
then
	echo "[Error] xerces library not found at $XERCESCPATH/lib. Please verify or install."
	exit -1
else
	echo "[Info ] Installed"
fi

echo "[Info ] Verifying xerces include..."
XERCESCINC=SAXParser.hpp
if [ ! -e $XERCESCPATH/include/xercesc/parsers/$XERCESCINC ]
then
	echo "[Error] xerces include file not found at $XERCESPATH//include/xercesc/parsers/. Please verify or install."
	exit -1
else
	echo "[Info ] Installed"
fi


#########################################
# check Qt4 installed
#########################################

MINQT4VER=4.5.0
pkg=qmake

echo "[Info ] Checking Qt4"

QT4=`which $pkg 2> /dev/null | wc -l`
if [ $QT4 -eq 0 ]
then
	echo "[Error] qmake can not be found."
	echo "[Error] Set the PATH environment variable or download/install Qt4 and try again."
	exit -1
else
	#-----------------------------------------
	# parse the version string assumed to be in the format: XXX.YYY.ZZZ
	# we use 'moc' to make parsing of the version nr easier
	#-----------------------------------------
	QT4=`which qmake`
	THEPATH=${QT4%/*}
	QT4VERSION=`${THEPATH}/moc -v 2>&1`
	VERSIONSTR=`expr ${QT4VERSION} : '.*\([1-9]\.[0-9]\.[0-9]\)'`

	if [[ "${VERSIONSTR}" = "${MINQT4VER}" ]]
	then
		echo "[Info ] Qt4 version ${VERSIONSTR} found at ${THEPATH}"
	else if [[ "${VERSIONSTR}" > "${MINQT4VER}" ]]
		then
			echo "[Warn ] Qt4 version ${VERSIONSTR} found at ${THEPATH}"
			echo "[Warn ] The Qt4 version used is ideally ${MINQT4VER}"
			echo "[Warn ] If needed, stop the process and install Qt4 ${MINQT4VER}"
		else
			echo "[Error] Minimum Qt4 version ${MINQT4VER} not installed"
		exit -1
	fi
	fi
fi


#-----------------------------------------
# verify the java installation
# we assume that a JDK is installed. To find out the jdk version we have to find the java
# command. When a JDK is installed, the java will be at the same location as the javac.
# therefor, we first try to locate the javac, and from that path, we execute the java -version
# command.
# we parse the output and compare this to the predefined minimum java version
#-----------------------------------------
pkg=javac

echo "[Info ] Verifying JDK"

JDK=`which javac 2> /dev/null | wc -l`
if [ $JDK -eq 0 ]
then
	echo "[Error] javac can not be found."
	echo "[Error] Set the PATH environment variable or download/install the jdk and try again."
	exit -1
else
	#-----------------------------------------
	# get the path of the javac and execute from this path the 'java -version' command
	# parse the version string assumed to be in the format: XXX.YYY.ZZZ_NNN
	#-----------------------------------------
	JDK=`which javac`
	THEPATH=${JDK%/*}
	IFS=$'\n' JAVAVERSION=($(${THEPATH}/javac -version 2>&1))

	VERSIONSTR=`expr $JAVAVERSION : '.*\([1-9]\.[0-9]\.[0-9]\)'`

	if [[ "${VERSIONSTR}" == "*${MINJAVAVER}*" ]]
	then
		echo "[Info ] Java version ${VERSIONSTR} found at ${THEPATH}"
	else if [[ "${VERSIONSTR}" > "${MINJAVAVER}" ]]
		then
			echo "[Warn ] Java version ${VERSIONSTR} found at ${THEPATH}"
			echo "[Warn ] The java version used is ideally ${MINJAVAVER}"
			echo "[Warn ] If needed, stop the process and install java ${MINJAVAVER}"
		else
			echo "[Error] javac version ${VERSIONSTR} must be higher than ${MINJAVAVER} "
			echo "[Error] Install version ${MINJAVAVER} or higher of the jdk."
			exit -1
		fi
	fi
fi

#-----------------------------------------
# make sure scripts are executable
#-----------------------------------------
CURRDIR=`pwd`
cd ../_src/eidmw
chmod +x configure_mac.sh
chmod +x configure

#-----------------------------------------
# configure and build the eID MW
# we don't run the makefile just like that because we want
# to control what is built
#-----------------------------------------
./configure_mac.sh
if [[ "${UNIVERSAL}" != "true" ]]
then
	make
fi
cd -

if [[ "${UNIVERSAL}" == "true" ]]
then
	cd ../_src/eidmw/_Builds
	xcodebuild -configuration Release
	cd -
fi

#-----------------------------------------
# Check the tokend is present, otherwise unzip the sources
#-----------------------------------------
if [ -d ../_src/eidmw/tokend/Sources ]
then
	cd ../_src/eidmw/tokend
	sudo rm -rf Sources
	cd -
fi

cd ../_src/eidmw/tokend 
tar -xvf SourcesDeploy.tar.gz
cd -

#-----------------------------------------
# build the tokend
#-----------------------------------------
cd ../_src/eidmw/tokend/Sources

xcodebuild -configuration Deployment

if [ ! -d build/Deployment/BEID.tokend ] 
then
	echo "[Error] Build tokend failed"
	exit -1
fi

if [ -d ../../bin/BEID.tokend ] 
then
	rm -rf ../../bin/BEID.tokend
fi

mv build/Deployment/BEID.tokend ../../bin

cd -

#-----------------------------------------
# 
#-----------------------------------------
cd ../_src/eidmw/misc/mac/OOoRegister
make
cd -

#-----------------------------------------
# create a pkg and dmg file
# The makefile requires
#-----------------------------------------
cd ../_src/eidmw/_Builds
sudo make -f Makefile_mac release QTBASEDIR=$QTBASEDIR UNIVERSAL=${UNIVERSAL}
cd -

#-----------------------------------------
# build the Quickinstaller in release mode
#-----------------------------------------
cd ../_src/eID-QuickInstaller/eID-EZinstaller
xcodebuild -project eID-EZinstaller.xcodeproj clean
xcodebuild -project eID-EZinstaller.xcodeproj -target eID-Quickinstaller -configuration Release
cd -

BUILDNR=`cat ../_src/eidmw/svn_revision | tr -d "\r"`

#-----------------------------------------
# move the beid.pkg to the quickinstaller and keep a copy locally
#-----------------------------------------
sudo rm -rf beid-$BUILDNR.pkg

sudo cp -r /release_build/beid.pkg .
sudo mv beid.pkg beid-$BUILDNR.pkg

#-----------------------------------------
# move the QuickInstaller dmg here with the correct build nr
#-----------------------------------------
if [ -e eID-Quickinstaller-$BUILDNR.dmg ]
then
	rm eID-Quickinstaller-$BUILDNR.dmg
fi
echo "[Info ] Copy ../_src/eID-QuickInstaller/eID-EZinstaller/build/Release/eID-Quickinstaller-$BUILDNR.dmg to ./eID-Quickinstaller-$BUILDNR.dmg "
cp ../_src/eID-QuickInstaller/eID-EZinstaller/build/Release/eID-Quickinstaller-$BUILDNR.dmg eID-Quickinstaller-$BUILDNR.dmg
echo "[Info ] Done..."
