/* ****************************************************************************

 * eID Middleware Project.
 * Copyright (C) 2008-2009 FedICT.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version
 * 3.0 as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, see
 * http://www.gnu.org/licenses/.

**************************************************************************** */
#include "EmulationCardFactory.h"

using namespace eIDMW;
static bool m_bCardInitialized = false;

/////////////////////////////////////////////////////////////////////////////////
// This is a test card containing data provided by Beid CARDS.
// It contains valid keys and valid/signature ID/address/photo values.

static CEmulationBeidCard *m_BeidV1Test1 = NULL;
static bool m_bBeidV1Test1Initialized = false;

CEmulationCard * CEmulationCardFactory::MakeBeidV1Test1()
{
	if(!m_bCardInitialized)
		Init();

	CEmulationBeidCard *poEmulationCard = m_BeidV1Test1;

	if (m_bBeidV1Test1Initialized)
		return poEmulationCard; // already intialized

	unsigned char tucATR[] =
		{0x3B,0x98,0x13,0x40,0x0A,0xA5,0x03,0x01,0x01,0x01,0xAD,0x13,0x11};
	poEmulationCard->SetATR(CByteArray(tucATR, sizeof(tucATR)));

	// MF
	poEmulationCard->PutPin("3F00",
		1, "1234", 4, 12, 8, PIN_ENC_GP, 3, 0xFF,
		"12345678", 0);

	// Belpic DF
	unsigned char tucBelpicAID[] = {0xA0,0x00,0x00,0x01,0x77,0x50,0x4B,0x43,0x53,0x2D,0x31,0x35};
	poEmulationCard->PutDF("3F00DF00", CByteArray(tucBelpicAID, sizeof(tucBelpicAID)));

	// ID DF
	poEmulationCard->PutDF("3F00DF01");

    // EF(DIR)
    unsigned char tuc3F002F00[] = {
        0x61,0x23,0x4f,0x0c,0xa0,0x00,0x00,0x01,0x77,0x50,0x4b,0x43,0x53,0x2d,0x31,0x35,
        0x50,0x06,0x42,0x45,0x4c,0x50,0x49,0x43,0x51,0x04,0x3f,0x00,0xdf,0x00,0x73,0x05,
        0x06,0x03,0x60,0x38,0x02,
    };
    poEmulationCard->PutTransparentEF("3F002F00",
        CByteArray(tuc3F002F00, (unsigned long) sizeof(tuc3F002F00)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ODF)
    unsigned char tuc3F00DF005031[] = {
        0xa0,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x35,0xa4,0x0a,0x30,0x08,
        0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x37,0xa8,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,
        0xdf,0x00,0x50,0x34,
    };
    poEmulationCard->PutTransparentEF("3F00DF005031",
        CByteArray(tuc3F00DF005031, (unsigned long) sizeof(tuc3F00DF005031)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(TokenInfo)
    unsigned char tuc3F00DF005032[] = {
        0x30,0x27,0x02,0x01,0x00,0x04,0x10,0x53,0x4c,0x49,0x4e,0x33,0x66,0x00,0x29,0x6c,
        0xff,0x26,0x23,0x00,0x00,0x00,0xe1,0x80,0x06,0x42,0x45,0x4c,0x50,0x49,0x43,0x03,
        0x02,0x04,0x30,0x9e,0x04,0x04,0x02,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005032",
        CByteArray(tuc3F00DF005032, (unsigned long) sizeof(tuc3F00DF005032)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(AODF)
    unsigned char tuc3F00DF005034[] = {
        0x30,0x33,0x30,0x0f,0x0c,0x09,0x42,0x61,0x73,0x69,0x63,0x20,0x50,0x49,0x4e,0x03,
        0x02,0x06,0xc0,0x30,0x03,0x04,0x01,0x01,0xa1,0x1b,0x30,0x19,0x03,0x02,0x02,0x0c,
        0x0a,0x01,0x00,0x02,0x01,0x04,0x02,0x01,0x08,0x80,0x01,0x01,0x04,0x01,0xff,0x30,
        0x04,0x04,0x02,0x3f,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005034",
        CByteArray(tuc3F00DF005034, (unsigned long) sizeof(tuc3F00DF005034)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(PrKDF)
    unsigned char tuc3F00DF005035[] = {
        0x30,0x3a,0x30,0x17,0x0c,0x0e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,
        0x74,0x69,0x6f,0x6e,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x0f,0x04,0x01,0x02,
        0x03,0x02,0x05,0x20,0x03,0x02,0x03,0xb8,0x02,0x02,0x00,0x82,0xa1,0x0e,0x30,0x0c,
        0x30,0x06,0x04,0x04,0x3f,0x00,0xdf,0x00,0x02,0x02,0x04,0x00,0x30,0x39,0x30,0x15,
        0x0c,0x09,0x53,0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x03,0x02,0x06,0xc0,0x04,
        0x01,0x01,0x02,0x01,0x01,0x30,0x10,0x04,0x01,0x03,0x03,0x03,0x06,0x00,0x40,0x03,
        0x02,0x03,0xb8,0x02,0x02,0x00,0x83,0xa1,0x0e,0x30,0x0c,0x30,0x06,0x04,0x04,0x3f,
        0x00,0xdf,0x00,0x02,0x02,0x04,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005035",
        CByteArray(tuc3F00DF005035, (unsigned long) sizeof(tuc3F00DF005035)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(CDF)
    unsigned char tuc3F00DF005037[] = {
        0x30,0x2c,0x30,0x17,0x0c,0x0e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,
        0x74,0x69,0x6f,0x6e,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x03,0x04,0x01,0x02,
        0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x38,0x30,0x27,
        0x30,0x12,0x0c,0x09,0x53,0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x03,0x02,0x06,
        0xc0,0x04,0x01,0x01,0x30,0x03,0x04,0x01,0x03,0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,
        0x06,0x3f,0x00,0xdf,0x00,0x50,0x39,0x30,0x23,0x30,0x0b,0x0c,0x02,0x43,0x41,0x03,
        0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x06,0x04,0x01,0x04,0x01,0x01,0xff,0xa1,0x0c,
        0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x3a,0x30,0x25,0x30,0x0d,
        0x0c,0x04,0x52,0x6f,0x6f,0x74,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x06,0x04,
        0x01,0x06,0x01,0x01,0xff,0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,
        0x00,0x50,0x3b,
    };
    poEmulationCard->PutTransparentEF("3F00DF005037",
        CByteArray(tuc3F00DF005037, (unsigned long) sizeof(tuc3F00DF005037)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#2) (authentication)
	unsigned char tuc3F00DF005038[] = {
		0x30,0x82,0x03,0xf6,0x30,0x82,0x02,0xde,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x01,0x15,0xa8,0xd3,0x59,0x66,0x00,0x00,0xce,0xc0,0x03,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x37,
		0x31,0x1a,0x30,0x18,0x06,0x03,0x55,0x04,0x06,0x13,0x11,0x42,0x45,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x31,0x19,0x30,0x17,
		0x06,0x03,0x55,0x04,0x03,0x13,0x10,0x5a,0x45,0x54,0x45,0x53,0x20,0x43,0x69,0x74,
		0x69,0x7a,0x65,0x6e,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x37,0x31,0x30,0x31,
		0x35,0x31,0x32,0x33,0x39,0x32,0x34,0x5a,0x17,0x0d,0x31,0x32,0x31,0x30,0x31,0x35,
		0x31,0x32,0x33,0x39,0x32,0x34,0x5a,0x30,0x6c,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,
		0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x26,0x30,0x24,0x06,0x03,0x55,0x04,0x03,0x13,
		0x1d,0x67,0x6e,0x61,0x6d,0x65,0x30,0x20,0x6e,0x61,0x6d,0x65,0x30,0x20,0x28,0x41,
		0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x29,0x31,0x0e,
		0x30,0x0c,0x06,0x03,0x55,0x04,0x04,0x13,0x05,0x6e,0x61,0x6d,0x65,0x30,0x31,0x0f,
		0x30,0x0d,0x06,0x03,0x55,0x04,0x2a,0x13,0x06,0x67,0x6e,0x61,0x6d,0x65,0x30,0x31,
		0x14,0x30,0x12,0x06,0x03,0x55,0x04,0x05,0x13,0x0b,0x30,0x30,0x30,0x30,0x30,0x30,
		0x30,0x30,0x30,0x30,0x30,0x30,0x81,0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,
		0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,
		0x81,0x00,0xdd,0x15,0xe4,0xaa,0xd6,0x3b,0xea,0xef,0x8a,0x5c,0x1f,0xd9,0x86,0x29,
		0x04,0xbb,0x10,0xf8,0xce,0x9f,0x86,0x7d,0xaf,0x4f,0xba,0xca,0x24,0xaa,0xc1,0x18,
		0x27,0xae,0xd1,0xf6,0x60,0x3e,0x72,0x8c,0x7f,0x97,0xbc,0xe3,0x22,0xc6,0x47,0x4c,
		0xb4,0x7c,0x03,0x6f,0x4a,0x22,0xb3,0x7f,0x7e,0x13,0xd0,0xb4,0x26,0xc9,0x29,0xe7,
		0x82,0x72,0x55,0xaf,0x73,0x19,0x31,0x52,0xb8,0x49,0xa4,0xbe,0xdb,0x82,0x01,0x13,
		0xfd,0x32,0x87,0xb3,0x5f,0x53,0x2d,0x20,0x7d,0x17,0x9d,0x37,0x48,0xf4,0xcb,0xa8,
		0x1f,0x08,0x5d,0xf3,0x32,0x05,0x6a,0x7f,0xa3,0x2e,0xab,0x39,0x2b,0x5f,0xf1,0x43,
		0xd3,0x7e,0x33,0xb7,0x3c,0x43,0x3d,0xd3,0xec,0xb2,0x50,0x06,0x51,0x8b,0xb5,0x72,
		0xf8,0x9d,0x02,0x03,0x01,0x00,0x01,0xa3,0x82,0x01,0x4b,0x30,0x82,0x01,0x47,0x30,
		0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x07,0x80,0x30,
		0x45,0x06,0x03,0x55,0x1d,0x20,0x04,0x3e,0x30,0x3c,0x30,0x3a,0x06,0x07,0x60,0x38,
		0x01,0x01,0x01,0x02,0x02,0x30,0x2f,0x30,0x2d,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,
		0x07,0x02,0x01,0x16,0x21,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,
		0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,
		0x2e,0x62,0x65,0x20,0x20,0x20,0x30,0x3c,0x06,0x03,0x55,0x1d,0x1f,0x04,0x35,0x30,
		0x33,0x30,0x31,0xa0,0x2f,0xa0,0x2d,0x86,0x2b,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,
		0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,
		0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,
		0x2e,0x63,0x72,0x6c,0x30,0x7c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01,
		0x04,0x70,0x30,0x6e,0x30,0x3f,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02,
		0x86,0x33,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x5a,0x65,0x74,
		0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,0x65,0x2f,0x64,0x75,0x6d,0x6d,0x79,
		0x2f,0x63,0x65,0x72,0x74,0x69,0x66,0x63,0x61,0x74,0x65,0x73,0x2f,0x74,0x65,0x73,
		0x74,0x2e,0x63,0x72,0x74,0x30,0x2b,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,
		0x01,0x86,0x1f,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x6f,0x63,0x73,0x70,0x2e,0x5a,
		0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,0x65,0x2f,0x64,0x75,0x6d,
		0x6d,0x79,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,
		0x04,0x03,0x02,0x05,0xa0,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,
		0x80,0x14,0xed,0x2b,0xa5,0x67,0x16,0xb1,0xed,0x70,0xe1,0x5d,0x55,0x7a,0x11,0x12,
		0x16,0x1c,0x97,0x41,0x56,0x96,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,
		0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x45,0x28,0x20,0xfb,0xa3,0xf1,
		0x04,0x25,0xbb,0x6c,0x4b,0x37,0x08,0xd1,0x54,0x99,0x1c,0x1c,0x28,0x4b,0xde,0x2e,
		0x53,0xf4,0x81,0x11,0xd1,0xb6,0x09,0x56,0xef,0x2c,0x30,0xfa,0x43,0x74,0x89,0xbc,
		0x05,0x06,0xc3,0xff,0x83,0x49,0xc4,0xea,0xc7,0x01,0x3e,0x67,0x75,0x74,0x71,0x59,
		0x0a,0x71,0xfb,0xf3,0xb7,0x10,0xd2,0x79,0x52,0x89,0x5f,0x1b,0xf8,0x58,0x61,0xfb,
		0xb5,0xec,0x09,0xe9,0x29,0x5c,0x1b,0x43,0x29,0x12,0x92,0x88,0xcc,0x70,0x97,0xd9,
		0xe0,0x81,0x61,0xa8,0x42,0xf8,0x88,0x57,0xf4,0x95,0x0a,0x01,0xc2,0xf4,0xa2,0xe7,
		0xfb,0x99,0xee,0xfa,0xbf,0x77,0x03,0xf9,0x6f,0xf4,0xad,0xa2,0xd9,0x01,0xd0,0x3c,
		0xdc,0x67,0xfe,0xa2,0x0b,0x82,0x7e,0x1e,0xcd,0xb2,0x45,0x4a,0x88,0x13,0xd1,0x2c,
		0x3e,0x0b,0xea,0xd0,0x2d,0x66,0xda,0x6b,0xad,0x6b,0x6e,0x5d,0x01,0x54,0x2f,0x56,
		0xdf,0xe4,0x1d,0x49,0x75,0xd5,0x1b,0x75,0xd6,0x84,0xf5,0x90,0xa9,0x68,0xce,0x87,
		0xb8,0xfe,0xb8,0x9f,0x4f,0x17,0xcb,0x62,0xbe,0xce,0x41,0x93,0x7b,0x43,0xcc,0xd5,
		0xff,0x26,0xfd,0xde,0xef,0xda,0xeb,0x0c,0x7f,0x14,0xb4,0xfd,0xe6,0xca,0x3a,0xcb,
		0xbf,0xc1,0xcc,0x71,0x43,0x1b,0x32,0xe8,0x37,0xa1,0x6d,0xe1,0xc3,0xd3,0x00,0xd5,
		0x9a,0xc1,0x38,0x92,0x71,0xb3,0xa5,0xba,0xd8,0xab,0x9f,0xb7,0x75,0xf6,0xd6,0x9a,
		0x95,0x8d,0xbb,0xe5,0x7a,0x15,0x2a,0x91,0x33,0x31,0x05,0x8a,0x4c,0x74,0xd3,0x95,
		0xbe,0x45,0xe6,0xe3,0x0e,0x64,0xc3,0xa4,0x6f,0x45,
	};
    poEmulationCard->PutTransparentEF("3F00DF005038",
        CByteArray(tuc3F00DF005038, (unsigned long) sizeof(tuc3F00DF005038)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#3) (non-repudiation)
	unsigned char tuc3F00DF005039[] = {
		0x30,0x82,0x04,0x0c,0x30,0x82,0x02,0xf4,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x01,0x15,0xa8,0xd3,0x5a,0x40,0x00,0x00,0xce,0xc0,0x04,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x37,
		0x31,0x1a,0x30,0x18,0x06,0x03,0x55,0x04,0x06,0x13,0x11,0x42,0x45,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x31,0x19,0x30,0x17,
		0x06,0x03,0x55,0x04,0x03,0x13,0x10,0x5a,0x45,0x54,0x45,0x53,0x20,0x43,0x69,0x74,
		0x69,0x7a,0x65,0x6e,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x37,0x31,0x30,0x31,
		0x35,0x31,0x32,0x33,0x39,0x32,0x34,0x5a,0x17,0x0d,0x31,0x32,0x31,0x30,0x31,0x35,
		0x31,0x32,0x33,0x39,0x32,0x34,0x5a,0x30,0x67,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,
		0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x21,0x30,0x1f,0x06,0x03,0x55,0x04,0x03,0x13,
		0x18,0x67,0x6e,0x61,0x6d,0x65,0x30,0x20,0x6e,0x61,0x6d,0x65,0x30,0x20,0x28,0x53,
		0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x29,0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,
		0x04,0x04,0x13,0x05,0x6e,0x61,0x6d,0x65,0x30,0x31,0x0f,0x30,0x0d,0x06,0x03,0x55,
		0x04,0x2a,0x13,0x06,0x67,0x6e,0x61,0x6d,0x65,0x30,0x31,0x14,0x30,0x12,0x06,0x03,
		0x55,0x04,0x05,0x13,0x0b,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
		0x30,0x81,0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,
		0x05,0x00,0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0xb9,0x1d,0x49,
		0x9b,0x9e,0x9e,0x3a,0x8c,0x3b,0x8a,0xce,0x79,0x78,0xdb,0x33,0x01,0xb8,0xd1,0x59,
		0x15,0x83,0x7b,0x91,0x91,0xbd,0xa0,0xf4,0x51,0x2b,0xf3,0x9a,0x9e,0xe3,0x56,0x42,
		0x3e,0xaf,0xfb,0x01,0xef,0xbb,0xf4,0x97,0x34,0x0c,0x21,0x12,0x82,0x4a,0x02,0x1d,
		0x90,0xce,0x3e,0x11,0xfc,0x6a,0x53,0xcd,0x8b,0xce,0xbf,0x21,0xb8,0x60,0x0a,0x89,
		0x83,0x7e,0x87,0x24,0x08,0x63,0x28,0x7f,0xb2,0xa2,0x1c,0x2a,0xfe,0x67,0xd4,0x2b,
		0xd9,0x0f,0x23,0x40,0x28,0x71,0x3e,0xd4,0xaf,0x72,0x34,0x7c,0xb5,0x37,0x7b,0x8c,
		0x5e,0x7a,0x0f,0x24,0xa6,0x43,0xa0,0x8b,0xce,0x74,0x39,0x4b,0x4f,0x85,0x30,0x85,
		0xb0,0x36,0x6f,0x45,0x06,0x34,0xee,0x2f,0xed,0x0e,0x8a,0x53,0xa5,0x02,0x03,0x01,
		0x00,0x01,0xa3,0x82,0x01,0x66,0x30,0x82,0x01,0x62,0x30,0x0e,0x06,0x03,0x55,0x1d,
		0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x06,0x40,0x30,0x46,0x06,0x03,0x55,0x1d,
		0x20,0x04,0x3f,0x30,0x3d,0x30,0x3b,0x06,0x07,0x60,0x38,0x01,0x01,0x01,0x02,0x01,
		0x30,0x30,0x30,0x2e,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x22,
		0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,
		0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,0x20,0x20,
		0x20,0x20,0x30,0x3c,0x06,0x03,0x55,0x1d,0x1f,0x04,0x35,0x30,0x33,0x30,0x31,0xa0,
		0x2f,0xa0,0x2d,0x86,0x2b,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,
		0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,
		0x67,0x69,0x75,0x6d,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,0x6c,
		0x30,0x18,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x03,0x04,0x0c,0x30,0x0a,
		0x30,0x08,0x06,0x06,0x04,0x00,0x8e,0x46,0x01,0x01,0x30,0x7c,0x06,0x08,0x2b,0x06,
		0x01,0x05,0x05,0x07,0x01,0x01,0x04,0x70,0x30,0x6e,0x30,0x3f,0x06,0x08,0x2b,0x06,
		0x01,0x05,0x05,0x07,0x30,0x02,0x86,0x33,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,
		0x77,0x77,0x2e,0x5a,0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,0x65,
		0x2f,0x64,0x75,0x6d,0x6d,0x79,0x2f,0x63,0x65,0x72,0x74,0x69,0x66,0x63,0x61,0x74,
		0x65,0x73,0x2f,0x74,0x65,0x73,0x74,0x2e,0x63,0x72,0x74,0x30,0x2b,0x06,0x08,0x2b,
		0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x86,0x1f,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,
		0x6f,0x63,0x73,0x70,0x2e,0x5a,0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,
		0x62,0x65,0x2f,0x64,0x75,0x6d,0x6d,0x79,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,
		0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x05,0xa0,0x30,0x1f,0x06,0x03,0x55,
		0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0xed,0x2b,0xa5,0x67,0x16,0xb1,0xed,0x70,
		0xe1,0x5d,0x55,0x7a,0x11,0x12,0x16,0x1c,0x97,0x41,0x56,0x96,0x30,0x0d,0x06,0x09,
		0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,
		0x22,0xe4,0x89,0x2c,0x7b,0xad,0x30,0xd7,0xf5,0x6c,0xde,0x70,0xe2,0x6c,0x90,0x8b,
		0x33,0xd3,0x20,0xcf,0xc9,0x62,0x71,0x91,0x95,0x8d,0xbd,0x63,0xb0,0x13,0x58,0xf4,
		0x88,0xa9,0xd9,0x36,0x76,0x8e,0x5f,0xae,0x3f,0xc7,0x88,0x5e,0x8b,0x55,0x64,0x54,
		0xc1,0xf5,0x54,0xee,0xde,0x43,0x4a,0xaf,0x3e,0x9d,0x93,0x0a,0x1c,0x18,0x5d,0xba,
		0x3f,0x00,0xfc,0xfd,0x62,0xc8,0x62,0x94,0xca,0x69,0x65,0x1b,0x27,0xde,0x24,0x91,
		0xc9,0xa2,0x6c,0x9c,0xcd,0xee,0xc6,0x91,0x0e,0x1d,0x18,0x7f,0x03,0x1f,0xbf,0xe9,
		0xa5,0x51,0x79,0xb0,0x0a,0x9e,0x81,0x9e,0x70,0x5e,0xb3,0x73,0xa4,0xb8,0x94,0xe8,
		0x91,0xa5,0x02,0xf5,0x6d,0x48,0x0a,0xb1,0xf9,0x9f,0xb1,0x2b,0x49,0xf7,0xd9,0x92,
		0x56,0x75,0x6e,0xd0,0x8d,0x80,0x60,0x2c,0x11,0xd2,0xcd,0x53,0x19,0xf3,0xb6,0xab,
		0xd7,0x2b,0x5d,0xd1,0xdf,0x54,0x3f,0xbb,0xf7,0x7c,0xc3,0xf4,0xe9,0x41,0x5c,0x17,
		0x46,0xf1,0x6e,0x3e,0x89,0xa2,0xfb,0xf2,0x89,0x73,0x3e,0xea,0x13,0x7a,0x74,0xbb,
		0x6e,0xb6,0xd0,0xea,0xf5,0xff,0x6b,0xfa,0x00,0xb2,0x7c,0xe3,0xe8,0x65,0x0f,0xe2,
		0x97,0x3f,0x9d,0x97,0x48,0x7a,0x14,0xf9,0xba,0xbf,0x2d,0x14,0x72,0xc3,0x3f,0x26,
		0xe0,0x19,0xa8,0x6d,0x23,0xcc,0xb4,0x7c,0x3f,0xcb,0x47,0x41,0x07,0xb1,0xe3,0x42,
		0xf1,0x1b,0x6b,0x76,0xa5,0xcf,0xb1,0xdf,0xf8,0xaa,0xd0,0xed,0x48,0x04,0x3e,0xd5,
		0x2b,0xf4,0x38,0x52,0xa1,0x11,0x29,0xc3,0x4e,0xca,0x23,0x02,0xc6,0xa6,0xc7,0xc0,
	};

    poEmulationCard->PutTransparentEF("3F00DF005039",
        CByteArray(tuc3F00DF005039, (unsigned long) sizeof(tuc3F00DF005039)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#4) (CA)
	unsigned char tuc3F00DF00503A[] = {
		0x30,0x82,0x03,0xf5,0x30,0x82,0x02,0xdd,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x00,0xfb,0x7c,0x59,0x0f,0xa2,0x00,0x00,0xce,0xc0,0x01,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x38,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x06,0x13,0x05,0x42,0x45,0x20,0x20,0x20,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x0a,0x13,0x05,0x5a,0x45,0x54,0x45,0x53,
		0x31,0x16,0x30,0x14,0x06,0x03,0x55,0x04,0x03,0x13,0x0d,0x5a,0x45,0x54,0x45,0x53,
		0x20,0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x34,0x30,0x33,
		0x32,0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x17,0x0d,0x30,0x39,0x30,0x33,0x32,
		0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x30,0x37,0x31,0x1a,0x30,0x18,0x06,0x03,
		0x55,0x04,0x06,0x13,0x11,0x42,0x45,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x31,0x19,0x30,0x17,0x06,0x03,0x55,0x04,0x03,0x13,
		0x10,0x5a,0x45,0x54,0x45,0x53,0x20,0x43,0x69,0x74,0x69,0x7a,0x65,0x6e,0x20,0x43,
		0x41,0x30,0x82,0x01,0x22,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,
		0x01,0x01,0x05,0x00,0x03,0x82,0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,0x01,
		0x01,0x00,0x9d,0x32,0xe1,0xe3,0xae,0x49,0xb7,0x32,0x4c,0x2c,0xc7,0x84,0xa4,0xf5,
		0xef,0x95,0x5b,0x61,0xf0,0x68,0xc5,0xb0,0x0a,0xeb,0xe0,0x9e,0x05,0x27,0x24,0xd0,
		0xca,0xe1,0x46,0x3a,0x95,0x4b,0x77,0xce,0xc8,0x88,0xb9,0x38,0x30,0xeb,0x15,0x23,
		0xc0,0xa6,0x01,0xe8,0x9c,0xe2,0x2f,0xbd,0x1e,0x2e,0x77,0xab,0x62,0x65,0xff,0xf5,
		0xc3,0x0b,0x0f,0x12,0x51,0x4f,0xaa,0x2a,0x4f,0xf1,0x06,0x8e,0x4a,0x93,0xfb,0x4a,
		0x22,0x5b,0x69,0x12,0xa5,0x81,0x9e,0xc3,0xfb,0xdc,0x50,0x4f,0x62,0xbb,0xc9,0xcb,
		0xdd,0xfd,0x84,0x6b,0xb0,0x6c,0xa1,0xcb,0xca,0xb6,0x20,0x8b,0x1b,0xe4,0xf6,0xac,
		0x21,0xef,0x6c,0x07,0x80,0xa5,0x8f,0x75,0x1f,0xfd,0x99,0x46,0x24,0xae,0xd0,0x54,
		0x28,0xbe,0x4a,0x75,0x91,0x96,0xc6,0xc0,0x21,0xe3,0x81,0x17,0x4f,0xb6,0x86,0x6b,
		0x5e,0x33,0x7a,0x17,0x9d,0x13,0x62,0x1b,0x57,0x19,0x51,0xfe,0x3f,0xdf,0x73,0xdf,
		0xa1,0xd1,0x07,0xfa,0x0c,0xcb,0xef,0x4e,0x82,0xb2,0xc1,0x9c,0x8f,0x77,0x03,0xe4,
		0x34,0xc5,0x55,0xd1,0x3a,0x17,0x86,0x4b,0x51,0x08,0x84,0xf0,0xaf,0x58,0x4c,0x8a,
		0x14,0x59,0x4d,0x3f,0x9f,0x46,0x70,0x3b,0xfb,0x23,0x1f,0x3b,0xec,0x7a,0x50,0xa4,
		0x18,0xe0,0x05,0xe0,0x7d,0xcd,0x01,0xb3,0x15,0x0f,0x3d,0xf5,0xcf,0xbb,0x85,0x2e,
		0x5d,0x83,0x1c,0xd5,0x54,0x12,0x5c,0x8d,0x19,0x92,0xe0,0x1b,0xcb,0x28,0x27,0xea,
		0x62,0xda,0xbe,0xf8,0xb8,0x7b,0xed,0xd7,0xbb,0xbc,0xb6,0xb6,0xc3,0xb9,0xa9,0xc8,
		0x90,0x8d,0x02,0x03,0x01,0x00,0x01,0xa3,0x81,0xfb,0x30,0x81,0xf8,0x30,0x0e,0x06,
		0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x12,0x06,
		0x03,0x55,0x1d,0x13,0x01,0x01,0xff,0x04,0x08,0x30,0x06,0x01,0x01,0xff,0x02,0x01,
		0x00,0x30,0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0xed,0x2b,0xa5,0x67,
		0x16,0xb1,0xed,0x70,0xe1,0x5d,0x55,0x7a,0x11,0x12,0x16,0x1c,0x97,0x41,0x56,0x96,
		0x30,0x41,0x06,0x03,0x55,0x1d,0x20,0x04,0x3a,0x30,0x38,0x30,0x36,0x06,0x06,0x60,
		0x38,0x01,0x01,0x01,0x02,0x30,0x2c,0x30,0x2a,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,
		0x07,0x02,0x01,0x16,0x1e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,
		0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,
		0x2e,0x62,0x65,0x30,0x3c,0x06,0x03,0x55,0x1d,0x1f,0x04,0x35,0x30,0x33,0x30,0x31,
		0xa0,0x2f,0xa0,0x2d,0x86,0x2b,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,
		0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,0x2f,0x62,0x65,
		0x6c,0x67,0x69,0x75,0x6d,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,
		0x6c,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,
		0x03,0x02,0x00,0x07,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,
		0x14,0xc0,0x36,0xc8,0xa1,0x2c,0x09,0x80,0x78,0xd1,0xc9,0x47,0x0b,0xad,0xa0,0xad,
		0x56,0x84,0x51,0x19,0xe6,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,
		0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0xaa,0x58,0xd0,0xa0,0xba,0x1a,0xf8,
		0xe5,0x5e,0xb7,0x39,0x34,0x4c,0x3d,0x54,0x6a,0x54,0x38,0x62,0xe7,0x77,0x2b,0x93,
		0x07,0xfb,0x34,0x5d,0x4e,0xc9,0x09,0xb5,0xc2,0x76,0x62,0x1b,0xd3,0xe0,0xb6,0xff,
		0xc7,0x46,0x1b,0x49,0x45,0x62,0x94,0x55,0xb7,0xa8,0x9c,0xc7,0xa0,0x31,0x5b,0xd8,
		0xbd,0x5a,0x33,0x81,0x5b,0x18,0xbf,0x29,0x7f,0xc1,0x4a,0x14,0xdf,0x18,0x03,0x1e,
		0xd4,0x55,0x21,0x5d,0x09,0x5b,0x11,0xad,0x35,0x74,0x14,0x8c,0x49,0xba,0x6d,0xf9,
		0xa8,0x40,0xa0,0x8c,0xe4,0x26,0x70,0x51,0x80,0x1d,0xfd,0x8f,0x99,0x09,0x49,0x30,
		0x12,0x2f,0xd4,0x02,0x85,0xa4,0x0a,0xfa,0x8d,0xbc,0xdb,0xc5,0xc6,0xee,0x54,0xf8,
		0xf5,0xa7,0x5c,0xe8,0x69,0x40,0x7c,0xc6,0xff,0xc8,0xac,0x56,0xf3,0x6e,0xfa,0xd1,
		0x6e,0x6b,0x1a,0xa6,0x0b,0x92,0x1d,0x8d,0xdf,0x0c,0x57,0xe3,0x33,0x0d,0x7f,0xc4,
		0xe7,0x2a,0x0b,0x51,0x1a,0x78,0x43,0xc9,0x97,0x7c,0x2b,0xeb,0x80,0xda,0xcd,0xe3,
		0x56,0xf7,0xc5,0xfe,0x70,0x8b,0xec,0xcb,0xa3,0xc3,0x11,0xcc,0xd4,0x65,0x56,0x86,
		0xc5,0xf9,0xc1,0x42,0xaf,0x99,0x46,0x94,0x3e,0x70,0x61,0xfc,0x3e,0xec,0x9f,0xb0,
		0xe2,0xca,0xc8,0xe5,0xdc,0x4c,0x8e,0x12,0x45,0x49,0x63,0xd7,0x64,0xde,0x3b,0xbd,
		0x2a,0x05,0xc0,0x18,0x43,0xed,0x01,0xad,0x9e,0xcb,0xb1,0x35,0x25,0x75,0x0f,0xd0,
		0x17,0x67,0xd6,0x08,0x60,0x8c,0xe3,0xde,0xf0,0xc1,0xd7,0x85,0xf0,0x17,0xa1,0x38,
		0x08,0x1d,0x5f,0xd2,0x46,0xa9,0x2f,0xd2,0xa0,
	};

    poEmulationCard->PutTransparentEF("3F00DF00503A",
        CByteArray(tuc3F00DF00503A, (unsigned long) sizeof(tuc3F00DF00503A)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#6) (root)
	unsigned char tuc3F00DF00503B[] = {
		0x30,0x82,0x03,0xb4,0x30,0x82,0x02,0x9c,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x00,0xfb,0x7c,0x59,0x0d,0xf3,0x00,0x00,0xce,0xc0,0x00,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x38,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x06,0x13,0x05,0x42,0x45,0x20,0x20,0x20,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x0a,0x13,0x05,0x5a,0x45,0x54,0x45,0x53,
		0x31,0x16,0x30,0x14,0x06,0x03,0x55,0x04,0x03,0x13,0x0d,0x5a,0x45,0x54,0x45,0x53,
		0x20,0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x34,0x30,0x33,
		0x32,0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x17,0x0d,0x30,0x39,0x30,0x33,0x32,
		0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x30,0x38,0x31,0x0e,0x30,0x0c,0x06,0x03,
		0x55,0x04,0x06,0x13,0x05,0x42,0x45,0x20,0x20,0x20,0x31,0x0e,0x30,0x0c,0x06,0x03,
		0x55,0x04,0x0a,0x13,0x05,0x5a,0x45,0x54,0x45,0x53,0x31,0x16,0x30,0x14,0x06,0x03,
		0x55,0x04,0x03,0x13,0x0d,0x5a,0x45,0x54,0x45,0x53,0x20,0x52,0x6f,0x6f,0x74,0x20,
		0x43,0x41,0x30,0x82,0x01,0x22,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,
		0x01,0x01,0x01,0x05,0x00,0x03,0x82,0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,
		0x01,0x01,0x00,0xb1,0x56,0x7b,0xe1,0xcb,0x9e,0xcc,0xb0,0x8f,0x1d,0x10,0x44,0xf9,
		0x85,0x3e,0xc5,0xcc,0xbd,0x14,0x79,0xaa,0x75,0xe4,0x2e,0xcc,0x3b,0xc6,0x2a,0x8d,
		0xb2,0x31,0x53,0x0f,0x67,0x2a,0x08,0x21,0x5c,0xd3,0x9a,0x46,0xc5,0x40,0x71,0xe6,
		0xa5,0x92,0x55,0xec,0xe4,0xba,0x43,0x02,0x67,0x58,0x56,0x6a,0x71,0x90,0xfb,0x4a,
		0x4e,0x5d,0xe1,0xbb,0x66,0xd8,0xc5,0xeb,0x94,0x3c,0x2a,0x0b,0xf4,0xf0,0x51,0xa0,
		0xaa,0xae,0xd2,0x1d,0x93,0x90,0x9d,0xfd,0x66,0x17,0x35,0xe9,0xaa,0x15,0x0f,0x12,
		0xde,0xd6,0x31,0xc7,0x57,0x10,0x87,0xda,0x37,0xdf,0xb1,0x12,0xf2,0xf3,0x4b,0x59,
		0x45,0x7d,0xdf,0x6f,0x3d,0xda,0x10,0x53,0x2c,0xe5,0xe2,0xd1,0xcf,0xb0,0xf8,0x7f,
		0xe6,0x68,0x47,0xe9,0x44,0x8f,0x7f,0x72,0x63,0x80,0x55,0x2d,0x32,0x13,0x0d,0x57,
		0x07,0x20,0xaf,0x9e,0x85,0xeb,0xe5,0x1b,0x28,0x4b,0x06,0x22,0x55,0xe2,0x1a,0xf3,
		0x9b,0x13,0x96,0x00,0x0d,0x11,0xf4,0x64,0xb3,0x6f,0x9f,0x59,0x7f,0x20,0xb8,0x68,
		0x57,0x7c,0x3e,0x3d,0xe7,0xea,0x9d,0x6e,0x33,0x5d,0xbf,0x30,0xe2,0x89,0x1a,0x9f,
		0xc3,0x8d,0x25,0x5c,0x01,0x2a,0xfb,0xf2,0xc4,0x20,0x40,0x50,0x57,0xc0,0x00,0x37,
		0xb8,0xa0,0x37,0x5f,0x38,0xe2,0xd9,0x54,0xaf,0x41,0xa3,0xea,0xef,0x6e,0xd3,0x1f,
		0x47,0xde,0x93,0xcd,0xf9,0x19,0x74,0x8a,0xb6,0x02,0xec,0x06,0x5b,0x74,0x00,0xdb,
		0x2f,0x48,0x6f,0xfa,0xf5,0xcd,0x99,0xc8,0xac,0x94,0xd0,0x13,0x61,0x36,0x44,0x0e,
		0x74,0x56,0x17,0x02,0x03,0x01,0x00,0x01,0xa3,0x81,0xb9,0x30,0x81,0xb6,0x30,0x0e,
		0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x0f,
		0x06,0x03,0x55,0x1d,0x13,0x01,0x01,0xff,0x04,0x05,0x30,0x03,0x01,0x01,0xff,0x30,
		0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0xc0,0x36,0xc8,0xa1,0x2c,0x09,
		0x80,0x78,0xd1,0xc9,0x47,0x0b,0xad,0xa0,0xad,0x56,0x84,0x51,0x19,0xe6,0x30,0x40,
		0x06,0x03,0x55,0x1d,0x20,0x04,0x39,0x30,0x37,0x30,0x35,0x06,0x05,0x60,0x38,0x01,
		0x01,0x01,0x30,0x2c,0x30,0x2a,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,
		0x16,0x1e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,
		0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,
		0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,
		0x02,0x00,0x07,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,
		0xc0,0x36,0xc8,0xa1,0x2c,0x09,0x80,0x78,0xd1,0xc9,0x47,0x0b,0xad,0xa0,0xad,0x56,
		0x84,0x51,0x19,0xe6,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,
		0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x4d,0x16,0xa5,0xe5,0x81,0x9f,0xac,0xb4,
		0xf7,0xaf,0x51,0x7e,0xa1,0x73,0x07,0xe6,0xe3,0x7d,0x96,0x3d,0x36,0x3f,0x9f,0xd7,
		0x01,0xed,0x53,0x70,0xb0,0x82,0x58,0x79,0x72,0x64,0x20,0x02,0x85,0xa4,0xb5,0xe6,
		0x7b,0x40,0xad,0x4b,0xe1,0x50,0x00,0x22,0x91,0x88,0xfa,0xbd,0xdc,0x69,0xbe,0xa6,
		0x6f,0x84,0x5c,0xf8,0x9a,0xfa,0x08,0xfa,0x8c,0xd4,0x14,0x35,0x1d,0xc9,0x2b,0x46,
		0xb4,0x94,0x87,0x42,0xf7,0x38,0xc2,0x36,0xc2,0xac,0x30,0x04,0xa9,0xe4,0xe0,0x6d,
		0xb8,0x46,0x54,0xc1,0xcb,0x4f,0x44,0xcf,0x3b,0x36,0x61,0xd7,0x34,0x2f,0x7c,0xef,
		0xe0,0x9c,0xc7,0xdc,0x82,0x5e,0x84,0x12,0xdc,0x17,0x05,0xa5,0x26,0x39,0x45,0x9e,
		0xb9,0xfc,0x0f,0x24,0x66,0xf4,0x9e,0x0a,0x16,0x3c,0x71,0xe0,0x17,0x03,0xdc,0x66,
		0x51,0x57,0x7d,0x8c,0x2b,0x0e,0x3c,0x55,0x8a,0xf6,0xc8,0x7a,0x12,0x4a,0x48,0x76,
		0xa4,0x29,0xad,0xa2,0x88,0xe6,0x2e,0x7c,0xfb,0xe2,0xc1,0xa5,0xfc,0xd1,0xb5,0xea,
		0xad,0x1e,0x8c,0xb2,0x2c,0xd9,0x2a,0xd1,0xf7,0xe6,0xb5,0x8c,0x60,0x44,0xdc,0x54,
		0x14,0x5f,0x65,0xbf,0x4b,0xc7,0xa4,0xc5,0x3f,0x49,0x5d,0xb1,0x9a,0x69,0x93,0xee,
		0x5c,0xa2,0x1a,0x35,0xfd,0xce,0xf4,0xb3,0x5c,0xd7,0x9d,0x72,0xbf,0x33,0xc9,0x17,
		0xaf,0x03,0xa8,0x59,0xe7,0x70,0x7b,0x74,0x15,0xd3,0x15,0x23,0xe9,0xd9,0x5d,0x36,
		0xc7,0xbd,0xda,0x45,0xd7,0x2e,0x21,0xf0,0x25,0xd7,0xd2,0x16,0x9a,0xc1,0xd1,0x09,
		0xb8,0xb3,0x9a,0xe8,0xb8,0xff,0x81,0xbb,
	};

    poEmulationCard->PutTransparentEF("3F00DF00503B",
        CByteArray(tuc3F00DF00503B, (unsigned long) sizeof(tuc3F00DF00503B)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#8) (RN)
	unsigned char tuc3F00DF00503C[] = {
		0x30,0x82,0x03,0xd6,0x30,0x82,0x02,0xbe,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x00,0xfb,0x7c,0x59,0x10,0x24,0x00,0x00,0xce,0xc0,0x02,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x3b,
		0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x0e,0x30,
		0x0c,0x06,0x03,0x55,0x04,0x0a,0x13,0x05,0x5a,0x45,0x54,0x45,0x53,0x31,0x1c,0x30,
		0x1a,0x06,0x03,0x55,0x04,0x03,0x13,0x13,0x5a,0x45,0x54,0x45,0x53,0x20,0x47,0x6f,
		0x76,0x65,0x72,0x6e,0x6d,0x65,0x6e,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,
		0x34,0x30,0x33,0x32,0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x17,0x0d,0x30,0x39,
		0x30,0x33,0x32,0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x30,0x21,0x31,0x0b,0x30,
		0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x12,0x30,0x10,0x06,0x03,
		0x55,0x04,0x03,0x13,0x09,0x5a,0x45,0x54,0x45,0x53,0x20,0x52,0x4e,0x20,0x30,0x81,
		0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,
		0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0xb4,0xb8,0x1d,0xed,0xc5,
		0x2d,0x80,0x31,0x42,0x08,0x76,0x44,0xac,0x96,0xde,0x35,0x7c,0xbc,0xc6,0xcd,0xec,
		0x48,0x73,0xfd,0x84,0x0e,0x19,0x90,0x18,0x5a,0x18,0x15,0x18,0x6f,0xca,0xab,0x63,
		0x10,0xea,0x7a,0x0d,0x5d,0x4b,0x74,0x01,0xbe,0xcb,0x18,0x1b,0x97,0x2d,0x7a,0x41,
		0x08,0x04,0x0f,0xbb,0x61,0xf7,0xb7,0xc1,0x8d,0xe1,0x00,0xb5,0xc9,0x8f,0x1b,0x3f,
		0xdf,0x9a,0x1f,0x88,0xe6,0x07,0x80,0xb9,0xf8,0x2b,0xb1,0x69,0xc2,0xed,0x3b,0xfb,
		0xc2,0x47,0xea,0x08,0x2b,0xae,0xd2,0x80,0x43,0xdd,0xc0,0x23,0x1e,0x0a,0x4e,0xe7,
		0x0d,0x3d,0x41,0x97,0xb7,0x20,0x22,0xd9,0x40,0x6b,0x85,0xe2,0x45,0x5a,0x90,0x8f,
		0xbf,0xc7,0x04,0xa8,0xa7,0x69,0x32,0xb0,0x1e,0x7d,0xfb,0x02,0x03,0x01,0x00,0x01,
		0xa3,0x82,0x01,0x72,0x30,0x82,0x01,0x6e,0x30,0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,
		0x01,0xff,0x04,0x04,0x03,0x02,0x06,0xc0,0x30,0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,
		0x16,0x04,0x14,0x82,0xce,0x78,0xd3,0x3f,0x6f,0x41,0x41,0xce,0xa1,0xec,0x04,0x89,
		0xcf,0x2d,0xb8,0xcb,0xc8,0x5a,0xc9,0x30,0x42,0x06,0x03,0x55,0x1d,0x20,0x04,0x3b,
		0x30,0x39,0x30,0x37,0x06,0x07,0x60,0x38,0x01,0x01,0x01,0x03,0x01,0x30,0x2c,0x30,
		0x2a,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x1e,0x68,0x74,0x74,
		0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,
		0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,0x30,0x3c,0x06,0x03,0x55,
		0x1d,0x1f,0x04,0x35,0x30,0x33,0x30,0x31,0xa0,0x2f,0xa0,0x2d,0x86,0x2b,0x68,0x74,
		0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,
		0x65,0x73,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2f,0x62,0x65,
		0x6c,0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,0x6c,0x30,0x7c,0x06,0x08,0x2b,0x06,0x01,
		0x05,0x05,0x07,0x01,0x01,0x04,0x70,0x30,0x6e,0x30,0x3f,0x06,0x08,0x2b,0x06,0x01,
		0x05,0x05,0x07,0x30,0x02,0x86,0x33,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,
		0x77,0x2e,0x5a,0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,0x65,0x2f,
		0x64,0x75,0x6d,0x6d,0x79,0x2f,0x63,0x65,0x72,0x74,0x69,0x66,0x63,0x61,0x74,0x65,
		0x73,0x2f,0x74,0x65,0x73,0x74,0x2e,0x63,0x72,0x74,0x30,0x2b,0x06,0x08,0x2b,0x06,
		0x01,0x05,0x05,0x07,0x30,0x01,0x86,0x1f,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x6f,
		0x63,0x73,0x70,0x2e,0x5a,0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,
		0x65,0x2f,0x64,0x75,0x6d,0x6d,0x79,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,
		0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x04,0xb0,0x30,0x09,0x06,0x03,0x55,0x1d,
		0x13,0x04,0x02,0x30,0x00,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,
		0x80,0x14,0x46,0xad,0x98,0xa1,0xc0,0x9a,0x48,0x5e,0x61,0xa0,0xbc,0x7e,0x0b,0x50,
		0x02,0x82,0x03,0xb8,0x4d,0x46,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,
		0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x23,0xab,0x0b,0xf7,0xb9,0x25,
		0x13,0x94,0xd9,0x35,0xb6,0x72,0xc8,0xa2,0x6e,0xe5,0x39,0x6d,0x40,0xcd,0xf6,0x3b,
		0x40,0x17,0x25,0x41,0x3e,0x06,0x39,0x75,0x56,0x9c,0x8d,0x41,0x13,0x09,0xcd,0x44,
		0x70,0xfc,0xb0,0x2d,0x10,0x2d,0x8a,0x8a,0xca,0x18,0xe1,0x47,0x7f,0x63,0xf6,0xbb,
		0x02,0x67,0xf5,0xc9,0xf1,0x10,0x12,0xad,0xeb,0x3b,0xaa,0xbe,0x18,0x67,0x35,0x52,
		0xb6,0xe9,0xe9,0xf7,0x36,0xd8,0x31,0xc2,0x1e,0x29,0x34,0x29,0x48,0x56,0x79,0x54,
		0xdc,0xd9,0xa9,0x8c,0xc4,0x67,0x70,0x97,0xbd,0xa6,0x8e,0xe3,0xb8,0x82,0x9b,0x54,
		0x8f,0xe5,0x92,0x8a,0xea,0x11,0x69,0x24,0x0f,0xc7,0x26,0x3a,0x7f,0x5d,0x42,0xa5,
		0x4f,0x17,0x05,0xed,0x1f,0x3b,0xc0,0x01,0x73,0x57,0x4e,0xf2,0x67,0x18,0x49,0x12,
		0xc5,0xc5,0x78,0x59,0x4d,0x2d,0x6a,0x37,0x4f,0x7f,0x1d,0xbe,0x17,0x90,0xad,0x8b,
		0xa7,0x85,0x96,0xa7,0x9d,0xc0,0x28,0x50,0xf6,0x15,0xf9,0xd2,0x2c,0xb8,0x54,0x93,
		0x1b,0xa3,0x57,0xc3,0xf8,0x7c,0x75,0xef,0x64,0xb6,0xbd,0x7b,0xd4,0x8d,0xb2,0x76,
		0x04,0x68,0x23,0x09,0xfe,0xd5,0xef,0x36,0x9b,0x96,0x89,0x91,0xb9,0x08,0x68,0x3f,
		0xca,0x39,0x8b,0x98,0x54,0x2e,0x27,0x0d,0x8f,0x5b,0x2e,0x9a,0x20,0xed,0xf8,0x2e,
		0xf5,0x81,0xf4,0xcb,0x61,0xd7,0x22,0xb9,0x34,0x1e,0xe6,0x6d,0x0f,0xe9,0x52,0x23,
		0x9b,0xa2,0x80,0x0b,0x50,0x47,0xd1,0x26,0xea,0xb8,0x32,0x72,0x82,0x27,0xfb,0x61,
		0x0d,0x4f,0xfa,0x99,0x88,0xad,0x72,0x36,0x33,0x26,
	};
    poEmulationCard->PutTransparentEF("3F00DF00503C",
        CByteArray(tuc3F00DF00503C, (unsigned long) sizeof(tuc3F00DF00503C)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#RN)
    unsigned char tuc3F00DF014031[] = {
        0x01,0x0c,0x35,0x39,0x30,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x31,0x32,0x02,0x10,
        0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x61,0x62,0x63,0x64,0x65,0x66,
        0x03,0x0a,0x30,0x31,0x2e,0x30,0x31,0x2e,0x32,0x30,0x30,0x37,0x04,0x0a,0x30,0x31,
        0x2e,0x30,0x31,0x2e,0x32,0x30,0x31,0x32,0x05,0x09,0x42,0x72,0x75,0x78,0x65,0x6c,
        0x6c,0x65,0x73,0x06,0x0b,0x38,0x30,0x30,0x31,0x32,0x35,0x31,0x31,0x32,0x36,0x35,
        0x07,0x05,0x6e,0x61,0x6d,0x65,0x30,0x08,0x06,0x67,0x6e,0x61,0x6d,0x65,0x30,0x09,
        0x00,0x0a,0x05,0x42,0x65,0x6c,0x67,0x65,0x0b,0x07,0x49,0x78,0x65,0x6c,0x6c,0x65,
        0x73,0x0c,0x0b,0x32,0x35,0x20,0x4a,0x41,0x4e,0x20,0x31,0x39,0x38,0x30,0x0d,0x01,
        0x4d,0x0e,0x06,0x50,0x72,0x69,0x6e,0x63,0x65,0x0f,0x01,0x31,0x10,0x01,0x30,0x11,
        0x14,0xdc,0x9d,0xb2,0xc8,0x3d,0xc1,0xf1,0xf7,0xd6,0x96,0x4c,0xae,0x35,0xda,0x0c,
        0xb9,0x2e,0x22,0x09,0xf0,
	};
    poEmulationCard->PutTransparentEF("3F00DF014031",
        CByteArray(tuc3F00DF014031, (unsigned long) sizeof(tuc3F00DF014031)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(SGN#RN)
    unsigned char tuc3F00DF014032[] = {
        0x47,0x4d,0x1d,0xec,0x14,0x22,0x8f,0x84,0xf4,0x12,0xac,0x32,0x89,0x55,0x16,0xda,
        0xbb,0x31,0x5f,0x79,0x5a,0x08,0x40,0x36,0x42,0x9b,0x11,0xf3,0x7e,0x63,0xcc,0xf4,
        0xe6,0x6f,0x85,0xf5,0x3b,0xae,0xcc,0x18,0x46,0x68,0xcd,0x1a,0x79,0xfd,0x81,0x0b,
        0xdb,0x30,0x3a,0x9a,0x0f,0xd4,0xad,0x54,0x67,0xc6,0x64,0xd8,0xbe,0xfb,0x51,0x36,
        0x1c,0xb5,0x99,0x0f,0x39,0x77,0x14,0x1c,0x33,0x80,0x51,0xd6,0xab,0xb3,0xab,0x56,
        0x1f,0xed,0x3d,0x07,0xc6,0x76,0x9b,0xc1,0x94,0xd3,0xdd,0x27,0x87,0x85,0x91,0x1b,
        0x06,0x4f,0xec,0x95,0xd9,0x1a,0x71,0x42,0x28,0x60,0x6b,0x3d,0xde,0x2c,0xa4,0x82,
        0xbb,0x33,0xfb,0xc6,0xe6,0x4e,0x50,0xed,0xce,0xde,0x88,0xcd,0x2c,0x99,0xc5,0x9d,
	};
    poEmulationCard->PutTransparentEF("3F00DF014032",
        CByteArray(tuc3F00DF014032, (unsigned long) sizeof(tuc3F00DF014032)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#Address)
    unsigned char tuc3F00DF014033[] = {
        0x01,0x0b,0x56,0x69,0x6c,0x61,0x6c,0x61,0x61,0x6e,0x20,0x31,0x33,0x02,0x04,0x31,
        0x36,0x30,0x31,0x03,0x09,0x52,0x75,0x69,0x73,0x62,0x72,0x6f,0x65,0x6b,
	};
    poEmulationCard->PutTransparentEF("3F00DF014033",
        CByteArray(tuc3F00DF014033, (unsigned long) sizeof(tuc3F00DF014033)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(SGN#Address)
    unsigned char tuc3F00DF014034[] = {
        0x51,0x44,0x70,0xe9,0xf2,0x5e,0x77,0xa5,0xd5,0xc8,0x7a,0x0d,0xe6,0xce,0x88,0xc0,
        0x5e,0xe1,0xef,0xac,0xe7,0xf0,0x0e,0x30,0x97,0x13,0xd9,0x06,0x1a,0xa5,0xb3,0xb6,
        0xbb,0x00,0xd0,0x17,0x2b,0xb4,0xad,0x98,0xca,0x70,0xf0,0xfe,0xd5,0xb6,0xb1,0xab,
        0x6d,0xc2,0xce,0x4f,0x15,0xac,0xea,0x81,0x3c,0xe9,0x38,0x85,0xc9,0xcb,0xe3,0x5d,
        0x07,0x4e,0xb9,0x94,0x65,0x15,0xab,0xa8,0x51,0x5e,0x03,0x4d,0x9e,0xc0,0xb2,0x00,
        0x29,0xd6,0x1d,0x07,0x8d,0xd0,0xb1,0x3b,0x9d,0xae,0x5d,0x6d,0x1a,0x38,0x75,0xd5,
        0x94,0xe3,0x42,0x43,0x9c,0x42,0x3e,0x2d,0x54,0x63,0xb6,0x51,0x45,0x4e,0x86,0xd0,
        0xcd,0x20,0xf0,0x02,0x93,0x29,0x38,0xf2,0xa3,0xd2,0x82,0x1a,0xf8,0x6d,0x27,0x62,
	};
    poEmulationCard->PutTransparentEF("3F00DF014034",
        CByteArray(tuc3F00DF014034, (unsigned long) sizeof(tuc3F00DF014034)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#Photo)
    unsigned char tuc3F00DF014035[] = {
		0xff,0xd8,0xff,0xe0,0x00,0x10,0x4a,0x46,0x49,0x46,0x00,0x01,0x02,0x01,0x01,0x2c,
		0x01,0x2c,0x00,0x00,0xff,0xdb,0x00,0x43,0x00,0x1c,0x13,0x15,0x18,0x15,0x11,0x1c,
		0x18,0x16,0x18,0x1f,0x1d,0x1c,0x21,0x29,0x45,0x2d,0x29,0x26,0x26,0x29,0x54,0x3c,
		0x40,0x32,0x45,0x64,0x58,0x69,0x67,0x62,0x58,0x60,0x5f,0x6e,0x7c,0x9e,0x86,0x6e,
		0x75,0x96,0x77,0x5f,0x60,0x8a,0xbb,0x8b,0x96,0xa3,0xa9,0xb1,0xb3,0xb1,0x6b,0x84,
		0xc2,0xd0,0xc1,0xac,0xce,0x9e,0xae,0xb1,0xaa,0xff,0xc0,0x00,0x0b,0x08,0x00,0xc8,
		0x00,0x8c,0x01,0x01,0x11,0x00,0xff,0xc4,0x00,0xd2,0x00,0x00,0x01,0x05,0x01,0x01,
		0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,
		0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x10,0x00,0x02,0x01,0x03,0x03,0x02,0x04,0x03,
		0x05,0x05,0x04,0x04,0x00,0x00,0x01,0x7d,0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
		0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,0x22,0x71,0x14,0x32,0x81,0x91,0xa1,0x08,
		0x23,0x42,0xb1,0xc1,0x15,0x52,0xd1,0xf0,0x24,0x33,0x62,0x72,0x82,0x09,0x0a,0x16,
		0x17,0x18,0x19,0x1a,0x25,0x26,0x27,0x28,0x29,0x2a,0x34,0x35,0x36,0x37,0x38,0x39,
		0x3a,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
		0x5a,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
		0x7a,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
		0x99,0x9a,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,0xb5,0xb6,
		0xb7,0xb8,0xb9,0xba,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xd2,0xd3,0xd4,
		0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,
		0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xff,0xda,0x00,0x08,0x01,0x01,
		0x00,0x00,0x3f,0x00,0xdf,0xc9,0xf5,0x34,0x64,0xfa,0x9a,0x32,0x7d,0x4d,0x19,0x3e,
		0xa6,0x8c,0x9f,0x53,0x46,0x4f,0xa9,0xa3,0x27,0xd4,0xd2,0x16,0xc0,0xc9,0x6c,0x7e,
		0x35,0x1f,0xda,0xa1,0x1d,0x67,0x4f,0xfb,0xec,0x53,0xd6,0x55,0x7f,0xb9,0x20,0x6f,
		0xa1,0xcd,0x3b,0x27,0xd4,0xd1,0x93,0xea,0x68,0xc9,0xf5,0x34,0x64,0xfa,0x9a,0x32,
		0x7d,0x4d,0x19,0x3e,0xa6,0x8c,0x9f,0x53,0x46,0x4f,0xa9,0xa4,0xa2,0x8a,0x28,0xaa,
		0x73,0x6a,0x31,0x46,0xfb,0x57,0xe6,0xc1,0xe4,0xe7,0x8a,0xab,0x73,0xa9,0x3b,0x8f,
		0xdc,0xfc,0xab,0x8c,0x93,0x9e,0x6b,0x2a,0x4b,0xd2,0xe7,0x25,0x99,0x88,0xee,0xd9,
		0x26,0xa3,0x17,0x32,0x72,0x36,0x82,0x3d,0x0a,0xff,0x00,0xf5,0xaa,0x58,0xe7,0x72,
		0x7e,0x50,0x8c,0x7b,0x00,0x7f,0xc9,0xab,0xd0,0xea,0x32,0x21,0xc1,0xde,0x87,0xb8,
		0x3f,0x30,0xfd,0x6b,0x52,0x0b,0xc8,0xe6,0xc0,0xe8,0x4f,0xa7,0x23,0xff,0x00,0xad,
		0xf8,0xd5,0x8a,0x28,0xa2,0x8a,0x28,0xa2,0x8a,0x46,0x65,0x45,0x2c,0xc4,0x05,0x51,
		0x92,0x4f,0x40,0x2b,0x9b,0xd4,0x35,0x69,0x2e,0x58,0xa4,0x04,0xac,0x59,0xe0,0x63,
		0xaf,0xb9,0xac,0xf5,0xf9,0x9c,0xf9,0xb2,0x1c,0x0e,0xde,0xb4,0x34,0xd6,0xd9,0xc7,
		0x97,0x9c,0x0e,0xb9,0x34,0x79,0xf0,0x63,0xfd,0x58,0xfc,0xa9,0x37,0xc2,0xdd,0x13,
		0x6f,0xb8,0x6c,0x7f,0x3a,0x9d,0x77,0x60,0x79,0x6e,0x19,0x4f,0x69,0x3f,0xc4,0x54,
		0xc9,0x37,0x96,0x42,0x48,0x0c,0x64,0xf4,0x0f,0x82,0xbf,0x81,0xab,0x03,0x83,0xc8,
		0x1c,0x76,0x35,0xa9,0xa7,0xcf,0xbd,0x7c,0xb2,0x78,0x51,0xf2,0x83,0xd4,0x7b,0x55,
		0xda,0x28,0xa2,0x8a,0x28,0xa2,0xb1,0xb5,0xcb,0x96,0x91,0x96,0xce,0x16,0xc7,0xf1,
		0x4a,0x47,0x61,0xd8,0x7f,0x5f,0xca,0xb2,0x7e,0x44,0x52,0xa9,0x8f,0x73,0x55,0x27,
		0xdb,0x9f,0x94,0xf3,0xf5,0xa8,0x83,0x7f,0x7b,0x9a,0x4c,0x7a,0x52,0xab,0x76,0x65,
		0xc8,0xa9,0x51,0x33,0xcc,0x2c,0x43,0x7a,0x67,0x07,0xf3,0xa9,0x96,0xea,0x44,0x1b,
		0x26,0x40,0xeb,0xdd,0x58,0x55,0x88,0x64,0x08,0x99,0xb7,0x6d,0xf1,0x8e,0xa8,0x7a,
		0xaf,0xd3,0xfc,0x2a,0xe4,0x32,0x2b,0x61,0xd4,0xed,0xc1,0xe1,0x87,0x05,0x4d,0x6c,
		0xda,0xdc,0x79,0xf1,0xfc,0xd8,0x12,0x0f,0xbc,0xa3,0xf9,0xd4,0xf4,0x51,0x45,0x14,
		0x53,0x26,0x90,0x43,0x0b,0xca,0xc3,0x21,0x14,0xb6,0x07,0x7c,0x76,0xae,0x62,0xea,
		0x46,0x3b,0x9d,0x8e,0x19,0xdb,0x73,0x9f,0xe8,0x2b,0x36,0x49,0x4b,0x70,0x0e,0x05,
		0x0a,0x85,0xce,0x31,0x9a,0x9d,0x2c,0x9d,0x97,0x27,0x8a,0x63,0x5b,0xb2,0x9f,0xeb,
		0x48,0x21,0xdc,0xa7,0xa0,0x61,0xda,0x98,0x51,0x94,0xf4,0x23,0x15,0x34,0x72,0xab,
		0x0d,0xb3,0x82,0x47,0xf7,0x87,0x51,0x4a,0x55,0xed,0xc8,0x92,0x32,0x1b,0xdc,0x74,
		0x61,0xe8,0x45,0x59,0x86,0x65,0x90,0x87,0x8f,0xe4,0x27,0x86,0x52,0x7a,0xff,0x00,
		0xf5,0xfd,0x3d,0x6b,0x4e,0xd6,0x53,0x1b,0x2c,0x89,0x93,0xb7,0x82,0xbe,0xde,0x95,
		0xb0,0x08,0x20,0x10,0x72,0x0f,0x20,0xd2,0xd1,0x45,0x14,0x55,0x0d,0x5e,0x60,0x96,
		0xeb,0x19,0x07,0x0e,0x77,0x13,0x8e,0x81,0x70,0x7f,0x9e,0x3f,0x5a,0xe5,0xae,0x65,
		0x2e,0xdc,0xfa,0xd3,0x60,0x84,0xca,0xe0,0x0a,0xdc,0xb4,0xb0,0x0a,0x01,0x22,0xb4,
		0x05,0xaa,0xec,0xe9,0xda,0xaa,0x5c,0xd8,0xe3,0x90,0x2b,0x32,0x68,0xb6,0x7b,0x1e,
		0xc7,0xd2,0xab,0x82,0xa3,0x83,0xf4,0xe3,0xb1,0xa8,0xa5,0x5e,0xeb,0x4d,0x8e,0x52,
		0xbc,0x75,0x0d,0xd4,0x52,0x9f,0x91,0xb7,0xaf,0xdd,0x61,0x86,0xad,0x7b,0x09,0xcb,
		0x27,0x27,0x2e,0xbc,0x30,0xfe,0x55,0xb9,0x68,0x73,0x16,0xdc,0xe4,0x0e,0x9f,0x4a,
		0x9e,0x8a,0x28,0xa2,0xb0,0xf5,0xf9,0x71,0x26,0xcd,0xd9,0x01,0x00,0x23,0xd0,0xf2,
		0x4f,0xfe,0xcb,0x5c,0xf0,0xcb,0x35,0x6d,0x69,0x76,0xe0,0x28,0x62,0x3a,0xfb,0x56,
		0xd2,0x2f,0x4e,0x95,0x30,0xe9,0x41,0x00,0x8e,0x6a,0x9d,0xdd,0x92,0xcc,0x84,0xa8,
		0xc3,0x7f,0x3a,0xe7,0x2f,0x2d,0xde,0x19,0x09,0xda,0x45,0x55,0x0e,0x7a,0x1e,0x94,
		0xd7,0x03,0x39,0x1d,0xe9,0xc8,0xdf,0xc3,0xd8,0x8f,0xce,0xac,0xd8,0xc9,0xe5,0x4e,
		0x37,0x74,0xe8,0x7e,0x95,0xd2,0xd8,0xb9,0x0d,0xb0,0x9e,0x6a,0xf5,0x14,0x51,0x45,
		0x72,0x7a,0xa4,0xbe,0x65,0xc5,0xce,0x58,0x13,0xe6,0x1f,0xc8,0x1c,0x0f,0xd0,0x0a,
		0xcf,0x8c,0x66,0x45,0x1e,0xa7,0x15,0xd2,0xd9,0xae,0xd8,0xc0,0x1c,0x55,0xf5,0xcf,
		0xa5,0x4a,0x29,0xd8,0xa3,0x15,0x4e,0xf6,0xc5,0x6e,0x54,0xe3,0x01,0xbd,0x7d,0x6b,
		0x9a,0xbd,0xb1,0x92,0xd9,0xce,0x54,0xe2,0xaa,0x88,0xcb,0x02,0x54,0xfe,0x14,0xcc,
		0x11,0xd7,0x8a,0x9e,0x32,0x37,0x29,0x3d,0x09,0xda,0x6b,0xa1,0xb3,0x90,0xe6,0x16,
		0x63,0xce,0x02,0xb1,0xf7,0xad,0x7a,0x28,0xa2,0x82,0xc1,0x41,0x66,0x38,0x50,0x32,
		0x7e,0x95,0xc2,0x33,0x92,0xe4,0xb1,0xc9,0x27,0x9f,0x7a,0x7d,0xa2,0xef,0xb9,0x41,
		0xfe,0xd6,0x6b,0xa7,0x84,0x04,0x51,0xb8,0x81,0xc7,0x7a,0x9c,0x4f,0x1a,0xf5,0x3c,
		0x7a,0xd4,0xab,0x2c,0x6d,0xf7,0x5d,0x4f,0xe3,0x52,0x02,0x28,0xcd,0x04,0x81,0xd6,
		0xa1,0x9e,0x38,0xe5,0x8c,0x89,0x30,0x47,0xbd,0x61,0xdd,0xe9,0x91,0x07,0x0d,0x6f,
		0x28,0x27,0xfb,0xbd,0x6a,0x85,0xcd,0xac,0x85,0x0b,0x18,0xc6,0x57,0xba,0x90,0x73,
		0xf8,0x55,0x64,0xf9,0xb3,0x9e,0xe3,0x15,0xb9,0x6e,0xe3,0x64,0x64,0x7f,0x7f,0xfa,
		0x56,0xf2,0x1d,0xc8,0xa7,0xd4,0x66,0x96,0x8a,0x2a,0xa6,0xaa,0xfb,0x34,0xd9,0x88,
		0xea,0x46,0xde,0xb8,0xea,0x70,0x7f,0x4c,0xd7,0x35,0x6d,0xb6,0x58,0x96,0x29,0x23,
		0x4d,0xac,0xa4,0x86,0x1f,0x7b,0x3e,0xb4,0xba,0x4c,0x3b,0xae,0x86,0x46,0x71,0xde,
		0xb6,0xe5,0x75,0x56,0xcd,0x40,0xfa,0x84,0x2a,0x30,0xcb,0xc1,0xef,0xc6,0x2a,0xb9,
		0xbc,0x80,0xb8,0xf2,0x98,0xe4,0xfa,0x73,0x57,0xac,0xef,0x43,0x10,0x37,0x86,0x07,
		0x8c,0xe6,0xb4,0x41,0xc8,0xcd,0x55,0xba,0xb8,0xf2,0xc1,0x19,0x22,0xb2,0xe5,0xba,
		0xe7,0xe6,0x66,0x23,0xbf,0xa0,0xa9,0x12,0xee,0xdd,0x40,0xda,0xd1,0xb1,0xf4,0xde,
		0x09,0xa7,0x49,0x24,0x53,0x29,0xf9,0x70,0x7d,0xeb,0x04,0xaf,0x97,0x3b,0x27,0xa1,
		0xad,0x2b,0x39,0x0f,0x93,0xc9,0xfb,0xae,0x31,0xfe,0x7f,0x1a,0xe9,0x2d,0x8e,0x6d,
		0xd0,0xfe,0x15,0x25,0x14,0x56,0x57,0x88,0xa4,0xd9,0x62,0xab,0xdd,0x9b,0x3f,0x80,
		0x18,0xfe,0xa2,0xb2,0x2c,0x88,0x7b,0x55,0x66,0x1f,0xea,0x8b,0x28,0xfe,0x7f,0xd6,
		0xae,0xe9,0x4a,0x3c,0xc7,0x60,0x31,0x56,0xee,0x2d,0xcc,0x8b,0x90,0x71,0x59,0x46,
		0xc0,0x2b,0xc8,0x25,0x52,0xe1,0xc6,0x03,0x77,0x43,0xf4,0xf4,0xa5,0xb2,0xb4,0x95,
		0xa4,0x41,0x74,0x77,0xc5,0x16,0x4a,0x20,0xf5,0x20,0x0f,0xcb,0x81,0x57,0x52,0xcb,
		0x6b,0x96,0x04,0xf2,0x78,0xc9,0xe7,0xf1,0xad,0x78,0x87,0xee,0x86,0x7a,0xe2,0xa8,
		0xdd,0x41,0xe6,0xcb,0x82,0x71,0x59,0xf2,0xe9,0xa8,0xc8,0xe8,0xea,0xdb,0xf1,0xf2,
		0x3a,0x9e,0x14,0xfd,0x2a,0xbc,0x16,0x52,0x64,0x9b,0xa4,0x32,0x32,0xae,0xc4,0x50,
		0x46,0x31,0xef,0x56,0xac,0x6c,0x1e,0x25,0xc3,0x1e,0x3d,0x3d,0x3e,0x95,0x9f,0xaa,
		0x43,0xe4,0x5e,0x86,0x1f,0x75,0xd7,0xfc,0xff,0x00,0x4a,0x4b,0x47,0xca,0x14,0xf7,
		0x26,0xba,0x6d,0x35,0xf7,0x5b,0x0e,0xb5,0x6e,0x8a,0x2b,0x03,0xc4,0x8d,0xf3,0x80,
		0x1b,0x8d,0xa0,0x63,0xd0,0xe4,0x9f,0xf0,0xaa,0x1a,0x4b,0x06,0x12,0xc0,0xcd,0x8c,
		0xe0,0x8c,0x7e,0xbf,0xd2,0xb5,0x6c,0xd0,0xc7,0x3b,0x29,0xe9,0x8e,0x0f,0xad,0x68,
		0x22,0xe7,0xad,0x23,0xc0,0x0f,0x6a,0x44,0xb7,0x51,0xfc,0x38,0xa7,0xf9,0x63,0x77,
		0xa6,0x2a,0x55,0xe0,0x53,0x08,0xc9,0xc1,0xa4,0x68,0x43,0x0f,0x7f,0x5a,0x6f,0xd9,
		0xc6,0x73,0x4e,0x29,0xb5,0x6b,0x0f,0x5f,0x50,0x22,0x88,0xf1,0x9d,0xdf,0xd2,0xb2,
		0xed,0x9b,0x13,0x2e,0x7b,0x9c,0x57,0x4b,0xa3,0xb6,0x63,0x2b,0xd8,0x7e,0x95,0xa5,
		0x45,0x15,0xcd,0x78,0x83,0x22,0x79,0x33,0xd0,0xba,0xe3,0xfe,0xf9,0x15,0x99,0x04,
		0xa2,0x0b,0x84,0x98,0x03,0x81,0x8c,0x8f,0x62,0x39,0xad,0xc8,0xe5,0x5f,0xb4,0x23,
		0x2b,0x82,0x8c,0x7e,0x52,0x0d,0x69,0x23,0x7c,0xc4,0x54,0xe2,0x8e,0x2a,0x17,0x62,
		0xcc,0x42,0xf4,0x15,0x3a,0xf2,0x2a,0x27,0x38,0x3f,0x2f,0x24,0x53,0xe3,0x70,0xeb,
		0x91,0xf9,0x53,0xce,0x2a,0x29,0x5b,0x0b,0x5c,0xce,0xb7,0x36,0xfb,0x94,0x41,0xd1,
		0x41,0x3f,0xe7,0xf2,0xac,0xf8,0xdb,0x0c,0xa7,0xd0,0xd6,0xfe,0x87,0x3f,0xef,0xca,
		0x9f,0xe2,0x18,0xad,0xda,0x28,0xae,0x6b,0xc4,0x21,0x85,0xc4,0x99,0x3c,0x16,0x52,
		0x07,0xb6,0xd0,0x3f,0xa1,0xac,0x86,0xc1,0x40,0x79,0xe9,0x49,0x0b,0x88,0xe7,0x47,
		0x27,0x85,0x60,0xc7,0xf3,0xae,0xb1,0x5c,0x70,0xd5,0x65,0x1f,0x8a,0x79,0xf9,0x85,
		0x52,0xba,0x8a,0xe5,0x43,0x79,0x2d,0x8c,0xf7,0xe0,0xff,0x00,0x3a,0x8a,0x3b,0xa9,
		0x91,0x42,0x30,0xcb,0x1e,0x0e,0x05,0x3a,0x34,0xbb,0x33,0xee,0xdf,0xf2,0x9e,0xab,
		0xc6,0x3f,0xc6,0xae,0xa2,0x95,0x39,0x14,0xad,0x20,0x15,0x5a,0xe6,0x5f,0x93,0xad,
		0x72,0xd7,0xcf,0xbe,0xee,0x43,0x9c,0xe0,0xe2,0xa2,0x5c,0x71,0xf5,0xe6,0xaf,0xe9,
		0xd2,0x94,0x99,0x48,0x38,0x65,0x39,0x15,0xd7,0xfd,0x3a,0x51,0x45,0x61,0x78,0x96,
		0x03,0xfb,0xb9,0xf9,0x2a,0x46,0xc3,0xec,0x46,0x48,0xfe,0x67,0xf2,0xac,0x40,0x84,
		0xdb,0x67,0xd0,0xd4,0x1d,0xfe,0xb5,0xbf,0xa7,0xdc,0x19,0xad,0x14,0xb1,0xc9,0x1c,
		0x1f,0xad,0x68,0x44,0x4f,0x63,0x53,0x89,0x31,0x4b,0x24,0xd1,0xa2,0xe5,0xdc,0x28,
		0xf7,0x35,0x02,0xdc,0xda,0xb9,0xe2,0x64,0xe3,0xf0,0x34,0xe5,0xbc,0xb5,0xdd,0x81,
		0x32,0xe7,0xdf,0x8a,0x90,0xb8,0x61,0x90,0x47,0xb1,0x1c,0xd4,0x72,0x9f,0x6a,0xce,
		0xbb,0x90,0x24,0x6c,0xc4,0xf0,0xa3,0x35,0xce,0x9c,0x93,0x93,0xde,0x95,0x4e,0x08,
		0xab,0x16,0xe7,0x0e,0xac,0xa7,0x90,0x6b,0xb2,0xb5,0x7f,0x32,0xda,0x36,0xff,0x00,
		0x64,0x0a,0x96,0x8a,0xa3,0xac,0xc5,0xe6,0xe9,0xb2,0x71,0x92,0xa4,0x30,0xfc,0xff,
		0x00,0xc0,0x9a,0xe7,0xfc,0xb0,0x96,0x59,0x3d,0x73,0x59,0xec,0x30,0xc7,0xd8,0xd5,
		0xcd,0x2e,0x63,0x1c,0xcd,0x19,0x3f,0x2b,0x0c,0xfe,0x35,0xb9,0x0c,0x82,0x9f,0x26,
		0x5f,0xa3,0x11,0x54,0xe6,0xb1,0x0c,0xfb,0xdd,0xde,0x5f,0x66,0x34,0x82,0xd6,0xd0,
		0xf5,0x49,0x01,0xf6,0x63,0x4e,0x36,0x56,0xee,0x30,0x91,0x91,0xee,0xc4,0xe6,0xac,
		0x41,0x6c,0x96,0xe0,0x08,0xcb,0x63,0xd3,0x71,0x34,0xf9,0xa4,0x01,0x71,0x58,0x9a,
		0xa4,0xe0,0x81,0x12,0x9e,0x4f,0x2d,0xcd,0x67,0x01,0x4b,0x8c,0xb0,0xa9,0xa1,0x8d,
		0x98,0xe5,0x06,0x70,0x09,0x3f,0x4a,0xec,0x2c,0x10,0x25,0xa2,0x61,0x98,0x86,0x19,
		0xc1,0xe8,0x0f,0x7c,0x55,0x8a,0x29,0x0a,0x86,0x52,0xac,0x32,0x08,0xc1,0x1e,0xa2,
		0xb9,0x8d,0x48,0xa8,0x41,0x1a,0x0e,0x17,0x82,0x7d,0xeb,0x2d,0x86,0x5b,0xeb,0x8a,
		0x20,0x6d,0x92,0xa9,0x15,0xb3,0x1c,0x98,0xe0,0xfe,0x75,0x7a,0x12,0x1d,0x78,0x3c,
		0xd4,0xeb,0x06,0xe1,0x8c,0x8a,0x43,0x69,0x4e,0xfb,0x38,0x41,0x51,0xc8,0xc2,0x31,
		0xcf,0x4a,0xce,0xba,0xb8,0xda,0xa7,0x1c,0x91,0x58,0x45,0x8b,0xbe,0xe6,0xe4,0x93,
		0x4e,0xcf,0x24,0xf6,0xa1,0x3a,0x56,0xae,0x8f,0x0b,0xc8,0xec,0x14,0x91,0xbd,0x76,
		0x9c,0x77,0x04,0xf3,0xfc,0xab,0xa7,0x55,0x0a,0xa1,0x47,0x40,0x31,0x4b,0x45,0x55,
		0xbd,0xb9,0xf2,0xe3,0x28,0x8d,0x87,0xc7,0x27,0xd0,0x57,0x39,0x70,0xdb,0x99,0xff,
		0x00,0x31,0x54,0xdb,0xa2,0x9c,0x7b,0x54,0x47,0x82,0x78,0xad,0x68,0xce,0xe8,0x55,
		0x87,0x71,0x4e,0x8e,0xe1,0xa1,0x39,0x3d,0x2b,0x46,0x1b,0xf8,0xd8,0x73,0x80,0x6a,
		0x71,0x76,0x84,0x75,0x1f,0x9d,0x47,0x25,0xec,0x60,0x7d,0xe1,0xf9,0xd6,0x74,0xd7,
		0x2f,0x70,0xd8,0x40,0x70,0x7b,0xd4,0x53,0xc7,0xb2,0xdd,0x8e,0x0e,0x48,0xac,0x71,
		0x4a,0x4f,0x18,0xa7,0xa9,0xc2,0xf4,0xae,0x83,0xc3,0xd2,0xc6,0xa8,0xc1,0x8e,0x19,
		0xb0,0x01,0xf6,0xff,0x00,0xf5,0xd6,0xe5,0x15,0x4a,0x5b,0x8d,0x89,0x9b,0x83,0xb5,
		0xba,0x84,0x15,0x97,0x35,0xc1,0x6d,0xc4,0x93,0x8e,0xb8,0x3f,0xce,0xb3,0x2e,0x1b,
		0x18,0x3d,0x7a,0xe6,0xa2,0x5f,0x98,0x91,0x9e,0xf9,0xa8,0xd8,0x10,0x2b,0x42,0xc5,
		0xb7,0x43,0xb4,0xf6,0x35,0x2b,0xaf,0x04,0x54,0x0f,0x1f,0xa7,0x5a,0x66,0xd9,0xfa,
		0x29,0xfd,0x6a,0x68,0xad,0x89,0x20,0xbf,0x35,0x76,0x28,0x80,0xc6,0x05,0x45,0x78,
		0x7f,0x74,0xc0,0x7a,0x56,0x29,0x5c,0x73,0x48,0x54,0x83,0x46,0xe2,0x48,0x1e,0xf5,
		0x3c,0x57,0x32,0xc5,0xb5,0x91,0xc8,0x60,0x30,0x3b,0xf1,0xe9,0x5a,0x56,0xda,0xdc,
		0xf1,0x80,0xb2,0x63,0x6f,0xa8,0x15,0xb2,0x97,0x37,0x45,0x41,0x30,0x02,0x0f,0x20,
		0x8e,0x84,0x57,0x3e,0xad,0x31,0x3f,0x3c,0x81,0x7f,0x53,0x51,0x4d,0x2e,0x1f,0xcb,
		0x53,0xc7,0x73,0xea,0x6a,0xac,0xaf,0xbd,0xcf,0xa0,0xa6,0x2b,0xe1,0xf3,0xda,0xa4,
		0x73,0xb9,0x73,0xde,0xac,0x58,0x3e,0x19,0x97,0xd7,0x15,0xa1,0xd4,0x50,0x17,0x3d,
		0x45,0x48,0xb1,0x8e,0xf4,0xed,0xa0,0x70,0x3a,0xd3,0x88,0xc0,0xcd,0x57,0x9f,0x95,
		0xc5,0x65,0xc8,0x98,0x72,0xb8,0xc7,0x26,0xa4,0xb5,0x84,0x4d,0x87,0x73,0x80,0x2a,
		0x9b,0x10,0x64,0x24,0x70,0xb9,0xe3,0xe9,0x46,0x79,0xa3,0x71,0xe2,0xa6,0x4b,0x99,
		0x95,0x40,0x59,0x5c,0x01,0xd8,0x31,0xa5,0x33,0x9c,0x1d,0xbd,0x4f,0x15,0x13,0x1d,
		0xa0,0x8c,0xfc,0xc7,0xaf,0xb5,0x47,0x40,0x1c,0xd3,0xc1,0x3b,0x6a,0x6b,0x73,0xb6,
		0x40,0x7d,0xeb,0x52,0x36,0xe3,0x1e,0xd5,0x20,0xf5,0xa5,0xc9,0xa7,0x03,0x4a,0x49,
		0x35,0x11,0x5c,0xf6,0xaa,0x97,0x10,0xe0,0x87,0xc7,0x43,0x93,0x55,0x25,0x76,0x84,
		0x3c,0x4a,0x4e,0x09,0xcd,0x56,0xef,0x41,0xe2,0x90,0x52,0xe7,0x14,0xed,0xea,0x83,
		0xe5,0x19,0x3e,0xa6,0x98,0x49,0x34,0x0a,0x72,0x7d,0xef,0xa5,0x03,0xbd,0x5a,0xb7,
		0x4c,0xb6,0x71,0xe9,0x5a,0x08,0x3d,0xbb,0x54,0xa0,0x0c,0xf1,0x4b,0x4f,0x00,0xd3,
		0xd6,0x33,0xdc,0x53,0xd2,0x1c,0x9a,0x65,0xd4,0x4b,0x1c,0x6c,0xcf,0xc0,0x03,0x9a,
		0xe7,0x70,0x25,0xde,0xc4,0x90,0xdc,0x6d,0x18,0xce,0x7b,0x53,0x18,0x15,0x7d,0xa7,
		0xa8,0x38,0x34,0xc3,0x9c,0xd2,0xd1,0x49,0x45,0x14,0xbf,0x4f,0xc6,0x9c,0x80,0xb1,
		0x00,0x75,0x35,0xb3,0x69,0x6d,0xfb,0xbc,0x8e,0xe7,0xf4,0xab,0x9f,0x67,0x38,0xfa,
		0x0a,0x55,0x87,0x27,0x9a,0x77,0x91,0xcd,0x38,0x42,0x41,0xe9,0x53,0xa4,0x27,0xd2,
		0xa5,0x54,0x0a,0x39,0x15,0x8b,0xe2,0x0b,0x9d,0xa1,0x60,0x46,0xe5,0x8e,0x5b,0x07,
		0xb5,0x61,0x06,0x65,0x39,0x04,0x83,0xea,0x0d,0x27,0x42,0x3e,0xb4,0x1e,0xb4,0x51,
		0x9a,0x4a,0x01,0xc1,0xcd,0x2e,0x68,0x03,0xbd,0x28,0x24,0x74,0x35,0xd3,0xe9,0x92,
		0x25,0xc5,0xb2,0xc8,0xa3,0x04,0x7c,0xac,0x3d,0x0d,0x5f,0x08,0x29,0x42,0x73,0x9e,
		0xb4,0xbe,0x58,0xa5,0x08,0x01,0xa7,0xd4,0x53,0xca,0xb1,0x44,0xce,0xc4,0x00,0x06,
		0x49,0x35,0xc7,0x5d,0xdc,0x1b,0x8b,0x87,0x94,0xe7,0xe6,0x3c,0x67,0xb0,0xed,0x50,
		0x0a,0x3b,0x8a,0x28,0xa5,0x15,0x3f,0xf6,0x75,0xf7,0xfc,0xf9,0xdc,0x7f,0xdf,0xa6,
		0xff,0x00,0x0a,0x4f,0xec,0xeb,0xef,0xf9,0xf3,0xb8,0xff,0x00,0xbf,0x4d,0xfe,0x14,
		0xa3,0x4f,0xbd,0xff,0x00,0x9f,0x3b,0x8f,0xfb,0xf4,0xdf,0xe1,0x4b,0xfd,0x9f,0x7d,
		0xff,0x00,0x3e,0x77,0x1f,0xf7,0xe9,0xbf,0xc2,0x81,0xa7,0xdf,0x7f,0xcf,0x9d,0xc7,
		0xfd,0xfa,0x6f,0xf0,0xad,0x2d,0x16,0x2b,0xcb,0x6b,0x83,0x1c,0x96,0xb3,0x88,0xe4,
		0xee,0x63,0x38,0x04,0x56,0xf8,0x46,0xc7,0xdc,0x6f,0xca,0x9c,0x11,0xbf,0xba,0xdf,
		0x95,0x3b,0x6b,0x63,0xee,0x9f,0xca,0x82,0xad,0xfd,0xd3,0xf9,0x53,0x08,0x7e,0x7e,
		0x46,0xfc,0xab,0x27,0x5a,0x17,0x4f,0x00,0x8a,0x08,0x26,0x6d,0xe7,0xe6,0x2a,0x84,
		0xe0,0x56,0x4a,0x68,0xf7,0xb2,0x23,0xb7,0x90,0xea,0x55,0x37,0xe1,0x90,0x8c,0xfb,
		0x0f,0x7f,0x6a,0x87,0xfb,0x3a,0xf7,0xfe,0x7c,0xee,0x3f,0xef,0xdb,0x7f,0x85,0x27,
		0xf6,0x75,0xee,0x7f,0xe3,0xce,0xe3,0xfe,0xfd,0x37,0xf8,0x51,0xfd,0x9d,0x7d,0xff,
		0x00,0x3e,0x77,0x1f,0xf7,0xe9,0xbf,0xc2,0x8f,0xec,0xfb,0xef,0xf9,0xf3,0xb8,0xff,
		0x00,0xbf,0x4d,0xfe,0x14,0xbf,0xd9,0xf7,0xbf,0xf3,0xe7,0x71,0xff,0x00,0x7e,0x9b,
		0xfc,0x2b,0xff,0xd9,
	};
    poEmulationCard->PutTransparentEF("3F00DF014035",
        CByteArray(tuc3F00DF014035, (unsigned long) sizeof(tuc3F00DF014035)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(PuK#7 ID) (CA role ID)
    unsigned char tuc3F00DF014038[] = { // TODO: is wrong!
        0x04,0x87,0x46,0xe9,0x09,0xf6,0x51,0xcf,0x9d,0x65,0x2c,0x59,0x18,0xf6,0xa6,0x3b,
        0xa2,0xd8,0x34,0xaa,
    };
    poEmulationCard->PutTransparentEF("3F00DF014038",
        CByteArray(tuc3F00DF014038, (unsigned long) sizeof(tuc3F00DF014038)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Preferences)
    unsigned char tuc3F00DF014039[] = {
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF014039",
        CByteArray(tuc3F00DF014039, (unsigned long) sizeof(tuc3F00DF014039)), AC_ALWAYS, 0, AC_PIN, 1);

	// Auth key
	unsigned char tucAuthMod[] = {
		0x00,0xdd,0x15,0xe4,0xaa,0xd6,0x3b,0xea,0xef,0x8a,0x5c,0x1f,0xd9,0x86,0x29,
		0x04,0xbb,0x10,0xf8,0xce,0x9f,0x86,0x7d,0xaf,0x4f,0xba,0xca,0x24,0xaa,0xc1,
		0x18,0x27,0xae,0xd1,0xf6,0x60,0x3e,0x72,0x8c,0x7f,0x97,0xbc,0xe3,0x22,0xc6,
		0x47,0x4c,0xb4,0x7c,0x03,0x6f,0x4a,0x22,0xb3,0x7f,0x7e,0x13,0xd0,0xb4,0x26,
		0xc9,0x29,0xe7,0x82,0x72,0x55,0xaf,0x73,0x19,0x31,0x52,0xb8,0x49,0xa4,0xbe,
		0xdb,0x82,0x01,0x13,0xfd,0x32,0x87,0xb3,0x5f,0x53,0x2d,0x20,0x7d,0x17,0x9d,
		0x37,0x48,0xf4,0xcb,0xa8,0x1f,0x08,0x5d,0xf3,0x32,0x05,0x6a,0x7f,0xa3,0x2e,
		0xab,0x39,0x2b,0x5f,0xf1,0x43,0xd3,0x7e,0x33,0xb7,0x3c,0x43,0x3d,0xd3,0xec,
		0xb2,0x50,0x06,0x51,0x8b,0xb5,0x72,0xf8,0x9d,
	};
	unsigned char tucAuthPrivExp[] = {
		0x00,0x86,0xa3,0x39,0x91,0x8c,0x4c,0x0b,0x03,0xfb,0xe7,0xa4,0x81,0xcd,0x01,
		0x17,0xdf,0x70,0x33,0x85,0x69,0x82,0xf6,0xf1,0x97,0x85,0x72,0x6b,0x28,0x0d,
		0xd5,0xce,0xfc,0xd8,0xe2,0xc8,0xb3,0xdf,0x00,0x8f,0x07,0x72,0x41,0x84,0xc0,
		0xe9,0x54,0xde,0x29,0x13,0xd2,0x67,0x7c,0x80,0x81,0xa8,0xdf,0x1a,0x5f,0x4b,
		0xab,0x80,0x38,0x7b,0xa8,0x51,0x36,0x8a,0x91,0x6f,0xb2,0x7d,0x36,0x1b,0x6c,
		0x42,0xf1,0x88,0x88,0x04,0xec,0x13,0x09,0xdb,0xfe,0xae,0x6e,0x63,0x65,0x39,
		0xcc,0x3b,0x6c,0x20,0x49,0xb9,0x34,0x1f,0x82,0xba,0x16,0x41,0x72,0x82,0xe5,
		0x03,0x48,0x97,0xf2,0x48,0x1b,0x7d,0xb1,0xba,0x55,0xbb,0x4a,0x18,0x7c,0x35,
		0x90,0xbb,0x8f,0x06,0xa6,0x29,0x34,0xe8,0xc5,
	};
	poEmulationCard->PutRsaKey(CByteArray(tucAuthPrivExp, sizeof(tucAuthPrivExp)),
		CByteArray(tucAuthMod, sizeof(tucAuthMod)),
		"3F00", 0x82, 0x01, false,
		ALGO_RSA_PKCS1_MD5 | ALGO_RSA_PKCS1_SHA1 | ALGO_RSA_PKCS1);

	// Signature key
	unsigned char tucSignMod[] = {
		0x00,0xb9,0x1d,0x49,0x9b,0x9e,0x9e,0x3a,0x8c,0x3b,0x8a,0xce,0x79,0x78,0xdb,
		0x33,0x01,0xb8,0xd1,0x59,0x15,0x83,0x7b,0x91,0x91,0xbd,0xa0,0xf4,0x51,0x2b,
		0xf3,0x9a,0x9e,0xe3,0x56,0x42,0x3e,0xaf,0xfb,0x01,0xef,0xbb,0xf4,0x97,0x34,
		0x0c,0x21,0x12,0x82,0x4a,0x02,0x1d,0x90,0xce,0x3e,0x11,0xfc,0x6a,0x53,0xcd,
		0x8b,0xce,0xbf,0x21,0xb8,0x60,0x0a,0x89,0x83,0x7e,0x87,0x24,0x08,0x63,0x28,
		0x7f,0xb2,0xa2,0x1c,0x2a,0xfe,0x67,0xd4,0x2b,0xd9,0x0f,0x23,0x40,0x28,0x71,
		0x3e,0xd4,0xaf,0x72,0x34,0x7c,0xb5,0x37,0x7b,0x8c,0x5e,0x7a,0x0f,0x24,0xa6,
		0x43,0xa0,0x8b,0xce,0x74,0x39,0x4b,0x4f,0x85,0x30,0x85,0xb0,0x36,0x6f,0x45,
		0x06,0x34,0xee,0x2f,0xed,0x0e,0x8a,0x53,0xa5,
	};
	unsigned char tucSignPrivExp[] = {
		0x35,0x48,0x68,0xd7,0x92,0x60,0x99,0x19,0xa4,0x49,0xe0,0x04,0xb6,0xf4,0xe1,
		0x49,0xad,0x99,0x14,0xbb,0x4c,0x8d,0x54,0xe9,0x4e,0x5b,0xf5,0xf7,0x27,0x5f,
		0x87,0x32,0x14,0xdd,0xcf,0x53,0x9b,0xf3,0xf4,0x2a,0xbd,0x3f,0x3a,0x06,0x91,
		0x37,0x33,0xcc,0xac,0xe0,0xcf,0x01,0xcf,0x5b,0xae,0x71,0xa9,0x69,0x55,0xd0,
		0xd8,0x41,0xcb,0xc2,0x79,0x01,0x51,0x8b,0xee,0x3f,0x52,0xe9,0x5f,0x98,0x1f,
		0x15,0xdc,0x1f,0xd3,0x14,0xb3,0x3b,0xc3,0xe0,0x86,0xc6,0x9f,0x7a,0xbb,0xe9,
		0xd1,0x6b,0x5b,0x96,0x5c,0x9b,0xe9,0xea,0xd6,0xcb,0x2a,0x2a,0x61,0xda,0xce,
		0x9e,0x22,0x81,0xc0,0x9a,0x4f,0xb8,0x90,0x4a,0xe1,0x89,0x03,0xfc,0x02,0x9b,
		0x24,0x4e,0xe0,0x61,0xc5,0x03,0x62,0x01,
	};
	poEmulationCard->PutRsaKey(CByteArray(tucSignPrivExp, sizeof(tucSignPrivExp)),
		CByteArray(tucSignMod, sizeof(tucSignMod)),
		"3F00", 0x83, 0x01, true,
		ALGO_RSA_PKCS1_MD5 | ALGO_RSA_PKCS1_SHA1 | ALGO_RSA_PKCS1);

	m_bBeidV1Test1Initialized = true;

	return poEmulationCard;
}

/////////////////////////////////////////////////////////////////////////////////
// Real eID card; no keys present

static CEmulationBeidCard *m_BeidV1Test2 = NULL;
static bool m_bBeidV1Test2Initialized = false;

CEmulationCard * CEmulationCardFactory::MakeBeidV1Test2()
{
	if(!m_bCardInitialized)
		Init();

	CEmulationBeidCard *poEmulationCard = m_BeidV1Test2;

	if (m_bBeidV1Test2Initialized)
		return poEmulationCard; // already intialized

	unsigned char tucATR[] =
		{0x3B,0x98,0x13,0x40,0x0A,0xA5,0x03,0x01,0x01,0x01,0xAD,0x13,0x11};
	poEmulationCard->SetATR(CByteArray(tucATR, sizeof(tucATR)));

	// MF
	poEmulationCard->PutPin("3F00",
		1, "1234", 4, 12, 8, PIN_ENC_GP, 3, 0xFF,
		"12345678", 0);

	// Belpic DF
	unsigned char tucBelpicAID[] = {0xA0,0x00,0x00,0x01,0x77,0x50,0x4B,0x43,0x53,0x2D,0x31,0x35};
	poEmulationCard->PutDF("3F00DF00", CByteArray(tucBelpicAID, sizeof(tucBelpicAID)));

	// ID DF
	poEmulationCard->PutDF("3F00DF01");

    // EF(DIR)
    unsigned char tuc3F002F00[] = {
        0x61,0x23,0x4f,0x0c,0xa0,0x00,0x00,0x01,0x77,0x50,0x4b,0x43,0x53,0x2d,0x31,0x35,
        0x50,0x06,0x42,0x45,0x4c,0x50,0x49,0x43,0x51,0x04,0x3f,0x00,0xdf,0x00,0x73,0x05,
        0x06,0x03,0x60,0x38,0x02,
    };
    poEmulationCard->PutTransparentEF("3F002F00",
        CByteArray(tuc3F002F00, (unsigned long) sizeof(tuc3F002F00)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ODF)
    unsigned char tuc3F00DF005031[] = {
        0xa0,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x35,0xa4,0x0a,0x30,0x08,
        0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x37,0xa8,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,
        0xdf,0x00,0x50,0x34,
    };
    poEmulationCard->PutTransparentEF("3F00DF005031",
        CByteArray(tuc3F00DF005031, (unsigned long) sizeof(tuc3F00DF005031)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(TokenInfo)
    unsigned char tuc3F00DF005032[] = {
        0x30,0x27,0x02,0x01,0x00,0x04,0x10,0x53,0x4c,0x49,0x4e,0x33,0x66,0x00,0x29,0x6c,
        0xff,0x26,0x23,0x66,0x0b,0x08,0x26,0x80,0x06,0x42,0x45,0x4c,0x50,0x49,0x43,0x03,
        0x02,0x04,0x30,0x9e,0x04,0x04,0x02,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005032",
        CByteArray(tuc3F00DF005032, (unsigned long) sizeof(tuc3F00DF005032)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(AODF)
    unsigned char tuc3F00DF005034[] = {
        0x30,0x33,0x30,0x0f,0x0c,0x09,0x42,0x61,0x73,0x69,0x63,0x20,0x50,0x49,0x4e,0x03,
        0x02,0x06,0xc0,0x30,0x03,0x04,0x01,0x01,0xa1,0x1b,0x30,0x19,0x03,0x02,0x02,0x0c,
        0x0a,0x01,0x00,0x02,0x01,0x04,0x02,0x01,0x08,0x80,0x01,0x01,0x04,0x01,0xff,0x30,
        0x04,0x04,0x02,0x3f,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005034",
        CByteArray(tuc3F00DF005034, (unsigned long) sizeof(tuc3F00DF005034)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(PrKDF)
    unsigned char tuc3F00DF005035[] = {
        0x30,0x3a,0x30,0x17,0x0c,0x0e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,
        0x74,0x69,0x6f,0x6e,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x0f,0x04,0x01,0x02,
        0x03,0x02,0x05,0x20,0x03,0x02,0x03,0xb8,0x02,0x02,0x00,0x82,0xa1,0x0e,0x30,0x0c,
        0x30,0x06,0x04,0x04,0x3f,0x00,0xdf,0x00,0x02,0x02,0x04,0x00,0x30,0x39,0x30,0x15,
        0x0c,0x09,0x53,0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x03,0x02,0x06,0xc0,0x04,
        0x01,0x01,0x02,0x01,0x01,0x30,0x10,0x04,0x01,0x03,0x03,0x03,0x06,0x00,0x40,0x03,
        0x02,0x03,0xb8,0x02,0x02,0x00,0x83,0xa1,0x0e,0x30,0x0c,0x30,0x06,0x04,0x04,0x3f,
        0x00,0xdf,0x00,0x02,0x02,0x04,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005035",
        CByteArray(tuc3F00DF005035, (unsigned long) sizeof(tuc3F00DF005035)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(CDF)
    unsigned char tuc3F00DF005037[] = {
        0x30,0x2c,0x30,0x17,0x0c,0x0e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,
        0x74,0x69,0x6f,0x6e,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x03,0x04,0x01,0x02,
        0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x38,0x30,0x27,
        0x30,0x12,0x0c,0x09,0x53,0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x03,0x02,0x06,
        0xc0,0x04,0x01,0x01,0x30,0x03,0x04,0x01,0x03,0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,
        0x06,0x3f,0x00,0xdf,0x00,0x50,0x39,0x30,0x23,0x30,0x0b,0x0c,0x02,0x43,0x41,0x03,
        0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x06,0x04,0x01,0x04,0x01,0x01,0xff,0xa1,0x0c,
        0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x3a,0x30,0x25,0x30,0x0d,
        0x0c,0x04,0x52,0x6f,0x6f,0x74,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x06,0x04,
        0x01,0x06,0x01,0x01,0xff,0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,
        0x00,0x50,0x3b,
    };
    poEmulationCard->PutTransparentEF("3F00DF005037",
        CByteArray(tuc3F00DF005037, (unsigned long) sizeof(tuc3F00DF005037)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#2) (authentication)
    unsigned char tuc3F00DF005038[] = {
        0x30,0x82,0x03,0xe1,0x30,0x82,0x02,0xc9,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x10,
        0x00,0x00,0x00,0x00,0x00,0xf8,0xa1,0x31,0x5b,0xc7,0x86,0x24,0x4d,0x3b,0xc6,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x33,
        0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x13,0x30,
        0x11,0x06,0x03,0x55,0x04,0x03,0x13,0x0a,0x43,0x69,0x74,0x69,0x7a,0x65,0x6e,0x20,
        0x43,0x41,0x31,0x0f,0x30,0x0d,0x06,0x03,0x55,0x04,0x05,0x13,0x06,0x32,0x30,0x30,
        0x36,0x32,0x30,0x30,0x1e,0x17,0x0d,0x30,0x36,0x31,0x30,0x32,0x35,0x31,0x39,0x32,
        0x33,0x30,0x37,0x5a,0x17,0x0d,0x31,0x31,0x31,0x30,0x32,0x34,0x32,0x33,0x35,0x39,
        0x35,0x39,0x5a,0x30,0x6e,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,
        0x42,0x45,0x31,0x27,0x30,0x25,0x06,0x03,0x55,0x04,0x03,0x13,0x1e,0x53,0x74,0x65,
        0x66,0x61,0x6e,0x20,0x48,0x6f,0x65,0x62,0x65,0x6e,0x20,0x28,0x41,0x75,0x74,0x68,
        0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x29,0x31,0x0f,0x30,0x0d,0x06,
        0x03,0x55,0x04,0x04,0x13,0x06,0x48,0x6f,0x65,0x62,0x65,0x6e,0x31,0x0f,0x30,0x0d,
        0x06,0x03,0x55,0x04,0x2a,0x13,0x06,0x53,0x74,0x65,0x66,0x61,0x6e,0x31,0x14,0x30,
        0x12,0x06,0x03,0x55,0x04,0x05,0x13,0x0b,0x37,0x33,0x30,0x34,0x30,0x31,0x30,0x32,
        0x37,0x34,0x39,0x30,0x81,0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,
        0x01,0x01,0x01,0x05,0x00,0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,
        0x85,0x42,0xd3,0xa2,0x97,0x62,0x72,0xc9,0x55,0x30,0xdd,0x68,0x4a,0x49,0x2d,0x54,
        0x6b,0x21,0x09,0x9f,0x0b,0x4f,0x3e,0x6c,0x2b,0x96,0xa5,0x45,0x05,0x7f,0x48,0xd9,
        0x98,0x98,0xd1,0xe1,0x3f,0x5d,0x59,0x7b,0x9a,0x63,0x77,0x93,0x19,0xbf,0x00,0x23,
        0x7c,0x79,0xc1,0x18,0xbe,0x02,0xae,0xd9,0x1a,0xd1,0x1f,0xe1,0x85,0x70,0xe9,0x5a,
        0xdb,0x3b,0x0c,0xe4,0x48,0xc1,0xab,0x90,0x75,0x79,0xeb,0x99,0xbe,0x62,0xf8,0xf6,
        0x4f,0xcb,0x34,0xc6,0xac,0xf5,0xd1,0x02,0xd0,0x70,0x62,0x1e,0x2f,0x5c,0x1e,0xe7,
        0xe4,0x02,0x73,0x5b,0x98,0x4b,0x8f,0xe4,0x37,0xe7,0x2f,0xed,0xa3,0x20,0xfb,0x47,
        0x7c,0xef,0xf0,0xf8,0x8b,0xe1,0xba,0x97,0x39,0x19,0xa1,0x7f,0xd4,0x25,0xcc,0xc1,
        0x02,0x03,0x01,0x00,0x01,0xa3,0x82,0x01,0x38,0x30,0x82,0x01,0x34,0x30,0x44,0x06,
        0x03,0x55,0x1d,0x20,0x04,0x3d,0x30,0x3b,0x30,0x39,0x06,0x07,0x60,0x38,0x01,0x01,
        0x01,0x02,0x02,0x30,0x2e,0x30,0x2c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,
        0x01,0x16,0x20,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,
        0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,
        0x2e,0x62,0x65,0x30,0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,
        0x02,0x07,0x80,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,
        0x07,0x93,0x19,0x45,0x26,0xaf,0x58,0x85,0x94,0xbf,0xb1,0xb4,0xb4,0x5e,0x9e,0xc2,
        0x7b,0x86,0xda,0x70,0x30,0x39,0x06,0x03,0x55,0x1d,0x1f,0x04,0x32,0x30,0x30,0x30,
        0x2e,0xa0,0x2c,0xa0,0x2a,0x86,0x28,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,
        0x6c,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,
        0x2f,0x65,0x69,0x64,0x63,0x32,0x30,0x30,0x36,0x32,0x30,0x2e,0x63,0x72,0x6c,0x30,
        0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,
        0x05,0xa0,0x30,0x6d,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01,0x04,0x61,
        0x30,0x5f,0x30,0x35,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02,0x86,0x29,
        0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x65,0x72,0x74,0x73,0x2e,0x65,0x69,0x64,
        0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,0x67,
        0x69,0x75,0x6d,0x72,0x73,0x2e,0x63,0x72,0x74,0x30,0x26,0x06,0x08,0x2b,0x06,0x01,
        0x05,0x05,0x07,0x30,0x01,0x86,0x1a,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x6f,0x63,
        0x73,0x70,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,
        0x65,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,
        0x03,0x82,0x01,0x01,0x00,0x68,0x07,0xbe,0x78,0x15,0xc0,0x32,0x52,0x4e,0x09,0x8f,
        0x87,0x77,0x31,0xf1,0x39,0xcc,0x6f,0x97,0xd4,0xbf,0x4f,0x10,0xd1,0xcb,0x77,0x43,
        0xee,0x4f,0x40,0x56,0x8a,0xbb,0x08,0x2d,0x97,0xac,0xdf,0xe8,0x1d,0xfe,0xc1,0xab,
        0xe6,0xaa,0x74,0x83,0x2f,0xe6,0x5b,0x92,0x51,0xf3,0x83,0x45,0x12,0x5e,0xf7,0xff,
        0x21,0xc9,0x71,0xb1,0xd0,0x97,0x99,0xdc,0x88,0xe4,0x04,0x48,0x72,0x56,0x14,0x4f,
        0xf5,0x23,0xc9,0x42,0x5f,0x7a,0x75,0x45,0x25,0x75,0xa2,0x42,0x3e,0xdf,0xd5,0xaa,
        0x7e,0x81,0xe1,0x2a,0x43,0x17,0x82,0xc9,0xce,0x7e,0xe6,0x97,0x49,0x0f,0x55,0x95,
        0xe8,0x8e,0x51,0x83,0x4f,0x31,0x84,0x50,0x5b,0xda,0x16,0x84,0x32,0x3c,0x7a,0x18,
        0x5d,0x0f,0x29,0xa4,0xbc,0x78,0xa1,0x2d,0x0c,0x78,0xb3,0x57,0x1a,0x38,0x7b,0x93,
        0x1e,0xe2,0xcc,0x25,0xda,0xc3,0x5b,0x4c,0x2c,0x5a,0xe2,0xb6,0x92,0x5c,0x3d,0x91,
        0x37,0x47,0xdd,0xd0,0x48,0xca,0xdd,0x77,0x20,0x35,0xe8,0xda,0x40,0x62,0x1a,0x0f,
        0x79,0x66,0x5b,0xb9,0x3c,0x33,0x66,0x33,0x6e,0xe3,0x74,0x2a,0x8a,0xfd,0xd0,0xbd,
        0xc1,0x05,0x09,0x60,0x33,0x9a,0xd3,0x65,0xfc,0xf9,0x73,0xc0,0xa7,0x86,0xfa,0x1b,
        0x7b,0xa2,0x0b,0x7b,0x70,0xf8,0x69,0xf3,0x6e,0xb8,0xf1,0xc8,0x5e,0x52,0x9c,0x04,
        0x50,0x6e,0xb7,0x46,0xcd,0x18,0xbe,0x2e,0xb1,0x00,0xf7,0x17,0x77,0x29,0xb8,0x3c,
        0x4d,0x9f,0xa6,0xdb,0xf2,0xe3,0xa0,0xc2,0xd6,0xcc,0x0e,0x1e,0x73,0xfe,0x50,0x54,
        0x82,0x20,0xd2,0x4c,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005038",
        CByteArray(tuc3F00DF005038, (unsigned long) sizeof(tuc3F00DF005038)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#3) (non-repudiation)
    unsigned char tuc3F00DF005039[] = {
        0x30,0x82,0x03,0xf6,0x30,0x82,0x02,0xde,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x10,
        0x00,0x00,0x00,0x00,0x00,0x30,0xef,0xb4,0x1b,0x4f,0xf6,0xd6,0x60,0xe4,0x63,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x33,
        0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x13,0x30,
        0x11,0x06,0x03,0x55,0x04,0x03,0x13,0x0a,0x43,0x69,0x74,0x69,0x7a,0x65,0x6e,0x20,
        0x43,0x41,0x31,0x0f,0x30,0x0d,0x06,0x03,0x55,0x04,0x05,0x13,0x06,0x32,0x30,0x30,
        0x36,0x32,0x30,0x30,0x1e,0x17,0x0d,0x30,0x36,0x31,0x30,0x32,0x35,0x31,0x39,0x32,
        0x33,0x30,0x38,0x5a,0x17,0x0d,0x31,0x31,0x31,0x30,0x32,0x34,0x32,0x33,0x35,0x39,
        0x35,0x39,0x5a,0x30,0x69,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,
        0x42,0x45,0x31,0x22,0x30,0x20,0x06,0x03,0x55,0x04,0x03,0x13,0x19,0x53,0x74,0x65,
        0x66,0x61,0x6e,0x20,0x48,0x6f,0x65,0x62,0x65,0x6e,0x20,0x28,0x53,0x69,0x67,0x6e,
        0x61,0x74,0x75,0x72,0x65,0x29,0x31,0x0f,0x30,0x0d,0x06,0x03,0x55,0x04,0x04,0x13,
        0x06,0x48,0x6f,0x65,0x62,0x65,0x6e,0x31,0x0f,0x30,0x0d,0x06,0x03,0x55,0x04,0x2a,
        0x13,0x06,0x53,0x74,0x65,0x66,0x61,0x6e,0x31,0x14,0x30,0x12,0x06,0x03,0x55,0x04,
        0x05,0x13,0x0b,0x37,0x33,0x30,0x34,0x30,0x31,0x30,0x32,0x37,0x34,0x39,0x30,0x81,
        0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,
        0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0x8c,0x4c,0x0f,0x82,0xac,
        0x6c,0x92,0xc7,0x60,0xc9,0xe0,0x8a,0x14,0x85,0x32,0xc1,0x8f,0xf0,0x8b,0xec,0x22,
        0x67,0x06,0x2c,0x1c,0x85,0xd8,0xf6,0xa9,0x25,0xee,0x8c,0xa9,0xfb,0x5e,0xc0,0x30,
        0x03,0x51,0x62,0x3a,0xce,0x62,0x39,0x27,0x8d,0x1d,0x85,0xcf,0xd4,0x1c,0x97,0xca,
        0xc9,0xb4,0x30,0xaf,0xb3,0x39,0xea,0x67,0xee,0x34,0x8e,0xae,0x51,0xa8,0xbf,0x41,
        0x4c,0x46,0xbd,0x1a,0x77,0x14,0x48,0x30,0x34,0x1d,0x47,0x52,0x26,0xa8,0x7a,0xc8,
        0x7b,0xf0,0x78,0x3f,0x21,0x1e,0x34,0xe4,0x91,0x93,0x67,0x94,0x84,0x59,0xd6,0xe2,
        0x19,0x04,0xbe,0x33,0xc0,0x66,0xcd,0xf7,0x22,0xf1,0xd1,0x41,0x11,0xa1,0x59,0x0a,
        0x2a,0x05,0x6c,0x5b,0x4b,0xc8,0x7f,0x1e,0xf1,0xb2,0xab,0x02,0x03,0x01,0x00,0x01,
        0xa3,0x82,0x01,0x52,0x30,0x82,0x01,0x4e,0x30,0x44,0x06,0x03,0x55,0x1d,0x20,0x04,
        0x3d,0x30,0x3b,0x30,0x39,0x06,0x07,0x60,0x38,0x01,0x01,0x01,0x02,0x01,0x30,0x2e,
        0x30,0x2c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x20,0x68,0x74,
        0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,
        0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x0e,
        0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x06,0x40,0x30,0x1f,
        0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x07,0x93,0x19,0x45,0x26,
        0xaf,0x58,0x85,0x94,0xbf,0xb1,0xb4,0xb4,0x5e,0x9e,0xc2,0x7b,0x86,0xda,0x70,0x30,
        0x39,0x06,0x03,0x55,0x1d,0x1f,0x04,0x32,0x30,0x30,0x30,0x2e,0xa0,0x2c,0xa0,0x2a,
        0x86,0x28,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,
        0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x2f,0x65,0x69,0x64,0x63,
        0x32,0x30,0x30,0x36,0x32,0x30,0x2e,0x63,0x72,0x6c,0x30,0x11,0x06,0x09,0x60,0x86,
        0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x05,0x20,0x30,0x6d,0x06,
        0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01,0x04,0x61,0x30,0x5f,0x30,0x35,0x06,
        0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02,0x86,0x29,0x68,0x74,0x74,0x70,0x3a,
        0x2f,0x2f,0x63,0x65,0x72,0x74,0x73,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,
        0x69,0x75,0x6d,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x72,0x73,
        0x2e,0x63,0x72,0x74,0x30,0x26,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,
        0x86,0x1a,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x6f,0x63,0x73,0x70,0x2e,0x65,0x69,
        0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x18,0x06,0x08,
        0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x03,0x04,0x0c,0x30,0x0a,0x30,0x08,0x06,0x06,
        0x04,0x00,0x8e,0x46,0x01,0x01,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,
        0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x51,0xac,0x8e,0x4b,0x6a,0x2d,
        0xd8,0x6a,0x85,0x9a,0x09,0x92,0xc4,0x1c,0x34,0x9c,0xe0,0x4c,0x91,0x5e,0x36,0x18,
        0x1a,0x0d,0x0a,0x9e,0x08,0xeb,0xc9,0xd8,0xf4,0x08,0x90,0x05,0x4f,0xa9,0x2d,0xef,
        0xef,0x32,0xf4,0xd3,0x50,0x36,0x1b,0x3f,0x93,0xe1,0xba,0xa5,0x94,0x62,0x26,0x63,
        0xbd,0x2e,0x81,0x3e,0xc8,0x5a,0x88,0x8a,0x84,0x9f,0x01,0x66,0xbe,0x5f,0x03,0x53,
        0xd7,0x40,0x68,0xce,0x13,0xeb,0x42,0x67,0x09,0x11,0xe2,0xc0,0xde,0x64,0x7f,0xf9,
        0x2b,0x72,0x8d,0x9c,0xdb,0x1d,0x1f,0xf9,0xbf,0x63,0x36,0xbc,0xc2,0xc9,0xed,0x2d,
        0xad,0xc2,0xac,0x42,0x38,0xb3,0x5a,0xe1,0x3c,0x34,0x06,0x93,0x4b,0xc0,0x9e,0x4c,
        0xc6,0xb8,0xc7,0x71,0x55,0x37,0x8f,0x8d,0xf8,0x74,0x31,0x09,0x1a,0x77,0x24,0x50,
        0x28,0xc2,0xd6,0x62,0x73,0x63,0xb9,0xc5,0x96,0xdc,0xa9,0x25,0xe9,0xdb,0x69,0xef,
        0xbb,0xaa,0x57,0x12,0xa9,0x01,0x31,0x38,0xbd,0x58,0xa4,0x24,0xfa,0x6d,0xad,0x7f,
        0x0d,0xbd,0x5d,0x14,0xba,0x64,0x14,0xbb,0x0a,0x9d,0x98,0x2a,0x00,0x07,0x11,0x17,
        0xdf,0x24,0x21,0x3f,0x05,0xb5,0xfa,0x0a,0xc7,0x73,0x89,0xd4,0x53,0x69,0x11,0x91,
        0xc0,0x7c,0x2c,0x17,0x78,0x10,0x2c,0xa5,0xfd,0x00,0xbf,0x6a,0x19,0xe5,0xbb,0xda,
        0x89,0xf1,0xb1,0x16,0xc4,0x60,0xd0,0x58,0x62,0xf1,0x8b,0xfd,0x0b,0xf6,0x07,0x59,
        0x1b,0x45,0xc8,0xca,0x57,0x8c,0x59,0x11,0xc7,0xa5,0xf3,0xa6,0x09,0x54,0xb7,0x06,
        0xd3,0xfe,0xc8,0x2b,0x7a,0x9e,0xf3,0xba,0x71,0xaa,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005039",
        CByteArray(tuc3F00DF005039, (unsigned long) sizeof(tuc3F00DF005039)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#4) (CA)
    unsigned char tuc3F00DF00503A[] = {
        0x30,0x82,0x03,0xdc,0x30,0x82,0x02,0xc4,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x37,
        0x7a,0x2a,0x69,0x18,0x27,0xc6,0xbb,0x56,0x8a,0x3b,0x53,0xb4,0xca,0x09,0x00,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x27,
        0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,
        0x16,0x06,0x03,0x55,0x04,0x03,0x13,0x0f,0x42,0x65,0x6c,0x67,0x69,0x75,0x6d,0x20,
        0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x35,0x31,0x32,0x30,
        0x31,0x31,0x31,0x30,0x30,0x30,0x30,0x5a,0x17,0x0d,0x31,0x32,0x30,0x38,0x30,0x31,
        0x31,0x30,0x30,0x30,0x30,0x30,0x5a,0x30,0x33,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,
        0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x13,0x30,0x11,0x06,0x03,0x55,0x04,0x03,0x13,
        0x0a,0x43,0x69,0x74,0x69,0x7a,0x65,0x6e,0x20,0x43,0x41,0x31,0x0f,0x30,0x0d,0x06,
        0x03,0x55,0x04,0x05,0x13,0x06,0x32,0x30,0x30,0x36,0x32,0x30,0x30,0x82,0x01,0x22,
        0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,
        0x82,0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,0x01,0x01,0x00,0xaf,0x29,0xad,
        0xf8,0x97,0x18,0xbc,0xea,0x93,0xe4,0xcc,0x8e,0xf3,0xb6,0xfc,0xf5,0x2b,0x36,0x60,
        0x47,0x86,0xa4,0x78,0x93,0x1c,0xac,0xc7,0xcc,0x34,0xbe,0xb1,0xa2,0x95,0x85,0xeb,
        0xfa,0xf9,0x8d,0x4a,0xad,0x4f,0x70,0xeb,0x32,0x1f,0x61,0x34,0x87,0xc8,0xa6,0x03,
        0xf9,0x61,0x62,0xd0,0x80,0x83,0x8b,0xbd,0x62,0x86,0x24,0x49,0x37,0xf3,0x24,0x92,
        0x0e,0xca,0xd5,0x66,0xbc,0x9f,0xb6,0x24,0xf0,0xd9,0x91,0xae,0xfa,0x24,0x74,0xc7,
        0xfd,0xa1,0x71,0x60,0xe0,0xb0,0xfe,0xad,0xaf,0x1d,0xc9,0x10,0x87,0xdb,0x50,0xb8,
        0xaf,0xe5,0x26,0xf5,0x05,0x50,0xaa,0x5c,0xe8,0xf5,0x03,0xa1,0x7b,0x5f,0x96,0xa5,
        0x66,0x91,0xf4,0x73,0x0e,0xe8,0xa6,0x5a,0xb4,0x0b,0xf0,0xf0,0xf9,0xe3,0x60,0xe9,
        0x53,0xc7,0x14,0x95,0xec,0x1b,0xcb,0x22,0xdf,0x75,0x16,0x65,0x7b,0x52,0xf4,0xf0,
        0xa4,0x1d,0x18,0x25,0x17,0xa0,0xd5,0x18,0xf5,0xc8,0x14,0x25,0xe1,0x23,0xa8,0xb0,
        0xe5,0x08,0xf1,0x38,0xd6,0x97,0x2e,0xec,0x1e,0xff,0x5a,0x19,0x23,0xc0,0x53,0xba,
        0xb8,0xdc,0xcf,0x08,0xed,0xe5,0x70,0x56,0x79,0xa7,0x96,0x3e,0x3a,0x8a,0x19,0xf9,
        0x20,0x5f,0x62,0x44,0x1d,0x88,0xf3,0xa4,0xd2,0x88,0x4f,0x48,0xe5,0x1a,0x73,0xcd,
        0x36,0xe0,0x5a,0xb3,0x12,0xc8,0xfd,0xd6,0x4b,0x95,0xac,0x3e,0x85,0x5c,0x15,0x31,
        0x60,0x52,0xa2,0x8f,0xa0,0x28,0x1a,0x6e,0x2c,0x32,0x8f,0x21,0x5c,0xc3,0xa6,0xf6,
        0x55,0xd2,0xaa,0x1d,0xa4,0x98,0xdd,0x2f,0xcd,0xd4,0x76,0x5f,0x91,0x02,0x03,0x01,
        0x00,0x01,0xa3,0x81,0xf7,0x30,0x81,0xf4,0x30,0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,
        0x01,0xff,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x12,0x06,0x03,0x55,0x1d,0x13,0x01,
        0x01,0xff,0x04,0x08,0x30,0x06,0x01,0x01,0xff,0x02,0x01,0x00,0x30,0x43,0x06,0x03,
        0x55,0x1d,0x20,0x04,0x3c,0x30,0x3a,0x30,0x38,0x06,0x06,0x60,0x38,0x01,0x01,0x01,
        0x02,0x30,0x2e,0x30,0x2c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,
        0x20,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,
        0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,
        0x65,0x30,0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0x07,0x93,0x19,0x45,
        0x26,0xaf,0x58,0x85,0x94,0xbf,0xb1,0xb4,0xb4,0x5e,0x9e,0xc2,0x7b,0x86,0xda,0x70,
        0x30,0x36,0x06,0x03,0x55,0x1d,0x1f,0x04,0x2f,0x30,0x2d,0x30,0x2b,0xa0,0x29,0xa0,
        0x27,0x86,0x25,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,
        0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,
        0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,0x6c,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,
        0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x00,0x07,0x30,0x1f,0x06,0x03,0x55,
        0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x10,0xf0,0x0c,0x56,0x9b,0x61,0xea,0x57,
        0x3a,0xb6,0x35,0x97,0x6d,0x9f,0xdd,0xb9,0x14,0x8e,0xdb,0xe6,0x30,0x0d,0x06,0x09,
        0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,
        0x0f,0x20,0x18,0xcc,0x94,0x9d,0xb3,0xf9,0xd5,0xb8,0x28,0xcd,0x64,0xc2,0x8b,0x61,
        0xbc,0x8a,0x34,0xe3,0xac,0x9c,0x4c,0x61,0x42,0x1f,0x23,0x0d,0x12,0x6e,0xcd,0xce,
        0x97,0xa5,0x9a,0xbc,0x3d,0x51,0xbf,0x93,0xb2,0xbe,0x35,0x9a,0x20,0xe1,0x66,0x93,
        0x58,0xac,0x3f,0xa4,0x90,0xd1,0x81,0xfa,0xed,0x63,0x3a,0xc4,0xc4,0x0b,0x81,0x4d,
        0xb0,0xec,0x37,0xb4,0x51,0xc2,0xf9,0xd3,0x96,0x66,0xb4,0x61,0x15,0xee,0x9b,0x34,
        0x4b,0xae,0x3d,0xaa,0x63,0x47,0x83,0xa0,0x7a,0xd4,0x03,0x8e,0x6a,0x56,0x9e,0xb3,
        0x27,0xf9,0x56,0x77,0xb6,0x56,0x3b,0x5d,0x21,0xb8,0x59,0x64,0xef,0x2e,0x38,0xaf,
        0x63,0xce,0xcd,0x00,0xe2,0x92,0x19,0x33,0x86,0x74,0x1e,0x9e,0xf2,0x1c,0x52,0x92,
        0xa5,0xd3,0x52,0x70,0xb1,0x8d,0x65,0x5e,0xe8,0x6f,0x39,0xf7,0xfc,0x86,0x58,0x06,
        0xdd,0xfb,0xcc,0x95,0x2a,0xa0,0x01,0x7b,0xba,0x06,0xc8,0xed,0x6f,0x8a,0x09,0xff,
        0x5d,0x90,0x2d,0x0e,0x52,0xaa,0xc8,0x37,0xc0,0xe8,0x36,0x19,0xcd,0x14,0x98,0xaf,
        0x94,0x22,0xf5,0xa7,0xe7,0x9e,0x07,0xea,0xf0,0x3c,0xfc,0x7f,0x3a,0xcf,0x5e,0x9a,
        0x2c,0x5f,0xd1,0x2c,0x97,0xa5,0x88,0xf7,0xbb,0xa4,0x1f,0xd8,0x8c,0x43,0x48,0x09,
        0x45,0xeb,0xb2,0xdc,0x6b,0x9a,0x2f,0x66,0xc7,0x99,0x7b,0x63,0x5c,0x17,0x3b,0x28,
        0x97,0xab,0x76,0x3d,0x9e,0x4e,0xba,0xd3,0x38,0x15,0x79,0x2f,0x64,0x2e,0x46,0xb9,
        0x25,0xdf,0xd4,0x98,0x79,0x69,0xd1,0x49,0xc7,0x06,0x89,0x72,0x8f,0x0b,0xfc,0xf1,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF00503A",
        CByteArray(tuc3F00DF00503A, (unsigned long) sizeof(tuc3F00DF00503A)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#6) (root)
    unsigned char tuc3F00DF00503B[] = {
        0x30,0x82,0x03,0x94,0x30,0x82,0x02,0x7c,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x58,
        0x0b,0x05,0x6c,0x53,0x24,0xdb,0xb2,0x50,0x57,0x18,0x5f,0xf9,0xe5,0xa6,0x50,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x27,
        0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,
        0x16,0x06,0x03,0x55,0x04,0x03,0x13,0x0f,0x42,0x65,0x6c,0x67,0x69,0x75,0x6d,0x20,
        0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x33,0x30,0x31,0x32,
        0x36,0x32,0x33,0x30,0x30,0x30,0x30,0x5a,0x17,0x0d,0x31,0x34,0x30,0x31,0x32,0x36,
        0x32,0x33,0x30,0x30,0x30,0x30,0x5a,0x30,0x27,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,
        0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x03,0x13,
        0x0f,0x42,0x65,0x6c,0x67,0x69,0x75,0x6d,0x20,0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,
        0x30,0x82,0x01,0x22,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,
        0x01,0x05,0x00,0x03,0x82,0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,0x01,0x01,
        0x00,0xc8,0xa1,0x71,0xe9,0x1c,0x46,0x42,0x79,0x78,0x71,0x6f,0x9d,0xae,0xa9,0xa8,
        0xab,0x28,0xb7,0x4d,0xc7,0x20,0xeb,0x30,0x91,0x5a,0x75,0xf5,0xe2,0xd2,0xcf,0xc8,
        0x4c,0x14,0x98,0x42,0x58,0xad,0xc7,0x11,0xc5,0x40,0x40,0x6a,0x5a,0xf9,0x74,0x12,
        0x27,0x87,0xe9,0x9c,0xe5,0x71,0x4e,0x22,0x2c,0xd1,0x12,0x18,0xaa,0x30,0x5e,0xa2,
        0x21,0xb9,0xd9,0xbb,0xff,0xf6,0x74,0xeb,0x31,0x01,0xe7,0x3b,0x7e,0x58,0x0f,0x91,
        0x16,0x4d,0x76,0x89,0xa8,0x01,0x4f,0xad,0x22,0x66,0x70,0xfa,0x4b,0x1d,0x95,0xc1,
        0x30,0x58,0xea,0xbc,0xd9,0x65,0xd8,0x9a,0xb4,0x88,0xeb,0x49,0x46,0x52,0xdf,0xd2,
        0x53,0x15,0x76,0xcb,0x14,0x5d,0x19,0x49,0xb1,0x6f,0x6a,0xd3,0xd3,0xfd,0xbc,0xc2,
        0x2d,0xec,0x45,0x3f,0x09,0x3f,0x58,0xbe,0xfc,0xd4,0xef,0x00,0x8c,0x81,0x35,0x72,
        0xbf,0xf7,0x18,0xea,0x96,0x62,0x7d,0x2b,0x28,0x7f,0x15,0x6c,0x63,0xd2,0xca,0xca,
        0x7d,0x05,0xac,0xc8,0x6d,0x07,0x6d,0x32,0xbe,0x68,0xb8,0x05,0x40,0xae,0x54,0x98,
        0x56,0x3e,0x66,0xf1,0x30,0xe8,0xef,0xc4,0xab,0x93,0x5e,0x07,0xde,0x32,0x8f,0x12,
        0x74,0xaa,0x5b,0x34,0x23,0x54,0xc0,0xea,0x6c,0xce,0xfe,0x36,0x92,0xa8,0x09,0x17,
        0xea,0xa1,0x2d,0xcf,0x6c,0xe3,0x84,0x1d,0xde,0x87,0x2e,0x33,0x0b,0x3c,0x74,0xe2,
        0x21,0x50,0x38,0x95,0x2e,0x5c,0xe0,0xe5,0xc6,0x31,0xf9,0xdb,0x40,0xfa,0x6a,0xa1,
        0xa4,0x8a,0x93,0x9b,0xa7,0x21,0x06,0x87,0x1d,0x27,0xd3,0xc4,0xa1,0xc9,0x4c,0xb0,
        0x6f,0x02,0x03,0x01,0x00,0x01,0xa3,0x81,0xbb,0x30,0x81,0xb8,0x30,0x0e,0x06,0x03,
        0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x0f,0x06,0x03,
        0x55,0x1d,0x13,0x01,0x01,0xff,0x04,0x05,0x30,0x03,0x01,0x01,0xff,0x30,0x42,0x06,
        0x03,0x55,0x1d,0x20,0x04,0x3b,0x30,0x39,0x30,0x37,0x06,0x05,0x60,0x38,0x01,0x01,
        0x01,0x30,0x2e,0x30,0x2c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,
        0x20,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,
        0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,
        0x65,0x30,0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0x10,0xf0,0x0c,0x56,
        0x9b,0x61,0xea,0x57,0x3a,0xb6,0x35,0x97,0x6d,0x9f,0xdd,0xb9,0x14,0x8e,0xdb,0xe6,
        0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,
        0x02,0x00,0x07,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,
        0x10,0xf0,0x0c,0x56,0x9b,0x61,0xea,0x57,0x3a,0xb6,0x35,0x97,0x6d,0x9f,0xdd,0xb9,
        0x14,0x8e,0xdb,0xe6,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,
        0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0xc8,0x6d,0x22,0x51,0x8a,0x61,0xf8,0x0f,
        0x96,0x6e,0xd5,0x20,0xb2,0x81,0xf8,0xc6,0xdc,0xa3,0x16,0x00,0xda,0xcd,0x6a,0xe7,
        0x6b,0x2a,0xfa,0x59,0x48,0xa7,0x4c,0x49,0x37,0xd7,0x73,0xa1,0x6a,0x01,0x65,0x5e,
        0x32,0xbd,0xe7,0x97,0xd3,0xd0,0x2e,0x3c,0x73,0xd3,0x8c,0x7b,0x83,0xef,0xd6,0x42,
        0xc1,0x3f,0xa8,0xa9,0x5d,0x0f,0x37,0xba,0x76,0xd2,0x40,0xbd,0xcc,0x2d,0x3f,0xd3,
        0x44,0x41,0x49,0x9c,0xfd,0x5b,0x29,0xf4,0x02,0x23,0x22,0x5b,0x71,0x1b,0xbf,0x58,
        0xd9,0x28,0x4e,0x2d,0x45,0xf4,0xda,0xe7,0xb5,0x63,0x45,0x44,0x11,0x0d,0x2a,0x7f,
        0x33,0x7f,0x36,0x49,0xb4,0xce,0x6e,0xa9,0x02,0x31,0xae,0x5c,0xfd,0xc8,0x89,0xbf,
        0x42,0x7b,0xd7,0xf1,0x60,0xf2,0xd7,0x87,0xf6,0x57,0x2e,0x7a,0x7e,0x6a,0x13,0x80,
        0x1d,0xdc,0xe3,0xd0,0x63,0x1e,0x3d,0x71,0x31,0xb1,0x60,0xd4,0x9e,0x08,0xca,0xab,
        0xf0,0x94,0xc7,0x48,0x75,0x54,0x81,0xf3,0x1b,0xad,0x77,0x9c,0xe8,0xb2,0x8f,0xdb,
        0x83,0xac,0x8f,0x34,0x6b,0xe8,0xbf,0xc3,0xd9,0xf5,0x43,0xc3,0x64,0x55,0xeb,0x1a,
        0xbd,0x36,0x86,0x36,0xba,0x21,0x8c,0x97,0x1a,0x21,0xd4,0xea,0x2d,0x3b,0xac,0xba,
        0xec,0xa7,0x1d,0xab,0xbe,0xb9,0x4a,0x9b,0x35,0x2f,0x1c,0x5c,0x1d,0x51,0xa7,0x1f,
        0x54,0xed,0x12,0x97,0xff,0xf2,0x6e,0x87,0x7d,0x46,0xc9,0x74,0xd6,0xef,0xeb,0x3d,
        0x7d,0xe6,0x59,0x6e,0x06,0x94,0x04,0xe4,0xa2,0x55,0x87,0x38,0x28,0x6a,0x22,0x5e,
        0xe2,0xbe,0x74,0x12,0xb0,0x04,0x43,0x2a,
    };
    poEmulationCard->PutTransparentEF("3F00DF00503B",
        CByteArray(tuc3F00DF00503B, (unsigned long) sizeof(tuc3F00DF00503B)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#8) (RN)
    unsigned char tuc3F00DF00503C[] = {
        0x30,0x82,0x03,0x2d,0x30,0x82,0x02,0x15,0xa0,0x03,0x02,0x01,0x02,0x02,0x0b,0x04,
        0x00,0x00,0x00,0x00,0x01,0x07,0xe6,0x0b,0xfc,0xdc,0x30,0x0d,0x06,0x09,0x2a,0x86,
        0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x27,0x31,0x0b,0x30,0x09,0x06,
        0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,
        0x03,0x13,0x0f,0x42,0x65,0x6c,0x67,0x69,0x75,0x6d,0x20,0x52,0x6f,0x6f,0x74,0x20,
        0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x35,0x31,0x32,0x30,0x31,0x31,0x31,0x30,0x30,
        0x30,0x30,0x5a,0x17,0x0d,0x31,0x32,0x30,0x38,0x30,0x31,0x31,0x30,0x30,0x30,0x30,
        0x30,0x5a,0x30,0x29,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,
        0x45,0x31,0x0c,0x30,0x0a,0x06,0x03,0x55,0x04,0x0a,0x13,0x03,0x52,0x52,0x4e,0x31,
        0x0c,0x30,0x0a,0x06,0x03,0x55,0x04,0x03,0x13,0x03,0x52,0x52,0x4e,0x30,0x81,0x9f,
        0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,
        0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0xe5,0xdc,0x8b,0xbb,0x67,0xfc,
        0xf7,0x73,0x96,0x28,0x23,0xb3,0x42,0x13,0xdf,0x9d,0x31,0x28,0x8b,0x7d,0xed,0x60,
        0xd9,0x11,0xba,0x0c,0x43,0x9c,0xcc,0xe0,0xe6,0x51,0x7d,0xb4,0x71,0xd9,0x00,0xea,
        0x1b,0x5f,0x6f,0x2d,0x17,0xd7,0xb2,0x5a,0x58,0x80,0x3c,0x93,0x70,0x9c,0xa9,0x40,
        0x4b,0x97,0xab,0xd2,0x34,0x17,0xee,0x79,0xcb,0x08,0xdd,0xde,0x12,0x50,0x82,0x24,
        0x73,0xd1,0xf9,0xcb,0x2e,0x4a,0x57,0xc4,0x3a,0x52,0x77,0x97,0x73,0xcc,0x37,0x55,
        0xf0,0x8b,0x8e,0x59,0xaa,0xb7,0x2b,0x11,0xa5,0x06,0x07,0x02,0x32,0xfa,0x42,0x40,
        0x67,0xe0,0x85,0xf1,0xf6,0xed,0xbe,0x62,0xf9,0x24,0x09,0x90,0x90,0x90,0xec,0x3a,
        0x55,0x97,0xbe,0x20,0x8f,0x04,0x87,0x93,0x81,0xcf,0x02,0x03,0x01,0x00,0x01,0xa3,
        0x81,0xdb,0x30,0x81,0xd8,0x30,0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,
        0x04,0x03,0x02,0x06,0xc0,0x30,0x43,0x06,0x03,0x55,0x1d,0x20,0x04,0x3c,0x30,0x3a,
        0x30,0x38,0x06,0x06,0x60,0x38,0x01,0x01,0x01,0x04,0x30,0x2e,0x30,0x2c,0x06,0x08,
        0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x20,0x68,0x74,0x74,0x70,0x3a,0x2f,
        0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,
        0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x1d,0x06,0x03,0x55,0x1d,
        0x0e,0x04,0x16,0x04,0x14,0x4f,0xa9,0x6f,0xbc,0xd1,0xe4,0x3f,0xb8,0xc4,0x0e,0x7a,
        0xc2,0x00,0x14,0xcc,0x85,0xf2,0x93,0xb2,0x41,0x30,0x36,0x06,0x03,0x55,0x1d,0x1f,
        0x04,0x2f,0x30,0x2d,0x30,0x2b,0xa0,0x29,0xa0,0x27,0x86,0x25,0x68,0x74,0x74,0x70,
        0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,
        0x75,0x6d,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,
        0x6c,0x30,0x09,0x06,0x03,0x55,0x1d,0x13,0x04,0x02,0x30,0x00,0x30,0x1f,0x06,0x03,
        0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x10,0xf0,0x0c,0x56,0x9b,0x61,0xea,
        0x57,0x3a,0xb6,0x35,0x97,0x6d,0x9f,0xdd,0xb9,0x14,0x8e,0xdb,0xe6,0x30,0x0d,0x06,
        0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,
        0x00,0xa9,0x38,0xb3,0x32,0xf2,0x4d,0xb0,0x13,0x55,0x6c,0x08,0x1b,0x06,0xf4,0xbb,
        0x97,0x4d,0xd0,0xbb,0xe1,0xb1,0x43,0x49,0xf8,0x4f,0x62,0x4f,0xdb,0x25,0x06,0x86,
        0x2c,0x31,0xa3,0x27,0xb4,0x61,0xd0,0x9f,0xd2,0x9a,0x30,0x23,0x28,0x5d,0x5c,0x47,
        0xbe,0xe6,0x3b,0xd4,0x7d,0x3b,0x68,0x35,0xde,0x1a,0xcd,0xd0,0xe0,0x54,0x50,0x61,
        0x42,0xf1,0xc7,0x23,0x29,0x49,0x63,0xb5,0x8b,0x09,0x25,0x87,0x4b,0x3a,0xb3,0x56,
        0xd6,0xb6,0xa2,0xe0,0x47,0xbd,0xc5,0x51,0x68,0xef,0x79,0x65,0x62,0x9b,0x95,0xf2,
        0xf3,0x20,0xdd,0xbc,0x27,0x86,0xf8,0x93,0xda,0x01,0xd1,0x7e,0x7f,0x76,0x5e,0xa1,
        0x10,0x7d,0x07,0xfd,0x27,0x98,0x72,0x79,0x32,0x8b,0xbc,0xe4,0xc9,0x1a,0xfd,0x85,
        0x83,0xf7,0x91,0x09,0xc8,0x74,0xff,0xfa,0x0f,0x2a,0x28,0xbb,0xbc,0x1e,0x85,0x86,
        0xc0,0x4f,0x91,0x16,0xfa,0x1b,0x18,0x84,0xae,0xd5,0x24,0x1a,0x00,0xb9,0x0b,0xae,
        0xe2,0x20,0x1f,0xa7,0x30,0xaf,0xb5,0x85,0x51,0xc9,0x8e,0x07,0x21,0x78,0x31,0x7d,
        0x51,0x97,0x6c,0xcc,0x8d,0xab,0xab,0xfa,0x0a,0x94,0x69,0xfc,0x76,0x56,0x0e,0xd2,
        0xa2,0x14,0x64,0x17,0x01,0x6e,0xbe,0x43,0x2d,0x57,0x0f,0x53,0xc5,0x48,0x52,0x54,
        0x65,0x3b,0x05,0x23,0xaa,0x91,0x58,0x15,0x86,0xdc,0x0f,0x0d,0x8f,0x1b,0x47,0xd0,
        0xe3,0x58,0xb1,0x70,0xcf,0x31,0x7d,0x2c,0x92,0xdd,0xc0,0xda,0xff,0x1e,0xb6,0xa7,
        0xda,0xce,0x86,0xad,0xc4,0x01,0x8b,0x32,0x97,0x81,0xe0,0x40,0x7f,0x3a,0xd5,0x72,
        0x1f,
    };
    poEmulationCard->PutTransparentEF("3F00DF00503C",
        CByteArray(tuc3F00DF00503C, (unsigned long) sizeof(tuc3F00DF00503C)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#RN)
    unsigned char tuc3F00DF014031[] = {
        0x01,0x0c,0x35,0x39,0x30,0x34,0x34,0x35,0x30,0x37,0x34,0x37,0x32,0x35,0x02,0x10,
        0x53,0x4c,0x49,0x4e,0x33,0x66,0x00,0x29,0x6c,0xff,0x26,0x23,0x66,0x0b,0x08,0x26,
        0x03,0x0a,0x32,0x34,0x2e,0x31,0x30,0x2e,0x32,0x30,0x30,0x36,0x04,0x0a,0x32,0x34,
        0x2e,0x31,0x30,0x2e,0x32,0x30,0x31,0x31,0x05,0x08,0x48,0x6f,0x6c,0x73,0x62,0x65,
        0x65,0x6b,0x06,0x0b,0x37,0x33,0x30,0x34,0x30,0x31,0x30,0x32,0x37,0x34,0x39,0x07,
        0x06,0x48,0x6f,0x65,0x62,0x65,0x6e,0x08,0x06,0x53,0x74,0x65,0x66,0x61,0x6e,0x09,
        0x00,0x0a,0x04,0x42,0x65,0x6c,0x67,0x0b,0x04,0x42,0x72,0x65,0x65,0x0c,0x0c,0x30,
        0x31,0x20,0x41,0x50,0x52,0x20,0x20,0x31,0x39,0x37,0x33,0x0d,0x01,0x4d,0x0e,0x00,
        0x0f,0x01,0x31,0x10,0x01,0x30,0x11,0x14,0x03,0xcc,0x6c,0x50,0x84,0x85,0x82,0x54,
        0xcc,0x72,0x3c,0xb4,0xe0,0x8e,0x45,0xa8,0x85,0x33,0x68,0x7a,
    };
    poEmulationCard->PutTransparentEF("3F00DF014031",
        CByteArray(tuc3F00DF014031, (unsigned long) sizeof(tuc3F00DF014031)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(SGN#RN)
    unsigned char tuc3F00DF014032[] = {
        0x3d,0x88,0x5c,0x02,0x01,0x24,0x2e,0xd0,0x6d,0x1a,0xe9,0x0c,0xf1,0xde,0x7e,0x75,
        0xe0,0x1e,0x6b,0x12,0x9c,0xa5,0x35,0x53,0xf4,0x79,0x4f,0xb3,0xea,0xc3,0x58,0x2a,
        0x67,0xc7,0xaa,0xf0,0x9d,0x75,0x68,0x75,0x45,0x0c,0xc1,0x59,0x1b,0x5b,0x20,0x7e,
        0xa2,0x6a,0x55,0x15,0xd5,0x40,0x25,0xf3,0x91,0x98,0x48,0x94,0xf8,0x51,0x4e,0xfb,
        0xdb,0x07,0x69,0xc5,0x86,0xd1,0x92,0x29,0xb9,0xf0,0x46,0x00,0xdc,0xad,0x28,0x1c,
        0x67,0x1a,0xb5,0x5e,0xa0,0xbb,0x0e,0xeb,0x7e,0xce,0x2c,0x57,0xbb,0xcf,0xc8,0x7b,
        0xb3,0xd2,0x19,0x6a,0x36,0x3b,0xb0,0xd7,0xa3,0x3f,0x52,0x46,0xd5,0x9d,0x85,0xda,
        0x9d,0xff,0x11,0x9a,0xa7,0x8e,0x25,0xa2,0x0d,0xa9,0x21,0x5a,0xee,0x96,0x93,0x65,
    };
    poEmulationCard->PutTransparentEF("3F00DF014032",
        CByteArray(tuc3F00DF014032, (unsigned long) sizeof(tuc3F00DF014032)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#Address)
    unsigned char tuc3F00DF014033[] = {
        0x01,0x0d,0x5a,0x61,0x6e,0x64,0x73,0x74,0x72,0x61,0x61,0x74,0x20,0x35,0x33,0x02,
        0x04,0x33,0x32,0x32,0x31,0x03,0x08,0x48,0x6f,0x6c,0x73,0x62,0x65,0x65,0x6b,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF014033",
        CByteArray(tuc3F00DF014033, (unsigned long) sizeof(tuc3F00DF014033)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(SGN#Address)
    unsigned char tuc3F00DF014034[] = {
        0x66,0x75,0xfe,0xf7,0xce,0x5b,0x09,0x39,0xed,0xfd,0x15,0x21,0x09,0x29,0x70,0xef,
        0x6c,0xb3,0x85,0x79,0x4a,0xf7,0xce,0x6d,0x54,0x6a,0x41,0xea,0x0c,0x74,0x70,0xd1,
        0xcf,0xda,0x8e,0x38,0xcf,0xea,0x96,0xb1,0x8e,0x14,0xf9,0xba,0xf6,0x32,0x75,0x75,
        0xc3,0x23,0x58,0xf2,0x6a,0x1a,0x1a,0x72,0x7e,0x60,0x7e,0x43,0x99,0xb6,0x74,0x41,
        0xe2,0x29,0x19,0xbd,0x18,0x22,0xa4,0xd3,0xeb,0x8a,0x5b,0xe4,0xb8,0x0c,0xe2,0xf7,
        0xe1,0xd1,0x4f,0xe2,0x26,0x4d,0xe5,0x2f,0x1b,0x71,0xfc,0x1c,0xac,0x2d,0xff,0x55,
        0xa7,0xd3,0xe6,0x5d,0x6d,0xe8,0x49,0x50,0x5c,0x42,0xd5,0x20,0x35,0x8b,0xae,0x57,
        0xb4,0x37,0x6f,0xbc,0x4c,0x42,0xfb,0x99,0xd1,0xc1,0xd9,0xf3,0x5c,0x89,0x64,0xad,
    };
    poEmulationCard->PutTransparentEF("3F00DF014034",
        CByteArray(tuc3F00DF014034, (unsigned long) sizeof(tuc3F00DF014034)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#Photo)
    unsigned char tuc3F00DF014035[] = {
        0xff,0xd8,0xff,0xe0,0x00,0x10,0x4a,0x46,0x49,0x46,0x00,0x01,0x02,0x01,0x01,0x2c,
        0x01,0x2c,0x00,0x00,0xff,0xdb,0x00,0x43,0x00,0x0f,0x0a,0x0b,0x0d,0x0b,0x09,0x0f,
        0x0d,0x0c,0x0d,0x11,0x10,0x0f,0x11,0x16,0x25,0x18,0x16,0x14,0x14,0x16,0x2d,0x20,
        0x22,0x1b,0x25,0x35,0x2f,0x38,0x37,0x34,0x2f,0x34,0x33,0x3b,0x42,0x55,0x48,0x3b,
        0x3f,0x50,0x3f,0x33,0x34,0x4a,0x64,0x4b,0x50,0x57,0x5a,0x5f,0x60,0x5f,0x39,0x47,
        0x68,0x6f,0x67,0x5c,0x6e,0x55,0x5d,0x5f,0x5b,0xff,0xc0,0x00,0x0b,0x08,0x00,0xc8,
        0x00,0x8c,0x01,0x01,0x11,0x00,0xff,0xc4,0x00,0xd2,0x00,0x00,0x01,0x05,0x01,0x01,
        0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,
        0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x10,0x00,0x02,0x01,0x03,0x03,0x02,0x04,0x03,
        0x05,0x05,0x04,0x04,0x00,0x00,0x01,0x7d,0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
        0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,0x22,0x71,0x14,0x32,0x81,0x91,0xa1,0x08,
        0x23,0x42,0xb1,0xc1,0x15,0x52,0xd1,0xf0,0x24,0x33,0x62,0x72,0x82,0x09,0x0a,0x16,
        0x17,0x18,0x19,0x1a,0x25,0x26,0x27,0x28,0x29,0x2a,0x34,0x35,0x36,0x37,0x38,0x39,
        0x3a,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
        0x5a,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
        0x7a,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
        0x99,0x9a,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,0xb5,0xb6,
        0xb7,0xb8,0xb9,0xba,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xd2,0xd3,0xd4,
        0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,
        0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xff,0xda,0x00,0x08,0x01,0x01,
        0x00,0x00,0x3f,0x00,0xef,0xb7,0x1f,0x53,0x40,0x27,0x1d,0x4d,0x21,0x63,0xea,0x68,
        0xdc,0x7d,0x4d,0x1b,0x8e,0x3a,0x9f,0xce,0x97,0x27,0xd4,0xd1,0x96,0x1d,0xcd,0x1b,
        0x8f,0xf7,0x8f,0xe7,0x4d,0x33,0x28,0x20,0x17,0xe4,0xf4,0xe7,0xad,0x29,0x93,0x03,
        0x3b,0xbf,0x5a,0x6a,0x4e,0xaf,0xc2,0x3e,0x48,0xeb,0xcd,0x3b,0x71,0xf5,0x34,0x9b,
        0x9b,0xd4,0xfe,0x74,0x6e,0x6f,0xef,0x1f,0xce,0x93,0x73,0x7f,0x78,0xfe,0x74,0xbb,
        0x9b,0xfb,0xc7,0xf3,0xa3,0x73,0x7a,0x9f,0xce,0x8d,0xcd,0xea,0x7f,0x3a,0x5c,0x52,
        0xd2,0x1c,0x51,0x49,0x50,0x5e,0x5e,0xc1,0x65,0x03,0x4d,0x71,0x22,0xa2,0x0e,0xe4,
        0xf5,0xae,0x43,0x53,0xf1,0xb3,0x07,0x2b,0x64,0x17,0x68,0xfe,0x22,0xbc,0xd6,0x63,
        0xf8,0xc2,0x69,0xa1,0x6f,0x38,0xb3,0x48,0x3e,0xee,0x0e,0xd5,0x3f,0x50,0x2b,0x22,
        0x2d,0x4d,0x9a,0xe9,0x66,0x9a,0x67,0xce,0x79,0x24,0x9e,0x05,0x5e,0xff,0x00,0x84,
        0xa2,0xee,0x30,0xf1,0x45,0x71,0x21,0x4c,0xf0,0x5b,0xe6,0xc0,0xfc,0x6a,0xb4,0x7a,
        0xe5,0xdc,0x13,0x89,0xa1,0xb8,0x90,0x3f,0x76,0xdd,0x9c,0xfd,0x6b,0x66,0xc3,0xc6,
        0xf7,0xb1,0x95,0xfb,0x4a,0x24,0xeb,0xf4,0xda,0x7f,0x4a,0xea,0xec,0x7c,0x43,0x65,
        0x79,0x66,0x6e,0x43,0x98,0xd5,0x78,0x60,0xdd,0x45,0x69,0xc7,0x22,0x4a,0x81,0xd1,
        0x83,0x2b,0x0c,0x82,0x3a,0x53,0xbb,0xd2,0xd1,0x45,0x3e,0x90,0xd1,0x4c,0x92,0x44,
        0x89,0x0b,0xc8,0xc1,0x54,0x72,0x49,0x38,0x02,0xb9,0x6d,0x73,0xc6,0x50,0x5a,0x86,
        0x8f,0x4f,0x2b,0x34,0x9f,0xdf,0x3f,0x74,0x7f,0x8d,0x70,0xfa,0x86,0xb3,0x79,0xa8,
        0x49,0xbe,0xe6,0x56,0x90,0xe3,0x8c,0xf1,0x8f,0xa0,0xaa,0x04,0x92,0x73,0xed,0xd6,
        0x98,0x84,0x9c,0x82,0x08,0xfa,0x8a,0x52,0x0e,0xdf,0x9b,0x39,0xc7,0x6a,0x01,0xc1,
        0xc1,0xa5,0xc7,0x39,0xa7,0x27,0xde,0x1c,0xfe,0x35,0x37,0x99,0x22,0x70,0x84,0xf2,
        0x7a,0x7a,0xd7,0x55,0xe1,0xcf,0x13,0xfd,0x8a,0x18,0xed,0xee,0x81,0x68,0x87,0x1b,
        0x81,0xc9,0x1c,0xd7,0x77,0x0c,0xa9,0x34,0x6b,0x24,0x6c,0x19,0x18,0x64,0x11,0xdc,
        0x54,0x94,0xb4,0x53,0xe9,0x0d,0x35,0x98,0x2a,0x92,0x48,0x00,0x57,0x0d,0xe2,0xcf,
        0x11,0x8b,0x82,0xd6,0x76,0x8d,0xfb,0xb5,0xce,0xe7,0xcf,0xde,0xfa,0x57,0x10,0xec,
        0x4b,0x1f,0x9b,0x23,0xb6,0x6a,0x12,0xc7,0xa8,0xe0,0x91,0xf9,0xd3,0xfe,0xf0,0xf6,
        0xef,0x49,0xef,0x9c,0x67,0x81,0x4e,0xed,0x9e,0xde,0xd4,0x80,0xe4,0xe7,0x1f,0x86,
        0x29,0x73,0xf3,0x01,0xc9,0xfa,0x53,0xd4,0xed,0x56,0x1d,0x0d,0x2a,0xc8,0x3a,0xb0,
        0xfd,0x29,0xe0,0xb0,0x60,0x41,0xf9,0x4d,0x77,0x9e,0x0e,0xd7,0x61,0x92,0x04,0xb0,
        0x95,0xb6,0xc8,0xbc,0x26,0x7f,0x88,0x7a,0x57,0x5a,0x29,0x45,0x2d,0x3e,0x83,0xd2,
        0xb9,0xdf,0x17,0xea,0xa2,0xc2,0xc7,0xca,0x5e,0x64,0x94,0x10,0x3d,0x87,0x15,0xe6,
        0x13,0xca,0x64,0x6c,0xf3,0x51,0x06,0xcf,0xe1,0x48,0xab,0xf7,0x48,0xcf,0x4a,0x7e,
        0xd2,0x07,0x20,0xfb,0x71,0x46,0xd3,0xd7,0x69,0xfc,0x05,0x4d,0x15,0xb3,0xbf,0x62,
        0x2a,0xd2,0xe9,0x72,0x75,0xd8,0xde,0xb4,0xf8,0xb4,0x79,0x09,0x04,0xa9,0xab,0xd1,
        0xe8,0x99,0x18,0x7c,0xe3,0xda,0xa9,0x5f,0x68,0xb2,0x43,0x97,0x8c,0x31,0x51,0xc9,
        0xac,0xe4,0xc2,0xfc,0xaf,0x91,0x83,0xc8,0x3d,0x2a,0xdd,0xb4,0xa6,0x0b,0x88,0xe4,
        0x8c,0x72,0x8c,0x18,0x57,0xaa,0x68,0xf7,0xdf,0xda,0x1a,0x7c,0x77,0x18,0x0a,0x5b,
        0xa8,0x07,0x38,0x35,0x7e,0x83,0x4f,0x34,0x86,0xbc,0xe3,0xc7,0x77,0x7e,0x6e,0xaa,
        0x63,0xce,0x44,0x48,0x17,0x19,0xee,0x79,0xff,0x00,0x0a,0xe4,0x58,0x74,0x1e,0xbd,
        0xea,0x6b,0x3b,0x63,0x2b,0xe4,0xfd,0xd1,0x5a,0x49,0x6a,0xbd,0x00,0xab,0x09,0x64,
        0x8f,0x8c,0x8a,0xb3,0x1d,0x8c,0x4b,0xc6,0xd1,0xcd,0x5d,0x86,0xd2,0x15,0x1c,0x20,
        0xab,0xab,0x12,0x6d,0xe1,0x45,0x3b,0xcb,0x52,0x06,0x45,0x28,0x40,0x3a,0x52,0x94,
        0x5c,0x1c,0x8e,0xbe,0xd5,0xcb,0xf8,0x8b,0x4e,0x11,0x11,0x3c,0x6b,0x85,0x6e,0x08,
        0xf4,0x35,0x8e,0x8d,0xb4,0x6d,0x39,0x1c,0xf7,0xae,0xdb,0xc0,0x97,0xa5,0x7c,0xcb,
        0x3c,0x65,0x4b,0x6f,0x07,0xd3,0x80,0x3f,0xa5,0x76,0xa0,0xd2,0xe6,0x9e,0x45,0x43,
        0x77,0x3a,0x5b,0x5b,0x49,0x34,0x87,0x0a,0x8a,0x58,0xd7,0x8f,0xea,0xf7,0x4f,0x7f,
        0x7d,0x2d,0xc3,0x8e,0x59,0x8b,0x7d,0x2a,0x8e,0x32,0x45,0x6d,0xda,0x5b,0x88,0x2d,
        0x97,0xfb,0xc7,0xad,0x4a,0x0f,0x39,0xab,0x90,0x01,0xe9,0x56,0xd1,0x01,0xc7,0x15,
        0x32,0x29,0xcf,0xd6,0xac,0x01,0x81,0x40,0xcd,0x4b,0x1a,0x9c,0x50,0xca,0x73,0xd2,
        0xaa,0xde,0xdb,0x8b,0x8b,0x77,0x8d,0x86,0x43,0x0c,0x57,0x13,0x2c,0x5e,0x59,0x78,
        0xd8,0x1f,0x94,0x91,0x5b,0x7e,0x11,0x9f,0xca,0xd6,0xe1,0xeb,0x87,0xca,0xf1,0xf4,
        0xaf,0x4b,0x5e,0x94,0xb5,0x2d,0x64,0x78,0xa0,0xb8,0xd0,0xae,0x76,0x0c,0x9d,0xbd,
        0xbe,0xb5,0xe4,0x93,0xb9,0x32,0x1e,0xb4,0xfb,0x38,0xfc,0xc9,0xd7,0x3e,0xb5,0xbd,
        0x20,0xc4,0x6b,0x51,0x01,0xf3,0x55,0xc8,0x3a,0x8a,0xbc,0x8c,0x05,0x4e,0x87,0x8e,
        0x95,0x20,0xa9,0x11,0x38,0xe6,0xad,0x46,0xa0,0x20,0xe2,0x99,0x22,0xe4,0xe4,0x54,
        0x12,0x8c,0x57,0x27,0xaf,0x40,0x12,0xe9,0x9c,0x0e,0x1f,0x9a,0xbb,0xe0,0xcb,0x65,
        0x9f,0x54,0x0d,0x92,0x0c,0x5f,0x30,0xc5,0x7a,0x3a,0xf4,0x14,0xa6,0xa4,0x35,0x5e,
        0xf6,0x05,0xb8,0xb3,0x96,0x17,0xfb,0xae,0x85,0x4f,0xe3,0x5e,0x33,0x79,0x16,0xcb,
        0x86,0x5c,0xfd,0xd2,0x47,0x27,0xd2,0xac,0xe9,0x89,0x99,0x46,0x79,0xad,0x67,0xfe,
        0x55,0x08,0x38,0x3c,0x55,0x98,0x4e,0x0e,0x4f,0x5a,0xb6,0x8f,0x93,0xc1,0xab,0x50,
        0xb5,0x4e,0x32,0x79,0xa9,0xd0,0x00,0xa3,0x26,0xa7,0x0c,0x36,0x8e,0x45,0x34,0xbf,
        0x18,0xa8,0x66,0xae,0x6b,0x5e,0x4c,0x9c,0x9f,0xc2,0xac,0xf8,0x11,0x5b,0xfb,0x56,
        0x5e,0x3e,0x51,0x1f,0x27,0xdf,0x35,0xe8,0x42,0x97,0xf0,0xa9,0x31,0x4d,0x71,0x95,
        0x22,0xbc,0x77,0x56,0xb6,0x31,0xea,0x33,0xc4,0xeb,0x82,0x92,0x15,0xc7,0xe3,0x52,
        0x69,0xaa,0x03,0xf4,0xe6,0xb4,0x25,0x1c,0x1c,0x55,0x60,0xd9,0x38,0xc5,0x4f,0x19,
        0x27,0x8e,0x6a,0xe4,0x23,0x91,0x57,0x61,0x4e,0x2a,0xc2,0x8e,0xd5,0x2c,0x63,0x24,
        0x62,0xac,0xf9,0x5c,0x53,0x19,0x48,0x15,0x13,0xf3,0xda,0xb0,0x75,0xe8,0xb3,0x16,
        0xf1,0xd0,0x75,0xab,0x5e,0x03,0x1f,0xe9,0x37,0x27,0x1d,0x94,0x7f,0x3a,0xee,0x96,
        0x9d,0x8a,0x92,0x90,0xf4,0xae,0x07,0xc7,0xb6,0x2b,0x0d,0xec,0x57,0x51,0xae,0x3c,
        0xe0,0x43,0x9f,0x71,0x8f,0xe9,0xfc,0xab,0x03,0x4d,0x19,0x63,0xed,0x57,0x66,0xe1,
        0x32,0x6a,0xbe,0x40,0x1c,0xd2,0xad,0xc2,0x8c,0x62,0xaf,0x5b,0x4c,0xad,0x5a,0x30,
        0x38,0x3f,0x95,0x58,0x89,0xb3,0xd7,0xbd,0x3a,0x39,0x02,0x0c,0x93,0xd2,0x89,0x75,
        0x58,0x61,0xe1,0xe4,0x51,0x55,0x1b,0x5d,0x80,0x92,0x00,0x63,0xee,0x2a,0x44,0xd4,
        0xa1,0x94,0x60,0xe5,0x73,0xdc,0xd5,0x7d,0x4a,0x35,0x96,0xce,0x50,0x39,0x18,0xaa,
        0xfe,0x0f,0x96,0x5b,0x79,0x27,0x75,0x00,0xa1,0x20,0x1c,0xd7,0xa0,0x2f,0x23,0x34,
        0xec,0x54,0x94,0xd6,0x38,0x04,0xfa,0x57,0x9f,0xf8,0x87,0x52,0x9a,0xfd,0x19,0x1b,
        0x63,0x44,0xa4,0x95,0xda,0x39,0x15,0x8b,0xa6,0x8c,0x33,0xd4,0xd7,0x72,0xec,0x4c,
        0x01,0x96,0xac,0xc1,0xe6,0x39,0x07,0x9f,0xc2,0xac,0x08,0x26,0xd9,0xbf,0x63,0x74,
        0xa8,0x16,0xe6,0x68,0x9b,0x90,0x54,0xe7,0xb5,0x69,0x5a,0x6a,0x7c,0x61,0xf8,0x35,
        0xb3,0x63,0x2f,0xda,0x53,0xe5,0xea,0x47,0x14,0xcb,0x85,0x96,0x33,0xc8,0x38,0xf5,
        0xac,0x1b,0xa5,0x8c,0xca,0xde,0x6d,0xc0,0x5e,0x79,0xef,0x53,0xdb,0x43,0x60,0x40,
        0x26,0xe8,0xe0,0xf7,0xce,0x2b,0x5a,0x2b,0x4b,0x79,0x50,0x18,0xa5,0xdc,0x31,0xc7,
        0x39,0xab,0x09,0x01,0x5b,0x73,0x1e,0x73,0xc6,0x39,0xa8,0xf4,0x88,0x19,0x2c,0x94,
        0x01,0x8c,0xcb,0xd2,0xbb,0x78,0xc7,0xca,0x29,0xe6,0xa4,0x34,0xd6,0x19,0x04,0x57,
        0x9d,0x6a,0x16,0x8d,0x65,0x79,0x3c,0x2c,0x38,0x56,0xe3,0x3d,0xc7,0x6a,0xa3,0x6d,
        0x0f,0x96,0xae,0xff,0x00,0xde,0x3c,0x55,0x79,0xce,0x5b,0x9a,0xaa,0xf3,0x49,0xbb,
        0x10,0x8c,0x7b,0xe2,0x89,0x92,0xee,0x52,0x82,0x39,0x1c,0x8e,0xe3,0x9a,0x8b,0x50,
        0xb6,0xf2,0x82,0xb0,0x0d,0x90,0x3e,0x62,0xde,0xb4,0xdb,0x30,0xe4,0x8c,0xf3,0x9a,
        0xeb,0xf4,0x80,0x23,0x55,0xc5,0x68,0xde,0x45,0xbd,0x36,0x8e,0xe2,0xb9,0xd9,0xb4,
        0xa6,0x69,0x18,0x6c,0x1f,0x37,0xb5,0x5b,0xd3,0x74,0x6f,0xb3,0x02,0x40,0x4c,0xbf,
        0x04,0x91,0xc8,0x1e,0xd5,0xa1,0x0e,0x8f,0x0c,0x27,0x74,0x43,0x61,0xf6,0xe2,0xa7,
        0x75,0x0a,0x98,0x1d,0xaa,0x7d,0x38,0x89,0x24,0x54,0xc0,0xe1,0x85,0x74,0x6a,0x38,
        0xa5,0xa9,0x29,0x2b,0x95,0xf1,0xad,0xb1,0x10,0x25,0xd2,0x0e,0x9f,0x2b,0x1f,0xe5,
        0x5c,0xb5,0xa2,0xb0,0xb6,0xc9,0xe7,0x24,0x9a,0x86,0x54,0x25,0xaa,0x5b,0x7b,0x75,
        0x3d,0x45,0x5d,0xd9,0xe5,0xa7,0x1c,0x56,0x56,0xa0,0x9b,0x8e,0xe2,0x6a,0x2b,0x64,
        0x0a,0x33,0xc5,0x6f,0x69,0x6c,0x4e,0x0d,0x6c,0x06,0x27,0x19,0xa7,0xaa,0x2b,0x8e,
        0x45,0x38,0x7c,0x84,0x00,0x72,0x2a,0x6d,0xc0,0xa9,0xe9,0x54,0xe6,0x04,0x66,0xa5,
        0xd2,0x57,0x17,0x41,0xbd,0x5a,0xba,0x31,0xd2,0x96,0xa4,0xa2,0xa8,0x6b,0x36,0xa2,
        0xef,0x4d,0x9a,0x22,0x32,0x4a,0xe4,0x7d,0x47,0x35,0xc2,0x34,0x5e,0x48,0x28,0x01,
        0xf9,0x6a,0x9c,0xa7,0x9a,0x92,0x27,0xc7,0x41,0x56,0x0b,0x65,0x79,0x15,0x99,0xa8,
        0x49,0x8e,0x05,0x45,0x6c,0x0b,0x46,0x0e,0x38,0x35,0xbb,0xa5,0x83,0xc7,0x6a,0xda,
        0xda,0xc0,0x00,0x47,0x38,0xa6,0x24,0x85,0x58,0xa9,0xa9,0x43,0x67,0x1c,0x54,0x84,
        0x9c,0x55,0x79,0x8e,0x41,0xab,0x3a,0x52,0xfe,0xf6,0x3f,0xa9,0xad,0xf1,0xd2,0x96,
        0xa4,0xa2,0x9a,0xe3,0x2b,0x5c,0x1e,0xa7,0x6e,0xf6,0xf7,0xb3,0x46,0xe3,0xa1,0xc8,
        0x3e,0xa2,0xb2,0x26,0xe0,0xe2,0x92,0x16,0x19,0xe4,0x54,0xcf,0x26,0x13,0xde,0xb1,
        0xae,0xdc,0xb4,0x84,0x9e,0xb4,0xf8,0x2e,0x56,0x28,0xb6,0xbf,0x51,0xd3,0x15,0xab,
        0xa6,0x5f,0x8c,0x81,0xd3,0xd8,0xd6,0xc4,0x77,0xce,0xf2,0xaa,0x24,0x4c,0xcb,0x8e,
        0x5b,0x3d,0x2a,0xcc,0x88,0x4e,0x1d,0x7a,0x8e,0xa2,0x9f,0x1b,0x03,0x8c,0xd4,0xdb,
        0xb2,0x3d,0xaa,0x07,0xe8,0x7d,0xeb,0x67,0x4d,0xb2,0x68,0x40,0x79,0x46,0x1b,0xa0,
        0x1e,0x95,0xa3,0x45,0x49,0x45,0x21,0xe9,0x59,0xfa,0xd5,0x94,0x77,0x36,0x32,0x12,
        0x80,0xc8,0x8a,0x4a,0xb6,0x39,0xe3,0x9a,0xf3,0xcb,0xd4,0xfd,0xe1,0xf4,0xcd,0x45,
        0x08,0xc3,0x63,0x35,0x63,0x03,0x93,0xda,0xb3,0xae,0x10,0x34,0x99,0xc5,0x42,0xd0,
        0x16,0xfb,0xa3,0x35,0xa0,0x60,0xf2,0xad,0xad,0x9b,0x67,0xcd,0xbf,0x9a,0xdf,0x80,
        0x1f,0x2c,0x3e,0x31,0x9a,0xb0,0x92,0x76,0xcf,0x34,0xe2,0x0e,0xef,0x6a,0x7a,0xb7,
        0x6a,0x58,0xb0,0xf7,0x31,0x2f,0x62,0xe3,0xf9,0xd7,0x4c,0x29,0x68,0xa9,0x28,0xa2,
        0x91,0x86,0x54,0x83,0x5e,0x71,0xac,0xc1,0xe4,0x5d,0x48,0x98,0xfb,0xac,0x46,0x6b,
        0x35,0x0e,0xd6,0xfa,0x55,0x98,0x81,0x94,0x63,0xa5,0x50,0xbf,0x63,0x0c,0x81,0x23,
        0x5c,0x9c,0x75,0x27,0x8a,0x2d,0x3c,0xd7,0x61,0xf3,0x28,0x1e,0xc3,0x35,0xad,0x14,
        0x72,0x91,0x83,0x20,0x23,0xd0,0x8a,0xbb,0x6f,0x14,0xac,0xbc,0x4d,0x8f,0x6c,0x54,
        0xa6,0xd6,0x70,0xa4,0xf9,0xab,0x9e,0xdc,0x53,0x2d,0xee,0x25,0x2d,0xe5,0xcc,0x9b,
        0x58,0x1c,0x67,0xb5,0x5c,0x1c,0x55,0xad,0x2d,0x0c,0xba,0x82,0x7a,0x20,0xdc,0x6b,
        0xa1,0xc5,0x18,0xa5,0xc5,0x3e,0x8a,0x28,0xae,0x17,0xc4,0x80,0x7f,0x6a,0x4e,0x98,
        0xf4,0x23,0xf2,0xae,0x6e,0x53,0xb5,0xbd,0xe9,0xf0,0xdc,0x79,0x6a,0x79,0xa8,0x1e,
        0x60,0xec,0x4b,0x0a,0xb5,0x14,0x71,0x85,0xdd,0xd2,0x9f,0x1c,0x25,0xe4,0x3e,0x59,
        0x20,0x7a,0xe6,0xb4,0xec,0x2d,0xda,0x2e,0xa4,0x90,0x4d,0x69,0x6f,0x00,0x73,0x50,
        0x4a,0xeb,0xb8,0x71,0x4f,0x57,0x3b,0x79,0xad,0xfd,0x12,0xdc,0xc7,0x6f,0xe6,0xb8,
        0xc3,0x4b,0xc8,0xfa,0x76,0xad,0x2a,0x29,0x4d,0x3a,0x8a,0x28,0xae,0x13,0xc5,0x87,
        0x6e,0xad,0x2f,0xd0,0x7f,0x21,0x5c,0xe4,0xc3,0x77,0x3d,0xea,0xb4,0x84,0x80,0x00,
        0xe2,0xa3,0x1c,0x74,0xab,0x91,0xc8,0x4a,0x81,0xd8,0xd6,0x9d,0x9a,0xf1,0x5a,0xd1,
        0xa9,0x28,0x0f,0xa5,0x2b,0x70,0x2a,0xbc,0xd2,0x63,0xfc,0x6a,0xe6,0x93,0x00,0xbd,
        0xbc,0x58,0xcf,0xdc,0x03,0x73,0x7b,0x8f,0x4a,0xeb,0x40,0x00,0x01,0x4b,0x4b,0x8a,
        0x52,0x29,0x68,0xa2,0xa8,0xdf,0xeb,0x16,0x36,0x1c,0x4f,0x3a,0x87,0xec,0x8b,0xcb,
        0x7e,0x55,0xc3,0xeb,0xf7,0xa9,0x7d,0x7c,0xf3,0xc6,0x0a,0xab,0x63,0x01,0xba,0xf1,
        0x58,0x8e,0xc7,0xad,0x46,0xdf,0x31,0xeb,0x8a,0x61,0x4e,0xc3,0xb5,0x3e,0x16,0x28,
        0x70,0xdd,0xab,0x5e,0xde,0x55,0x2a,0x0a,0xd5,0xd8,0xef,0x55,0x17,0x19,0xc7,0xd6,
        0xa3,0x6b,0xe5,0x3c,0x2b,0x64,0xf6,0x02,0x9d,0x14,0x0f,0x33,0x6e,0x90,0x91,0xed,
        0x5d,0x17,0x87,0xa2,0x0b,0x3c,0x8c,0x06,0x36,0xa8,0x1f,0x9f,0xff,0x00,0xaa,0xb7,
        0xf1,0x46,0x3f,0x9d,0x2d,0x2d,0x14,0xc9,0x65,0x8e,0x18,0xcb,0xca,0xe1,0x54,0x75,
        0x24,0xd7,0x27,0xe2,0x5f,0x14,0x14,0x8c,0xc1,0x60,0xc4,0x6e,0x1c,0xc9,0xd0,0xfe,
        0x15,0xc8,0x09,0x18,0xb6,0xf7,0x25,0x9d,0xba,0x92,0x6a,0x47,0x62,0xc3,0xf0,0xaa,
        0xce,0x0d,0x46,0x43,0x02,0x09,0xa5,0x0d,0x83,0xeb,0x4b,0x8d,0xdd,0x6a,0x68,0x97,
        0x8e,0x37,0x7b,0x55,0x88,0xe0,0x2e,0xc3,0x20,0xe3,0xeb,0x5a,0x56,0xd6,0xea,0x84,
        0x10,0x2a,0xfc,0x49,0xc5,0x58,0xb5,0xd5,0x93,0x4e,0xbd,0x10,0x90,0x09,0x98,0x64,
        0x03,0xed,0x5d,0x05,0xb6,0xa7,0x04,0xf8,0xc9,0xd8,0x7d,0x1a,0xad,0x87,0x56,0xfb,
        0xa4,0x1f,0xa5,0x28,0x34,0xb5,0x85,0x7d,0xe2,0x35,0x50,0x56,0xcd,0x37,0x7f,0xb6,
        0xdd,0x3f,0x01,0x5c,0xe6,0xa1,0x7b,0x3d,0xd7,0x32,0x3b,0x31,0x1e,0xa6,0xb1,0xef,
        0x54,0xc8,0xa1,0xfa,0xe3,0xad,0x54,0x1d,0x45,0x4a,0x32,0x47,0xad,0x28,0x8c,0xb0,
        0xe4,0x54,0x9f,0x66,0x27,0xb5,0x35,0xad,0x18,0x1e,0x99,0xa7,0x25,0xb1,0xc8,0xc8,
        0xab,0x91,0x41,0xc7,0xdd,0xab,0x31,0xc4,0x46,0x30,0x2a,0xe4,0x30,0xb1,0x23,0x3d,
        0x2a,0xd8,0x8f,0x0b,0x59,0x1a,0xcc,0x67,0x02,0x74,0x1f,0x3c,0x3c,0xfd,0x47,0x7a,
        0xd5,0xb7,0x93,0x7c,0x28,0xeb,0xfc,0x40,0x11,0x53,0xa4,0xa5,0x94,0x8c,0x91,0xcf,
        0x23,0x35,0xa1,0x6f,0xaa,0xb2,0x00,0x25,0x5d,0xc0,0x77,0xcf,0x35,0x75,0x75,0x1b,
        0x72,0xb9,0xdc,0x47,0xb1,0x15,0xca,0x3a,0x0e,0x40,0xe4,0x8f,0x4a,0xab,0x02,0x79,
        0x83,0x9e,0xf5,0x11,0xb6,0x01,0xd9,0x18,0x7c,0xad,0x54,0xa7,0xb0,0xdb,0xd0,0x73,
        0x55,0x52,0x22,0x1b,0x04,0x74,0xab,0x70,0xa5,0x5b,0x11,0xf1,0xd2,0x9f,0xe4,0x64,
        0x76,0xa7,0xac,0x38,0xea,0x2a,0xc4,0x51,0xae,0x2a,0xca,0x44,0xbe,0x95,0x3a,0xa7,
        0x1d,0x30,0x28,0x71,0xc1,0xaa,0x57,0x11,0x79,0x8a,0xea,0x47,0xde,0x52,0x29,0x34,
        0xd3,0xbb,0x4d,0x84,0xfa,0x0c,0x7f,0x4a,0xb0,0x4e,0xd9,0x33,0xd9,0xa9,0x09,0x23,
        0xe9,0x4f,0x59,0x06,0x28,0x8e,0xce,0xeb,0x39,0x36,0xd2,0x8c,0xff,0x00,0xb0,0x6a,
        0xbd,0xbd,0x85,0xdc,0x73,0x3a,0xfd,0x96,0x6d,0xb9,0xe0,0xf9,0x67,0x15,0x3c,0xba,
        0x7d,0xcb,0x0c,0x8b,0x69,0x73,0xfe,0xe1,0xa8,0xdf,0x4d,0xb9,0x74,0xff,0x00,0x8f,
        0x69,0x41,0xff,0x00,0xae,0x66,0xa8,0x49,0xa3,0xde,0x6f,0xc8,0xb4,0x9c,0xff,0x00,
        0xdb,0x33,0xfe,0x14,0xab,0xa5,0xde,0x81,0xff,0x00,0x1e,0x93,0xff,0x00,0xdf,0xb3,
        0xfe,0x15,0x3c,0x7a,0x7d,0xe6,0x39,0xb4,0x9c,0x7f,0xdb,0x33,0xfe,0x15,0x38,0xb0,
        0xba,0xc7,0xfc,0x7a,0xcd,0x9f,0xfa,0xe6,0x69,0xe2,0xc6,0xe7,0xbd,0xb4,0xdf,0xf7,
        0xc1,0xa9,0xa3,0xb2,0x9c,0x75,0xb6,0x93,0xfe,0xf8,0x35,0x38,0xb5,0x98,0x63,0xf7,
        0x12,0x7f,0xdf,0x06,0x94,0xdb,0x5c,0x7f,0xcf,0x19,0x3f,0xef,0x93,0x4d,0x6b,0x6b,
        0x83,0xff,0x00,0x2c,0x24,0xff,0x00,0xbe,0x0d,0x31,0xec,0xa7,0x11,0xb1,0x10,0x48,
        0x4e,0x0f,0x1b,0x0d,0x51,0xd2,0xec,0x6f,0x23,0xd3,0x15,0x1e,0xd6,0x65,0x61,0x9e,
        0x0c,0x64,0x1e,0xbf,0x4a,0xb6,0xd6,0x77,0x25,0x07,0xee,0x25,0xcf,0xfb,0x86,0x81,
        0x69,0x72,0xcb,0xcd,0xbc,0xbf,0xf7,0xc1,0xa8,0x8d,0x95,0xd0,0x24,0x7d,0x9a,0x53,
        0xff,0x00,0x00,0x35,0xff,0xd9,
    };
    poEmulationCard->PutTransparentEF("3F00DF014035",
        CByteArray(tuc3F00DF014035, (unsigned long) sizeof(tuc3F00DF014035)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(PuK#7 ID) (CA role ID)
    unsigned char tuc3F00DF014038[] = {
        0x04,0x87,0x46,0xe9,0x09,0xf6,0x51,0xcf,0x9d,0x65,0x2c,0x59,0x18,0xf6,0xa6,0x3b,
        0xa2,0xd8,0x34,0xaa,
    };
    poEmulationCard->PutTransparentEF("3F00DF014038",
        CByteArray(tuc3F00DF014038, (unsigned long) sizeof(tuc3F00DF014038)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Preferences)
    unsigned char tuc3F00DF014039[] = {
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF014039",
        CByteArray(tuc3F00DF014039, (unsigned long) sizeof(tuc3F00DF014039)), AC_ALWAYS, 0, AC_PIN, 1);

	m_bBeidV1Test2Initialized = true;

	return poEmulationCard;
}

/////////////////////////////////////////////////////////////////////////////////
// Applet V2 test card

static CEmulationBeidCard *m_BeidV2Test1 = NULL;
static bool m_bBeidV2Test1Initialized = false;

CEmulationCard * CEmulationCardFactory::MakeBeidV2Test1()
{
	if(!m_bCardInitialized)
		Init();

	CEmulationBeidCard *poEmulationCard = m_BeidV2Test1;

	if (m_bBeidV2Test1Initialized)
		return poEmulationCard; // already intialized

	unsigned char tucATR[] =
		{0x3B,0x98,0x95,0x40,0xFF,0xD0,0x00,0x48,0x01,0x01,0xAD,0x13,0x21};
	poEmulationCard->SetATR(CByteArray(tucATR, sizeof(tucATR)));

	// MF

	poEmulationCard->PutPin("3F00",
		0x85, "1234", 4, 12, 8, PIN_ENC_GP, 3, 0xFF,
		"12345678", 0);

	poEmulationCard->PutPin("3F00",
		0x86, "1234", 4, 12, 8, PIN_ENC_GP, 3, 0xFF,
		"12345678", 0);

	// Belpic DF
	unsigned char tucBelpicAID[] = {0xA0,0x00,0x00,0x01,0x77,0x50,0x4B,0x43,0x53,0x2D,0x31,0x35};
	poEmulationCard->PutDF("3F00DF00", CByteArray(tucBelpicAID, sizeof(tucBelpicAID)));

	// ID DF
	unsigned char tucIDAID[] = {0xA0,0x00,0x00,0x01,0x77,0x49,0x64,0x46,0x69,0x6C,0x65,0x73};
	poEmulationCard->PutDF("3F00DF01", CByteArray(tucIDAID, sizeof(tucIDAID)));

	// EF(DIR)
    unsigned char tuc3F002F00[] = {
        0x61,0x23,0x4f,0x0c,0xa0,0x00,0x00,0x01,0x77,0x50,0x4b,0x43,0x53,0x2d,0x31,0x35,
        0x50,0x06,0x42,0x45,0x4c,0x50,0x49,0x43,0x51,0x04,0x3f,0x00,0xdf,0x00,0x73,0x05,
        0x06,0x03,0x60,0x38,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F002F00",
        CByteArray(tuc3F002F00, (unsigned long) sizeof(tuc3F002F00)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ODF)
    unsigned char tuc3F00DF005031[] = {
        0xa0,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x35,0xa4,0x0a,0x30,0x08,
        0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x37,0xa8,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,
        0xdf,0x00,0x50,0x34,
    };
    poEmulationCard->PutTransparentEF("3F00DF005031",
        CByteArray(tuc3F00DF005031, (unsigned long) sizeof(tuc3F00DF005031)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(TokenInfo)
    unsigned char tuc3F00DF005032[] = {
        0x30,0x27,0x02,0x01,0x00,0x04,0x10,0x53,0x4c,0x49,0x4e,0x33,0x66,0x00,0x38,0x7b,
        0xff,0x24,0x72,0xb0,0x18,0x16,0x39,0x80,0x06,0x42,0x45,0x4c,0x50,0x49,0x43,0x03,
        0x02,0x04,0x30,0x9e,0x04,0x03,0x02,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005032",
        CByteArray(tuc3F00DF005032, (unsigned long) sizeof(tuc3F00DF005032)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(AODF)
    unsigned char tuc3F00DF005034[] = {
        0x30,0x39,0x30,0x14,0x0c,0x0e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,
        0x74,0x69,0x6f,0x6e,0x03,0x02,0x06,0xc0,0x30,0x03,0x04,0x01,0x01,0xa1,0x1c,0x30,
        0x1a,0x03,0x02,0x02,0x0c,0x0a,0x01,0x00,0x02,0x01,0x04,0x02,0x01,0x08,0x80,0x02,
        0x00,0x85,0x04,0x01,0xff,0x30,0x04,0x04,0x02,0x3f,0x00,0x30,0x34,0x30,0x0f,0x0c,
        0x09,0x53,0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x03,0x02,0x06,0xc0,0x30,0x03,
        0x04,0x01,0x02,0xa1,0x1c,0x30,0x1a,0x03,0x02,0x02,0x0c,0x0a,0x01,0x00,0x02,0x01,
        0x04,0x02,0x01,0x08,0x80,0x02,0x00,0x86,0x04,0x01,0xff,0x30,0x04,0x04,0x02,0x3f,
        0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005034",
        CByteArray(tuc3F00DF005034, (unsigned long) sizeof(tuc3F00DF005034)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(PrKDF)
    unsigned char tuc3F00DF005035[] = {
        0x30,0x3a,0x30,0x17,0x0c,0x0e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,
        0x74,0x69,0x6f,0x6e,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x0f,0x04,0x01,0x02,
        0x03,0x02,0x05,0x20,0x03,0x02,0x03,0xb8,0x02,0x02,0x00,0x8a,0xa1,0x0e,0x30,0x0c,
        0x30,0x06,0x04,0x04,0x3f,0x00,0xdf,0x00,0x02,0x02,0x04,0x00,0x30,0x39,0x30,0x15,
        0x0c,0x09,0x53,0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x03,0x02,0x06,0xc0,0x04,
        0x01,0x02,0x02,0x01,0x01,0x30,0x10,0x04,0x01,0x03,0x03,0x03,0x06,0x00,0x40,0x03,
        0x02,0x03,0xb8,0x02,0x02,0x00,0x89,0xa1,0x0e,0x30,0x0c,0x30,0x06,0x04,0x04,0x3f,
        0x00,0xdf,0x00,0x02,0x02,0x04,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005035",
        CByteArray(tuc3F00DF005035, (unsigned long) sizeof(tuc3F00DF005035)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(CDF)
    unsigned char tuc3F00DF005037[] = {
        0x30,0x2c,0x30,0x17,0x0c,0x0e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,
        0x74,0x69,0x6f,0x6e,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x03,0x04,0x01,0x02,
        0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x38,0x30,0x27,
        0x30,0x12,0x0c,0x09,0x53,0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x03,0x02,0x06,
        0xc0,0x04,0x01,0x01,0x30,0x03,0x04,0x01,0x03,0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,
        0x06,0x3f,0x00,0xdf,0x00,0x50,0x39,0x30,0x23,0x30,0x0b,0x0c,0x02,0x43,0x41,0x03,
        0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x06,0x04,0x01,0x04,0x01,0x01,0xff,0xa1,0x0c,
        0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x3a,0x30,0x25,0x30,0x0d,
        0x0c,0x04,0x52,0x6f,0x6f,0x74,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x06,0x04,
        0x01,0x06,0x01,0x01,0xff,0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,
        0x00,0x50,0x3b,
    };
    poEmulationCard->PutTransparentEF("3F00DF005037",
        CByteArray(tuc3F00DF005037, (unsigned long) sizeof(tuc3F00DF005037)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#2) (authentication)
    unsigned char tuc3F00DF005038[] = {
        0x30,0x82,0x03,0xf6,0x30,0x82,0x02,0xde,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
        0x00,0x00,0x00,0x00,0x01,0x15,0xa8,0xd3,0x5d,0x0f,0x00,0x00,0xce,0xc0,0x03,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x37,
        0x31,0x1a,0x30,0x18,0x06,0x03,0x55,0x04,0x06,0x13,0x11,0x42,0x45,0x20,0x20,0x20,
        0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x31,0x19,0x30,0x17,
        0x06,0x03,0x55,0x04,0x03,0x13,0x10,0x5a,0x45,0x54,0x45,0x53,0x20,0x43,0x69,0x74,
        0x69,0x7a,0x65,0x6e,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x37,0x31,0x30,0x31,
        0x35,0x31,0x32,0x33,0x39,0x32,0x35,0x5a,0x17,0x0d,0x31,0x32,0x31,0x30,0x31,0x35,
        0x31,0x32,0x33,0x39,0x32,0x35,0x5a,0x30,0x6c,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,
        0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x26,0x30,0x24,0x06,0x03,0x55,0x04,0x03,0x13,
        0x1d,0x67,0x6e,0x61,0x6d,0x65,0x31,0x20,0x6e,0x61,0x6d,0x65,0x31,0x20,0x28,0x41,
        0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x29,0x31,0x0e,
        0x30,0x0c,0x06,0x03,0x55,0x04,0x04,0x13,0x05,0x6e,0x61,0x6d,0x65,0x31,0x31,0x0f,
        0x30,0x0d,0x06,0x03,0x55,0x04,0x2a,0x13,0x06,0x67,0x6e,0x61,0x6d,0x65,0x31,0x31,
        0x14,0x30,0x12,0x06,0x03,0x55,0x04,0x05,0x13,0x0b,0x30,0x30,0x30,0x30,0x30,0x30,
        0x30,0x30,0x30,0x30,0x31,0x30,0x81,0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,
        0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,
        0x81,0x00,0x9f,0x6a,0x13,0x30,0x30,0x18,0xb1,0x1d,0x6e,0xa3,0x84,0x0e,0x69,0x23,
        0x43,0x93,0xe6,0x16,0x07,0xdc,0x0f,0x50,0xbd,0x59,0x0e,0x10,0x36,0x17,0xf2,0xb0,
        0x24,0x93,0x5c,0x10,0x2b,0x9d,0xd2,0x7c,0x40,0x55,0xfe,0x15,0xe7,0x8b,0xd9,0x5b,
        0x0d,0xfb,0x73,0x5d,0x52,0xd5,0x69,0xb2,0x16,0xc8,0x29,0xde,0x41,0xd0,0x60,0x8f,
        0xbf,0x75,0x1b,0x25,0x1f,0xf8,0x2e,0x5f,0xe9,0x2d,0xb6,0x40,0xe9,0x63,0xe6,0xe7,
        0x41,0x99,0x09,0x90,0xbf,0xac,0xd6,0x58,0x60,0xad,0xb3,0xe0,0xe7,0x6e,0x20,0xbf,
        0x6b,0xd3,0xde,0x3c,0x2c,0xbb,0x70,0x20,0x40,0xd1,0x3b,0x8a,0xe4,0x68,0xde,0x71,
        0x0f,0xd3,0x44,0xd2,0x98,0x62,0x02,0xfb,0xe3,0x3f,0xc4,0xb9,0x86,0xd7,0xa4,0x50,
        0x46,0x5d,0x02,0x03,0x01,0x00,0x01,0xa3,0x82,0x01,0x4b,0x30,0x82,0x01,0x47,0x30,
        0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x07,0x80,0x30,
        0x45,0x06,0x03,0x55,0x1d,0x20,0x04,0x3e,0x30,0x3c,0x30,0x3a,0x06,0x07,0x60,0x38,
        0x01,0x01,0x01,0x02,0x02,0x30,0x2f,0x30,0x2d,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,
        0x07,0x02,0x01,0x16,0x21,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,
        0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,
        0x2e,0x62,0x65,0x20,0x20,0x20,0x30,0x3c,0x06,0x03,0x55,0x1d,0x1f,0x04,0x35,0x30,
        0x33,0x30,0x31,0xa0,0x2f,0xa0,0x2d,0x86,0x2b,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,
        0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,
        0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,
        0x2e,0x63,0x72,0x6c,0x30,0x7c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01,
        0x04,0x70,0x30,0x6e,0x30,0x3f,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02,
        0x86,0x33,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x5a,0x65,0x74,
        0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,0x65,0x2f,0x64,0x75,0x6d,0x6d,0x79,
        0x2f,0x63,0x65,0x72,0x74,0x69,0x66,0x63,0x61,0x74,0x65,0x73,0x2f,0x74,0x65,0x73,
        0x74,0x2e,0x63,0x72,0x74,0x30,0x2b,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,
        0x01,0x86,0x1f,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x6f,0x63,0x73,0x70,0x2e,0x5a,
        0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,0x65,0x2f,0x64,0x75,0x6d,
        0x6d,0x79,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,
        0x04,0x03,0x02,0x05,0xa0,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,
        0x80,0x14,0xed,0x2b,0xa5,0x67,0x16,0xb1,0xed,0x70,0xe1,0x5d,0x55,0x7a,0x11,0x12,
        0x16,0x1c,0x97,0x41,0x56,0x96,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,
        0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x38,0x44,0x37,0x57,0xfb,0x61,
        0x7c,0xef,0xfd,0x5e,0x47,0x87,0x6f,0x94,0xd9,0x2f,0x1a,0xb1,0x92,0xda,0x2d,0xa4,
        0xd5,0xbb,0x67,0xae,0xe1,0xc7,0x6e,0x62,0x69,0x3e,0x5f,0xeb,0x74,0x2a,0x07,0x79,
        0x43,0xde,0xbd,0xf9,0xf4,0x15,0xa0,0xf6,0xb9,0x16,0xd5,0xd6,0x45,0x9f,0x0a,0x89,
        0x8f,0x4a,0x0f,0x3d,0xd2,0x33,0xbc,0x3f,0x1d,0xc7,0xd1,0xb4,0x1c,0x9a,0x0f,0xac,
        0x53,0x70,0x64,0xb4,0x34,0xb4,0xac,0x76,0x98,0xce,0x10,0x8a,0x73,0x28,0x3e,0xa7,
        0xcc,0x00,0x5b,0x68,0x0e,0x53,0x3c,0x5f,0xb0,0x0e,0xa0,0xb1,0x42,0x39,0x28,0xec,
        0x76,0xd9,0x81,0x3f,0xd8,0x0c,0x68,0xf3,0xb1,0x44,0x75,0x40,0xfe,0x53,0x0c,0x1a,
        0x12,0xd2,0x07,0xad,0xa0,0x3e,0xe4,0x7b,0xaf,0x99,0x39,0x47,0x4e,0x36,0x06,0x6f,
        0x4e,0xcd,0x22,0x9c,0x67,0x72,0xe3,0x88,0xd8,0x27,0x17,0xe7,0xa3,0xf9,0x80,0x50,
        0x63,0x06,0xc5,0x51,0x6c,0x9b,0xf7,0x27,0xd6,0x53,0x09,0x62,0x2c,0x32,0x2f,0x08,
        0x11,0x55,0xbe,0x2d,0x61,0x2e,0x86,0x6d,0x6c,0xfb,0x45,0xa3,0x99,0x01,0x10,0xb9,
        0x97,0x58,0x69,0xd0,0xcd,0xf9,0x6d,0x1b,0x62,0xb8,0xc2,0x10,0x9e,0xff,0xde,0xee,
        0xc7,0xc7,0x66,0xfb,0xfe,0x69,0xca,0xd8,0x7b,0x61,0xff,0x79,0x60,0x60,0xa3,0xa6,
        0x8b,0xa4,0x32,0x24,0xf1,0xd4,0x6c,0xb8,0x0f,0x74,0x42,0x86,0x3e,0x66,0x58,0xdd,
        0x14,0x49,0x2b,0xbb,0x0b,0x15,0xb8,0x50,0xc5,0x18,0x50,0x3c,0xbe,0xbe,0xc3,0x20,
        0xd8,0x58,0xed,0x45,0x2b,0x88,0xfe,0xd5,0xa9,0xab,
	};
    poEmulationCard->PutTransparentEF("3F00DF005038",
        CByteArray(tuc3F00DF005038, (unsigned long) sizeof(tuc3F00DF005038)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#3) (non-repudiation)
    unsigned char tuc3F00DF005039[] = {
        0x30,0x82,0x04,0x0c,0x30,0x82,0x02,0xf4,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
        0x00,0x00,0x00,0x00,0x01,0x15,0xa8,0xd3,0x5e,0x67,0x00,0x00,0xce,0xc0,0x04,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x37,
        0x31,0x1a,0x30,0x18,0x06,0x03,0x55,0x04,0x06,0x13,0x11,0x42,0x45,0x20,0x20,0x20,
        0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x31,0x19,0x30,0x17,
        0x06,0x03,0x55,0x04,0x03,0x13,0x10,0x5a,0x45,0x54,0x45,0x53,0x20,0x43,0x69,0x74,
        0x69,0x7a,0x65,0x6e,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x37,0x31,0x30,0x31,
        0x35,0x31,0x32,0x33,0x39,0x32,0x35,0x5a,0x17,0x0d,0x31,0x32,0x31,0x30,0x31,0x35,
        0x31,0x32,0x33,0x39,0x32,0x35,0x5a,0x30,0x67,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,
        0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x21,0x30,0x1f,0x06,0x03,0x55,0x04,0x03,0x13,
        0x18,0x67,0x6e,0x61,0x6d,0x65,0x31,0x20,0x6e,0x61,0x6d,0x65,0x31,0x20,0x28,0x53,
        0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x29,0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,
        0x04,0x04,0x13,0x05,0x6e,0x61,0x6d,0x65,0x31,0x31,0x0f,0x30,0x0d,0x06,0x03,0x55,
        0x04,0x2a,0x13,0x06,0x67,0x6e,0x61,0x6d,0x65,0x31,0x31,0x14,0x30,0x12,0x06,0x03,
        0x55,0x04,0x05,0x13,0x0b,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,
        0x30,0x81,0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,
        0x05,0x00,0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0xa9,0xd9,0x08,
        0x25,0xac,0xeb,0x70,0x63,0xbc,0xeb,0x01,0x53,0x50,0x86,0xb9,0x09,0x50,0xc1,0x50,
        0xba,0xbd,0xca,0x63,0xdc,0xb0,0x27,0x0d,0x9a,0x6a,0x5e,0xee,0x22,0x95,0xe9,0x5c,
        0x65,0x65,0x58,0x6b,0x10,0x2e,0xcb,0xba,0x09,0x36,0xd7,0xc4,0xc1,0x48,0x10,0x88,
        0xd3,0x3f,0x7d,0x3d,0x93,0xf4,0x26,0x6e,0x2f,0x2e,0xf5,0x5c,0xe4,0x00,0x9c,0x72,
        0xb5,0x00,0xb4,0x6f,0xc4,0xf1,0xf3,0xf5,0x45,0x04,0x27,0xcd,0x66,0xd5,0xce,0x84,
        0xfd,0x89,0x77,0x98,0x61,0x87,0x91,0x70,0x48,0x04,0x42,0xd5,0xd7,0x01,0xb7,0x74,
        0x76,0x73,0x06,0x82,0xc9,0x13,0x98,0x5a,0xfb,0x82,0x59,0xe0,0x05,0x5d,0xa2,0x1a,
        0x98,0x09,0x4d,0x89,0xd2,0x3b,0x2f,0xf6,0x51,0xb1,0xbe,0x57,0xe7,0x02,0x03,0x01,
        0x00,0x01,0xa3,0x82,0x01,0x66,0x30,0x82,0x01,0x62,0x30,0x0e,0x06,0x03,0x55,0x1d,
        0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x06,0x40,0x30,0x46,0x06,0x03,0x55,0x1d,
        0x20,0x04,0x3f,0x30,0x3d,0x30,0x3b,0x06,0x07,0x60,0x38,0x01,0x01,0x01,0x02,0x01,
        0x30,0x30,0x30,0x2e,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x22,
        0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,
        0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,0x20,0x20,
        0x20,0x20,0x30,0x3c,0x06,0x03,0x55,0x1d,0x1f,0x04,0x35,0x30,0x33,0x30,0x31,0xa0,
        0x2f,0xa0,0x2d,0x86,0x2b,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,
        0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,
        0x67,0x69,0x75,0x6d,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,0x6c,
        0x30,0x18,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x03,0x04,0x0c,0x30,0x0a,
        0x30,0x08,0x06,0x06,0x04,0x00,0x8e,0x46,0x01,0x01,0x30,0x7c,0x06,0x08,0x2b,0x06,
        0x01,0x05,0x05,0x07,0x01,0x01,0x04,0x70,0x30,0x6e,0x30,0x3f,0x06,0x08,0x2b,0x06,
        0x01,0x05,0x05,0x07,0x30,0x02,0x86,0x33,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,
        0x77,0x77,0x2e,0x5a,0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,0x65,
        0x2f,0x64,0x75,0x6d,0x6d,0x79,0x2f,0x63,0x65,0x72,0x74,0x69,0x66,0x63,0x61,0x74,
        0x65,0x73,0x2f,0x74,0x65,0x73,0x74,0x2e,0x63,0x72,0x74,0x30,0x2b,0x06,0x08,0x2b,
        0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x86,0x1f,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,
        0x6f,0x63,0x73,0x70,0x2e,0x5a,0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,
        0x62,0x65,0x2f,0x64,0x75,0x6d,0x6d,0x79,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,
        0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x05,0xa0,0x30,0x1f,0x06,0x03,0x55,
        0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0xed,0x2b,0xa5,0x67,0x16,0xb1,0xed,0x70,
        0xe1,0x5d,0x55,0x7a,0x11,0x12,0x16,0x1c,0x97,0x41,0x56,0x96,0x30,0x0d,0x06,0x09,
        0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,
        0x5e,0xda,0x3e,0x91,0x03,0x1c,0xf0,0x27,0x9a,0x3e,0x74,0x1c,0x9c,0xdc,0x9e,0xfe,
        0x2e,0x88,0x40,0x6c,0x71,0x6c,0x7a,0xde,0xe2,0x1a,0x78,0x21,0x43,0x79,0xa4,0x8b,
        0x7f,0x64,0x0c,0x86,0xed,0xe6,0x20,0xb9,0x5d,0x0f,0x37,0x08,0xb6,0xbd,0x8f,0xf9,
        0x1f,0xc5,0x7c,0x16,0xc5,0x9e,0xf0,0x93,0x5b,0x36,0x02,0x83,0xee,0x37,0xa5,0x17,
        0x86,0x23,0x76,0xf5,0x50,0xf8,0xe6,0x3c,0xfa,0xc6,0xb9,0x67,0xb8,0xae,0x08,0xe9,
        0x40,0x22,0x3d,0x4a,0xf2,0xfd,0x89,0x94,0xcb,0xf3,0xa2,0x5c,0xa1,0x8c,0x48,0x49,
        0xc8,0x62,0x60,0x55,0x50,0x77,0x53,0x20,0xb2,0x27,0x23,0x83,0x3a,0x9f,0xb8,0xa9,
        0x26,0xdf,0xd9,0x5b,0xd4,0x6d,0x09,0xbe,0x2e,0xc7,0x46,0xd9,0x55,0x71,0x7e,0x85,
        0x08,0xcf,0xf3,0x88,0x52,0xcc,0xb2,0x08,0xde,0x00,0x8d,0x06,0xa9,0xd6,0x68,0x15,
        0xb1,0x17,0x39,0x13,0xeb,0xe7,0xf6,0xe0,0x76,0x5d,0x8f,0x8d,0x0b,0x5e,0xd1,0xcf,
        0x1d,0x26,0x22,0x61,0x69,0xba,0x34,0x47,0x62,0x54,0x4c,0x94,0x16,0xfe,0x30,0x08,
        0x6d,0xcf,0x65,0x64,0xad,0x4b,0x7d,0x85,0xa9,0xf8,0x60,0x34,0x43,0x62,0x99,0x69,
        0xf5,0x60,0x2a,0x4c,0xf3,0x91,0xb3,0xeb,0x7d,0x32,0x14,0x5a,0xdd,0x71,0xfc,0xef,
        0xc9,0x57,0x90,0x9c,0x2f,0xf6,0xd8,0xd1,0x89,0x63,0x46,0xc3,0x16,0xc1,0xe0,0xb5,
        0x67,0x7e,0x48,0xac,0x99,0x76,0xcc,0x42,0x1a,0x7d,0x57,0xcf,0x10,0xf8,0xaf,0x6d,
        0x2b,0xaf,0xb6,0x41,0x46,0xee,0xc9,0xf5,0x4a,0xe6,0x54,0x5c,0x39,0x22,0x09,0xc0,
	};
    poEmulationCard->PutTransparentEF("3F00DF005039",
        CByteArray(tuc3F00DF005039, (unsigned long) sizeof(tuc3F00DF005039)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#4) (CA)
	unsigned char tuc3F00DF00503A[] = {
		0x30,0x82,0x03,0xf5,0x30,0x82,0x02,0xdd,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x00,0xfb,0x7c,0x59,0x0f,0xa2,0x00,0x00,0xce,0xc0,0x01,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x38,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x06,0x13,0x05,0x42,0x45,0x20,0x20,0x20,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x0a,0x13,0x05,0x5a,0x45,0x54,0x45,0x53,
		0x31,0x16,0x30,0x14,0x06,0x03,0x55,0x04,0x03,0x13,0x0d,0x5a,0x45,0x54,0x45,0x53,
		0x20,0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x34,0x30,0x33,
		0x32,0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x17,0x0d,0x30,0x39,0x30,0x33,0x32,
		0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x30,0x37,0x31,0x1a,0x30,0x18,0x06,0x03,
		0x55,0x04,0x06,0x13,0x11,0x42,0x45,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x31,0x19,0x30,0x17,0x06,0x03,0x55,0x04,0x03,0x13,
		0x10,0x5a,0x45,0x54,0x45,0x53,0x20,0x43,0x69,0x74,0x69,0x7a,0x65,0x6e,0x20,0x43,
		0x41,0x30,0x82,0x01,0x22,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,
		0x01,0x01,0x05,0x00,0x03,0x82,0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,0x01,
		0x01,0x00,0x9d,0x32,0xe1,0xe3,0xae,0x49,0xb7,0x32,0x4c,0x2c,0xc7,0x84,0xa4,0xf5,
		0xef,0x95,0x5b,0x61,0xf0,0x68,0xc5,0xb0,0x0a,0xeb,0xe0,0x9e,0x05,0x27,0x24,0xd0,
		0xca,0xe1,0x46,0x3a,0x95,0x4b,0x77,0xce,0xc8,0x88,0xb9,0x38,0x30,0xeb,0x15,0x23,
		0xc0,0xa6,0x01,0xe8,0x9c,0xe2,0x2f,0xbd,0x1e,0x2e,0x77,0xab,0x62,0x65,0xff,0xf5,
		0xc3,0x0b,0x0f,0x12,0x51,0x4f,0xaa,0x2a,0x4f,0xf1,0x06,0x8e,0x4a,0x93,0xfb,0x4a,
		0x22,0x5b,0x69,0x12,0xa5,0x81,0x9e,0xc3,0xfb,0xdc,0x50,0x4f,0x62,0xbb,0xc9,0xcb,
		0xdd,0xfd,0x84,0x6b,0xb0,0x6c,0xa1,0xcb,0xca,0xb6,0x20,0x8b,0x1b,0xe4,0xf6,0xac,
		0x21,0xef,0x6c,0x07,0x80,0xa5,0x8f,0x75,0x1f,0xfd,0x99,0x46,0x24,0xae,0xd0,0x54,
		0x28,0xbe,0x4a,0x75,0x91,0x96,0xc6,0xc0,0x21,0xe3,0x81,0x17,0x4f,0xb6,0x86,0x6b,
		0x5e,0x33,0x7a,0x17,0x9d,0x13,0x62,0x1b,0x57,0x19,0x51,0xfe,0x3f,0xdf,0x73,0xdf,
		0xa1,0xd1,0x07,0xfa,0x0c,0xcb,0xef,0x4e,0x82,0xb2,0xc1,0x9c,0x8f,0x77,0x03,0xe4,
		0x34,0xc5,0x55,0xd1,0x3a,0x17,0x86,0x4b,0x51,0x08,0x84,0xf0,0xaf,0x58,0x4c,0x8a,
		0x14,0x59,0x4d,0x3f,0x9f,0x46,0x70,0x3b,0xfb,0x23,0x1f,0x3b,0xec,0x7a,0x50,0xa4,
		0x18,0xe0,0x05,0xe0,0x7d,0xcd,0x01,0xb3,0x15,0x0f,0x3d,0xf5,0xcf,0xbb,0x85,0x2e,
		0x5d,0x83,0x1c,0xd5,0x54,0x12,0x5c,0x8d,0x19,0x92,0xe0,0x1b,0xcb,0x28,0x27,0xea,
		0x62,0xda,0xbe,0xf8,0xb8,0x7b,0xed,0xd7,0xbb,0xbc,0xb6,0xb6,0xc3,0xb9,0xa9,0xc8,
		0x90,0x8d,0x02,0x03,0x01,0x00,0x01,0xa3,0x81,0xfb,0x30,0x81,0xf8,0x30,0x0e,0x06,
		0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x12,0x06,
		0x03,0x55,0x1d,0x13,0x01,0x01,0xff,0x04,0x08,0x30,0x06,0x01,0x01,0xff,0x02,0x01,
		0x00,0x30,0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0xed,0x2b,0xa5,0x67,
		0x16,0xb1,0xed,0x70,0xe1,0x5d,0x55,0x7a,0x11,0x12,0x16,0x1c,0x97,0x41,0x56,0x96,
		0x30,0x41,0x06,0x03,0x55,0x1d,0x20,0x04,0x3a,0x30,0x38,0x30,0x36,0x06,0x06,0x60,
		0x38,0x01,0x01,0x01,0x02,0x30,0x2c,0x30,0x2a,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,
		0x07,0x02,0x01,0x16,0x1e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,
		0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,
		0x2e,0x62,0x65,0x30,0x3c,0x06,0x03,0x55,0x1d,0x1f,0x04,0x35,0x30,0x33,0x30,0x31,
		0xa0,0x2f,0xa0,0x2d,0x86,0x2b,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,
		0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,0x2f,0x62,0x65,
		0x6c,0x67,0x69,0x75,0x6d,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,
		0x6c,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,
		0x03,0x02,0x00,0x07,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,
		0x14,0xc0,0x36,0xc8,0xa1,0x2c,0x09,0x80,0x78,0xd1,0xc9,0x47,0x0b,0xad,0xa0,0xad,
		0x56,0x84,0x51,0x19,0xe6,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,
		0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0xaa,0x58,0xd0,0xa0,0xba,0x1a,0xf8,
		0xe5,0x5e,0xb7,0x39,0x34,0x4c,0x3d,0x54,0x6a,0x54,0x38,0x62,0xe7,0x77,0x2b,0x93,
		0x07,0xfb,0x34,0x5d,0x4e,0xc9,0x09,0xb5,0xc2,0x76,0x62,0x1b,0xd3,0xe0,0xb6,0xff,
		0xc7,0x46,0x1b,0x49,0x45,0x62,0x94,0x55,0xb7,0xa8,0x9c,0xc7,0xa0,0x31,0x5b,0xd8,
		0xbd,0x5a,0x33,0x81,0x5b,0x18,0xbf,0x29,0x7f,0xc1,0x4a,0x14,0xdf,0x18,0x03,0x1e,
		0xd4,0x55,0x21,0x5d,0x09,0x5b,0x11,0xad,0x35,0x74,0x14,0x8c,0x49,0xba,0x6d,0xf9,
		0xa8,0x40,0xa0,0x8c,0xe4,0x26,0x70,0x51,0x80,0x1d,0xfd,0x8f,0x99,0x09,0x49,0x30,
		0x12,0x2f,0xd4,0x02,0x85,0xa4,0x0a,0xfa,0x8d,0xbc,0xdb,0xc5,0xc6,0xee,0x54,0xf8,
		0xf5,0xa7,0x5c,0xe8,0x69,0x40,0x7c,0xc6,0xff,0xc8,0xac,0x56,0xf3,0x6e,0xfa,0xd1,
		0x6e,0x6b,0x1a,0xa6,0x0b,0x92,0x1d,0x8d,0xdf,0x0c,0x57,0xe3,0x33,0x0d,0x7f,0xc4,
		0xe7,0x2a,0x0b,0x51,0x1a,0x78,0x43,0xc9,0x97,0x7c,0x2b,0xeb,0x80,0xda,0xcd,0xe3,
		0x56,0xf7,0xc5,0xfe,0x70,0x8b,0xec,0xcb,0xa3,0xc3,0x11,0xcc,0xd4,0x65,0x56,0x86,
		0xc5,0xf9,0xc1,0x42,0xaf,0x99,0x46,0x94,0x3e,0x70,0x61,0xfc,0x3e,0xec,0x9f,0xb0,
		0xe2,0xca,0xc8,0xe5,0xdc,0x4c,0x8e,0x12,0x45,0x49,0x63,0xd7,0x64,0xde,0x3b,0xbd,
		0x2a,0x05,0xc0,0x18,0x43,0xed,0x01,0xad,0x9e,0xcb,0xb1,0x35,0x25,0x75,0x0f,0xd0,
		0x17,0x67,0xd6,0x08,0x60,0x8c,0xe3,0xde,0xf0,0xc1,0xd7,0x85,0xf0,0x17,0xa1,0x38,
		0x08,0x1d,0x5f,0xd2,0x46,0xa9,0x2f,0xd2,0xa0,
	};

    poEmulationCard->PutTransparentEF("3F00DF00503A",
        CByteArray(tuc3F00DF00503A, (unsigned long) sizeof(tuc3F00DF00503A)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#6) (root)
	unsigned char tuc3F00DF00503B[] = {
		0x30,0x82,0x03,0xb4,0x30,0x82,0x02,0x9c,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x00,0xfb,0x7c,0x59,0x0d,0xf3,0x00,0x00,0xce,0xc0,0x00,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x38,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x06,0x13,0x05,0x42,0x45,0x20,0x20,0x20,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x0a,0x13,0x05,0x5a,0x45,0x54,0x45,0x53,
		0x31,0x16,0x30,0x14,0x06,0x03,0x55,0x04,0x03,0x13,0x0d,0x5a,0x45,0x54,0x45,0x53,
		0x20,0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x34,0x30,0x33,
		0x32,0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x17,0x0d,0x30,0x39,0x30,0x33,0x32,
		0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x30,0x38,0x31,0x0e,0x30,0x0c,0x06,0x03,
		0x55,0x04,0x06,0x13,0x05,0x42,0x45,0x20,0x20,0x20,0x31,0x0e,0x30,0x0c,0x06,0x03,
		0x55,0x04,0x0a,0x13,0x05,0x5a,0x45,0x54,0x45,0x53,0x31,0x16,0x30,0x14,0x06,0x03,
		0x55,0x04,0x03,0x13,0x0d,0x5a,0x45,0x54,0x45,0x53,0x20,0x52,0x6f,0x6f,0x74,0x20,
		0x43,0x41,0x30,0x82,0x01,0x22,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,
		0x01,0x01,0x01,0x05,0x00,0x03,0x82,0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,
		0x01,0x01,0x00,0xb1,0x56,0x7b,0xe1,0xcb,0x9e,0xcc,0xb0,0x8f,0x1d,0x10,0x44,0xf9,
		0x85,0x3e,0xc5,0xcc,0xbd,0x14,0x79,0xaa,0x75,0xe4,0x2e,0xcc,0x3b,0xc6,0x2a,0x8d,
		0xb2,0x31,0x53,0x0f,0x67,0x2a,0x08,0x21,0x5c,0xd3,0x9a,0x46,0xc5,0x40,0x71,0xe6,
		0xa5,0x92,0x55,0xec,0xe4,0xba,0x43,0x02,0x67,0x58,0x56,0x6a,0x71,0x90,0xfb,0x4a,
		0x4e,0x5d,0xe1,0xbb,0x66,0xd8,0xc5,0xeb,0x94,0x3c,0x2a,0x0b,0xf4,0xf0,0x51,0xa0,
		0xaa,0xae,0xd2,0x1d,0x93,0x90,0x9d,0xfd,0x66,0x17,0x35,0xe9,0xaa,0x15,0x0f,0x12,
		0xde,0xd6,0x31,0xc7,0x57,0x10,0x87,0xda,0x37,0xdf,0xb1,0x12,0xf2,0xf3,0x4b,0x59,
		0x45,0x7d,0xdf,0x6f,0x3d,0xda,0x10,0x53,0x2c,0xe5,0xe2,0xd1,0xcf,0xb0,0xf8,0x7f,
		0xe6,0x68,0x47,0xe9,0x44,0x8f,0x7f,0x72,0x63,0x80,0x55,0x2d,0x32,0x13,0x0d,0x57,
		0x07,0x20,0xaf,0x9e,0x85,0xeb,0xe5,0x1b,0x28,0x4b,0x06,0x22,0x55,0xe2,0x1a,0xf3,
		0x9b,0x13,0x96,0x00,0x0d,0x11,0xf4,0x64,0xb3,0x6f,0x9f,0x59,0x7f,0x20,0xb8,0x68,
		0x57,0x7c,0x3e,0x3d,0xe7,0xea,0x9d,0x6e,0x33,0x5d,0xbf,0x30,0xe2,0x89,0x1a,0x9f,
		0xc3,0x8d,0x25,0x5c,0x01,0x2a,0xfb,0xf2,0xc4,0x20,0x40,0x50,0x57,0xc0,0x00,0x37,
		0xb8,0xa0,0x37,0x5f,0x38,0xe2,0xd9,0x54,0xaf,0x41,0xa3,0xea,0xef,0x6e,0xd3,0x1f,
		0x47,0xde,0x93,0xcd,0xf9,0x19,0x74,0x8a,0xb6,0x02,0xec,0x06,0x5b,0x74,0x00,0xdb,
		0x2f,0x48,0x6f,0xfa,0xf5,0xcd,0x99,0xc8,0xac,0x94,0xd0,0x13,0x61,0x36,0x44,0x0e,
		0x74,0x56,0x17,0x02,0x03,0x01,0x00,0x01,0xa3,0x81,0xb9,0x30,0x81,0xb6,0x30,0x0e,
		0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x0f,
		0x06,0x03,0x55,0x1d,0x13,0x01,0x01,0xff,0x04,0x05,0x30,0x03,0x01,0x01,0xff,0x30,
		0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0xc0,0x36,0xc8,0xa1,0x2c,0x09,
		0x80,0x78,0xd1,0xc9,0x47,0x0b,0xad,0xa0,0xad,0x56,0x84,0x51,0x19,0xe6,0x30,0x40,
		0x06,0x03,0x55,0x1d,0x20,0x04,0x39,0x30,0x37,0x30,0x35,0x06,0x05,0x60,0x38,0x01,
		0x01,0x01,0x30,0x2c,0x30,0x2a,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,
		0x16,0x1e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,
		0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,
		0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,
		0x02,0x00,0x07,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,
		0xc0,0x36,0xc8,0xa1,0x2c,0x09,0x80,0x78,0xd1,0xc9,0x47,0x0b,0xad,0xa0,0xad,0x56,
		0x84,0x51,0x19,0xe6,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,
		0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x4d,0x16,0xa5,0xe5,0x81,0x9f,0xac,0xb4,
		0xf7,0xaf,0x51,0x7e,0xa1,0x73,0x07,0xe6,0xe3,0x7d,0x96,0x3d,0x36,0x3f,0x9f,0xd7,
		0x01,0xed,0x53,0x70,0xb0,0x82,0x58,0x79,0x72,0x64,0x20,0x02,0x85,0xa4,0xb5,0xe6,
		0x7b,0x40,0xad,0x4b,0xe1,0x50,0x00,0x22,0x91,0x88,0xfa,0xbd,0xdc,0x69,0xbe,0xa6,
		0x6f,0x84,0x5c,0xf8,0x9a,0xfa,0x08,0xfa,0x8c,0xd4,0x14,0x35,0x1d,0xc9,0x2b,0x46,
		0xb4,0x94,0x87,0x42,0xf7,0x38,0xc2,0x36,0xc2,0xac,0x30,0x04,0xa9,0xe4,0xe0,0x6d,
		0xb8,0x46,0x54,0xc1,0xcb,0x4f,0x44,0xcf,0x3b,0x36,0x61,0xd7,0x34,0x2f,0x7c,0xef,
		0xe0,0x9c,0xc7,0xdc,0x82,0x5e,0x84,0x12,0xdc,0x17,0x05,0xa5,0x26,0x39,0x45,0x9e,
		0xb9,0xfc,0x0f,0x24,0x66,0xf4,0x9e,0x0a,0x16,0x3c,0x71,0xe0,0x17,0x03,0xdc,0x66,
		0x51,0x57,0x7d,0x8c,0x2b,0x0e,0x3c,0x55,0x8a,0xf6,0xc8,0x7a,0x12,0x4a,0x48,0x76,
		0xa4,0x29,0xad,0xa2,0x88,0xe6,0x2e,0x7c,0xfb,0xe2,0xc1,0xa5,0xfc,0xd1,0xb5,0xea,
		0xad,0x1e,0x8c,0xb2,0x2c,0xd9,0x2a,0xd1,0xf7,0xe6,0xb5,0x8c,0x60,0x44,0xdc,0x54,
		0x14,0x5f,0x65,0xbf,0x4b,0xc7,0xa4,0xc5,0x3f,0x49,0x5d,0xb1,0x9a,0x69,0x93,0xee,
		0x5c,0xa2,0x1a,0x35,0xfd,0xce,0xf4,0xb3,0x5c,0xd7,0x9d,0x72,0xbf,0x33,0xc9,0x17,
		0xaf,0x03,0xa8,0x59,0xe7,0x70,0x7b,0x74,0x15,0xd3,0x15,0x23,0xe9,0xd9,0x5d,0x36,
		0xc7,0xbd,0xda,0x45,0xd7,0x2e,0x21,0xf0,0x25,0xd7,0xd2,0x16,0x9a,0xc1,0xd1,0x09,
		0xb8,0xb3,0x9a,0xe8,0xb8,0xff,0x81,0xbb,
	};

    poEmulationCard->PutTransparentEF("3F00DF00503B",
        CByteArray(tuc3F00DF00503B, (unsigned long) sizeof(tuc3F00DF00503B)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#8) (RN)
	unsigned char tuc3F00DF00503C[] = {
		0x30,0x82,0x03,0xd6,0x30,0x82,0x02,0xbe,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x00,0xfb,0x7c,0x59,0x10,0x24,0x00,0x00,0xce,0xc0,0x02,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x3b,
		0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x0e,0x30,
		0x0c,0x06,0x03,0x55,0x04,0x0a,0x13,0x05,0x5a,0x45,0x54,0x45,0x53,0x31,0x1c,0x30,
		0x1a,0x06,0x03,0x55,0x04,0x03,0x13,0x13,0x5a,0x45,0x54,0x45,0x53,0x20,0x47,0x6f,
		0x76,0x65,0x72,0x6e,0x6d,0x65,0x6e,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,
		0x34,0x30,0x33,0x32,0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x17,0x0d,0x30,0x39,
		0x30,0x33,0x32,0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x30,0x21,0x31,0x0b,0x30,
		0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x12,0x30,0x10,0x06,0x03,
		0x55,0x04,0x03,0x13,0x09,0x5a,0x45,0x54,0x45,0x53,0x20,0x52,0x4e,0x20,0x30,0x81,
		0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,
		0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0xb4,0xb8,0x1d,0xed,0xc5,
		0x2d,0x80,0x31,0x42,0x08,0x76,0x44,0xac,0x96,0xde,0x35,0x7c,0xbc,0xc6,0xcd,0xec,
		0x48,0x73,0xfd,0x84,0x0e,0x19,0x90,0x18,0x5a,0x18,0x15,0x18,0x6f,0xca,0xab,0x63,
		0x10,0xea,0x7a,0x0d,0x5d,0x4b,0x74,0x01,0xbe,0xcb,0x18,0x1b,0x97,0x2d,0x7a,0x41,
		0x08,0x04,0x0f,0xbb,0x61,0xf7,0xb7,0xc1,0x8d,0xe1,0x00,0xb5,0xc9,0x8f,0x1b,0x3f,
		0xdf,0x9a,0x1f,0x88,0xe6,0x07,0x80,0xb9,0xf8,0x2b,0xb1,0x69,0xc2,0xed,0x3b,0xfb,
		0xc2,0x47,0xea,0x08,0x2b,0xae,0xd2,0x80,0x43,0xdd,0xc0,0x23,0x1e,0x0a,0x4e,0xe7,
		0x0d,0x3d,0x41,0x97,0xb7,0x20,0x22,0xd9,0x40,0x6b,0x85,0xe2,0x45,0x5a,0x90,0x8f,
		0xbf,0xc7,0x04,0xa8,0xa7,0x69,0x32,0xb0,0x1e,0x7d,0xfb,0x02,0x03,0x01,0x00,0x01,
		0xa3,0x82,0x01,0x72,0x30,0x82,0x01,0x6e,0x30,0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,
		0x01,0xff,0x04,0x04,0x03,0x02,0x06,0xc0,0x30,0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,
		0x16,0x04,0x14,0x82,0xce,0x78,0xd3,0x3f,0x6f,0x41,0x41,0xce,0xa1,0xec,0x04,0x89,
		0xcf,0x2d,0xb8,0xcb,0xc8,0x5a,0xc9,0x30,0x42,0x06,0x03,0x55,0x1d,0x20,0x04,0x3b,
		0x30,0x39,0x30,0x37,0x06,0x07,0x60,0x38,0x01,0x01,0x01,0x03,0x01,0x30,0x2c,0x30,
		0x2a,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x1e,0x68,0x74,0x74,
		0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,
		0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,0x30,0x3c,0x06,0x03,0x55,
		0x1d,0x1f,0x04,0x35,0x30,0x33,0x30,0x31,0xa0,0x2f,0xa0,0x2d,0x86,0x2b,0x68,0x74,
		0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,
		0x65,0x73,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2f,0x62,0x65,
		0x6c,0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,0x6c,0x30,0x7c,0x06,0x08,0x2b,0x06,0x01,
		0x05,0x05,0x07,0x01,0x01,0x04,0x70,0x30,0x6e,0x30,0x3f,0x06,0x08,0x2b,0x06,0x01,
		0x05,0x05,0x07,0x30,0x02,0x86,0x33,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,
		0x77,0x2e,0x5a,0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,0x65,0x2f,
		0x64,0x75,0x6d,0x6d,0x79,0x2f,0x63,0x65,0x72,0x74,0x69,0x66,0x63,0x61,0x74,0x65,
		0x73,0x2f,0x74,0x65,0x73,0x74,0x2e,0x63,0x72,0x74,0x30,0x2b,0x06,0x08,0x2b,0x06,
		0x01,0x05,0x05,0x07,0x30,0x01,0x86,0x1f,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x6f,
		0x63,0x73,0x70,0x2e,0x5a,0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,
		0x65,0x2f,0x64,0x75,0x6d,0x6d,0x79,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,
		0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x04,0xb0,0x30,0x09,0x06,0x03,0x55,0x1d,
		0x13,0x04,0x02,0x30,0x00,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,
		0x80,0x14,0x46,0xad,0x98,0xa1,0xc0,0x9a,0x48,0x5e,0x61,0xa0,0xbc,0x7e,0x0b,0x50,
		0x02,0x82,0x03,0xb8,0x4d,0x46,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,
		0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x23,0xab,0x0b,0xf7,0xb9,0x25,
		0x13,0x94,0xd9,0x35,0xb6,0x72,0xc8,0xa2,0x6e,0xe5,0x39,0x6d,0x40,0xcd,0xf6,0x3b,
		0x40,0x17,0x25,0x41,0x3e,0x06,0x39,0x75,0x56,0x9c,0x8d,0x41,0x13,0x09,0xcd,0x44,
		0x70,0xfc,0xb0,0x2d,0x10,0x2d,0x8a,0x8a,0xca,0x18,0xe1,0x47,0x7f,0x63,0xf6,0xbb,
		0x02,0x67,0xf5,0xc9,0xf1,0x10,0x12,0xad,0xeb,0x3b,0xaa,0xbe,0x18,0x67,0x35,0x52,
		0xb6,0xe9,0xe9,0xf7,0x36,0xd8,0x31,0xc2,0x1e,0x29,0x34,0x29,0x48,0x56,0x79,0x54,
		0xdc,0xd9,0xa9,0x8c,0xc4,0x67,0x70,0x97,0xbd,0xa6,0x8e,0xe3,0xb8,0x82,0x9b,0x54,
		0x8f,0xe5,0x92,0x8a,0xea,0x11,0x69,0x24,0x0f,0xc7,0x26,0x3a,0x7f,0x5d,0x42,0xa5,
		0x4f,0x17,0x05,0xed,0x1f,0x3b,0xc0,0x01,0x73,0x57,0x4e,0xf2,0x67,0x18,0x49,0x12,
		0xc5,0xc5,0x78,0x59,0x4d,0x2d,0x6a,0x37,0x4f,0x7f,0x1d,0xbe,0x17,0x90,0xad,0x8b,
		0xa7,0x85,0x96,0xa7,0x9d,0xc0,0x28,0x50,0xf6,0x15,0xf9,0xd2,0x2c,0xb8,0x54,0x93,
		0x1b,0xa3,0x57,0xc3,0xf8,0x7c,0x75,0xef,0x64,0xb6,0xbd,0x7b,0xd4,0x8d,0xb2,0x76,
		0x04,0x68,0x23,0x09,0xfe,0xd5,0xef,0x36,0x9b,0x96,0x89,0x91,0xb9,0x08,0x68,0x3f,
		0xca,0x39,0x8b,0x98,0x54,0x2e,0x27,0x0d,0x8f,0x5b,0x2e,0x9a,0x20,0xed,0xf8,0x2e,
		0xf5,0x81,0xf4,0xcb,0x61,0xd7,0x22,0xb9,0x34,0x1e,0xe6,0x6d,0x0f,0xe9,0x52,0x23,
		0x9b,0xa2,0x80,0x0b,0x50,0x47,0xd1,0x26,0xea,0xb8,0x32,0x72,0x82,0x27,0xfb,0x61,
		0x0d,0x4f,0xfa,0x99,0x88,0xad,0x72,0x36,0x33,0x26,
	};
    poEmulationCard->PutTransparentEF("3F00DF00503C",
        CByteArray(tuc3F00DF00503C, (unsigned long) sizeof(tuc3F00DF00503C)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#RN)
    unsigned char tuc3F00DF014031[] = {
        0x01,0x0c,0x35,0x39,0x30,0x34,0x35,0x36,0x37,0x38,0x39,0x30,0x31,0x32,0x02,0x10,
        0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x61,0x62,0x63,0x64,0x65,0x66,
        0x03,0x0a,0x30,0x31,0x2e,0x30,0x31,0x2e,0x32,0x30,0x30,0x37,0x04,0x0a,0x30,0x31,
        0x2e,0x30,0x31,0x2e,0x32,0x30,0x31,0x32,0x05,0x09,0x42,0x72,0x75,0x78,0x65,0x6c,
        0x6c,0x65,0x73,0x06,0x0b,0x38,0x30,0x30,0x31,0x32,0x35,0x31,0x31,0x32,0x36,0x35,
        0x07,0x05,0x6e,0x61,0x6d,0x65,0x31,0x08,0x06,0x67,0x6e,0x61,0x6d,0x65,0x31,0x09,
        0x00,0x0a,0x05,0x42,0x65,0x6c,0x67,0x65,0x0b,0x07,0x49,0x78,0x65,0x6c,0x6c,0x65,
        0x73,0x0c,0x0b,0x32,0x35,0x20,0x4a,0x41,0x4e,0x20,0x31,0x39,0x38,0x30,0x0d,0x01,
        0x4d,0x0e,0x06,0x50,0x72,0x69,0x6e,0x63,0x65,0x0f,0x01,0x31,0x10,0x01,0x30,0x11,
        0x14,0xdc,0x9d,0xb2,0xc8,0x3d,0xc1,0xf1,0xf7,0xd6,0x96,0x4c,0xae,0x35,0xda,0x0c,
        0xb9,0x2e,0x22,0x09,0xf0,
	};
    poEmulationCard->PutTransparentEF("3F00DF014031",
        CByteArray(tuc3F00DF014031, (unsigned long) sizeof(tuc3F00DF014031)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(SGN#RN)
    unsigned char tuc3F00DF014032[] = {
        0x8f,0x0b,0x38,0xf1,0xd7,0x34,0x65,0x73,0xed,0xff,0xca,0x2c,0x74,0x43,0xf6,0x65,
        0x10,0x4c,0x39,0xe6,0xf5,0xb8,0xf2,0x0c,0x37,0x32,0xbe,0xc5,0x3b,0x42,0xcb,0x73,
        0xe9,0xd5,0x9e,0x77,0xbf,0x7b,0xed,0x64,0x2c,0x47,0x5a,0x80,0xb5,0x2f,0xdf,0xeb,
        0xac,0x34,0xd6,0x1a,0x57,0x93,0x71,0xf3,0x3d,0xc5,0x9f,0x1b,0xa4,0x0c,0xc7,0x64,
        0x84,0x72,0xd5,0x82,0x35,0x4f,0xb8,0xcb,0x7a,0x3e,0xff,0x7a,0x23,0xc2,0x11,0x63,
        0x07,0x68,0x05,0x8a,0xf5,0x80,0xa1,0xdc,0x78,0xbe,0x4d,0x94,0x3a,0x21,0xc6,0x59,
        0x9f,0xcb,0x32,0xee,0x07,0x5d,0xb3,0x30,0xf1,0xa2,0x35,0xf1,0xf7,0x10,0x21,0x00,
        0xfc,0x3d,0x5c,0x77,0xed,0xe7,0x6e,0xcf,0x18,0x25,0xf7,0xc6,0x3a,0x57,0x0a,0x7d,
	};
    poEmulationCard->PutTransparentEF("3F00DF014032",
        CByteArray(tuc3F00DF014032, (unsigned long) sizeof(tuc3F00DF014032)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#Address)
    unsigned char tuc3F00DF014033[] = {
        0x01,0x0b,0x56,0x69,0x6c,0x61,0x6c,0x61,0x61,0x6e,0x20,0x31,0x33,0x02,0x04,0x31,
        0x36,0x30,0x31,0x03,0x09,0x52,0x75,0x69,0x73,0x62,0x72,0x6f,0x65,0x6b,
	};
    poEmulationCard->PutTransparentEF("3F00DF014033",
        CByteArray(tuc3F00DF014033, (unsigned long) sizeof(tuc3F00DF014033)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(SGN#Address)
    unsigned char tuc3F00DF014034[] = {
        0x8b,0xa8,0x2b,0xa6,0x05,0x7b,0x47,0xda,0x27,0xec,0xc6,0x59,0xfe,0x5c,0x5e,0xb4,
        0xf9,0x2e,0xf9,0xd9,0xae,0x30,0x46,0xa0,0x70,0x92,0xc3,0x58,0x69,0x0f,0x9f,0x6a,
        0x9c,0x10,0xb3,0x15,0x37,0x86,0x81,0x06,0x5c,0xf1,0x69,0x8a,0x92,0x40,0xc5,0x05,
        0xd3,0x23,0xca,0x71,0x6a,0x30,0x0d,0x2b,0x75,0x59,0xc7,0x0d,0xe0,0xf8,0xe8,0x56,
        0x9f,0xcd,0x1b,0x43,0x6f,0xa8,0xff,0x5c,0x66,0xd6,0xc1,0xa3,0x2a,0xdb,0xe2,0xe0,
        0x72,0x0f,0x5f,0xd2,0x2b,0x15,0xff,0x21,0x50,0x7c,0x2e,0xe6,0x16,0x2e,0xf6,0x0c,
        0x91,0xc5,0x99,0x4b,0xb5,0x23,0x47,0x18,0xfb,0x41,0xe3,0x5f,0xd8,0xd5,0xe0,0x1b,
        0xe1,0x67,0x61,0x86,0x79,0xdc,0xe2,0xbc,0x69,0x69,0x9e,0x51,0xe4,0x7b,0xf4,0xc1,
	};
    poEmulationCard->PutTransparentEF("3F00DF014034",
        CByteArray(tuc3F00DF014034, (unsigned long) sizeof(tuc3F00DF014034)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#Photo)
    unsigned char tuc3F00DF014035[] = {
		0xff,0xd8,0xff,0xe0,0x00,0x10,0x4a,0x46,0x49,0x46,0x00,0x01,0x02,0x01,0x01,0x2c,
		0x01,0x2c,0x00,0x00,0xff,0xdb,0x00,0x43,0x00,0x1c,0x13,0x15,0x18,0x15,0x11,0x1c,
		0x18,0x16,0x18,0x1f,0x1d,0x1c,0x21,0x29,0x45,0x2d,0x29,0x26,0x26,0x29,0x54,0x3c,
		0x40,0x32,0x45,0x64,0x58,0x69,0x67,0x62,0x58,0x60,0x5f,0x6e,0x7c,0x9e,0x86,0x6e,
		0x75,0x96,0x77,0x5f,0x60,0x8a,0xbb,0x8b,0x96,0xa3,0xa9,0xb1,0xb3,0xb1,0x6b,0x84,
		0xc2,0xd0,0xc1,0xac,0xce,0x9e,0xae,0xb1,0xaa,0xff,0xc0,0x00,0x0b,0x08,0x00,0xc8,
		0x00,0x8c,0x01,0x01,0x11,0x00,0xff,0xc4,0x00,0xd2,0x00,0x00,0x01,0x05,0x01,0x01,
		0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,
		0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x10,0x00,0x02,0x01,0x03,0x03,0x02,0x04,0x03,
		0x05,0x05,0x04,0x04,0x00,0x00,0x01,0x7d,0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
		0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,0x22,0x71,0x14,0x32,0x81,0x91,0xa1,0x08,
		0x23,0x42,0xb1,0xc1,0x15,0x52,0xd1,0xf0,0x24,0x33,0x62,0x72,0x82,0x09,0x0a,0x16,
		0x17,0x18,0x19,0x1a,0x25,0x26,0x27,0x28,0x29,0x2a,0x34,0x35,0x36,0x37,0x38,0x39,
		0x3a,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
		0x5a,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
		0x7a,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
		0x99,0x9a,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,0xb5,0xb6,
		0xb7,0xb8,0xb9,0xba,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xd2,0xd3,0xd4,
		0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,
		0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xff,0xda,0x00,0x08,0x01,0x01,
		0x00,0x00,0x3f,0x00,0xdf,0xc9,0xf5,0x34,0x64,0xfa,0x9a,0x32,0x7d,0x4d,0x19,0x3e,
		0xa6,0x8c,0x9f,0x53,0x46,0x4f,0xa9,0xa3,0x27,0xd4,0xd2,0x16,0xc0,0xc9,0x6c,0x7e,
		0x35,0x1f,0xda,0xa1,0x1d,0x67,0x4f,0xfb,0xec,0x53,0xd6,0x55,0x7f,0xb9,0x20,0x6f,
		0xa1,0xcd,0x3b,0x27,0xd4,0xd1,0x93,0xea,0x68,0xc9,0xf5,0x34,0x64,0xfa,0x9a,0x32,
		0x7d,0x4d,0x19,0x3e,0xa6,0x8c,0x9f,0x53,0x46,0x4f,0xa9,0xa4,0xa2,0x8a,0x28,0xaa,
		0x73,0x6a,0x31,0x46,0xfb,0x57,0xe6,0xc1,0xe4,0xe7,0x8a,0xab,0x73,0xa9,0x3b,0x8f,
		0xdc,0xfc,0xab,0x8c,0x93,0x9e,0x6b,0x2a,0x4b,0xd2,0xe7,0x25,0x99,0x88,0xee,0xd9,
		0x26,0xa3,0x17,0x32,0x72,0x36,0x82,0x3d,0x0a,0xff,0x00,0xf5,0xaa,0x58,0xe7,0x72,
		0x7e,0x50,0x8c,0x7b,0x00,0x7f,0xc9,0xab,0xd0,0xea,0x32,0x21,0xc1,0xde,0x87,0xb8,
		0x3f,0x30,0xfd,0x6b,0x52,0x0b,0xc8,0xe6,0xc0,0xe8,0x4f,0xa7,0x23,0xff,0x00,0xad,
		0xf8,0xd5,0x8a,0x28,0xa2,0x8a,0x28,0xa2,0x8a,0x46,0x65,0x45,0x2c,0xc4,0x05,0x51,
		0x92,0x4f,0x40,0x2b,0x9b,0xd4,0x35,0x69,0x2e,0x58,0xa4,0x04,0xac,0x59,0xe0,0x63,
		0xaf,0xb9,0xac,0xf5,0xf9,0x9c,0xf9,0xb2,0x1c,0x0e,0xde,0xb4,0x34,0xd6,0xd9,0xc7,
		0x97,0x9c,0x0e,0xb9,0x34,0x79,0xf0,0x63,0xfd,0x58,0xfc,0xa9,0x37,0xc2,0xdd,0x13,
		0x6f,0xb8,0x6c,0x7f,0x3a,0x9d,0x77,0x60,0x79,0x6e,0x19,0x4f,0x69,0x3f,0xc4,0x54,
		0xc9,0x37,0x96,0x42,0x48,0x0c,0x64,0xf4,0x0f,0x82,0xbf,0x81,0xab,0x03,0x83,0xc8,
		0x1c,0x76,0x35,0xa9,0xa7,0xcf,0xbd,0x7c,0xb2,0x78,0x51,0xf2,0x83,0xd4,0x7b,0x55,
		0xda,0x28,0xa2,0x8a,0x28,0xa2,0xb1,0xb5,0xcb,0x96,0x91,0x96,0xce,0x16,0xc7,0xf1,
		0x4a,0x47,0x61,0xd8,0x7f,0x5f,0xca,0xb2,0x7e,0x44,0x52,0xa9,0x8f,0x73,0x55,0x27,
		0xdb,0x9f,0x94,0xf3,0xf5,0xa8,0x83,0x7f,0x7b,0x9a,0x4c,0x7a,0x52,0xab,0x76,0x65,
		0xc8,0xa9,0x51,0x33,0xcc,0x2c,0x43,0x7a,0x67,0x07,0xf3,0xa9,0x96,0xea,0x44,0x1b,
		0x26,0x40,0xeb,0xdd,0x58,0x55,0x88,0x64,0x08,0x99,0xb7,0x6d,0xf1,0x8e,0xa8,0x7a,
		0xaf,0xd3,0xfc,0x2a,0xe4,0x32,0x2b,0x61,0xd4,0xed,0xc1,0xe1,0x87,0x05,0x4d,0x6c,
		0xda,0xdc,0x79,0xf1,0xfc,0xd8,0x12,0x0f,0xbc,0xa3,0xf9,0xd4,0xf4,0x51,0x45,0x14,
		0x53,0x26,0x90,0x43,0x0b,0xca,0xc3,0x21,0x14,0xb6,0x07,0x7c,0x76,0xae,0x62,0xea,
		0x46,0x3b,0x9d,0x8e,0x19,0xdb,0x73,0x9f,0xe8,0x2b,0x36,0x49,0x4b,0x70,0x0e,0x05,
		0x0a,0x85,0xce,0x31,0x9a,0x9d,0x2c,0x9d,0x97,0x27,0x8a,0x63,0x5b,0xb2,0x9f,0xeb,
		0x48,0x21,0xdc,0xa7,0xa0,0x61,0xda,0x98,0x51,0x94,0xf4,0x23,0x15,0x34,0x72,0xab,
		0x0d,0xb3,0x82,0x47,0xf7,0x87,0x51,0x4a,0x55,0xed,0xc8,0x92,0x32,0x1b,0xdc,0x74,
		0x61,0xe8,0x45,0x59,0x86,0x65,0x90,0x87,0x8f,0xe4,0x27,0x86,0x52,0x7a,0xff,0x00,
		0xf5,0xfd,0x3d,0x6b,0x4e,0xd6,0x53,0x1b,0x2c,0x89,0x93,0xb7,0x82,0xbe,0xde,0x95,
		0xb0,0x08,0x20,0x10,0x72,0x0f,0x20,0xd2,0xd1,0x45,0x14,0x55,0x0d,0x5e,0x60,0x96,
		0xeb,0x19,0x07,0x0e,0x77,0x13,0x8e,0x81,0x70,0x7f,0x9e,0x3f,0x5a,0xe5,0xae,0x65,
		0x2e,0xdc,0xfa,0xd3,0x60,0x84,0xca,0xe0,0x0a,0xdc,0xb4,0xb0,0x0a,0x01,0x22,0xb4,
		0x05,0xaa,0xec,0xe9,0xda,0xaa,0x5c,0xd8,0xe3,0x90,0x2b,0x32,0x68,0xb6,0x7b,0x1e,
		0xc7,0xd2,0xab,0x82,0xa3,0x83,0xf4,0xe3,0xb1,0xa8,0xa5,0x5e,0xeb,0x4d,0x8e,0x52,
		0xbc,0x75,0x0d,0xd4,0x52,0x9f,0x91,0xb7,0xaf,0xdd,0x61,0x86,0xad,0x7b,0x09,0xcb,
		0x27,0x27,0x2e,0xbc,0x30,0xfe,0x55,0xb9,0x68,0x73,0x16,0xdc,0xe4,0x0e,0x9f,0x4a,
		0x9e,0x8a,0x28,0xa2,0xb0,0xf5,0xf9,0x71,0x26,0xcd,0xd9,0x01,0x00,0x23,0xd0,0xf2,
		0x4f,0xfe,0xcb,0x5c,0xf0,0xcb,0x35,0x6d,0x69,0x76,0xe0,0x28,0x62,0x3a,0xfb,0x56,
		0xd2,0x2f,0x4e,0x95,0x30,0xe9,0x41,0x00,0x8e,0x6a,0x9d,0xdd,0x92,0xcc,0x84,0xa8,
		0xc3,0x7f,0x3a,0xe7,0x2f,0x2d,0xde,0x19,0x09,0xda,0x45,0x55,0x0e,0x7a,0x1e,0x94,
		0xd7,0x03,0x39,0x1d,0xe9,0xc8,0xdf,0xc3,0xd8,0x8f,0xce,0xac,0xd8,0xc9,0xe5,0x4e,
		0x37,0x74,0xe8,0x7e,0x95,0xd2,0xd8,0xb9,0x0d,0xb0,0x9e,0x6a,0xf5,0x14,0x51,0x45,
		0x72,0x7a,0xa4,0xbe,0x65,0xc5,0xce,0x58,0x13,0xe6,0x1f,0xc8,0x1c,0x0f,0xd0,0x0a,
		0xcf,0x8c,0x66,0x45,0x1e,0xa7,0x15,0xd2,0xd9,0xae,0xd8,0xc0,0x1c,0x55,0xf5,0xcf,
		0xa5,0x4a,0x29,0xd8,0xa3,0x15,0x4e,0xf6,0xc5,0x6e,0x54,0xe3,0x01,0xbd,0x7d,0x6b,
		0x9a,0xbd,0xb1,0x92,0xd9,0xce,0x54,0xe2,0xaa,0x88,0xcb,0x02,0x54,0xfe,0x14,0xcc,
		0x11,0xd7,0x8a,0x9e,0x32,0x37,0x29,0x3d,0x09,0xda,0x6b,0xa1,0xb3,0x90,0xe6,0x16,
		0x63,0xce,0x02,0xb1,0xf7,0xad,0x7a,0x28,0xa2,0x82,0xc1,0x41,0x66,0x38,0x50,0x32,
		0x7e,0x95,0xc2,0x33,0x92,0xe4,0xb1,0xc9,0x27,0x9f,0x7a,0x7d,0xa2,0xef,0xb9,0x41,
		0xfe,0xd6,0x6b,0xa7,0x84,0x04,0x51,0xb8,0x81,0xc7,0x7a,0x9c,0x4f,0x1a,0xf5,0x3c,
		0x7a,0xd4,0xab,0x2c,0x6d,0xf7,0x5d,0x4f,0xe3,0x52,0x02,0x28,0xcd,0x04,0x81,0xd6,
		0xa1,0x9e,0x38,0xe5,0x8c,0x89,0x30,0x47,0xbd,0x61,0xdd,0xe9,0x91,0x07,0x0d,0x6f,
		0x28,0x27,0xfb,0xbd,0x6a,0x85,0xcd,0xac,0x85,0x0b,0x18,0xc6,0x57,0xba,0x90,0x73,
		0xf8,0x55,0x64,0xf9,0xb3,0x9e,0xe3,0x15,0xb9,0x6e,0xe3,0x64,0x64,0x7f,0x7f,0xfa,
		0x56,0xf2,0x1d,0xc8,0xa7,0xd4,0x66,0x96,0x8a,0x2a,0xa6,0xaa,0xfb,0x34,0xd9,0x88,
		0xea,0x46,0xde,0xb8,0xea,0x70,0x7f,0x4c,0xd7,0x35,0x6d,0xb6,0x58,0x96,0x29,0x23,
		0x4d,0xac,0xa4,0x86,0x1f,0x7b,0x3e,0xb4,0xba,0x4c,0x3b,0xae,0x86,0x46,0x71,0xde,
		0xb6,0xe5,0x75,0x56,0xcd,0x40,0xfa,0x84,0x2a,0x30,0xcb,0xc1,0xef,0xc6,0x2a,0xb9,
		0xbc,0x80,0xb8,0xf2,0x98,0xe4,0xfa,0x73,0x57,0xac,0xef,0x43,0x10,0x37,0x86,0x07,
		0x8c,0xe6,0xb4,0x41,0xc8,0xcd,0x55,0xba,0xb8,0xf2,0xc1,0x19,0x22,0xb2,0xe5,0xba,
		0xe7,0xe6,0x66,0x23,0xbf,0xa0,0xa9,0x12,0xee,0xdd,0x40,0xda,0xd1,0xb1,0xf4,0xde,
		0x09,0xa7,0x49,0x24,0x53,0x29,0xf9,0x70,0x7d,0xeb,0x04,0xaf,0x97,0x3b,0x27,0xa1,
		0xad,0x2b,0x39,0x0f,0x93,0xc9,0xfb,0xae,0x31,0xfe,0x7f,0x1a,0xe9,0x2d,0x8e,0x6d,
		0xd0,0xfe,0x15,0x25,0x14,0x56,0x57,0x88,0xa4,0xd9,0x62,0xab,0xdd,0x9b,0x3f,0x80,
		0x18,0xfe,0xa2,0xb2,0x2c,0x88,0x7b,0x55,0x66,0x1f,0xea,0x8b,0x28,0xfe,0x7f,0xd6,
		0xae,0xe9,0x4a,0x3c,0xc7,0x60,0x31,0x56,0xee,0x2d,0xcc,0x8b,0x90,0x71,0x59,0x46,
		0xc0,0x2b,0xc8,0x25,0x52,0xe1,0xc6,0x03,0x77,0x43,0xf4,0xf4,0xa5,0xb2,0xb4,0x95,
		0xa4,0x41,0x74,0x77,0xc5,0x16,0x4a,0x20,0xf5,0x20,0x0f,0xcb,0x81,0x57,0x52,0xcb,
		0x6b,0x96,0x04,0xf2,0x78,0xc9,0xe7,0xf1,0xad,0x78,0x87,0xee,0x86,0x7a,0xe2,0xa8,
		0xdd,0x41,0xe6,0xcb,0x82,0x71,0x59,0xf2,0xe9,0xa8,0xc8,0xe8,0xea,0xdb,0xf1,0xf2,
		0x3a,0x9e,0x14,0xfd,0x2a,0xbc,0x16,0x52,0x64,0x9b,0xa4,0x32,0x32,0xae,0xc4,0x50,
		0x46,0x31,0xef,0x56,0xac,0x6c,0x1e,0x25,0xc3,0x1e,0x3d,0x3d,0x3e,0x95,0x9f,0xaa,
		0x43,0xe4,0x5e,0x86,0x1f,0x75,0xd7,0xfc,0xff,0x00,0x4a,0x4b,0x47,0xca,0x14,0xf7,
		0x26,0xba,0x6d,0x35,0xf7,0x5b,0x0e,0xb5,0x6e,0x8a,0x2b,0x03,0xc4,0x8d,0xf3,0x80,
		0x1b,0x8d,0xa0,0x63,0xd0,0xe4,0x9f,0xf0,0xaa,0x1a,0x4b,0x06,0x12,0xc0,0xcd,0x8c,
		0xe0,0x8c,0x7e,0xbf,0xd2,0xb5,0x6c,0xd0,0xc7,0x3b,0x29,0xe9,0x8e,0x0f,0xad,0x68,
		0x22,0xe7,0xad,0x23,0xc0,0x0f,0x6a,0x44,0xb7,0x51,0xfc,0x38,0xa7,0xf9,0x63,0x77,
		0xa6,0x2a,0x55,0xe0,0x53,0x08,0xc9,0xc1,0xa4,0x68,0x43,0x0f,0x7f,0x5a,0x6f,0xd9,
		0xc6,0x73,0x4e,0x29,0xb5,0x6b,0x0f,0x5f,0x50,0x22,0x88,0xf1,0x9d,0xdf,0xd2,0xb2,
		0xed,0x9b,0x13,0x2e,0x7b,0x9c,0x57,0x4b,0xa3,0xb6,0x63,0x2b,0xd8,0x7e,0x95,0xa5,
		0x45,0x15,0xcd,0x78,0x83,0x22,0x79,0x33,0xd0,0xba,0xe3,0xfe,0xf9,0x15,0x99,0x04,
		0xa2,0x0b,0x84,0x98,0x03,0x81,0x8c,0x8f,0x62,0x39,0xad,0xc8,0xe5,0x5f,0xb4,0x23,
		0x2b,0x82,0x8c,0x7e,0x52,0x0d,0x69,0x23,0x7c,0xc4,0x54,0xe2,0x8e,0x2a,0x17,0x62,
		0xcc,0x42,0xf4,0x15,0x3a,0xf2,0x2a,0x27,0x38,0x3f,0x2f,0x24,0x53,0xe3,0x70,0xeb,
		0x91,0xf9,0x53,0xce,0x2a,0x29,0x5b,0x0b,0x5c,0xce,0xb7,0x36,0xfb,0x94,0x41,0xd1,
		0x41,0x3f,0xe7,0xf2,0xac,0xf8,0xdb,0x0c,0xa7,0xd0,0xd6,0xfe,0x87,0x3f,0xef,0xca,
		0x9f,0xe2,0x18,0xad,0xda,0x28,0xae,0x6b,0xc4,0x21,0x85,0xc4,0x99,0x3c,0x16,0x52,
		0x07,0xb6,0xd0,0x3f,0xa1,0xac,0x86,0xc1,0x40,0x79,0xe9,0x49,0x0b,0x88,0xe7,0x47,
		0x27,0x85,0x60,0xc7,0xf3,0xae,0xb1,0x5c,0x70,0xd5,0x65,0x1f,0x8a,0x79,0xf9,0x85,
		0x52,0xba,0x8a,0xe5,0x43,0x79,0x2d,0x8c,0xf7,0xe0,0xff,0x00,0x3a,0x8a,0x3b,0xa9,
		0x91,0x42,0x30,0xcb,0x1e,0x0e,0x05,0x3a,0x34,0xbb,0x33,0xee,0xdf,0xf2,0x9e,0xab,
		0xc6,0x3f,0xc6,0xae,0xa2,0x95,0x39,0x14,0xad,0x20,0x15,0x5a,0xe6,0x5f,0x93,0xad,
		0x72,0xd7,0xcf,0xbe,0xee,0x43,0x9c,0xe0,0xe2,0xa2,0x5c,0x71,0xf5,0xe6,0xaf,0xe9,
		0xd2,0x94,0x99,0x48,0x38,0x65,0x39,0x15,0xd7,0xfd,0x3a,0x51,0x45,0x61,0x78,0x96,
		0x03,0xfb,0xb9,0xf9,0x2a,0x46,0xc3,0xec,0x46,0x48,0xfe,0x67,0xf2,0xac,0x40,0x84,
		0xdb,0x67,0xd0,0xd4,0x1d,0xfe,0xb5,0xbf,0xa7,0xdc,0x19,0xad,0x14,0xb1,0xc9,0x1c,
		0x1f,0xad,0x68,0x44,0x4f,0x63,0x53,0x89,0x31,0x4b,0x24,0xd1,0xa2,0xe5,0xdc,0x28,
		0xf7,0x35,0x02,0xdc,0xda,0xb9,0xe2,0x64,0xe3,0xf0,0x34,0xe5,0xbc,0xb5,0xdd,0x81,
		0x32,0xe7,0xdf,0x8a,0x90,0xb8,0x61,0x90,0x47,0xb1,0x1c,0xd4,0x72,0x9f,0x6a,0xce,
		0xbb,0x90,0x24,0x6c,0xc4,0xf0,0xa3,0x35,0xce,0x9c,0x93,0x93,0xde,0x95,0x4e,0x08,
		0xab,0x16,0xe7,0x0e,0xac,0xa7,0x90,0x6b,0xb2,0xb5,0x7f,0x32,0xda,0x36,0xff,0x00,
		0x64,0x0a,0x96,0x8a,0xa3,0xac,0xc5,0xe6,0xe9,0xb2,0x71,0x92,0xa4,0x30,0xfc,0xff,
		0x00,0xc0,0x9a,0xe7,0xfc,0xb0,0x96,0x59,0x3d,0x73,0x59,0xec,0x30,0xc7,0xd8,0xd5,
		0xcd,0x2e,0x63,0x1c,0xcd,0x19,0x3f,0x2b,0x0c,0xfe,0x35,0xb9,0x0c,0x82,0x9f,0x26,
		0x5f,0xa3,0x11,0x54,0xe6,0xb1,0x0c,0xfb,0xdd,0xde,0x5f,0x66,0x34,0x82,0xd6,0xd0,
		0xf5,0x49,0x01,0xf6,0x63,0x4e,0x36,0x56,0xee,0x30,0x91,0x91,0xee,0xc4,0xe6,0xac,
		0x41,0x6c,0x96,0xe0,0x08,0xcb,0x63,0xd3,0x71,0x34,0xf9,0xa4,0x01,0x71,0x58,0x9a,
		0xa4,0xe0,0x81,0x12,0x9e,0x4f,0x2d,0xcd,0x67,0x01,0x4b,0x8c,0xb0,0xa9,0xa1,0x8d,
		0x98,0xe5,0x06,0x70,0x09,0x3f,0x4a,0xec,0x2c,0x10,0x25,0xa2,0x61,0x98,0x86,0x19,
		0xc1,0xe8,0x0f,0x7c,0x55,0x8a,0x29,0x0a,0x86,0x52,0xac,0x32,0x08,0xc1,0x1e,0xa2,
		0xb9,0x8d,0x48,0xa8,0x41,0x1a,0x0e,0x17,0x82,0x7d,0xeb,0x2d,0x86,0x5b,0xeb,0x8a,
		0x20,0x6d,0x92,0xa9,0x15,0xb3,0x1c,0x98,0xe0,0xfe,0x75,0x7a,0x12,0x1d,0x78,0x3c,
		0xd4,0xeb,0x06,0xe1,0x8c,0x8a,0x43,0x69,0x4e,0xfb,0x38,0x41,0x51,0xc8,0xc2,0x31,
		0xcf,0x4a,0xce,0xba,0xb8,0xda,0xa7,0x1c,0x91,0x58,0x45,0x8b,0xbe,0xe6,0xe4,0x93,
		0x4e,0xcf,0x24,0xf6,0xa1,0x3a,0x56,0xae,0x8f,0x0b,0xc8,0xec,0x14,0x91,0xbd,0x76,
		0x9c,0x77,0x04,0xf3,0xfc,0xab,0xa7,0x55,0x0a,0xa1,0x47,0x40,0x31,0x4b,0x45,0x55,
		0xbd,0xb9,0xf2,0xe3,0x28,0x8d,0x87,0xc7,0x27,0xd0,0x57,0x39,0x70,0xdb,0x99,0xff,
		0x00,0x31,0x54,0xdb,0xa2,0x9c,0x7b,0x54,0x47,0x82,0x78,0xad,0x68,0xce,0xe8,0x55,
		0x87,0x71,0x4e,0x8e,0xe1,0xa1,0x39,0x3d,0x2b,0x46,0x1b,0xf8,0xd8,0x73,0x80,0x6a,
		0x71,0x76,0x84,0x75,0x1f,0x9d,0x47,0x25,0xec,0x60,0x7d,0xe1,0xf9,0xd6,0x74,0xd7,
		0x2f,0x70,0xd8,0x40,0x70,0x7b,0xd4,0x53,0xc7,0xb2,0xdd,0x8e,0x0e,0x48,0xac,0x71,
		0x4a,0x4f,0x18,0xa7,0xa9,0xc2,0xf4,0xae,0x83,0xc3,0xd2,0xc6,0xa8,0xc1,0x8e,0x19,
		0xb0,0x01,0xf6,0xff,0x00,0xf5,0xd6,0xe5,0x15,0x4a,0x5b,0x8d,0x89,0x9b,0x83,0xb5,
		0xba,0x84,0x15,0x97,0x35,0xc1,0x6d,0xc4,0x93,0x8e,0xb8,0x3f,0xce,0xb3,0x2e,0x1b,
		0x18,0x3d,0x7a,0xe6,0xa2,0x5f,0x98,0x91,0x9e,0xf9,0xa8,0xd8,0x10,0x2b,0x42,0xc5,
		0xb7,0x43,0xb4,0xf6,0x35,0x2b,0xaf,0x04,0x54,0x0f,0x1f,0xa7,0x5a,0x66,0xd9,0xfa,
		0x29,0xfd,0x6a,0x68,0xad,0x89,0x20,0xbf,0x35,0x76,0x28,0x80,0xc6,0x05,0x45,0x78,
		0x7f,0x74,0xc0,0x7a,0x56,0x29,0x5c,0x73,0x48,0x54,0x83,0x46,0xe2,0x48,0x1e,0xf5,
		0x3c,0x57,0x32,0xc5,0xb5,0x91,0xc8,0x60,0x30,0x3b,0xf1,0xe9,0x5a,0x56,0xda,0xdc,
		0xf1,0x80,0xb2,0x63,0x6f,0xa8,0x15,0xb2,0x97,0x37,0x45,0x41,0x30,0x02,0x0f,0x20,
		0x8e,0x84,0x57,0x3e,0xad,0x31,0x3f,0x3c,0x81,0x7f,0x53,0x51,0x4d,0x2e,0x1f,0xcb,
		0x53,0xc7,0x73,0xea,0x6a,0xac,0xaf,0xbd,0xcf,0xa0,0xa6,0x2b,0xe1,0xf3,0xda,0xa4,
		0x73,0xb9,0x73,0xde,0xac,0x58,0x3e,0x19,0x97,0xd7,0x15,0xa1,0xd4,0x50,0x17,0x3d,
		0x45,0x48,0xb1,0x8e,0xf4,0xed,0xa0,0x70,0x3a,0xd3,0x88,0xc0,0xcd,0x57,0x9f,0x95,
		0xc5,0x65,0xc8,0x98,0x72,0xb8,0xc7,0x26,0xa4,0xb5,0x84,0x4d,0x87,0x73,0x80,0x2a,
		0x9b,0x10,0x64,0x24,0x70,0xb9,0xe3,0xe9,0x46,0x79,0xa3,0x71,0xe2,0xa6,0x4b,0x99,
		0x95,0x40,0x59,0x5c,0x01,0xd8,0x31,0xa5,0x33,0x9c,0x1d,0xbd,0x4f,0x15,0x13,0x1d,
		0xa0,0x8c,0xfc,0xc7,0xaf,0xb5,0x47,0x40,0x1c,0xd3,0xc1,0x3b,0x6a,0x6b,0x73,0xb6,
		0x40,0x7d,0xeb,0x52,0x36,0xe3,0x1e,0xd5,0x20,0xf5,0xa5,0xc9,0xa7,0x03,0x4a,0x49,
		0x35,0x11,0x5c,0xf6,0xaa,0x97,0x10,0xe0,0x87,0xc7,0x43,0x93,0x55,0x25,0x76,0x84,
		0x3c,0x4a,0x4e,0x09,0xcd,0x56,0xef,0x41,0xe2,0x90,0x52,0xe7,0x14,0xed,0xea,0x83,
		0xe5,0x19,0x3e,0xa6,0x98,0x49,0x34,0x0a,0x72,0x7d,0xef,0xa5,0x03,0xbd,0x5a,0xb7,
		0x4c,0xb6,0x71,0xe9,0x5a,0x08,0x3d,0xbb,0x54,0xa0,0x0c,0xf1,0x4b,0x4f,0x00,0xd3,
		0xd6,0x33,0xdc,0x53,0xd2,0x1c,0x9a,0x65,0xd4,0x4b,0x1c,0x6c,0xcf,0xc0,0x03,0x9a,
		0xe7,0x70,0x25,0xde,0xc4,0x90,0xdc,0x6d,0x18,0xce,0x7b,0x53,0x18,0x15,0x7d,0xa7,
		0xa8,0x38,0x34,0xc3,0x9c,0xd2,0xd1,0x49,0x45,0x14,0xbf,0x4f,0xc6,0x9c,0x80,0xb1,
		0x00,0x75,0x35,0xb3,0x69,0x6d,0xfb,0xbc,0x8e,0xe7,0xf4,0xab,0x9f,0x67,0x38,0xfa,
		0x0a,0x55,0x87,0x27,0x9a,0x77,0x91,0xcd,0x38,0x42,0x41,0xe9,0x53,0xa4,0x27,0xd2,
		0xa5,0x54,0x0a,0x39,0x15,0x8b,0xe2,0x0b,0x9d,0xa1,0x60,0x46,0xe5,0x8e,0x5b,0x07,
		0xb5,0x61,0x06,0x65,0x39,0x04,0x83,0xea,0x0d,0x27,0x42,0x3e,0xb4,0x1e,0xb4,0x51,
		0x9a,0x4a,0x01,0xc1,0xcd,0x2e,0x68,0x03,0xbd,0x28,0x24,0x74,0x35,0xd3,0xe9,0x92,
		0x25,0xc5,0xb2,0xc8,0xa3,0x04,0x7c,0xac,0x3d,0x0d,0x5f,0x08,0x29,0x42,0x73,0x9e,
		0xb4,0xbe,0x58,0xa5,0x08,0x01,0xa7,0xd4,0x53,0xca,0xb1,0x44,0xce,0xc4,0x00,0x06,
		0x49,0x35,0xc7,0x5d,0xdc,0x1b,0x8b,0x87,0x94,0xe7,0xe6,0x3c,0x67,0xb0,0xed,0x50,
		0x0a,0x3b,0x8a,0x28,0xa5,0x15,0x3f,0xf6,0x75,0xf7,0xfc,0xf9,0xdc,0x7f,0xdf,0xa6,
		0xff,0x00,0x0a,0x4f,0xec,0xeb,0xef,0xf9,0xf3,0xb8,0xff,0x00,0xbf,0x4d,0xfe,0x14,
		0xa3,0x4f,0xbd,0xff,0x00,0x9f,0x3b,0x8f,0xfb,0xf4,0xdf,0xe1,0x4b,0xfd,0x9f,0x7d,
		0xff,0x00,0x3e,0x77,0x1f,0xf7,0xe9,0xbf,0xc2,0x81,0xa7,0xdf,0x7f,0xcf,0x9d,0xc7,
		0xfd,0xfa,0x6f,0xf0,0xad,0x2d,0x16,0x2b,0xcb,0x6b,0x83,0x1c,0x96,0xb3,0x88,0xe4,
		0xee,0x63,0x38,0x04,0x56,0xf8,0x46,0xc7,0xdc,0x6f,0xca,0x9c,0x11,0xbf,0xba,0xdf,
		0x95,0x3b,0x6b,0x63,0xee,0x9f,0xca,0x82,0xad,0xfd,0xd3,0xf9,0x53,0x08,0x7e,0x7e,
		0x46,0xfc,0xab,0x27,0x5a,0x17,0x4f,0x00,0x8a,0x08,0x26,0x6d,0xe7,0xe6,0x2a,0x84,
		0xe0,0x56,0x4a,0x68,0xf7,0xb2,0x23,0xb7,0x90,0xea,0x55,0x37,0xe1,0x90,0x8c,0xfb,
		0x0f,0x7f,0x6a,0x87,0xfb,0x3a,0xf7,0xfe,0x7c,0xee,0x3f,0xef,0xdb,0x7f,0x85,0x27,
		0xf6,0x75,0xee,0x7f,0xe3,0xce,0xe3,0xfe,0xfd,0x37,0xf8,0x51,0xfd,0x9d,0x7d,0xff,
		0x00,0x3e,0x77,0x1f,0xf7,0xe9,0xbf,0xc2,0x8f,0xec,0xfb,0xef,0xf9,0xf3,0xb8,0xff,
		0x00,0xbf,0x4d,0xfe,0x14,0xbf,0xd9,0xf7,0xbf,0xf3,0xe7,0x71,0xff,0x00,0x7e,0x9b,
		0xfc,0x2b,0xff,0xd9,
	};
    poEmulationCard->PutTransparentEF("3F00DF014035",
        CByteArray(tuc3F00DF014035, (unsigned long) sizeof(tuc3F00DF014035)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(PuK#7 ID) (CA role ID)
    unsigned char tuc3F00DF014038[] = { // TODO: is wrong!
        0x04,0x87,0x46,0xe9,0x09,0xf6,0x51,0xcf,0x9d,0x65,0x2c,0x59,0x18,0xf6,0xa6,0x3b,
        0xa2,0xd8,0x34,0xaa,
	};
    poEmulationCard->PutTransparentEF("3F00DF014038",
        CByteArray(tuc3F00DF014038, (unsigned long) sizeof(tuc3F00DF014038)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Preferences)
    unsigned char tuc3F00DF014039[] = {
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF014039",
        CByteArray(tuc3F00DF014039, (unsigned long) sizeof(tuc3F00DF014039)), AC_ALWAYS, 0, AC_PIN, 1);

	// Auth key
	unsigned char tucAuthMod[] = {
		0x00,0x9f,0x6a,0x13,0x30,0x30,0x18,0xb1,0x1d,0x6e,0xa3,0x84,0x0e,0x69,0x23,
		0x43,0x93,0xe6,0x16,0x07,0xdc,0x0f,0x50,0xbd,0x59,0x0e,0x10,0x36,0x17,0xf2,
		0xb0,0x24,0x93,0x5c,0x10,0x2b,0x9d,0xd2,0x7c,0x40,0x55,0xfe,0x15,0xe7,0x8b,
		0xd9,0x5b,0x0d,0xfb,0x73,0x5d,0x52,0xd5,0x69,0xb2,0x16,0xc8,0x29,0xde,0x41,
		0xd0,0x60,0x8f,0xbf,0x75,0x1b,0x25,0x1f,0xf8,0x2e,0x5f,0xe9,0x2d,0xb6,0x40,
		0xe9,0x63,0xe6,0xe7,0x41,0x99,0x09,0x90,0xbf,0xac,0xd6,0x58,0x60,0xad,0xb3,
		0xe0,0xe7,0x6e,0x20,0xbf,0x6b,0xd3,0xde,0x3c,0x2c,0xbb,0x70,0x20,0x40,0xd1,
		0x3b,0x8a,0xe4,0x68,0xde,0x71,0x0f,0xd3,0x44,0xd2,0x98,0x62,0x02,0xfb,0xe3,
		0x3f,0xc4,0xb9,0x86,0xd7,0xa4,0x50,0x46,0x5d
	};
	unsigned char tucAuthPrivExp[] = {
		0x26,0x68,0x7a,0x43,0x0b,0xf3,0x87,0x08,0xde,0x55,0x4b,0x45,0xe5,0x92,0xf7,
		0x7f,0x34,0xda,0x6d,0xfe,0x59,0x3a,0x4c,0xc4,0x9e,0x1c,0xcd,0xcb,0xab,0x4f,
		0x41,0x20,0xb7,0xf7,0xb5,0x6a,0x8b,0x02,0x20,0xc6,0x17,0x37,0xd3,0xd7,0xe0,
		0x00,0x8e,0x37,0xdd,0x2d,0xc8,0xfd,0x5e,0x3f,0xe8,0x39,0x45,0xcd,0x24,0xf2,
		0x3d,0xb1,0xa4,0xa1,0x02,0xc5,0x6c,0x17,0x48,0x57,0x01,0xa4,0x1d,0xbb,0xa0,
		0x95,0xa4,0xd9,0x3a,0x47,0x6b,0x16,0xd5,0xda,0x83,0x6a,0x17,0x35,0x92,0xff,
		0x53,0x51,0xfe,0x9b,0xba,0x8c,0xad,0x0c,0x73,0xdc,0x8e,0x95,0xd9,0xc2,0xef,
		0x16,0xb3,0x74,0xee,0x68,0xed,0xaa,0xb9,0xcf,0xae,0x7f,0x20,0x83,0x64,0x84,
		0x5d,0x01,0x86,0x03,0xd3,0x72,0x72,0x89
	};
	poEmulationCard->PutRsaKey(CByteArray(tucAuthPrivExp, sizeof(tucAuthPrivExp)),
		CByteArray(tucAuthMod, sizeof(tucAuthMod)),
		"3F00", 0x8A, 0x01, false,
		ALGO_RSA_PKCS1_MD5 | ALGO_RSA_PKCS1_SHA1 | ALGO_RSA_PKCS1);

	// Signature key
	unsigned char tucSignMod[] = {
		0x00,0xa9,0xd9,0x08,0x25,0xac,0xeb,0x70,0x63,0xbc,0xeb,0x01,0x53,0x50,0x86,
		0xb9,0x09,0x50,0xc1,0x50,0xba,0xbd,0xca,0x63,0xdc,0xb0,0x27,0x0d,0x9a,0x6a,
		0x5e,0xee,0x22,0x95,0xe9,0x5c,0x65,0x65,0x58,0x6b,0x10,0x2e,0xcb,0xba,0x09,
		0x36,0xd7,0xc4,0xc1,0x48,0x10,0x88,0xd3,0x3f,0x7d,0x3d,0x93,0xf4,0x26,0x6e,
		0x2f,0x2e,0xf5,0x5c,0xe4,0x00,0x9c,0x72,0xb5,0x00,0xb4,0x6f,0xc4,0xf1,0xf3,
		0xf5,0x45,0x04,0x27,0xcd,0x66,0xd5,0xce,0x84,0xfd,0x89,0x77,0x98,0x61,0x87,
		0x91,0x70,0x48,0x04,0x42,0xd5,0xd7,0x01,0xb7,0x74,0x76,0x73,0x06,0x82,0xc9,
		0x13,0x98,0x5a,0xfb,0x82,0x59,0xe0,0x05,0x5d,0xa2,0x1a,0x98,0x09,0x4d,0x89,
		0xd2,0x3b,0x2f,0xf6,0x51,0xb1,0xbe,0x57,0xe7
	};
	unsigned char tucSignPrivExp[] = {
		0x6d,0x8b,0x08,0x72,0x24,0x20,0x85,0x10,0x0e,0x9c,0x12,0xf2,0xc5,0x10,0xde,
		0xee,0x5f,0x23,0x0f,0x0a,0x21,0xb6,0x12,0xca,0x16,0xe2,0x59,0x27,0xaa,0x4b,
		0x27,0x93,0x2e,0xd4,0x9f,0x3e,0xd6,0x2a,0x3c,0x82,0xe7,0x6b,0x85,0xc4,0xc3,
		0x96,0x4d,0xd3,0xca,0xc2,0xbf,0x3c,0x5f,0xca,0x4a,0x98,0xcd,0xf2,0xab,0x45,
		0xcb,0x27,0x7c,0x8c,0x91,0x40,0xba,0x3f,0x8b,0x4f,0x0c,0xdd,0x47,0xb1,0x4a,
		0xa1,0x89,0xda,0x17,0x00,0x9c,0xa0,0xef,0x97,0x16,0xf0,0xee,0x4b,0xec,0x3e,
		0xcc,0xf5,0xbf,0x35,0x2c,0x01,0xd0,0xb8,0x7a,0x45,0x10,0x80,0x6b,0x75,0xa7,
		0x49,0xa8,0x97,0x4c,0x0b,0xd5,0x38,0xf5,0x3e,0x80,0xa0,0x7d,0x64,0xd9,0x30,
		0x1c,0x6c,0x74,0x88,0x97,0x41,0x15,0x41
	};
	poEmulationCard->PutRsaKey(CByteArray(tucSignPrivExp, sizeof(tucSignPrivExp)),
		CByteArray(tucSignMod, sizeof(tucSignMod)),
		"3F00", 0x8B, 0x01, true,
		ALGO_RSA_PKCS1_MD5 | ALGO_RSA_PKCS1_SHA1 | ALGO_RSA_PKCS1);

	m_bBeidV2Test1Initialized = true;

	return poEmulationCard;
}

/////////////////////////////////////////////////////////////////////////////////
// Real eID card with revoked certs (old Erwin Vermoesen card); no keys present

static CEmulationBeidCard *m_BeidV1Test3 = NULL;
static bool m_bBeidV1Test3Initialized = false;

CEmulationCard * CEmulationCardFactory::MakeBeidV1Test3()
{
	if(!m_bCardInitialized)
		Init();

	CEmulationBeidCard *poEmulationCard = m_BeidV1Test3;

	if (m_bBeidV1Test3Initialized)
		return poEmulationCard; // already intialized

	unsigned char tucATR[] =
		{0x3B,0x98,0x13,0x40,0x0A,0xA5,0x03,0x01,0x01,0x01,0xAD,0x13,0x11};
	poEmulationCard->SetATR(CByteArray(tucATR, sizeof(tucATR)));

	// MF
	poEmulationCard->PutPin("3F00",
		1, "1234", 4, 12, 8, PIN_ENC_GP, 3, 0xFF,
		"12345678", 0);

	// Belpic DF
	unsigned char tucBelpicAID[] = {0xA0,0x00,0x00,0x01,0x77,0x50,0x4B,0x43,0x53,0x2D,0x31,0x35};
	poEmulationCard->PutDF("3F00DF00", CByteArray(tucBelpicAID, sizeof(tucBelpicAID)));

	// ID DF
	poEmulationCard->PutDF("3F00DF01");


    // EF(DIR)
    unsigned char tuc3F002F00[] = {
        0x61,0x23,0x4f,0x0c,0xa0,0x00,0x00,0x01,0x77,0x50,0x4b,0x43,0x53,0x2d,0x31,0x35,
        0x50,0x06,0x42,0x45,0x4c,0x50,0x49,0x43,0x51,0x04,0x3f,0x00,0xdf,0x00,0x73,0x05,
        0x06,0x03,0x60,0x38,0x02,
    };
    poEmulationCard->PutTransparentEF("3F002F00",
        CByteArray(tuc3F002F00, (unsigned long) sizeof(tuc3F002F00)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ODF)
    unsigned char tuc3F00DF005031[] = {
        0xa0,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x35,0xa4,0x0a,0x30,0x08,
        0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x37,0xa8,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,
        0xdf,0x00,0x50,0x34,
    };
    poEmulationCard->PutTransparentEF("3F00DF005031",
        CByteArray(tuc3F00DF005031, (unsigned long) sizeof(tuc3F00DF005031)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(TokenInfo)
    unsigned char tuc3F00DF005032[] = {
        0x30,0x27,0x02,0x01,0x00,0x04,0x10,0x53,0x4c,0x49,0x4e,0x33,0x66,0x00,0x29,0x6c,
        0xff,0x24,0x71,0x9b,0x18,0x13,0x20,0x80,0x06,0x42,0x45,0x4c,0x50,0x49,0x43,0x03,
        0x02,0x04,0x30,0x9e,0x04,0x01,0x01,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005032",
        CByteArray(tuc3F00DF005032, (unsigned long) sizeof(tuc3F00DF005032)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(AODF)
    unsigned char tuc3F00DF005034[] = {
        0x30,0x33,0x30,0x0f,0x0c,0x09,0x42,0x61,0x73,0x69,0x63,0x20,0x50,0x49,0x4e,0x03,
        0x02,0x06,0xc0,0x30,0x03,0x04,0x01,0x01,0xa1,0x1b,0x30,0x19,0x03,0x02,0x02,0x0c,
        0x0a,0x01,0x00,0x02,0x01,0x04,0x02,0x01,0x08,0x80,0x01,0x01,0x04,0x01,0xff,0x30,
        0x04,0x04,0x02,0x3f,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005034",
        CByteArray(tuc3F00DF005034, (unsigned long) sizeof(tuc3F00DF005034)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(PrKDF)
    unsigned char tuc3F00DF005035[] = {
        0x30,0x3a,0x30,0x17,0x0c,0x0e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,
        0x74,0x69,0x6f,0x6e,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x0f,0x04,0x01,0x02,
        0x03,0x02,0x05,0x20,0x03,0x02,0x03,0xb8,0x02,0x02,0x00,0x82,0xa1,0x0e,0x30,0x0c,
        0x30,0x06,0x04,0x04,0x3f,0x00,0xdf,0x00,0x02,0x02,0x04,0x00,0x30,0x39,0x30,0x15,
        0x0c,0x09,0x53,0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x03,0x02,0x06,0xc0,0x04,
        0x01,0x01,0x02,0x01,0x01,0x30,0x10,0x04,0x01,0x03,0x03,0x03,0x06,0x00,0x40,0x03,
        0x02,0x03,0xb8,0x02,0x02,0x00,0x83,0xa1,0x0e,0x30,0x0c,0x30,0x06,0x04,0x04,0x3f,
        0x00,0xdf,0x00,0x02,0x02,0x04,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF005035",
        CByteArray(tuc3F00DF005035, (unsigned long) sizeof(tuc3F00DF005035)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(CDF)
    unsigned char tuc3F00DF005037[] = {
        0x30,0x2c,0x30,0x17,0x0c,0x0e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,
        0x74,0x69,0x6f,0x6e,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x03,0x04,0x01,0x02,
        0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x38,0x30,0x27,
        0x30,0x12,0x0c,0x09,0x53,0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x03,0x02,0x06,
        0xc0,0x04,0x01,0x01,0x30,0x03,0x04,0x01,0x03,0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,
        0x06,0x3f,0x00,0xdf,0x00,0x50,0x39,0x30,0x23,0x30,0x0b,0x0c,0x02,0x43,0x41,0x03,
        0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x06,0x04,0x01,0x04,0x01,0x01,0xff,0xa1,0x0c,
        0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,0x00,0x50,0x3a,0x30,0x25,0x30,0x0d,
        0x0c,0x04,0x52,0x6f,0x6f,0x74,0x03,0x02,0x06,0xc0,0x04,0x01,0x01,0x30,0x06,0x04,
        0x01,0x06,0x01,0x01,0xff,0xa1,0x0c,0x30,0x0a,0x30,0x08,0x04,0x06,0x3f,0x00,0xdf,
        0x00,0x50,0x3b,
    };
    poEmulationCard->PutTransparentEF("3F00DF005037",
        CByteArray(tuc3F00DF005037, (unsigned long) sizeof(tuc3F00DF005037)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#2) (authentication)
    unsigned char tuc3F00DF005038[] = {
        0x30,0x82,0x03,0xdb,0x30,0x82,0x02,0xc3,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x10,
        0x00,0x00,0x00,0x00,0x00,0xf7,0x00,0x2d,0x12,0xa1,0x81,0xfd,0x44,0xaf,0xab,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x22,
        0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x13,0x30,
        0x11,0x06,0x03,0x55,0x04,0x03,0x13,0x0a,0x43,0x69,0x74,0x69,0x7a,0x65,0x6e,0x20,
        0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x34,0x31,0x30,0x32,0x38,0x30,0x37,0x30,0x31,
        0x34,0x36,0x5a,0x17,0x0d,0x30,0x39,0x31,0x30,0x32,0x38,0x30,0x37,0x30,0x31,0x34,
        0x36,0x5a,0x30,0x79,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,
        0x45,0x31,0x29,0x30,0x27,0x06,0x03,0x55,0x04,0x03,0x13,0x20,0x45,0x72,0x77,0x69,
        0x6e,0x20,0x56,0x65,0x72,0x6d,0x6f,0x65,0x73,0x65,0x6e,0x20,0x28,0x41,0x75,0x74,
        0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x29,0x31,0x12,0x30,0x10,
        0x06,0x03,0x55,0x04,0x04,0x13,0x09,0x56,0x65,0x72,0x6d,0x6f,0x65,0x73,0x65,0x6e,
        0x31,0x15,0x30,0x13,0x06,0x03,0x55,0x04,0x2a,0x13,0x0c,0x45,0x72,0x77,0x69,0x6e,
        0x20,0x50,0x65,0x74,0x72,0x75,0x73,0x31,0x14,0x30,0x12,0x06,0x03,0x55,0x04,0x05,
        0x13,0x0b,0x35,0x37,0x30,0x38,0x32,0x31,0x32,0x35,0x31,0x38,0x31,0x30,0x81,0x9f,
        0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,
        0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0x82,0x87,0xdb,0x85,0x49,0x50,
        0x62,0xdd,0x3c,0x8b,0xe5,0x1f,0x99,0xc7,0x72,0xb4,0xe6,0x0b,0x43,0xc4,0x14,0xc1,
        0x38,0x7c,0xa1,0x71,0x71,0xda,0xc4,0xac,0x8f,0x33,0x3e,0xf8,0x00,0x53,0xc1,0xb6,
        0x32,0x6d,0x63,0x50,0x58,0x9d,0x80,0x35,0x4a,0xa1,0x20,0x17,0x53,0x09,0xc9,0x65,
        0x6e,0x96,0x36,0xf5,0xcd,0x41,0x16,0x20,0x2c,0xf2,0x5d,0xc9,0x75,0x07,0x1e,0xba,
        0x21,0x27,0xc3,0xb6,0xab,0x2d,0x3a,0x5f,0x28,0x4b,0x1e,0x3f,0x37,0xe6,0x9d,0x71,
        0x03,0x94,0xa9,0xb7,0x85,0x3d,0x13,0xd0,0x1c,0xd0,0x07,0x02,0x8c,0x72,0xc2,0x99,
        0x79,0x5c,0x6c,0xd5,0x47,0x5b,0xc1,0xf3,0x06,0xaf,0x69,0xca,0x57,0x6c,0xf3,0x5e,
        0x17,0x77,0x53,0x73,0x43,0xc1,0xa0,0x28,0x1d,0x27,0x02,0x03,0x01,0x00,0x01,0xa3,
        0x82,0x01,0x38,0x30,0x82,0x01,0x34,0x30,0x44,0x06,0x03,0x55,0x1d,0x20,0x04,0x3d,
        0x30,0x3b,0x30,0x39,0x06,0x07,0x60,0x38,0x01,0x01,0x01,0x02,0x02,0x30,0x2e,0x30,
        0x2c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x20,0x68,0x74,0x74,
        0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,
        0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x0e,0x06,
        0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x07,0x80,0x30,0x1f,0x06,
        0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x3f,0x0d,0x64,0xad,0xf1,0x6d,
        0x81,0x16,0xb9,0x5c,0x93,0x7a,0xba,0xc6,0x59,0x89,0x6a,0x7e,0x66,0x32,0x30,0x39,
        0x06,0x03,0x55,0x1d,0x1f,0x04,0x32,0x30,0x30,0x30,0x2e,0xa0,0x2c,0xa0,0x2a,0x86,
        0x28,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,0x2e,
        0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x2f,0x65,0x69,0x64,0x63,0x32,
        0x30,0x30,0x34,0x2d,0x31,0x2e,0x63,0x72,0x6c,0x30,0x11,0x06,0x09,0x60,0x86,0x48,
        0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x05,0xa0,0x30,0x6d,0x06,0x08,
        0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01,0x04,0x61,0x30,0x5f,0x30,0x35,0x06,0x08,
        0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02,0x86,0x29,0x68,0x74,0x74,0x70,0x3a,0x2f,
        0x2f,0x63,0x65,0x72,0x74,0x73,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,
        0x75,0x6d,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x72,0x73,0x2e,
        0x63,0x72,0x74,0x30,0x26,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x86,
        0x1a,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x6f,0x63,0x73,0x70,0x2e,0x65,0x69,0x64,
        0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x0d,0x06,0x09,0x2a,
        0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0xa4,
        0x87,0x72,0x82,0xd1,0xc6,0xe2,0x94,0x11,0x8b,0xcb,0x20,0x13,0x3e,0x21,0x76,0x8a,
        0x27,0x38,0x65,0x7e,0xf9,0x3a,0xb3,0x01,0x82,0xc9,0xde,0xe4,0x35,0x30,0x3a,0x34,
        0xa0,0xbf,0xe4,0xb5,0xa0,0xa3,0xbb,0xe3,0x39,0x2a,0x9b,0x25,0xf1,0xac,0x05,0x22,
        0x1a,0xcc,0x77,0x3e,0x19,0x78,0x53,0x93,0x90,0x41,0x72,0xd8,0x47,0x50,0x63,0x2d,
        0x57,0xe8,0xcc,0xec,0x5c,0xf9,0xc6,0x46,0x70,0xf5,0x2f,0x1c,0xb7,0x8d,0xea,0xc8,
        0x4a,0xf8,0xf1,0xb1,0xab,0x51,0xf0,0x1f,0x79,0x55,0x4a,0xd7,0x59,0x69,0x9d,0xb3,
        0x24,0x31,0x24,0xb3,0x4d,0xb9,0xfe,0xf2,0x94,0x6a,0x80,0xe2,0xa8,0xbe,0xd5,0x04,
        0xb3,0x27,0x43,0xa2,0xa8,0x41,0x53,0x9a,0xb6,0x60,0x59,0x54,0xaa,0x64,0x6d,0x22,
        0x13,0x34,0x9d,0x45,0x56,0x1b,0x9e,0x65,0x3d,0xad,0x89,0x96,0x06,0xb4,0x75,0x7c,
        0x78,0xde,0x87,0x4d,0x43,0xe5,0x38,0x01,0xcf,0x17,0xaa,0x59,0x1f,0x83,0x91,0xd8,
        0x26,0x47,0xdf,0xb1,0x3d,0x7c,0x6b,0xf8,0x41,0xe6,0x8e,0x7e,0x0b,0x5d,0xfe,0xbc,
        0x95,0x0c,0xd3,0x70,0xdc,0x30,0x61,0x25,0x66,0x28,0x83,0xb1,0x61,0x20,0xbf,0xe7,
        0x84,0x0d,0xc9,0x14,0x72,0xfc,0x3b,0xdf,0x0d,0xba,0xee,0x61,0x35,0x23,0x10,0x11,
        0x68,0x07,0x9c,0x06,0x7b,0xaa,0x3e,0x52,0xa0,0xc6,0x7a,0x4b,0x01,0x6f,0x26,0x9f,
        0xd6,0x75,0x0f,0x97,0xc9,0xc0,0x34,0x77,0x93,0x72,0x37,0xbc,0x59,0x62,0x09,0x3e,
        0xac,0xd8,0x28,0x32,0x08,0x3b,0x88,0x09,0x86,0x14,0xaf,0x32,0x6b,0xb4,0x32,
    };
    poEmulationCard->PutTransparentEF("3F00DF005038",
        CByteArray(tuc3F00DF005038, (unsigned long) sizeof(tuc3F00DF005038)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#3) (non-repudiation)
    unsigned char tuc3F00DF005039[] = {
        0x30,0x82,0x03,0xf0,0x30,0x82,0x02,0xd8,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x10,
        0x00,0x00,0x00,0x00,0x00,0x3d,0x9d,0xbb,0xb8,0x42,0x7a,0xf7,0xf0,0x76,0x7e,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x22,
        0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x13,0x30,
        0x11,0x06,0x03,0x55,0x04,0x03,0x13,0x0a,0x43,0x69,0x74,0x69,0x7a,0x65,0x6e,0x20,
        0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x34,0x31,0x30,0x32,0x38,0x30,0x37,0x30,0x31,
        0x34,0x36,0x5a,0x17,0x0d,0x30,0x39,0x31,0x30,0x32,0x38,0x30,0x37,0x30,0x31,0x34,
        0x36,0x5a,0x30,0x74,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,
        0x45,0x31,0x24,0x30,0x22,0x06,0x03,0x55,0x04,0x03,0x13,0x1b,0x45,0x72,0x77,0x69,
        0x6e,0x20,0x56,0x65,0x72,0x6d,0x6f,0x65,0x73,0x65,0x6e,0x20,0x28,0x53,0x69,0x67,
        0x6e,0x61,0x74,0x75,0x72,0x65,0x29,0x31,0x12,0x30,0x10,0x06,0x03,0x55,0x04,0x04,
        0x13,0x09,0x56,0x65,0x72,0x6d,0x6f,0x65,0x73,0x65,0x6e,0x31,0x15,0x30,0x13,0x06,
        0x03,0x55,0x04,0x2a,0x13,0x0c,0x45,0x72,0x77,0x69,0x6e,0x20,0x50,0x65,0x74,0x72,
        0x75,0x73,0x31,0x14,0x30,0x12,0x06,0x03,0x55,0x04,0x05,0x13,0x0b,0x35,0x37,0x30,
        0x38,0x32,0x31,0x32,0x35,0x31,0x38,0x31,0x30,0x81,0x9f,0x30,0x0d,0x06,0x09,0x2a,
        0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,0x81,0x8d,0x00,0x30,0x81,
        0x89,0x02,0x81,0x81,0x00,0x83,0x7a,0xa6,0xe2,0xa9,0x9b,0x0f,0xba,0x58,0x94,0x9e,
        0x8c,0xab,0x76,0xb0,0xcd,0xc9,0x8d,0x88,0xa0,0xf7,0xe0,0xd9,0x04,0xb2,0x06,0xbe,
        0x47,0x14,0x54,0x8a,0x75,0x65,0xd4,0xa1,0xc6,0x55,0xf5,0xd9,0x1b,0x13,0x31,0xe4,
        0xfe,0x0e,0x4f,0xc2,0x5f,0xf6,0x92,0xed,0x2c,0x6d,0x38,0x92,0x05,0xac,0xcc,0xf8,
        0x63,0x48,0x8a,0x64,0x62,0x40,0x01,0x1b,0x0b,0x26,0x0d,0x33,0xfb,0x33,0x7a,0xe6,
        0xb0,0xa2,0x2e,0x9e,0x6a,0xdc,0x1a,0x2b,0x0c,0x1b,0xa3,0xc0,0x4f,0x5d,0x02,0xd6,
        0xb5,0xf0,0x02,0x11,0x7a,0x68,0xa7,0x03,0x23,0xea,0xb8,0x83,0xc8,0xa8,0x53,0x07,
        0x62,0x17,0x87,0x40,0xff,0x84,0xe1,0x4e,0xb5,0x28,0xd1,0xb3,0x36,0xe7,0xab,0x88,
        0xcf,0xf5,0xc4,0x92,0xd9,0x02,0x03,0x01,0x00,0x01,0xa3,0x82,0x01,0x52,0x30,0x82,
        0x01,0x4e,0x30,0x44,0x06,0x03,0x55,0x1d,0x20,0x04,0x3d,0x30,0x3b,0x30,0x39,0x06,
        0x07,0x60,0x38,0x01,0x01,0x01,0x02,0x01,0x30,0x2e,0x30,0x2c,0x06,0x08,0x2b,0x06,
        0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x20,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,
        0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,
        0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,
        0x01,0xff,0x04,0x04,0x03,0x02,0x06,0x40,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,
        0x18,0x30,0x16,0x80,0x14,0x3f,0x0d,0x64,0xad,0xf1,0x6d,0x81,0x16,0xb9,0x5c,0x93,
        0x7a,0xba,0xc6,0x59,0x89,0x6a,0x7e,0x66,0x32,0x30,0x39,0x06,0x03,0x55,0x1d,0x1f,
        0x04,0x32,0x30,0x30,0x30,0x2e,0xa0,0x2c,0xa0,0x2a,0x86,0x28,0x68,0x74,0x74,0x70,
        0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,
        0x75,0x6d,0x2e,0x62,0x65,0x2f,0x65,0x69,0x64,0x63,0x32,0x30,0x30,0x34,0x2d,0x31,
        0x2e,0x63,0x72,0x6c,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,
        0x01,0x04,0x04,0x03,0x02,0x05,0x20,0x30,0x6d,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,
        0x07,0x01,0x01,0x04,0x61,0x30,0x5f,0x30,0x35,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,
        0x07,0x30,0x02,0x86,0x29,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x65,0x72,0x74,
        0x73,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,
        0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x72,0x73,0x2e,0x63,0x72,0x74,0x30,0x26,
        0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x86,0x1a,0x68,0x74,0x74,0x70,
        0x3a,0x2f,0x2f,0x6f,0x63,0x73,0x70,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,
        0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x18,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,
        0x01,0x03,0x04,0x0c,0x30,0x0a,0x30,0x08,0x06,0x06,0x04,0x00,0x8e,0x46,0x01,0x01,
        0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,
        0x82,0x01,0x01,0x00,0x69,0x3d,0x38,0xf3,0x78,0x34,0x28,0x09,0x33,0x8b,0x4f,0xb2,
        0x10,0x21,0x40,0xa9,0x0a,0x69,0x86,0x05,0xae,0x10,0x5d,0x0b,0x82,0x6b,0x61,0x8a,
        0x02,0xca,0x40,0x0c,0xd3,0x02,0xbc,0x09,0xd8,0x8a,0x50,0xf9,0xe3,0x2c,0xc4,0x00,
        0xa5,0x4f,0x06,0x54,0x6e,0xc0,0xce,0x6d,0xb7,0x0d,0x41,0x50,0xa1,0x22,0x8f,0x4f,
        0x5f,0xfc,0x1b,0x97,0x1c,0xbf,0xc1,0x4a,0x0a,0x20,0xba,0x77,0x12,0x77,0x76,0xee,
        0x57,0x6f,0x3e,0xf1,0x66,0x2b,0x3e,0x09,0x7b,0x07,0x8c,0x03,0x2a,0x7c,0x7f,0x55,
        0xdd,0x45,0x6f,0x16,0xdd,0x8a,0xb7,0x98,0x21,0x83,0x90,0xdb,0x6b,0x3e,0xc5,0xf3,
        0x9a,0x18,0xdd,0x0b,0x34,0x3e,0x1e,0x8c,0xbb,0xd3,0x5e,0x16,0x8b,0x16,0xd6,0x33,
        0x4c,0xa6,0x66,0x78,0xd8,0x35,0x06,0xba,0x03,0x0c,0xe6,0x96,0xd8,0x77,0x69,0x68,
        0x0f,0xf7,0x31,0x0d,0x15,0x7d,0x86,0x90,0x1c,0x68,0x78,0xbb,0x1c,0x18,0xa5,0xdc,
        0x1a,0xa4,0x73,0xb8,0x51,0x14,0xb0,0x62,0x3d,0x63,0x17,0x20,0x99,0x35,0x6c,0xc9,
        0xb0,0x1c,0x57,0x82,0xe3,0x0b,0xaa,0xf7,0xfc,0x4b,0x2c,0xb0,0x61,0x57,0xf7,0x58,
        0xad,0xe3,0x5f,0xad,0x69,0x59,0x0b,0x81,0xe7,0x09,0x96,0x68,0x3d,0xd9,0x6f,0x18,
        0x11,0xcb,0xdc,0xe7,0xfc,0x7f,0xc3,0x7e,0x57,0x1b,0x72,0x66,0x05,0xa4,0xf3,0xb7,
        0xb1,0xa4,0x7e,0x0c,0x03,0xe0,0xa8,0x8c,0x6c,0x62,0x42,0x90,0x99,0xc5,0x87,0x20,
        0xcd,0xca,0x12,0xd2,0xea,0x9d,0x8f,0x77,0xe8,0xbc,0x61,0x65,0x07,0xdc,0x4f,0x8e,
        0x38,0xb3,0x51,0x87,
    };
    poEmulationCard->PutTransparentEF("3F00DF005039",
        CByteArray(tuc3F00DF005039, (unsigned long) sizeof(tuc3F00DF005039)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#4) (CA)
    unsigned char tuc3F00DF00503A[] = {
        0x30,0x82,0x03,0xcb,0x30,0x82,0x02,0xb3,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x79,
        0x76,0xbd,0x57,0xc4,0xc4,0x93,0xc3,0x7e,0x54,0x0a,0x34,0xd6,0x2b,0x6e,0x98,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x27,
        0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,
        0x16,0x06,0x03,0x55,0x04,0x03,0x13,0x0f,0x42,0x65,0x6c,0x67,0x69,0x75,0x6d,0x20,
        0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x33,0x31,0x32,0x31,
        0x35,0x31,0x33,0x30,0x30,0x30,0x30,0x5a,0x17,0x0d,0x31,0x30,0x30,0x38,0x31,0x35,
        0x31,0x32,0x30,0x30,0x30,0x30,0x5a,0x30,0x22,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,
        0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x13,0x30,0x11,0x06,0x03,0x55,0x04,0x03,0x13,
        0x0a,0x43,0x69,0x74,0x69,0x7a,0x65,0x6e,0x20,0x43,0x41,0x30,0x82,0x01,0x22,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,0x82,
        0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,0x01,0x01,0x00,0xae,0x6f,0xfc,0xf4,
        0x1c,0x59,0x78,0x31,0x55,0xcd,0xdf,0xa2,0xfd,0x6e,0xd4,0xa3,0x40,0x24,0xb6,0x5f,
        0xad,0xf6,0xf7,0x7e,0x6e,0x7a,0x8c,0xb6,0x44,0x9a,0xf2,0x30,0x9c,0xdc,0x61,0x83,
        0x1e,0x08,0xcf,0x0f,0x4e,0x0e,0x92,0x1e,0xd4,0x9c,0x6e,0x42,0xe1,0xb6,0x42,0x63,
        0xa9,0x7b,0x86,0x7e,0xbc,0x63,0xd6,0x37,0x77,0x6d,0x2f,0xb4,0x62,0x43,0x28,0xfb,
        0xe1,0xe8,0x68,0xcd,0x61,0x72,0xcc,0x43,0x6e,0x7b,0x1c,0xc0,0x79,0xb1,0xe3,0xbc,
        0x2a,0x32,0x9e,0x94,0x5c,0xa6,0xe0,0x12,0xa4,0x77,0xcd,0x56,0x76,0x09,0x43,0x84,
        0x0e,0xb4,0x2c,0x7f,0xf2,0xe9,0xd2,0xe1,0x1f,0x69,0xd2,0xcf,0xf0,0x60,0xc6,0xa6,
        0xa4,0xfd,0x77,0x02,0x60,0x22,0x70,0xcd,0xaa,0x4d,0x1b,0xfc,0x01,0xe0,0x41,0x9a,
        0xfa,0x81,0x83,0xa3,0x8c,0x27,0xe9,0xe8,0xa4,0xff,0x3b,0xcf,0x84,0x91,0x96,0xff,
        0xce,0x94,0x90,0xc6,0x2c,0x8a,0xca,0xf2,0xc6,0x14,0x8e,0x2a,0x3a,0x3b,0xfa,0x8c,
        0x95,0x6c,0xa5,0x76,0xd0,0xa6,0xd3,0x20,0x40,0xd2,0xd9,0xe9,0x51,0x74,0xba,0xcc,
        0xf3,0xd4,0x15,0xce,0xb3,0xa9,0xf8,0xed,0xf2,0x99,0x3c,0x72,0x9c,0x02,0xc2,0x5d,
        0xef,0xb9,0x28,0x19,0xda,0xc8,0x74,0x4e,0x2b,0xa9,0x3e,0xf4,0xbd,0x5f,0xdb,0x87,
        0x72,0x3f,0xfa,0x00,0x4a,0x59,0xc3,0x07,0x87,0xc3,0x32,0x44,0x8a,0xdc,0xe5,0x99,
        0x9b,0xf6,0xd4,0xac,0x55,0x3e,0xde,0x03,0xf8,0x1b,0x23,0xe1,0x60,0xa1,0x14,0x17,
        0x6c,0x54,0x2c,0xe8,0x5b,0xc6,0x0c,0x1c,0xb8,0x80,0x6d,0xbf,0x02,0x03,0x01,0x00,
        0x01,0xa3,0x81,0xf7,0x30,0x81,0xf4,0x30,0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,
        0xff,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x12,0x06,0x03,0x55,0x1d,0x13,0x01,0x01,
        0xff,0x04,0x08,0x30,0x06,0x01,0x01,0xff,0x02,0x01,0x00,0x30,0x43,0x06,0x03,0x55,
        0x1d,0x20,0x04,0x3c,0x30,0x3a,0x30,0x38,0x06,0x06,0x60,0x38,0x01,0x01,0x01,0x02,
        0x30,0x2e,0x30,0x2c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x20,
        0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,
        0x79,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,
        0x30,0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0x3f,0x0d,0x64,0xad,0xf1,
        0x6d,0x81,0x16,0xb9,0x5c,0x93,0x7a,0xba,0xc6,0x59,0x89,0x6a,0x7e,0x66,0x32,0x30,
        0x36,0x06,0x03,0x55,0x1d,0x1f,0x04,0x2f,0x30,0x2d,0x30,0x2b,0xa0,0x29,0xa0,0x27,
        0x86,0x25,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,
        0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,0x67,
        0x69,0x75,0x6d,0x2e,0x63,0x72,0x6c,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,
        0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x00,0x07,0x30,0x1f,0x06,0x03,0x55,0x1d,
        0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x10,0xf0,0x0c,0x56,0x9b,0x61,0xea,0x57,0x3a,
        0xb6,0x35,0x97,0x6d,0x9f,0xdd,0xb9,0x14,0x8e,0xdb,0xe6,0x30,0x0d,0x06,0x09,0x2a,
        0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0xc2,
        0x73,0x46,0xc3,0x8f,0x5c,0x5d,0x83,0x50,0xca,0x3f,0xbe,0x6e,0xaf,0xe6,0xa9,0xdb,
        0x70,0xf5,0x74,0xdb,0x19,0xd8,0x73,0x4f,0x81,0xa8,0x9a,0x0d,0x58,0x71,0x56,0xd2,
        0xcc,0x1a,0xf7,0x0d,0x5f,0x8f,0xc0,0x4b,0xb9,0x8a,0x3f,0x19,0x43,0x00,0xc8,0x77,
        0xa9,0xaf,0x60,0x49,0xa8,0xcb,0xb4,0x01,0xdf,0xac,0x03,0xee,0x27,0x3c,0x4b,0xc8,
        0x7a,0x91,0x10,0xa0,0xc1,0x6b,0x01,0xde,0xf0,0x69,0x14,0x6d,0x8f,0x9a,0xd8,0x79,
        0x60,0x02,0xbf,0xa0,0x2b,0x4a,0xbb,0x8f,0x3a,0xe5,0x74,0x17,0x0a,0xc7,0x57,0x5e,
        0x07,0x2e,0x74,0x12,0x63,0x8e,0x21,0x46,0xbe,0xc3,0x93,0x61,0xca,0xc9,0xbc,0xc4,
        0x31,0x0c,0xff,0x16,0xc6,0xf3,0x9d,0x8c,0xb6,0x3d,0x4f,0x3e,0x8c,0x2b,0xb0,0xc8,
        0x87,0xda,0x20,0xec,0x0f,0x02,0x8b,0x04,0x5a,0xc0,0x78,0x74,0x60,0x1e,0x30,0x91,
        0x04,0xa4,0x72,0x79,0x17,0xce,0xee,0x9b,0x37,0xc7,0x76,0xe6,0x60,0x41,0x94,0x01,
        0xb1,0x56,0x8f,0x14,0xa1,0xc7,0x5e,0xfd,0x59,0xf8,0xcc,0xc5,0xd7,0x2a,0xe2,0x98,
        0x10,0xf4,0x57,0x8c,0xa7,0xf4,0x32,0x6f,0xfb,0x34,0x6f,0x2b,0x80,0x0e,0xcc,0xed,
        0x98,0x95,0x96,0x4a,0xc3,0x0e,0x4e,0xa2,0x17,0x7b,0xd1,0x85,0x48,0xd8,0x69,0x73,
        0xbf,0xa4,0xdd,0x5c,0xc1,0x45,0x5a,0xa2,0x39,0x4b,0x0e,0xff,0xcb,0xdf,0x79,0x3b,
        0x88,0x0d,0xc9,0x87,0x5b,0xdc,0xb2,0x4b,0x86,0x74,0xd5,0x51,0x6f,0xc3,0xd1,0x64,
        0xac,0x8e,0x17,0x49,0x2c,0xa1,0x93,0xe7,0x77,0xa6,0xbd,0xc5,0xd6,0xc5,0x4a,
    };
    poEmulationCard->PutTransparentEF("3F00DF00503A",
        CByteArray(tuc3F00DF00503A, (unsigned long) sizeof(tuc3F00DF00503A)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#6) (root)
    unsigned char tuc3F00DF00503B[] = {
        0x30,0x82,0x03,0x94,0x30,0x82,0x02,0x7c,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x58,
        0x0b,0x05,0x6c,0x53,0x24,0xdb,0xb2,0x50,0x57,0x18,0x5f,0xf9,0xe5,0xa6,0x50,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x27,
        0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,
        0x16,0x06,0x03,0x55,0x04,0x03,0x13,0x0f,0x42,0x65,0x6c,0x67,0x69,0x75,0x6d,0x20,
        0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x33,0x30,0x31,0x32,
        0x36,0x32,0x33,0x30,0x30,0x30,0x30,0x5a,0x17,0x0d,0x31,0x34,0x30,0x31,0x32,0x36,
        0x32,0x33,0x30,0x30,0x30,0x30,0x5a,0x30,0x27,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,
        0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x03,0x13,
        0x0f,0x42,0x65,0x6c,0x67,0x69,0x75,0x6d,0x20,0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,
        0x30,0x82,0x01,0x22,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,
        0x01,0x05,0x00,0x03,0x82,0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,0x01,0x01,
        0x00,0xc8,0xa1,0x71,0xe9,0x1c,0x46,0x42,0x79,0x78,0x71,0x6f,0x9d,0xae,0xa9,0xa8,
        0xab,0x28,0xb7,0x4d,0xc7,0x20,0xeb,0x30,0x91,0x5a,0x75,0xf5,0xe2,0xd2,0xcf,0xc8,
        0x4c,0x14,0x98,0x42,0x58,0xad,0xc7,0x11,0xc5,0x40,0x40,0x6a,0x5a,0xf9,0x74,0x12,
        0x27,0x87,0xe9,0x9c,0xe5,0x71,0x4e,0x22,0x2c,0xd1,0x12,0x18,0xaa,0x30,0x5e,0xa2,
        0x21,0xb9,0xd9,0xbb,0xff,0xf6,0x74,0xeb,0x31,0x01,0xe7,0x3b,0x7e,0x58,0x0f,0x91,
        0x16,0x4d,0x76,0x89,0xa8,0x01,0x4f,0xad,0x22,0x66,0x70,0xfa,0x4b,0x1d,0x95,0xc1,
        0x30,0x58,0xea,0xbc,0xd9,0x65,0xd8,0x9a,0xb4,0x88,0xeb,0x49,0x46,0x52,0xdf,0xd2,
        0x53,0x15,0x76,0xcb,0x14,0x5d,0x19,0x49,0xb1,0x6f,0x6a,0xd3,0xd3,0xfd,0xbc,0xc2,
        0x2d,0xec,0x45,0x3f,0x09,0x3f,0x58,0xbe,0xfc,0xd4,0xef,0x00,0x8c,0x81,0x35,0x72,
        0xbf,0xf7,0x18,0xea,0x96,0x62,0x7d,0x2b,0x28,0x7f,0x15,0x6c,0x63,0xd2,0xca,0xca,
        0x7d,0x05,0xac,0xc8,0x6d,0x07,0x6d,0x32,0xbe,0x68,0xb8,0x05,0x40,0xae,0x54,0x98,
        0x56,0x3e,0x66,0xf1,0x30,0xe8,0xef,0xc4,0xab,0x93,0x5e,0x07,0xde,0x32,0x8f,0x12,
        0x74,0xaa,0x5b,0x34,0x23,0x54,0xc0,0xea,0x6c,0xce,0xfe,0x36,0x92,0xa8,0x09,0x17,
        0xea,0xa1,0x2d,0xcf,0x6c,0xe3,0x84,0x1d,0xde,0x87,0x2e,0x33,0x0b,0x3c,0x74,0xe2,
        0x21,0x50,0x38,0x95,0x2e,0x5c,0xe0,0xe5,0xc6,0x31,0xf9,0xdb,0x40,0xfa,0x6a,0xa1,
        0xa4,0x8a,0x93,0x9b,0xa7,0x21,0x06,0x87,0x1d,0x27,0xd3,0xc4,0xa1,0xc9,0x4c,0xb0,
        0x6f,0x02,0x03,0x01,0x00,0x01,0xa3,0x81,0xbb,0x30,0x81,0xb8,0x30,0x0e,0x06,0x03,
        0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x0f,0x06,0x03,
        0x55,0x1d,0x13,0x01,0x01,0xff,0x04,0x05,0x30,0x03,0x01,0x01,0xff,0x30,0x42,0x06,
        0x03,0x55,0x1d,0x20,0x04,0x3b,0x30,0x39,0x30,0x37,0x06,0x05,0x60,0x38,0x01,0x01,
        0x01,0x30,0x2e,0x30,0x2c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,
        0x20,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,
        0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,
        0x65,0x30,0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0x10,0xf0,0x0c,0x56,
        0x9b,0x61,0xea,0x57,0x3a,0xb6,0x35,0x97,0x6d,0x9f,0xdd,0xb9,0x14,0x8e,0xdb,0xe6,
        0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,
        0x02,0x00,0x07,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,
        0x10,0xf0,0x0c,0x56,0x9b,0x61,0xea,0x57,0x3a,0xb6,0x35,0x97,0x6d,0x9f,0xdd,0xb9,
        0x14,0x8e,0xdb,0xe6,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,
        0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0xc8,0x6d,0x22,0x51,0x8a,0x61,0xf8,0x0f,
        0x96,0x6e,0xd5,0x20,0xb2,0x81,0xf8,0xc6,0xdc,0xa3,0x16,0x00,0xda,0xcd,0x6a,0xe7,
        0x6b,0x2a,0xfa,0x59,0x48,0xa7,0x4c,0x49,0x37,0xd7,0x73,0xa1,0x6a,0x01,0x65,0x5e,
        0x32,0xbd,0xe7,0x97,0xd3,0xd0,0x2e,0x3c,0x73,0xd3,0x8c,0x7b,0x83,0xef,0xd6,0x42,
        0xc1,0x3f,0xa8,0xa9,0x5d,0x0f,0x37,0xba,0x76,0xd2,0x40,0xbd,0xcc,0x2d,0x3f,0xd3,
        0x44,0x41,0x49,0x9c,0xfd,0x5b,0x29,0xf4,0x02,0x23,0x22,0x5b,0x71,0x1b,0xbf,0x58,
        0xd9,0x28,0x4e,0x2d,0x45,0xf4,0xda,0xe7,0xb5,0x63,0x45,0x44,0x11,0x0d,0x2a,0x7f,
        0x33,0x7f,0x36,0x49,0xb4,0xce,0x6e,0xa9,0x02,0x31,0xae,0x5c,0xfd,0xc8,0x89,0xbf,
        0x42,0x7b,0xd7,0xf1,0x60,0xf2,0xd7,0x87,0xf6,0x57,0x2e,0x7a,0x7e,0x6a,0x13,0x80,
        0x1d,0xdc,0xe3,0xd0,0x63,0x1e,0x3d,0x71,0x31,0xb1,0x60,0xd4,0x9e,0x08,0xca,0xab,
        0xf0,0x94,0xc7,0x48,0x75,0x54,0x81,0xf3,0x1b,0xad,0x77,0x9c,0xe8,0xb2,0x8f,0xdb,
        0x83,0xac,0x8f,0x34,0x6b,0xe8,0xbf,0xc3,0xd9,0xf5,0x43,0xc3,0x64,0x55,0xeb,0x1a,
        0xbd,0x36,0x86,0x36,0xba,0x21,0x8c,0x97,0x1a,0x21,0xd4,0xea,0x2d,0x3b,0xac,0xba,
        0xec,0xa7,0x1d,0xab,0xbe,0xb9,0x4a,0x9b,0x35,0x2f,0x1c,0x5c,0x1d,0x51,0xa7,0x1f,
        0x54,0xed,0x12,0x97,0xff,0xf2,0x6e,0x87,0x7d,0x46,0xc9,0x74,0xd6,0xef,0xeb,0x3d,
        0x7d,0xe6,0x59,0x6e,0x06,0x94,0x04,0xe4,0xa2,0x55,0x87,0x38,0x28,0x6a,0x22,0x5e,
        0xe2,0xbe,0x74,0x12,0xb0,0x04,0x43,0x2a,
    };
    poEmulationCard->PutTransparentEF("3F00DF00503B",
        CByteArray(tuc3F00DF00503B, (unsigned long) sizeof(tuc3F00DF00503B)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Cert#8) (RN)
    unsigned char tuc3F00DF00503C[] = {
        0x30,0x82,0x03,0xb9,0x30,0x82,0x02,0xa1,0xa0,0x03,0x02,0x01,0x02,0x02,0x0b,0x01,
        0x00,0x00,0x00,0x00,0x00,0xfa,0x39,0x92,0xb2,0x10,0x30,0x0d,0x06,0x09,0x2a,0x86,
        0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x25,0x31,0x0b,0x30,0x09,0x06,
        0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x16,0x30,0x14,0x06,0x03,0x55,0x04,
        0x03,0x13,0x0d,0x47,0x6f,0x76,0x65,0x72,0x6e,0x6d,0x65,0x6e,0x74,0x20,0x43,0x41,
        0x30,0x1e,0x17,0x0d,0x30,0x34,0x30,0x31,0x32,0x31,0x31,0x37,0x35,0x35,0x33,0x32,
        0x5a,0x17,0x0d,0x31,0x30,0x30,0x31,0x32,0x31,0x31,0x37,0x35,0x35,0x33,0x32,0x5a,
        0x30,0x29,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,
        0x0c,0x30,0x0a,0x06,0x03,0x55,0x04,0x03,0x13,0x03,0x52,0x52,0x4e,0x31,0x0c,0x30,
        0x0a,0x06,0x03,0x55,0x04,0x0a,0x13,0x03,0x52,0x52,0x4e,0x30,0x81,0x9f,0x30,0x0d,
        0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,0x81,0x8d,
        0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0xc4,0x98,0xe3,0x8c,0xd3,0x9b,0xe3,0x2a,
        0xb0,0x69,0x0f,0xa1,0xdf,0xa5,0xad,0xbe,0xd0,0x89,0x86,0x4c,0x74,0x9e,0xf3,0x1f,
        0xba,0xd3,0x48,0x5a,0x8c,0x4d,0xb2,0x70,0xa9,0xd2,0x1a,0xf2,0xfb,0x63,0xd3,0x23,
        0x45,0x8d,0x62,0xfd,0x9e,0x4c,0x78,0xe6,0xf9,0x93,0xcc,0x21,0x3e,0x75,0xae,0x3b,
        0x78,0x52,0x95,0x4a,0x69,0xb9,0xcc,0x51,0x4f,0x96,0xa3,0x32,0x9d,0x57,0xba,0xcd,
        0x05,0x48,0x72,0xe4,0x45,0x0b,0x1a,0xef,0xea,0x59,0x58,0xb7,0x60,0x0d,0x08,0xaa,
        0x8c,0x86,0x85,0xcb,0xec,0xa0,0x65,0xb9,0x6c,0x53,0xc2,0x60,0xac,0x85,0x1c,0xe6,
        0x2a,0xad,0xc1,0xc7,0xc4,0x14,0xa7,0x3a,0x6f,0x90,0x3f,0x80,0x00,0x7b,0x24,0xf7,
        0xdf,0x62,0xca,0x40,0xe7,0xf2,0x2c,0xab,0x02,0x03,0x01,0x00,0x01,0xa3,0x82,0x01,
        0x68,0x30,0x82,0x01,0x64,0x30,0x44,0x06,0x03,0x55,0x1d,0x20,0x04,0x3d,0x30,0x3b,
        0x30,0x39,0x06,0x07,0x60,0x38,0x01,0x01,0x01,0x03,0x01,0x30,0x2e,0x30,0x2c,0x06,
        0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x20,0x68,0x74,0x74,0x70,0x3a,
        0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,
        0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x0e,0x06,0x03,0x55,
        0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x06,0xc0,0x30,0x1f,0x06,0x03,0x55,
        0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x68,0xcb,0x1e,0x8c,0xd7,0x35,0xb8,0x28,
        0x40,0x57,0xe6,0x1a,0x9b,0x3e,0xc7,0x9a,0x37,0xcc,0x7d,0x67,0x30,0x1d,0x06,0x03,
        0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0x50,0x41,0xc3,0xf5,0x9b,0xd3,0x01,0x6b,0xd3,
        0x67,0x54,0x4d,0x4d,0x24,0x24,0x6a,0x20,0xfe,0x7a,0x7e,0x30,0x3f,0x06,0x03,0x55,
        0x1d,0x1f,0x04,0x38,0x30,0x36,0x30,0x34,0xa0,0x32,0xa0,0x30,0x86,0x2e,0x68,0x74,
        0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,
        0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x2f,0x67,0x6f,0x76,0x65,0x72,0x6e,0x6d,0x65,
        0x6e,0x74,0x32,0x30,0x30,0x34,0x2d,0x31,0x2e,0x63,0x72,0x6c,0x30,0x09,0x06,0x03,
        0x55,0x1d,0x13,0x04,0x02,0x30,0x00,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,
        0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x04,0xb0,0x30,0x6d,0x06,0x08,0x2b,0x06,
        0x01,0x05,0x05,0x07,0x01,0x01,0x04,0x61,0x30,0x5f,0x30,0x35,0x06,0x08,0x2b,0x06,
        0x01,0x05,0x05,0x07,0x30,0x02,0x86,0x29,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,
        0x65,0x72,0x74,0x73,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,
        0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x72,0x73,0x2e,0x63,0x72,
        0x74,0x30,0x26,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x86,0x1a,0x68,
        0x74,0x74,0x70,0x3a,0x2f,0x2f,0x6f,0x63,0x73,0x70,0x2e,0x65,0x69,0x64,0x2e,0x62,
        0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,
        0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0xb0,0x89,0xe6,
        0x9b,0xee,0xb8,0x00,0x5f,0xab,0x42,0x48,0xb3,0xc1,0x9a,0x9b,0xdf,0xcd,0x5e,0x1a,
        0xaa,0x35,0x91,0x32,0x14,0x3a,0x64,0x5c,0xae,0xc1,0x45,0xb5,0xb2,0x83,0xc9,0x58,
        0x6e,0xa5,0xc6,0x65,0x63,0x3c,0xfa,0x40,0x87,0xb4,0x87,0x41,0xee,0xb2,0xbd,0x21,
        0x10,0x31,0x80,0x2c,0x32,0x7a,0xf2,0xa2,0xed,0x51,0x6c,0xe1,0x7d,0xfe,0xf3,0x31,
        0x4b,0xd0,0x47,0xd1,0xac,0x16,0x94,0x6e,0x6f,0xe8,0xfc,0x41,0x29,0xe9,0xa5,0xa3,
        0xd8,0x64,0xa6,0xc6,0x49,0x86,0x6a,0xa6,0xce,0x7a,0xb8,0xec,0x47,0x1b,0xdd,0x02,
        0x6b,0x6a,0x85,0x3c,0xd2,0xf5,0x95,0xf4,0x54,0xa9,0xc1,0x3c,0xab,0xbb,0x7f,0xa9,
        0x3f,0x34,0x82,0x37,0x5c,0x59,0x83,0x18,0x2d,0xe2,0x26,0xd0,0xd8,0x08,0xaa,0x92,
        0xbf,0x6c,0xc0,0x55,0x2b,0x64,0x65,0x94,0xec,0xe5,0x11,0x2b,0xb6,0x5c,0x28,0x6f,
        0x48,0x10,0x8a,0x02,0x13,0xf5,0xfb,0x7d,0x05,0x43,0x50,0xa6,0x35,0xe5,0x52,0x5d,
        0xe7,0x7d,0xe3,0x24,0xb2,0xf5,0x04,0xff,0x35,0xd9,0x09,0x2d,0xac,0x03,0x15,0xa4,
        0x73,0x5f,0x0c,0x9c,0x35,0x45,0x7d,0x80,0xed,0x6d,0x12,0xe1,0xd7,0x49,0xc2,0x15,
        0x26,0x84,0x34,0x5d,0xd8,0x4e,0xbf,0x86,0x5c,0x23,0x4c,0xbb,0x18,0xed,0xe9,0xd4,
        0x42,0x44,0xae,0x31,0x61,0xb2,0x92,0xed,0xad,0xb3,0xf1,0x9c,0x32,0x61,0x0f,0x53,
        0x91,0xc6,0x14,0x32,0x04,0x01,0x58,0x7f,0x3d,0xaa,0xd9,0x51,0xd1,0x47,0x84,0xd1,
        0xa6,0x3e,0xdd,0xf0,0x77,0x27,0xd7,0x7a,0x2e,0x01,0x5e,0x9a,0x89,
    };
    poEmulationCard->PutTransparentEF("3F00DF00503C",
        CByteArray(tuc3F00DF00503C, (unsigned long) sizeof(tuc3F00DF00503C)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#RN)
    unsigned char tuc3F00DF014031[] = {
        0x01,0x0c,0x35,0x39,0x30,0x30,0x31,0x32,0x31,0x30,0x32,0x30,0x38,0x37,0x02,0x10,
        0x53,0x4c,0x49,0x4e,0x33,0x66,0x00,0x29,0x6c,0xff,0x24,0x71,0x9b,0x18,0x13,0x20,
        0x03,0x0a,0x30,0x36,0x2e,0x30,0x39,0x2e,0x32,0x30,0x30,0x34,0x04,0x0a,0x30,0x36,
        0x2e,0x30,0x39,0x2e,0x32,0x30,0x30,0x39,0x05,0x06,0x48,0x61,0x61,0x63,0x68,0x74,
        0x06,0x0b,0x35,0x37,0x30,0x38,0x32,0x31,0x32,0x35,0x31,0x38,0x31,0x07,0x09,0x56,
        0x65,0x72,0x6d,0x6f,0x65,0x73,0x65,0x6e,0x08,0x0c,0x45,0x72,0x77,0x69,0x6e,0x20,
        0x50,0x65,0x74,0x72,0x75,0x73,0x09,0x01,0x4a,0x0a,0x04,0x42,0x65,0x6c,0x67,0x0b,
        0x08,0x4e,0x65,0x65,0x72,0x70,0x65,0x6c,0x74,0x0c,0x0c,0x32,0x31,0x20,0x41,0x55,
        0x47,0x20,0x20,0x31,0x39,0x35,0x37,0x0d,0x01,0x4d,0x0e,0x00,0x0f,0x01,0x31,0x10,
        0x01,0x30,0x11,0x14,0xfb,0x9c,0x1c,0xa3,0x60,0x9d,0x3d,0x65,0x11,0xab,0xe3,0x8d,
        0xd2,0xa5,0x5d,0x14,0x2b,0xca,0xfb,0x4c,
    };
    poEmulationCard->PutTransparentEF("3F00DF014031",
        CByteArray(tuc3F00DF014031, (unsigned long) sizeof(tuc3F00DF014031)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(SGN#RN)
    unsigned char tuc3F00DF014032[] = {
        0x0d,0xdf,0xfd,0x0c,0x45,0x8c,0x1f,0x3b,0x82,0xe8,0x7a,0x48,0x03,0x13,0x01,0xd0,
        0x95,0x2f,0x0c,0x32,0xcd,0x95,0x7c,0x59,0x27,0x86,0xaa,0xe3,0x33,0x18,0x91,0x68,
        0x34,0x22,0xf5,0x59,0x6b,0x40,0x39,0xb7,0x90,0x8c,0x9f,0xfd,0x1e,0x79,0xfb,0x44,
        0xd4,0x66,0x7e,0x4a,0xff,0x6f,0xe7,0xf1,0x5c,0x63,0xc6,0x8d,0x17,0x45,0xc4,0x80,
        0xe7,0x5a,0x2b,0x5f,0xc2,0xdc,0xaf,0xca,0xb6,0x83,0x48,0x60,0x41,0x50,0xfa,0xe5,
        0x71,0x51,0xab,0x92,0xdf,0x20,0x35,0x4e,0xb6,0xfd,0x9c,0xe4,0xb4,0xce,0x30,0x00,
        0x68,0xbb,0x24,0x15,0xbb,0x35,0xcd,0x4c,0x18,0x19,0xda,0xaa,0x8c,0x1c,0x21,0x61,
        0x1f,0x10,0x81,0xf2,0xea,0x0d,0x71,0xdf,0x8b,0xd1,0x3e,0x40,0xe1,0x57,0xf5,0x9f,
    };
    poEmulationCard->PutTransparentEF("3F00DF014032",
        CByteArray(tuc3F00DF014032, (unsigned long) sizeof(tuc3F00DF014032)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#Address)
    unsigned char tuc3F00DF014033[] = {
        0x01,0x11,0x4a,0x65,0x6e,0x6e,0x65,0x6b,0x65,0x6e,0x73,0x73,0x74,0x72,0x61,0x61,
        0x74,0x20,0x31,0x02,0x04,0x33,0x31,0x35,0x30,0x03,0x06,0x48,0x61,0x61,0x63,0x68,
        0x74,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF014033",
        CByteArray(tuc3F00DF014033, (unsigned long) sizeof(tuc3F00DF014033)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(SGN#Address)
    unsigned char tuc3F00DF014034[] = {
        0x67,0x36,0x0a,0xf3,0x43,0x96,0x6e,0x37,0x1d,0xc6,0xdf,0xe9,0xf0,0x52,0x56,0x5a,
        0x0e,0x96,0x4b,0x28,0x9c,0xc5,0xad,0x0b,0xb3,0x3f,0x2e,0xd6,0x6d,0xd3,0xf6,0x87,
        0xf8,0xe5,0xe8,0x1e,0x5f,0x7f,0x12,0xcf,0x65,0x3f,0x67,0x0f,0x01,0x60,0x7e,0x32,
        0x47,0x5e,0x38,0x37,0x60,0x6f,0x3f,0x16,0xb4,0x0a,0x4a,0xe9,0xa1,0x6c,0x17,0x81,
        0x96,0x02,0xb5,0x5c,0xab,0x2f,0xd8,0x74,0x38,0xff,0xad,0xe0,0x17,0xed,0xe2,0x71,
        0xed,0xe4,0x5a,0x20,0xbe,0x0b,0x52,0x90,0x47,0x72,0xae,0xd9,0x90,0xa9,0x12,0x16,
        0x5e,0x2a,0xde,0x63,0xcc,0x95,0xa6,0xe9,0x53,0x95,0x82,0x65,0x10,0xc6,0x0d,0x14,
        0x55,0x57,0x97,0xa4,0x36,0xcd,0x2e,0xca,0x08,0x63,0x86,0xd3,0xff,0x23,0x22,0x5c,
    };
    poEmulationCard->PutTransparentEF("3F00DF014034",
        CByteArray(tuc3F00DF014034, (unsigned long) sizeof(tuc3F00DF014034)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(ID#Photo)
    unsigned char tuc3F00DF014035[] = {
        0xff,0xd8,0xff,0xe0,0x00,0x10,0x4a,0x46,0x49,0x46,0x00,0x01,0x02,0x01,0x01,0x2c,
        0x01,0x2c,0x00,0x00,0xff,0xdb,0x00,0x43,0x00,0x19,0x11,0x13,0x16,0x13,0x10,0x19,
        0x16,0x14,0x16,0x1c,0x1b,0x19,0x1e,0x25,0x3e,0x29,0x25,0x22,0x22,0x25,0x4c,0x37,
        0x3a,0x2d,0x3e,0x5a,0x50,0x5f,0x5e,0x59,0x50,0x57,0x56,0x64,0x70,0x90,0x7a,0x64,
        0x6a,0x88,0x6c,0x56,0x57,0x7d,0xaa,0x7e,0x88,0x94,0x99,0xa1,0xa2,0xa1,0x61,0x78,
        0xb0,0xbd,0xaf,0x9c,0xbb,0x90,0x9e,0xa1,0x9a,0xff,0xc0,0x00,0x0b,0x08,0x00,0xc8,
        0x00,0x8c,0x01,0x01,0x11,0x00,0xff,0xc4,0x00,0xd2,0x00,0x00,0x01,0x05,0x01,0x01,
        0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,
        0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x10,0x00,0x02,0x01,0x03,0x03,0x02,0x04,0x03,
        0x05,0x05,0x04,0x04,0x00,0x00,0x01,0x7d,0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
        0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,0x22,0x71,0x14,0x32,0x81,0x91,0xa1,0x08,
        0x23,0x42,0xb1,0xc1,0x15,0x52,0xd1,0xf0,0x24,0x33,0x62,0x72,0x82,0x09,0x0a,0x16,
        0x17,0x18,0x19,0x1a,0x25,0x26,0x27,0x28,0x29,0x2a,0x34,0x35,0x36,0x37,0x38,0x39,
        0x3a,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
        0x5a,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
        0x7a,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
        0x99,0x9a,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,0xb5,0xb6,
        0xb7,0xb8,0xb9,0xba,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xd2,0xd3,0xd4,
        0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,
        0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xff,0xda,0x00,0x08,0x01,0x01,
        0x00,0x00,0x3f,0x00,0xea,0x68,0xa2,0x8a,0x28,0xa2,0x8a,0x28,0xa2,0x8a,0x28,0xa2,
        0x8a,0x28,0xa2,0x8a,0x28,0xa2,0xa2,0x9e,0xe2,0x1b,0x74,0xdf,0x3c,0xaa,0x83,0xfd,
        0xa3,0xd7,0xe9,0xeb,0x58,0xd7,0x3e,0x25,0x85,0x37,0x0b,0x68,0x99,0xcf,0x20,0x33,
        0x70,0x3e,0xbe,0xbf,0xca,0xb1,0xa7,0xd5,0xef,0x66,0x90,0xb9,0xb8,0x74,0xcf,0x18,
        0x43,0xb4,0x01,0x9f,0x6f,0xff,0x00,0x5d,0x42,0x6f,0xee,0xc9,0x04,0xdd,0x4c,0x48,
        0xe8,0x7c,0xc3,0xc5,0x4d,0x6f,0xab,0x5e,0xc1,0x20,0x71,0x70,0xef,0x8f,0xe1,0x91,
        0x8b,0x03,0xf9,0xd6,0xad,0xb7,0x89,0x8e,0x40,0xb9,0x80,0x63,0x3c,0xb4,0x67,0xfa,
        0x1f,0xf1,0xad,0x9b,0x3b,0xeb,0x7b,0xd4,0xdd,0x04,0x80,0x91,0xd5,0x4f,0x04,0x7e,
        0x15,0x66,0x8a,0x28,0xa2,0x8a,0x28,0xa2,0x9a,0xee,0xb1,0xa1,0x77,0x60,0xaa,0x3a,
        0x96,0x38,0x02,0xb9,0xdd,0x4f,0xc4,0x05,0x83,0x45,0x65,0x95,0x07,0x20,0xc8,0x47,
        0x3f,0x87,0xf9,0xfc,0xab,0x01,0xdd,0x9d,0x8b,0x3b,0x16,0x62,0x72,0x49,0x39,0x26,
        0x9b,0x49,0x45,0x14,0xb9,0xa7,0xc5,0x2b,0xc4,0xe1,0xe3,0x76,0x46,0x1d,0x19,0x4e,
        0x08,0xae,0xab,0x49,0xd6,0xd2,0xeb,0x6c,0x37,0x18,0x49,0xba,0x06,0xec,0xff,0x00,
        0xe0,0x6b,0x62,0x8a,0x28,0xa2,0x8a,0x2a,0x1b,0xab,0x98,0xad,0x20,0x69,0x66,0x6c,
        0x28,0xfc,0xc9,0xf4,0x15,0xc8,0xea,0x9a,0x9c,0xd7,0xee,0x41,0x25,0x61,0x07,0x2a,
        0x9f,0xe3,0x59,0xfd,0x69,0x44,0x6c,0x7f,0x84,0xd0,0x63,0x6f,0x43,0x4d,0xc1,0x14,
        0x62,0x8c,0x51,0x45,0x39,0x49,0x1c,0x8a,0xe9,0x34,0x5d,0x65,0xa5,0x74,0xb6,0xb9,
        0x39,0x27,0x85,0x90,0x9e,0xfe,0x86,0xb7,0xe8,0xa2,0x8a,0x28,0xae,0x4b,0xc4,0x37,
        0x3e,0x7d,0xf1,0x50,0x7e,0x58,0x86,0xd1,0xf5,0xef,0x59,0x78,0x27,0xb8,0xab,0x96,
        0xb6,0xa0,0xfc,0xcd,0x83,0x57,0xd6,0x15,0xf4,0xa9,0xd2,0xd2,0x36,0x1c,0xa8,0xa6,
        0xc9,0xa5,0xc3,0x20,0xe0,0x62,0xab,0x36,0x88,0x73,0xf2,0xe7,0x1e,0xd5,0x03,0xe9,
        0x33,0xa3,0x7c,0xaa,0xd8,0xf5,0xa9,0x93,0x41,0x99,0xc6,0x4b,0x01,0xf5,0x15,0x20,
        0xd0,0x8a,0xfd,0xe6,0x04,0xd3,0x9b,0x48,0x8f,0xe9,0xc5,0x65,0x5d,0x5b,0xb5,0xb4,
        0xb8,0xfe,0x13,0xd2,0xba,0xad,0x16,0xf8,0x5e,0x59,0x80,0xc4,0x99,0x63,0x00,0x3e,
        0x7b,0xfa,0x1f,0xd2,0xb4,0x28,0xa2,0x8a,0x64,0xcf,0xe5,0xc2,0xef,0xfd,0xd5,0x26,
        0xb8,0x59,0xd8,0xc9,0x33,0x1c,0x72,0x4f,0x6a,0x92,0x18,0xb2,0x46,0x45,0x69,0x40,
        0xa0,0x01,0xc5,0x5c,0x8a,0x3f,0x5e,0x95,0x65,0x50,0xe3,0x81,0xc7,0xd2,0x9e,0xa0,
        0x83,0xc8,0xab,0x11,0xa7,0x03,0x8a,0x94,0x28,0xf4,0xa5,0xc0,0xc6,0x2a,0x37,0x40,
        0x49,0xc7,0x5a,0x82,0x44,0xf4,0x15,0x95,0xa8,0xdb,0x89,0x90,0x80,0x39,0x1d,0x2b,
        0x3f,0x4b,0xba,0x7b,0x0b,0xa0,0xc4,0x31,0x4e,0x8e,0xa3,0xb8,0xae,0xc1,0x58,0x32,
        0x86,0x52,0x0a,0x91,0x90,0x47,0x43,0x4b,0x45,0x15,0x5e,0xf9,0xc2,0x59,0x4e,0xc4,
        0xe3,0xe4,0x23,0x3f,0x85,0x71,0x67,0x96,0x24,0x55,0xbb,0x50,0x09,0xe4,0x0a,0xd1,
        0x81,0x06,0xe1,0xc5,0x5e,0x54,0x1d,0xaa,0x75,0x21,0x57,0xb5,0x28,0x6c,0xb7,0x18,
        0xa9,0x04,0x80,0x00,0x0d,0x3b,0x7a,0xe3,0xbd,0x06,0x45,0xc6,0x46,0x4d,0x31,0xe4,
        0xc1,0xce,0x0f,0xe5,0x41,0x21,0xb3,0xcd,0x55,0xb8,0x8c,0x13,0x58,0x3a,0x84,0x5e,
        0x54,0xdb,0xd7,0xbd,0x6f,0xe8,0xb3,0x19,0x6c,0x54,0x11,0xc2,0x70,0x0e,0xec,0xfe,
        0x1e,0xd8,0xfe,0x58,0xad,0x0a,0x28,0xac,0xbf,0x10,0xcc,0x62,0xd3,0xf6,0xae,0x3f,
        0x78,0xe1,0x4e,0x7d,0x3a,0xf1,0xf9,0x0a,0xe5,0xd0,0xe5,0xab,0x4a,0xda,0x3c,0x00,
        0x6a,0xf4,0x23,0x90,0x2a,0xe2,0xe3,0x3d,0xea,0x40,0x01,0xec,0x33,0x52,0x79,0x63,
        0x14,0xd0,0xbc,0x64,0xe6,0x97,0x1f,0x5a,0x55,0x53,0x9c,0x1c,0xd3,0x8a,0x12,0x7a,
        0x7e,0xb4,0x8c,0xbb,0x7b,0x54,0x32,0x7d,0xec,0xd6,0x36,0xb2,0xbc,0x06,0xab,0xde,
        0x1d,0x62,0x6d,0xe4,0x52,0x78,0xc8,0x23,0x9f,0xf3,0xed,0x5b,0x14,0x51,0x58,0x1e,
        0x28,0x65,0x22,0x15,0x04,0xee,0x19,0x24,0x63,0x8c,0x1f,0xff,0x00,0x55,0x60,0xc2,
        0x7e,0x61,0x9a,0xd9,0x8f,0xee,0x0c,0x7a,0x54,0x91,0x36,0x18,0x13,0x56,0x9a,0x46,
        0x0b,0x95,0x00,0xd5,0x73,0x7f,0x24,0x47,0x98,0xcf,0xd7,0x1c,0x55,0x98,0x35,0x35,
        0x7c,0x07,0x18,0x35,0x71,0x26,0x46,0x03,0x9c,0xfd,0x2a,0x4f,0x35,0x45,0x35,0xe6,
        0x45,0xe4,0x1a,0x82,0x5d,0x46,0x28,0xb7,0x64,0xe4,0xfb,0x55,0x65,0xd5,0x44,0xe7,
        0x6a,0x29,0xfc,0x45,0x48,0xf3,0x92,0x3a,0x56,0x7e,0xa4,0x37,0xdb,0x66,0x9d,0xe1,
        0xd9,0x08,0x94,0xa7,0x62,0x0d,0x74,0x34,0x51,0x58,0x5e,0x25,0x68,0xca,0xc7,0x18,
        0x45,0xf3,0x3e,0xf1,0x6e,0x33,0x8e,0x78,0xfe,0x75,0xcf,0xa2,0x91,0x20,0x06,0xb6,
        0x22,0x3f,0x20,0xc5,0x2f,0x46,0xce,0x69,0xe7,0x51,0x8e,0x0f,0x97,0x05,0xdc,0xf6,
        0x15,0x56,0x5d,0x60,0x9c,0x2b,0xda,0x8c,0x1e,0x99,0x38,0xcd,0x57,0x6b,0x80,0x1b,
        0x25,0x19,0x33,0xc8,0x06,0xaf,0x58,0xdc,0x34,0x84,0x0c,0x1c,0x56,0xd1,0x00,0x44,
        0x48,0x23,0x35,0x8d,0x7b,0x3b,0xc6,0xe7,0x6e,0x48,0xac,0xc7,0xbc,0x62,0x73,0xb7,
        0x3f,0x53,0x56,0xad,0x2f,0xe6,0xc6,0x22,0x86,0x26,0xf9,0x72,0x42,0xe4,0x11,0x5a,
        0x10,0xdc,0x8b,0x8c,0xab,0x29,0x47,0x03,0xee,0xb0,0xc1,0xa6,0x6a,0x09,0x8b,0x53,
        0xec,0x2a,0x1d,0x08,0x15,0xbd,0x8f,0x07,0x83,0x9c,0x8f,0xc0,0xd7,0x4d,0x45,0x15,
        0x87,0xac,0xc6,0x1b,0x50,0x8b,0x23,0xef,0x26,0x3f,0x53,0x59,0x77,0xb6,0xad,0x14,
        0xb9,0x00,0xf2,0x7b,0x55,0xcb,0x75,0xc8,0x50,0x6a,0x79,0xa0,0xc8,0x00,0x37,0x5f,
        0x4a,0x92,0xd6,0xc6,0x04,0x53,0xbd,0x32,0x7f,0xbc,0x46,0x4f,0xe7,0x4d,0x7d,0x12,
        0xd5,0xe4,0xdf,0xe6,0xbf,0x5e,0x98,0xa8,0x6f,0xf4,0xf5,0x75,0xdc,0x33,0xb9,0x46,
        0x17,0x1c,0x53,0x6d,0x90,0xc4,0x81,0x4e,0x01,0x03,0xb5,0x5b,0x13,0x65,0x47,0x7a,
        0x6c,0x90,0x89,0x63,0x23,0xd7,0xad,0x56,0x8b,0x4e,0x55,0x24,0x3a,0x2b,0x0f,0xa5,
        0x68,0xda,0xc1,0x6f,0x00,0xdd,0x1c,0x28,0x08,0xe0,0x91,0xd6,0x8b,0x88,0x16,0x57,
        0x59,0x02,0xfc,0xde,0xa2,0xaa,0xdd,0x2e,0xeb,0x59,0x07,0x39,0xdb,0x4c,0xd2,0x63,
        0x31,0x5c,0x43,0xb8,0x72,0x41,0x35,0xbf,0x45,0x15,0x99,0xa9,0xc2,0x7e,0xd3,0x14,
        0xe4,0x65,0x55,0x71,0xf4,0x3f,0xe7,0xf9,0x56,0x7c,0xdb,0xe5,0x95,0x4f,0xf0,0x73,
        0x91,0x47,0x46,0x18,0xab,0x91,0x30,0xc0,0xcf,0x5a,0x99,0x5c,0x8e,0x29,0xdb,0xb0,
        0x3b,0xe6,0xa3,0x99,0x95,0x57,0x2e,0xd8,0xf6,0xaa,0x2e,0xd1,0xb3,0x1d,0xa4,0xd4,
        0x91,0x7c,0xc7,0x00,0x77,0xa9,0xa3,0x60,0x38,0x63,0xf8,0x54,0xc8,0x72,0xc7,0x6e,
        0x28,0x55,0x6d,0xdb,0x41,0x23,0x34,0xf6,0x72,0xbd,0x41,0xc7,0xb8,0xa8,0xdd,0x03,
        0x60,0xaf,0x7a,0x74,0x31,0xa3,0x5c,0x46,0xe0,0xf4,0x62,0x38,0xfa,0x67,0xfa,0x56,
        0x85,0x14,0x55,0x6d,0x42,0x3f,0x32,0xd1,0xf0,0x06,0x46,0x0f,0xd3,0xd7,0xf4,0xcd,
        0x63,0x42,0xa2,0x16,0x6d,0xec,0x48,0x75,0x21,0x49,0xf5,0xa4,0x07,0x9a,0x91,0x5c,
        0xe4,0x60,0xd6,0x84,0x2a,0xac,0x9b,0xb1,0xf5,0xa6,0x5c,0x4a,0x91,0x21,0x72,0x7a,
        0x0a,0xc7,0xf3,0xda,0x79,0x8c,0xac,0x48,0x5e,0x80,0x7b,0x50,0x25,0xb7,0x47,0xe6,
        0x45,0xcf,0xd6,0xaf,0xdb,0xdd,0xc4,0x88,0x0f,0xca,0x0f,0xf3,0xa8,0xe4,0xbc,0xb7,
        0x69,0x0f,0x99,0x22,0x2e,0x7b,0x03,0x4e,0x69,0x4c,0x7f,0x3c,0x67,0x2b,0x57,0xec,
        0xe7,0x59,0x00,0x27,0xae,0x2a,0x5b,0x8d,0xac,0x99,0x18,0xe2,0xaa,0x2b,0x11,0xb4,
        0xe7,0x8c,0xf0,0x0d,0x58,0xb5,0x8d,0x62,0x75,0x8c,0x31,0x27,0x05,0x89,0x3d,0xfa,
        0x7f,0x8d,0x5c,0xa2,0x8a,0x6b,0xa8,0x74,0x64,0x6e,0x8c,0x30,0x6b,0x1a,0x40,0x09,
        0x65,0xc8,0x25,0x18,0x8f,0xc4,0x55,0x53,0xd7,0xd3,0x06,0x9e,0xbc,0x73,0x57,0x22,
        0x9b,0xe4,0x1c,0xf6,0xe7,0x9a,0xa7,0x7e,0x1a,0x55,0x0a,0x3a,0x13,0xcd,0x57,0x09,
        0xb5,0x36,0xe2,0xa2,0xfb,0x37,0x24,0x84,0xeb,0x49,0xe4,0xc8,0x08,0xf9,0x70,0x07,
        0xa5,0x58,0x6b,0x55,0x70,0x37,0x20,0x18,0xea,0x40,0xe4,0xd5,0xc8,0x51,0x76,0xec,
        0xc0,0x03,0xd2,0x96,0x0c,0xc5,0x26,0xdc,0xf1,0x56,0x7c,0xde,0x1b,0x3d,0x2a,0xb1,
        0xed,0xc9,0xf6,0xad,0x3b,0x66,0x57,0x66,0xc0,0xe5,0x40,0x19,0xab,0x14,0x51,0x45,
        0x54,0xba,0xb1,0x59,0x98,0xc9,0x1b,0xf9,0x72,0xe3,0x04,0xe3,0x20,0xfd,0x45,0x65,
        0xdc,0x5b,0xbd,0xbc,0x9b,0x24,0x65,0x62,0x46,0x72,0x06,0x2a,0x30,0x72,0x2a,0x68,
        0x06,0x7b,0xd3,0x66,0x90,0x28,0x62,0x46,0x31,0x55,0x4d,0xcc,0x48,0x41,0x73,0x9f,
        0x61,0x4e,0xfe,0xd1,0x84,0x74,0x19,0xfa,0x9a,0x78,0xbd,0x80,0x8e,0x87,0x34,0xf1,
        0x7d,0x0e,0xdf,0x98,0x1c,0xd1,0xf6,0xa8,0x5c,0xe1,0x1f,0x07,0xdf,0x8a,0x92,0x17,
        0x13,0xa8,0x20,0xf2,0x0d,0x4e,0xea,0x06,0x46,0x69,0x23,0x8d,0xa5,0x65,0x55,0x60,
        0x1b,0xb1,0x23,0x38,0xfc,0x2b,0x4e,0x08,0x56,0x18,0xf6,0x29,0x27,0x9c,0x92,0x7a,
        0x9a,0x92,0x8a,0x28,0xa2,0xb3,0x35,0x88,0xf8,0x8e,0x51,0x8f,0xee,0x9e,0x7f,0x11,
        0xfd,0x6b,0x30,0x1e,0x6a,0x68,0x24,0x1b,0xb0,0x69,0x6f,0x20,0xf3,0x10,0xe0,0xf0,
        0xde,0x95,0x9b,0xf6,0x00,0x0f,0x04,0x9f,0xa9,0xa9,0x52,0xd5,0x47,0x54,0x5c,0x54,
        0xc2,0xde,0x23,0xd6,0x35,0xcf,0xd2,0x95,0xad,0x62,0x20,0xe1,0x45,0x44,0xba,0x7a,
        0xb3,0x7c,0xc3,0x8f,0x6a,0xbb,0x6b,0x00,0x89,0xf0,0xb9,0x0a,0x7b,0x54,0xb2,0x67,
        0x79,0xee,0x05,0x49,0x68,0x49,0xbb,0x4c,0x0f,0x52,0x7e,0x98,0xff,0x00,0xeb,0x8a,
        0xd4,0xa2,0x8a,0x28,0xa2,0xa1,0xbb,0x87,0xcf,0xb7,0x74,0x1d,0x71,0x95,0xfa,0xf6,
        0xae,0x70,0x92,0x18,0x83,0x90,0x47,0x04,0x1e,0xa2,0x9c,0x5b,0x69,0x04,0x55,0x94,
        0x9c,0x3c,0x7c,0xe0,0x91,0x4a,0x8a,0x18,0xd4,0x9e,0x50,0xed,0x55,0xe6,0x81,0xc9,
        0xf9,0x4f,0x15,0x24,0x31,0x10,0x30,0xc6,0xa6,0x2a,0x17,0x3c,0xf1,0x48,0x8e,0x06,
        0x4d,0x0d,0x26,0x13,0x3e,0xb5,0x63,0x4b,0x42,0x55,0xe6,0x60,0x30,0x7e,0x55,0x3f,
        0x4e,0xbf,0xaf,0xf2,0xad,0x0a,0x28,0xa2,0x8a,0x28,0xae,0x7f,0x5a,0x8d,0x61,0xba,
        0xdc,0x83,0x1b,0xc0,0x66,0xfa,0xf3,0xfe,0x15,0x41,0x5b,0x77,0x7a,0x91,0x4f,0x96,
        0xc3,0xd2,0xad,0x43,0x2f,0x00,0xf6,0xab,0x21,0xc1,0xc6,0xda,0x70,0x04,0x9a,0x3c,
        0xbf,0xad,0x41,0x2c,0x9b,0x4e,0xd3,0x9a,0x88,0xc9,0xce,0x29,0x79,0x9a,0x54,0x89,
        0x1b,0x05,0x88,0x19,0xeb,0x8f,0x7a,0xdf,0x8d,0x16,0x28,0xd5,0x10,0x61,0x54,0x60,
        0x0a,0x75,0x14,0x51,0x45,0x14,0x56,0x3e,0xb2,0xb9,0x9d,0x73,0xd0,0xa7,0xf5,0x35,
        0x87,0x20,0x68,0x9c,0xe3,0xa5,0x02,0x60,0x78,0x34,0xe4,0x9f,0x1d,0xea,0xcc,0x37,
        0x38,0x6e,0xb5,0x76,0x3b,0xa5,0xfe,0xf5,0x0f,0x7d,0x80,0x76,0xe3,0xd8,0xd5,0x19,
        0xae,0x41,0x39,0x2c,0x38,0xa8,0x04,0xfb,0x8e,0x17,0x93,0x56,0xe2,0x66,0xb6,0x43,
        0x30,0xc1,0x75,0x19,0x1b,0xba,0x71,0x5b,0xb6,0x17,0x91,0xdf,0x5b,0x2c,0xc9,0x80,
        0x4f,0xde,0x4c,0xe4,0xa9,0xab,0x34,0x51,0x45,0x14,0x51,0x58,0x7a,0x8d,0xec,0x17,
        0x32,0x85,0x81,0xbc,0xcf,0x2c,0x7c,0xcc,0xbd,0x39,0xed,0x9f,0xc2,0xb3,0x67,0x5c,
        0xd5,0x49,0x23,0xc7,0x35,0x11,0xdc,0x3b,0xd3,0x7c,0xc7,0x5e,0x86,0x9c,0xb7,0x32,
        0x0e,0xf4,0x1b,0x89,0x0f,0x43,0x8a,0x54,0x57,0x90,0xf2,0x6b,0x46,0xce,0x0e,0x7a,
        0x55,0xab,0xb8,0xb7,0xc5,0xe5,0xa9,0xc3,0x10,0x45,0x64,0x69,0xba,0x84,0xba,0x7d,
        0xc7,0x99,0x19,0xca,0x9e,0x1d,0x0f,0x46,0x1f,0xe3,0x5d,0xa5,0xb4,0xf1,0xdc,0xc0,
        0x93,0x44,0x72,0xac,0x33,0xf4,0xf6,0x3e,0xf5,0x2d,0x14,0x54,0x17,0x37,0x96,0xd6,
        0xa3,0xf7,0xf3,0x22,0x1c,0x67,0x04,0xf2,0x47,0xd3,0xad,0x62,0xdd,0x78,0x99,0x40,
        0xc5,0xa4,0x24,0x9f,0xef,0x49,0xd3,0xf2,0x1f,0xe3,0x58,0xf7,0x7a,0xa5,0xe5,0xd9,
        0x22,0x49,0x98,0x29,0xcf,0xc8,0xbc,0x2e,0x3d,0x31,0xdf,0xf1,0xa9,0xb4,0xe3,0x8b,
        0x77,0xc0,0xea,0xe3,0x27,0x1d,0x30,0x3f,0xfa,0xf5,0x61,0xb9,0xa8,0x4a,0x64,0xf4,
        0xa8,0x64,0x88,0xfa,0x54,0x5f,0x66,0x90,0xf4,0x06,0x97,0xec,0x72,0x8e,0xa2,0xa4,
        0x4b,0x43,0xdc,0x55,0xa8,0x60,0xc7,0x6a,0xbd,0x12,0xec,0x5e,0x9d,0x6a,0x6b,0x78,
        0xb7,0x19,0x65,0x6f,0xe0,0x5f,0xe7,0xc7,0xf8,0xd7,0x28,0xdc,0x13,0x56,0xac,0x35,
        0x1b,0x8b,0x09,0x37,0x42,0xc3,0x07,0xaa,0x37,0x2a,0x7f,0x0a,0xe9,0xac,0x75,0xdb,
        0x4b,0xa5,0xc4,0x8c,0x20,0x93,0xb8,0x73,0xc7,0xe0,0x6b,0x52,0xb8,0xbb,0xbd,0x72,
        0xfa,0xe7,0x03,0xcc,0xf2,0x80,0xed,0x16,0x57,0x3f,0x8f,0x5a,0xce,0x66,0x67,0x62,
        0xcc,0x49,0x62,0x72,0x49,0xea,0x69,0x28,0xad,0x7d,0x1d,0x4c,0x96,0xf3,0xc6,0xa1,
        0x73,0xb9,0x73,0xbb,0xb0,0x20,0x8c,0xff,0x00,0x2a,0x93,0x63,0x29,0x65,0x6e,0x19,
        0x4e,0x08,0x3e,0xb4,0x00,0x0d,0x49,0x1c,0x4a,0xcc,0x01,0xab,0xd1,0x5a,0xa8,0x03,
        0xe5,0x15,0x2b,0x5b,0xa0,0x1d,0x2a,0xab,0xc4,0x14,0xe7,0x02,0x93,0x68,0xce,0x7a,
        0x54,0xaa,0x85,0x98,0x28,0xea,0x7a,0x66,0xad,0x95,0x8a,0x18,0x8c,0x88,0x3e,0x57,
        0xe4,0xe4,0xe7,0x81,0xdf,0xe8,0x7f,0xf6,0x6a,0xe2,0x4f,0x5a,0x4a,0x5a,0x96,0x3b,
        0xcb,0x98,0x53,0x64,0x57,0x12,0xa2,0xfa,0x2b,0x90,0x2a,0x1a,0x28,0xa2,0xb5,0xfc,
        0x38,0xfb,0x6e,0xe4,0x52,0xbb,0x83,0x27,0x4f,0x5e,0x40,0xfe,0xb5,0xab,0x77,0x66,
        0x4e,0x5f,0x7f,0xef,0x57,0x83,0xb8,0xe4,0xc9,0xe9,0x8f,0x7e,0x3f,0x4a,0xa2,0x30,
        0x47,0xcb,0x48,0xac,0x41,0xf4,0xad,0x0b,0x59,0xc1,0x5c,0x1e,0xb4,0xe9,0xe7,0x20,
        0xf1,0x55,0x4c,0x9b,0x8f,0x73,0x52,0x80,0x78,0x01,0x77,0x3b,0x1c,0x2a,0x8e,0xa4,
        0xd5,0xeb,0x48,0x1a,0x17,0xc4,0x98,0x32,0xb0,0xcb,0x15,0x39,0x0a,0x3d,0x07,0xd7,
        0xfc,0x7d,0x2a,0xbe,0xb1,0x31,0x82,0xc2,0x7f,0x99,0x48,0x71,0xb2,0x31,0xe9,0xeb,
        0xfe,0x7d,0xab,0x90,0xa4,0xa2,0x83,0x45,0x25,0x2d,0x15,0xa1,0xa2,0x36,0x35,0x05,
        0x19,0x20,0x30,0x20,0x91,0xda,0xba,0xb5,0x57,0x91,0x44,0xd9,0x06,0x64,0x38,0x2a,
        0x3b,0x0e,0xeb,0xf5,0xf7,0xfa,0x76,0xaa,0x37,0xb6,0x7e,0x72,0x1b,0x9b,0x34,0xec,
        0x4b,0x02,0x4f,0xcf,0xdf,0x20,0x63,0xad,0x52,0x45,0xdc,0x0f,0xca,0xca,0xcb,0xc1,
        0x56,0x18,0x20,0xfb,0x8a,0x8d,0x83,0x2b,0x7c,0xa4,0x8f,0xa5,0x3d,0x09,0x3f,0x78,
        0x93,0xf5,0xa9,0x50,0x31,0x91,0x63,0x8d,0x77,0xc8,0xdd,0x14,0x7f,0x33,0xed,0x5a,
        0xb0,0x5b,0xfd,0x99,0x77,0x12,0xaf,0x72,0xe3,0xb9,0xe3,0xe8,0x3d,0x07,0xf9,0xf6,
        0xa9,0xc0,0xc4,0x5b,0x49,0xfd,0xe3,0x9e,0xa7,0x83,0x9f,0xfe,0xb7,0xf4,0xae,0x6b,
        0xc4,0x97,0x05,0xa5,0x4b,0x75,0x38,0x58,0xf3,0x95,0x15,0x89,0x45,0x14,0x55,0x9f,
        0xec,0xfb,0xdf,0xf9,0xf3,0xb8,0xff,0x00,0xbf,0x4d,0xfe,0x14,0x9f,0xd9,0xf7,0xbf,
        0xf3,0xe7,0x71,0xff,0x00,0x7e,0x9b,0xfc,0x29,0x7f,0xb3,0xef,0x7f,0xe7,0xce,0xe3,
        0xfe,0xfd,0x37,0xf8,0x51,0xfd,0x9f,0x7b,0xff,0x00,0x3e,0x77,0x1f,0xf7,0xe9,0xbf,
        0xc2,0xac,0xe9,0xf6,0xb7,0x70,0xde,0xc4,0xed,0x69,0x70,0x06,0x70,0x4f,0x96,0x78,
        0x07,0x8a,0xea,0x62,0x2e,0x64,0x52,0xc8,0xc1,0x5b,0xe5,0x61,0xb7,0xf8,0x80,0xfb,
        0xc7,0xdb,0x8c,0x7e,0x55,0x31,0x05,0x1f,0x08,0x38,0x7c,0xf6,0xe1,0x4f,0xf9,0xff,
        0x00,0x3c,0xd5,0x6b,0x9b,0x25,0x92,0x4d,0xc0,0x90,0xcc,0x78,0x61,0x92,0x41,0xf4,
        0x3f,0xec,0xfe,0x5c,0xfd,0x6b,0x39,0xed,0xe6,0x57,0x28,0xd0,0x39,0x61,0xd4,0xaa,
        0x92,0xa7,0xe8,0x71,0x4b,0x0d,0xa4,0xf3,0x12,0x4a,0x34,0x68,0xa7,0xe6,0x2c,0xa4,
        0x31,0xff,0x00,0x74,0x56,0x9d,0x9d,0xba,0x5b,0x40,0xdf,0x21,0xc9,0xfb,0xc3,0x04,
        0x9f,0xa7,0xbf,0xf9,0xed,0xc5,0x4c,0x89,0xb4,0xee,0x20,0x96,0xe8,0x32,0x73,0xb4,
        0x7f,0x9f,0xf3,0xc5,0x32,0x5d,0xc1,0x4c,0xca,0x84,0xc9,0xb7,0x0a,0xb8,0xed,0x9f,
        0xf3,0xf9,0x57,0x25,0x7d,0x6d,0x79,0x71,0x74,0xf2,0x0b,0x4b,0x8c,0x1e,0x06,0x62,
        0x6c,0x91,0xea,0x78,0xea,0x7a,0xd5,0x7f,0xec,0xfb,0xdf,0xf9,0xf3,0xb8,0xff,0x00,
        0xbf,0x47,0xfc,0x28,0xfe,0xcf,0xbd,0xff,0x00,0x9f,0x4b,0x8f,0xfb,0xf4,0xdf,0xe1,
        0x41,0xd3,0xef,0x7f,0xe7,0xce,0xe3,0xfe,0xfd,0x37,0xf8,0x52,0x1b,0x0b,0xd1,0xff,
        0x00,0x2e,0x97,0x1f,0xf7,0xe9,0xbf,0xc2,0xbf,0xff,0xd9,
    };
    poEmulationCard->PutTransparentEF("3F00DF014035",
        CByteArray(tuc3F00DF014035, (unsigned long) sizeof(tuc3F00DF014035)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(PuK#7 ID) (CA role ID)
    unsigned char tuc3F00DF014038[] = {
        0x3a,0x9a,0xff,0x77,0x5b,0xe7,0x99,0xc9,0xa3,0x67,0xbd,0xc0,0xc9,0xa7,0x15,0xdc,
        0x95,0xa6,0x7b,0xd3,
    };
    poEmulationCard->PutTransparentEF("3F00DF014038",
        CByteArray(tuc3F00DF014038, (unsigned long) sizeof(tuc3F00DF014038)), AC_ALWAYS, 0, AC_NEVER, 0);

    // EF(Preferences)
    unsigned char tuc3F00DF014039[] = {
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,
    };
    poEmulationCard->PutTransparentEF("3F00DF014039",
        CByteArray(tuc3F00DF014039, (unsigned long) sizeof(tuc3F00DF014039)), AC_ALWAYS, 0, AC_PIN, 1);

	m_bBeidV1Test3Initialized = true;

	return poEmulationCard;
}

/////////////////////////////////////////////////////////////////////////////////
// SIS card

static CEmulationSISCard *m_SISTest1 = NULL;

static unsigned char SISTest1Data[] = {
	0x92,0x23,0x10,0x91,0x46,0x0B,0x1B,0x13,0x43,0x45,0x43,0x30,0x31,0x00,0x50,0xFA,
	0x67,0x61,0x29,0x4F,0x07,0xA0,0x00,0x00,0x00,0x33,0x01,0x00,0x53,0x1E,0x00,0x10,
	0x00,0xCC,0x00,0x5C,0x00,0x11,0x00,0x3C,0x00,0x2C,0x00,0x12,0x00,0x68,0x00,0x64,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x11,0x02,0x07,
	0x30,0x40,0x10,0x27,0x49,0x20,0x04,0x01,0x05,0x53,0x49,0x53,0x42,0x45,0x4C,0x2D,
	0x2B,0xEE,0x3E,0x37,0x20,0x04,0x01,0x02,0x20,0x14,0x01,0x31,0xFF,0xFF,0xFF,0xFF,
	0xFF,0xFF,0xFF,0x80,0x98,0x46,0xB4,0xEF,0x00,0x12,0x02,0x07,0x30,0x40,0x10,0x27,
	0x49,0x20,0x04,0x01,0x05,0x48,0x4F,0x45,0x42,0x45,0x4E,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x53,0x54,0x45,0x46,0x41,0x4E,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x31,0x19,
	0x73,0x04,0x01,0xFF,0xFF,0xFF,0xFF,0x40,0x47,0x0E,0x65,0x2B,0x00,0x10,0x02,0x5E,
	0x62,0x82,0xE7,0xB8,0x8A,0xB3,0x32,0x68,0x2C,0x2B,0xE8,0xC8,0x98,0x52,0x6E,0x49,
	0x5A,0x37,0x6F,0x55,0xCB,0x6F,0xB3,0xBD,0x8F,0x6F,0xF5,0x28,0x27,0xAE,0x5A,0xC8,
	0x1D,0xEB,0xA5,0x6C,0xE4,0x4F,0x7B,0x77,0x83,0xD0,0xEF,0xBF,0x53,0xC4,0x57,0xDB,
	0x12,0xF7,0x74,0xA7,0x04,0x4D,0x57,0x75,0x3A,0xDA,0x4C,0x7D,0xAD,0x9A,0xC6,0x6F,
	0x88,0xF4,0x1B,0x5E,0x57,0xBA,0x8A,0xE3,0xEF,0x15,0x75,0x30,0x42,0x71,0xDD,0xB0,
	0x9D,0xC3,0xBF,0x40,0x6C,0x4D,0x9D,0x52,0x00,0x43,0x02,0x8D,0x49,0x9E,0xFA,0xB9,
	0xDC,0xFE,0xB9,0xD1,0x79,0xEE,0x9B,0xC3,0x3B,0x4A,0x1F,0x25,0x6C,0x4F,0xCF,0x7D,
	0x20,0x49,0x8F,0x5F,0xB6,0x7A,0x3E,0x03,0x87,0xED,0x1C,0x0D,0xEE,0xB4,0xA5,0x48,
	0xD0,0x94,0x51,0x97,0xE3,0xAC,0xBE,0xD3,0xB5,0xD9,0x30,0x96,0xE1,0x47,0x3E,0x10,
	0x85,0xD2,0x91,0x79,0xCC,0x0F,0x17,0xD7,0x8A,0x09,0x2E,0x27,0x6C,0x02,0x89,0xDE,
	0xDC,0xBC,0x5B,0xD0,0xDE,0x6C,0x8F,0xD2,0xD7,0x34,0xE5,0x95,0xC1,0x7C,0xE7,0xE5,
	0xD2,0x24,0x6D,0x78,0xDF,0x4E,0x7D,0xC9,0xBB,0x01,0x42,0x76,0x7B,0x88,0xEC,0x5E,
	0xCE,0xB8,0xA6,0x9F
};

/////////////////////////////////////////////////////////////////////////////////

void CEmulationCardFactory::Init(){

  if(m_bCardInitialized ) return;

  m_BeidV1Test1 = new CEmulationBeidCard(0x11);
  m_BeidV1Test2 = new CEmulationBeidCard(0x11);
  m_BeidV2Test1 = new CEmulationBeidCard(0x20);
  m_BeidV1Test3 = new CEmulationBeidCard(0x11);
  m_SISTest1 = new CEmulationSISCard(CByteArray(SISTest1Data, sizeof(SISTest1Data)));

  m_bCardInitialized = true;
  
}
CEmulationCardFactory::~CEmulationCardFactory()
{
  if( m_BeidV1Test1 != NULL) {
    delete m_BeidV1Test1;
    m_BeidV1Test1 = NULL;
  }
  if( m_BeidV1Test2 != NULL) {
    delete m_BeidV1Test2;
    m_BeidV1Test2 = NULL;
  }
  if( m_BeidV2Test1 != NULL) {
    delete m_BeidV2Test1;
    m_BeidV2Test1 = NULL;
  }
  if( m_SISTest1 != NULL) {
    delete m_SISTest1;
    m_SISTest1 = NULL;
  }
}

CEmulationCard *CEmulationCardFactory::getInstance(EmulationCard type)
{
	if(!m_bCardInitialized)
		Init();

	switch(type)
	{
	case BEID_V1_TEST1: return MakeBeidV1Test1();
	case BEID_V1_TEST2: return MakeBeidV1Test2();
	case BEID_V2_TEST1: return MakeBeidV2Test1();
	case BEID_V1_TEST3: return MakeBeidV1Test3();
	case SIS_TEST1: return m_SISTest1;
	}

	return NULL;
}
