/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.35
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace be.belgium.eid {

using System;
using System.Runtime.InteropServices;

/// <summary>
/// This class represent a reader.
/// You get reader object from the ReaderSet 
///     either by its index (getReaderByNum) or by its name (getReaderByName).
/// Once you have a reader object, you can check if a card is present (isCardPresent).
/// Then you can ask which type of card is in the reader with getCardType()
///		and then get a card object using one of this method :
///			getCard, getEIDCard, getKidsCard, getForeignerCard or getSISCard.
/// </summary>
public class BEID_ReaderContext : BEID_Object
    {
  private HandleRef swigCPtr;

  internal BEID_ReaderContext(IntPtr cPtr, bool cMemoryOwn) : base(beidlib_dotNetPINVOKE.BEID_ReaderContextUpcast(cPtr), cMemoryOwn) {
    swigCPtr = new HandleRef(this, cPtr);
  }

  internal static HandleRef getCPtr(BEID_ReaderContext obj) {
    return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
  }

  ~BEID_ReaderContext() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if(swigCPtr.Handle != IntPtr.Zero && swigCMemOwn) {
        swigCMemOwn = false;
        beidlib_dotNetPINVOKE.delete_BEID_ReaderContext(swigCPtr);
      }
      swigCPtr = new HandleRef(null, IntPtr.Zero);
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  /// <summary>
  /// Construct using a fileType and fileName.
  /// </summary>
  /// <remarks>
  /// No physical reader are connected.
  /// </remarks>
  public BEID_ReaderContext(BEID_FileType fileType, string fileName)
      : this(beidlib_dotNetPINVOKE.new_BEID_ReaderContext__SWIG_0((int)fileType, fileName), true)
  {
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>
  /// Construct using a fileType and its content (for compatibility with SetRawFile).
  /// </summary>
  /// <remarks>
  /// No physical reader are connected.
  /// </remarks>
  public BEID_ReaderContext(BEID_FileType fileType, BEID_ByteArray data)
      : this(beidlib_dotNetPINVOKE.new_BEID_ReaderContext__SWIG_1((int)fileType, BEID_ByteArray.getCPtr(data)), true)
  {
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>
  /// Construct using Raw data for Eid.
  /// </summary>
  /// <remarks>
  /// No physical reader are connected.
  /// </remarks>
  public BEID_ReaderContext(BEID_RawData_Eid data)
      : this(beidlib_dotNetPINVOKE.new_BEID_ReaderContext__SWIG_2(BEID_RawData_Eid.getCPtr(data)), true)
  {
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>
  /// Construct using Raw data for Sis.
  /// </summary>
  /// <remarks>
  /// No physical reader are connected.
  /// </remarks>
  public BEID_ReaderContext(BEID_RawData_Sis data)
      : this(beidlib_dotNetPINVOKE.new_BEID_ReaderContext__SWIG_3(BEID_RawData_Sis.getCPtr(data)), true)
  {
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>Return the name of the reader.</summary>
  public string getName() {
    string ret = beidlib_dotNetPINVOKE.BEID_ReaderContext_getName(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return true if a card is present and false otherwise.</summary>
  public bool isCardPresent() {
    bool ret = beidlib_dotNetPINVOKE.BEID_ReaderContext_isCardPresent(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Release the card.</summary>
  /// <param name="bAllReference">
  /// If true all the invalid reference/pointer are destroyed.
  /// PUT THIS PARAMETER TO TRUE IS THREAD UNSAFE. 
  /// You have to be sure that you will not use any old reference/pointer after this release
  /// </param>
  public void releaseCard(bool bAllReference)
  {
    beidlib_dotNetPINVOKE.BEID_ReaderContext_releaseCard__SWIG_0(swigCPtr, bAllReference);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>Release the card.</summary>
  public void releaseCard()
  {
    beidlib_dotNetPINVOKE.BEID_ReaderContext_releaseCard__SWIG_1(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>Return true if a card has changed since the last called (with the same ulOldId parameter).</summary>
  public bool isCardChanged(ref uint ulOldId) {
    bool ret = beidlib_dotNetPINVOKE.BEID_ReaderContext_isCardChanged(swigCPtr, ref ulOldId);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Return the type of the card in the reader.
  /// Throw BEID_ExNoCardPresent exception if no card is present. 
  /// </summary>
  public BEID_CardType getCardType()
  {
    BEID_CardType ret = (BEID_CardType)beidlib_dotNetPINVOKE.BEID_ReaderContext_getCardType(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Get the card in the reader.
  /// Instantiation is made regarding the type of the card 
  ///			(BEID_EIDCard, BEID_KidsCard, BEID_ForeignerCard or BEID_SISCard).
  /// </summary>
  /// <remarks>
  /// If no card is present in the reader, exception BEID_ExNoCardPresent is thrown.
  /// If the card type is not supported, exception BEID_ExCardTypeUnknown is thrown.
  /// </remarks>
  public BEID_Card getCard()
  { 
	BEID_CardType cardType=getCardType();

	switch(cardType)
	{
	case BEID_CardType.BEID_CARDTYPE_EID:			
	case BEID_CardType.BEID_CARDTYPE_KIDS:
	case BEID_CardType.BEID_CARDTYPE_FOREIGNER:
		return getEIDCard();			

	case BEID_CardType.BEID_CARDTYPE_SIS:			
		return getSISCard();			

    default:										
		throw new BEID_ExCardTypeUnknown();
	}
}

	/// <summary> 
	/// Get the EIDcard in the reader. 
	///		Instantiation is made regarding the type of the card 
	///			(BEID_EIDCard, BEID_KidsCard, BEID_ForeignerCard).
	/// </summary>
    /// <remarks>
	/// If no card is present in the reader, exception BEID_ExNoCardPresent is thrown.
	/// If the card is not an EIDcard, exception BEID_ExCardBadType is thrown.
    /// </remarks>
  public BEID_EIDCard getEIDCard() { 
	BEID_CardType cardType=getCardType();

	switch(cardType)
	{
	case BEID_CardType.BEID_CARDTYPE_EID:			
		BEID_EIDCard ret = new BEID_EIDCard(beidlib_dotNetPINVOKE.BEID_ReaderContext_getEIDCard(swigCPtr), false);	
		if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
		return ret;

	case BEID_CardType.BEID_CARDTYPE_KIDS:			
		return getKidsCard();		

	case BEID_CardType.BEID_CARDTYPE_FOREIGNER:		
		return getForeignerCard();	

    default:										
		throw new BEID_ExCardBadType();
	}
}

  /// <summary> 
  /// Get the KidsCard in the reader.
  /// </summary>
  /// <remarks>
  /// If no card is present in the reader, exception BEID_ExNoCardPresent is thrown.
  /// If the card is not a KidsCard, exception BEID_ExCardBadType is thrown.
  /// </remarks>
  public BEID_KidsCard getKidsCard() {
    BEID_KidsCard ret = new BEID_KidsCard(beidlib_dotNetPINVOKE.BEID_ReaderContext_getKidsCard(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Get the ForeignerCard in the reader.
  /// </summary>
  /// <remarks>
  /// If no card is present in the reader, exception BEID_ExNoCardPresent is thrown.
  /// If the card is not a ForeignerCard, exception BEID_ExCardBadType is thrown.
  /// </remarks>
  public BEID_ForeignerCard getForeignerCard()
  {
    BEID_ForeignerCard ret = new BEID_ForeignerCard(beidlib_dotNetPINVOKE.BEID_ReaderContext_getForeignerCard(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Get the SISCard in the reader.
  /// </summary>
  /// <remarks>
  /// If no card is present in the reader, exception BEID_ExNoCardPresent is thrown.
  /// If the card is not a SISCard, exception BEID_ExCardBadType is thrown.
  /// </remarks>
  public BEID_SISCard getSISCard()
  {
    BEID_SISCard ret = new BEID_SISCard(beidlib_dotNetPINVOKE.BEID_ReaderContext_getSISCard(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary> 
  /// Specify a callback function to be called each time a card is inserted/remove in/from this reader.
  /// </summary>
  /// <returns>A handle can be used to stop the callbacks when they are no longer needed</returns>
  public uint SetEventCallback(BEID_SetEventDelegate callback, IntPtr pvRef)
  { 
	beidlib_dotNetPINVOKE.CUSTOM_SetEventHelper.countRef++;	
	IntPtr ptrCount = new IntPtr(beidlib_dotNetPINVOKE.CUSTOM_SetEventHelper.countRef);

	//We add the references to the hash table
	beidlib_dotNetPINVOKE.CUSTOM_SetEventHelper.delegateRef callbackRef =  new beidlib_dotNetPINVOKE.CUSTOM_SetEventHelper.delegateRef();
	callbackRef.functionRef = callback;
	callbackRef.ptrRef = pvRef;
	callbackRef.handleRef = 0;
	beidlib_dotNetPINVOKE.CUSTOM_SetEventHelper.delegateRefs.Add(beidlib_dotNetPINVOKE.CUSTOM_SetEventHelper.countRef,callbackRef);

	//We call the SetEvent with the internal reference (countRef)
	uint ulRslt = beidlib_dotNetPINVOKE.BEID_ReaderContext_SetEventCallback(swigCPtr, 0, ptrCount);
	if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) 
	{
		beidlib_dotNetPINVOKE.CUSTOM_SetEventHelper.delegateRefs.Remove(callbackRef);
		throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
	}
	else
	{
		callbackRef.handleRef = ulRslt;
	}

	return ulRslt; 
  }

  /// <summary>To tell that the callbacks are not longer needed.</summary>
  /// <param name="ulHandle">is the handle return by SetEventCallback</param>
  public void StopEventCallback(uint ulHandle) { 
	beidlib_dotNetPINVOKE.BEID_ReaderContext_StopEventCallback(swigCPtr, ulHandle);
	if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
	
	//Remove ulHandle from delegateRefs 
	foreach(beidlib_dotNetPINVOKE.CUSTOM_SetEventHelper.delegateRef callbackRef in beidlib_dotNetPINVOKE.CUSTOM_SetEventHelper.delegateRefs.Values )
    {
      if(callbackRef.handleRef==ulHandle)
      {
          beidlib_dotNetPINVOKE.CUSTOM_SetEventHelper.delegateRefs.Remove(callbackRef);
          break;
      }
    }	
  }

  /// <summary>Begin a transaction with the reader.</summary>
  public void BeginTransaction() {
    beidlib_dotNetPINVOKE.BEID_ReaderContext_BeginTransaction(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>End the transaction.</summary>
  public void EndTransaction() {
    beidlib_dotNetPINVOKE.BEID_ReaderContext_EndTransaction(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>Return true if this is a virtual reader (create from a file).</summary>
  public bool isVirtualReader() {
    bool ret = beidlib_dotNetPINVOKE.BEID_ReaderContext_isVirtualReader(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

}

}
