/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.35
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace be.belgium.eid {

using System;
using System.Runtime.InteropServices;

/// <summary>Container class for all certificates on the card.</summary>
public class BEID_Certificates : BEID_Crypto {
  private HandleRef swigCPtr;

  internal BEID_Certificates(IntPtr cPtr, bool cMemoryOwn) : base(beidlib_dotNetPINVOKE.BEID_CertificatesUpcast(cPtr), cMemoryOwn) {
    swigCPtr = new HandleRef(this, cPtr);
  }

  internal static HandleRef getCPtr(BEID_Certificates obj) {
    return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
  }

  ~BEID_Certificates() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if(swigCPtr.Handle != IntPtr.Zero && swigCMemOwn) {
        swigCMemOwn = false;
        beidlib_dotNetPINVOKE.delete_BEID_Certificates(swigCPtr);
      }
      swigCPtr = new HandleRef(null, IntPtr.Zero);
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  /// <summary>
  /// Create an BEID_Certificates store without any link to a card.
  /// </summary>
  /// <remarks>
  /// This store is not link to any Card, so some methods could not be used.
  /// These methods throw BEID_ExBadUsage exception.
  /// </remarks>
  public BEID_Certificates()
      : this(beidlib_dotNetPINVOKE.new_BEID_Certificates(), true)
  {
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>The number of certificates on the card.</summary>
  public uint countFromCard()
  {
    uint ret = beidlib_dotNetPINVOKE.BEID_Certificates_countFromCard(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>The number of certificates (on the card or not).</summary>
  public uint countAll()
  {
    uint ret = beidlib_dotNetPINVOKE.BEID_Certificates_countAll(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>
  /// Get the ulIndex certificate from the card.
  /// </summary>
  /// <remarks>
  /// Throw BEID_ExParamRange exception if the index is out of range.
  /// </remarks>
  public BEID_Certificate getCertFromCard(uint ulIndexCard)
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_Certificates_getCertFromCard(swigCPtr, ulIndexCard), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>
  /// Return the certificate with the number ulIndexAll.
  /// ATTENTION ulIndexAll and ulIndexCard are two different index.
  /// Index will change if new certificates are added with addCert().
  /// </summary>
  public BEID_Certificate getCert(uint ulIndexAll)
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_Certificates_getCert__SWIG_0(swigCPtr, ulIndexAll), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the certificate by type.</summary>
  public BEID_Certificate getCert(BEID_CertifType type)
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_Certificates_getCert__SWIG_1(swigCPtr, (int)type), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the RRN certificate from the card.</summary>
  public BEID_Certificate getRrn()
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_Certificates_getRrn(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the root certificate from the card.</summary>
  public BEID_Certificate getRoot()
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_Certificates_getRoot(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the ca certificate from the card.</summary>
  public BEID_Certificate getCA()
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_Certificates_getCA(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the signature certificate from the card.</summary>
  public BEID_Certificate getSignature()
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_Certificates_getSignature(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the authentication certificate from the card.</summary>
  public BEID_Certificate getAuthentication()
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_Certificates_getAuthentication(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Add a new certificate to the store.</summary>
  public BEID_Certificate addCertificate(BEID_ByteArray cert)
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_Certificates_addCertificate(swigCPtr, BEID_ByteArray.getCPtr(cert)), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

}

}
