#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test inventory/tagging method regexps
# Copyright © 2003 Colin Walters <walters@verbum.org>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "inventory"

inventory_has () {
  class=$1
  type=$2
  fname=$3
  file_matches '^'${class}'[[:space:]]+'${type}'[[:space:]]*'${fname} ../,inventory
}

begin_test_savectx "simple source inventory"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
cd hello-world
tla inventory > ../,inventory
inventory_has 'S' '' 'README'
inventory_has 'S' '' 'hello-world\.c'
end_test_savectx 

begin_test_savectx "simple junk inventory"
touch ',,test-junk'
touch ',other-junk'
tla inventory --junk > ../,inventory
file_matches ',,test-junk' ../,inventory
file_matches ',other-junk' ../,inventory
end_test_savectx

begin_test_savectx "simple junk and source inventory"
tla inventory --kind --source --junk > ../,inventory
inventory_has 'S' 'r' 'README'
inventory_has 'S' 'r' 'hello-world\.c'
inventory_has 'J' 'r' ',,test-junk'
inventory_has 'J' 'r' ',other-junk'
end_test_savectx

begin_test_savectx "default untagged source is precious"
touch blargh
test "$(tla inventory -p)" = "blargh" || test "$(tla inventory -p)" = "blargh
gmon.out" || test_fail "got more than blargh in '$(tla inventory -p)'"
end_test_savectx

begin_test_savectx "change junk regexp to match \"README\""
tla id-tagging-defaults | egrep -v '^junk' > '{arch}/=tagging-method'
echo 'junk ^(,.*)|(README)$' >> '{arch}/=tagging-method'
tla inventory --kind --source --junk > ../,inventory
inventory_has 'J' 'r' ',,test-junk'
inventory_has 'J' 'r' 'README'
inventory_has 'S' 'r' 'hello-world\.c'
end_test_savectx

begin_test_savectx "two junk regexps"
tla id-tagging-defaults > '{arch}/=tagging-method'
echo 'junk ^README$' >> '{arch}/=tagging-method'
tla inventory --kind --source --junk > ../,inventory
inventory_has 'J' 'r' ',,test-junk'
inventory_has 'J' 'r' 'README'
inventory_has 'S' 'r' 'hello-world\.c'
end_test_savectx

cd ..
begin_test "explicit_id mvs not ignored"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
cd hello-world
mv README READ
mv .arch-ids/README.id .arch-ids/READ.id
tla status > ,,changes && test_fail "no changes detected '$(tla diff)'"
file_matches "R.*README.*=>.*READ" ,,changes || test_fail "rename not detected"
file_matches "R.*README\\.id.*=>.*READ\\.id" ,,changes || test_fail "id rename not detected"
end_test

begin_test "explicit_id mvs file not id is patch"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world || test_fail "could not checkout hello-world"
cd hello-world
rm hello-world.c || test_fail "could not rm hello-world.c"
mv README hello-world.c || test_fail "could not mv README"
cp hello-world.c README || test_fail "could not copy hello-world.c"
tla status > ,,changes && test_fail "no changes detected '$(tla diff)'"
file_matches "R.*README.*=>.*READ" ,,changes && test_fail "rename detected"
file_matches "R.*hello-world" ,,changes && test_fail "rename detected"
file_matches "M.*hello-world\\.c" ,,changes || test_fail "hello-world.c change not detected"
end_test

begin_test "explicit_id mvs id file not file is rename (and patch to the files to reverse their content)"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
cd hello-world
mv .arch-ids/READ{ME,}.id
mv .arch-ids/{hello-world.c,README}.id
mv .arch-ids/{READ,hello-world.c}.id
tla status > ,,changes && test_fail "no changes detected '$(tla diff)'"
file_matches "R.*README.*=>.*hello-world.c" ,,changes || test_fail "rename README not detected"
file_matches "R.*hello-world.c.*=>.*README" ,,changes || test_fail "rename hello-world not detected"
file_matches "R.*.arch-ids/README.id.*=>.*.arch-ids/hello-world.c.id" ,,changes || test_fail "rename README.id not detected"
file_matches "R.*.arch-ids/hello-world.c.id.*=>.*.arch-ids/README.id" ,,changes || test_fail "rename hello-world.id not detected"
file_matches "M.*hello-world\\.c" ,,changes || test_fail "hello-world.c change not detected"
file_matches "M.*README" ,,changes || test_fail "README change not detected"
end_test

begin_test "swo is ignored by default"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
cd hello-world
touch foo.swo
tla lint --strict || test_fail "foo.swo triggers a strict lint failure"
end_test

clean_workdir

# tag: Colin Walters Sun, 12 Oct 2003 12:43:30 -0400 (test-inventory.sh)
#
