/* relational.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__FILE_UTILS__RELATIONAL_H
#define INCLUDE__FILE_UTILS__RELATIONAL_H


#include "hackerlab/machine/types.h"
#include "hackerlab/arrays/ar.h"



typedef t_uchar *  rel_field;
#ifndef _IN_RELATIONAL_
typedef rel_field const * rel_record;
#else
typedef rel_field * rel_record;
#endif
typedef rel_record * rel_table;

struct rel_join_output_spec
{
  int table;
  int field;
};

typedef int * rel_cut_spec;

/* rel_table */
extern int rel_n_records (rel_table r);
#define rel_add_records(t, args...) _rel_add_records(t, "rel_add_records: "__location__, ##args)
extern void _rel_add_records (rel_table * table, char const * name, ...);
#define rel_add_record(t, r) _rel_add_record(t, r, "rel_add_record: "__location__)
extern void _rel_add_record (rel_table * table, rel_record r, char const * name);
extern void rel_insert_records (rel_table *table, int index, ...);
extern void rel_remove_records (rel_table *table, int from_index, int to_index);
extern void rel_replace_record (rel_table table, int index, rel_record record);
extern void rel_free_table (rel_table t);
extern rel_table rel_delim_split (t_uchar const * string, t_uchar const * delimiters);
extern rel_table rel_ws_split (t_uchar const * string);
extern rel_table rel_nl_split (t_uchar const * string);
extern rel_table rel_ws_split_pairs (t_uchar const * string);
#define rel_copy_table(t) _rel_copy_table(t, "rel_copy_table: "__location__)
extern rel_table _rel_copy_table (rel_table t, char const * name);
extern rel_table rel_unflatten (int count, int width, char * strings[]);
#define rel_for_each(table, varname) for (varname = 0; varname < rel_n_records (table); ++varname)
/* copy t to the end of out */
#define rel_append_x(out, t) _rel_append_x(out, t, "rel_append_x: "__location__)
extern void _rel_append_x (rel_table * out, rel_table t, char const * name);
extern void rel_reverse_table (rel_table t);
extern void rel_sort_table_by_field (int reverse_p,
                                     rel_table t,
                                     int field_n);
extern void rel_sort_table_by_field_fn (int reverse_p,
                                        rel_table t,
                                        int field_n, 
                                        int (*fn)(t_uchar *, t_uchar *));
extern void rel_sort_table_by_fields (int reverse_p,
                                      rel_table t,
                                      int * fields);
extern int * rel_sort_fields (int f, ...);
#define rel_uniq_by_field(table, field) _rel_uniq_by_field(table, field, "rel_uniq_by_field: "__location__)
extern void _rel_uniq_by_field (rel_table * table,
                               int field,
                               char const * name);
#define rel_cut(fields, table) _rel_cut(fields, table, "rel_uniq_by_field: "__location__)
extern rel_table _rel_cut (rel_cut_spec fields, rel_table t, char const * name);
#define rel_join(absence_table, output, table1_field, table2_field, table1, table2) _rel_join(absence_table, output, table1_field, table2_field, table1, table2, "rel_uniq_by_field: "__location__)
extern rel_table _rel_join (int absence_table,
                           struct rel_join_output_spec * output,
                           int table1_field,
                           int table2_field,
                           rel_table table1,
                           rel_table table2,
                           char const * name);
#define rel_join_output(table, field, args...) _rel_join_output("rel_join_output: "__location__, table, field, ##args)
extern struct rel_join_output_spec * _rel_join_output (char const * name,
                                                       int table,
                                                       int field, ...);
#define rel_read_table(fd, n_fields, err_name, err_src) _rel_read_table(fd, n_fields, err_name, err_src, "rel_read_table: "__location__)
extern rel_table _rel_read_table (int fd,
                                 int n_fields,
                                 char * err_name,
                                 char * err_src,
                                 char const * name);
#define rel_read_pika_unescape_iso8859_1_table(fd, n_fields, err_name, err_src) _rel_read_pika_unescape_iso8859_1_table(fd, n_fields, err_name, err_src, "rel_read_pika_unescape_iso8859_1_table: "__location__)
extern rel_table _rel_read_pika_unescape_iso8859_1_table (int fd,
                                                         int n_fields,
                                                         char * err_name,
                                                         char * err_src,
                                                         char const * name);
extern void rel_print_table (int fd, rel_table table);
extern void rel_print_pika_escape_iso8859_1_table (int fd, int escape_classes, rel_table table);
extern void rel_print_table_sp (int fd, rel_table file);
extern void rel_print_pika_escape_iso8859_1_table_sp (int fd, int escape_classes, rel_table file);
/* rel_set */
extern rel_table rel_set_subtract (rel_table left, rel_table right);
/* rel_record */
extern int rel_n_fields (rel_record r);
#define rel_make_record(field0, args...) _rel_make_record("rel_make_record: "__location__, field0, ##args)
extern rel_record _rel_make_record (char const * name, t_uchar const * const field0, ...);
#define rel_add_field(r, field) _rel_add_field(r, field, "rel_copy_record: "__location__)
extern void _rel_add_field (rel_record * r, t_uchar const * field, char const * name);
extern rel_record rel_singleton_record_n (t_uchar const * start, size_t len);
#define rel_copy_record(r) _rel_copy_record(r, "rel_copy_record: "__location__)
extern rel_record _rel_copy_record (rel_record r, char const * name);
extern rel_record rel_cut_record (rel_cut_spec fields, rel_record r);
extern rel_cut_spec rel_cut_list (int field, ...);
extern void rel_cut_spec_finalise (rel_cut_spec *spec);
#endif  /* INCLUDE__FILE_UTILS__RELATIONAL_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (relational.h)
 */
