/* relassoc.c:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "libawk/relassoc.h"



/** 
 * \brief convert a rel_table to an assoc_table
 * \param table a table to convert
 * \param key_column the column in the rel table to be key into the assoc
 * \param value_column the column in the rel table to be found by lookups in the table
 */
assoc_table
rel_to_assoc (rel_table table, int key_column, int value_column)
{
  int lim;
  int x;
  assoc_table answer = 0;

  lim = rel_n_records (table);
  for (x = 0; x < lim; ++x)
    assoc_set (&answer, table[x][key_column], table[x][value_column]);

  return answer;
}



/* tag: Tom Lord Thu May 15 14:41:16 2003 (relassoc.c)
 */
