/* project-tree.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__PROJECT_TREE_H
#define INCLUDE__LIBARCH__PROJECT_TREE_H


#include "hackerlab/machine/types.h"
#include "hackerlab/mem/talloc.h"
#include "libawk/relational.h"
#include "libawk/associative.h"
#include "libarch/patch-id.h"
#include "libarch/patch-logs.h"
#include "libarch/inventory-entry.h"



#define ARCH_PROJECT_TREE_ANCESTRY_FILE "{arch}/+ancestry"

enum arch_tree_state
{
  arch_tree_in_ok_state = 0,
  arch_tree_in_resolve_conflicts,
  arch_tree_in_commit_definite,
  arch_tree_in_mid_commit,
};

enum arch_id_tagging_method
{
  arch_names_id_tagging,
  arch_implicit_id_tagging,
  arch_tagline_id_tagging,
  arch_explicit_id_tagging,

  arch_unspecified_id_tagging,     /* used in make/apply_changeset auto detect. */
};

/* forward decls */
enum arch_inventory_category;
typedef struct arch_archive arch_archive_t;
typedef struct arch_project_tree arch_project_tree_t;

#include "libarch/invent.h"


typedef struct arch_project_tree_vtable_
{
    void (*init) (arch_project_tree_t *tree);
    enum arch_id_tagging_method (*id_tagging_method) (arch_project_tree_t * tree, enum arch_inventory_category * cat_var, int strict);
    inventory_entry_t * (*path_id) (arch_project_tree_t * tree,
                          int * errn,
                          t_uchar const * const path,
                          struct stat * known_lstat);
    void (*changeset_inventory_traveral) (arch_project_tree_t * tree, struct arch_inventory_options * options, inv_callback callback, void * closure);
    void (*mutated) (arch_project_tree_t * tree);
    int *** (*vtable_end) (char const * const * const *); /* never used, makes compile fail when new methods are added but not in 
                                                             a vtable. should always be last */
} arch_project_tree_vtable;

extern int *** arch_project_tree_vtable_end (char const * const * const *); /* never used, makes compile fail when new methods are added but not in 
                                                             a vtable */

struct arch_project_tree
{
    arch_project_tree_vtable *vtable;
    t_uchar * root;
    t_uchar * archive;
    t_uchar * fqversion;
    t_uchar * fqrevision;
    rel_table ancestry;
    t_uchar * version;  /* deprecated */
    t_uchar * revision; /* deprecated */
    assoc_table local_ancestry; /* untrusted local log data */
    arch_patch_log_dir_t *patch_logs; /* patch logs data */
    /* these are not applicable to all trees,
     * but until the object structure firms, its easier ot put them here
     */
    /* force unignored files to be tagged */
    int untagged_is_source;
    /* tree method for getting file tags */
    enum arch_id_tagging_method tag_method;
    /* cached tags (tla tree specific */
    assoc_table id_tagging_shortcut;
    /* something */
    assoc_table explicit_skips;
};


extern void arch_init_tree (t_uchar const * const tree_root);
extern t_uchar * arch_tree_root (enum arch_tree_state * state, t_uchar const * const input_dir, int accurate);
extern t_uchar * arch_tree_root_ext (void * context, enum arch_tree_state * state, t_uchar const * const input_dir, int accurate, arch_project_tree_t **object_out, int exact);
extern int arch_project_tree_dir_is_root (void * context, t_uchar const * dir, arch_project_tree_t **out);
extern t_uchar * arch_tree_ctl_dir (t_uchar const * tree_root);
extern void arch_set_tree_version (t_uchar const * tree_root, arch_patch_id * patch_id);
extern t_uchar * arch_tree_version (t_uchar const * tree_root);
extern t_uchar * arch_try_tree_version (t_uchar * cmd);
extern t_uchar * arch_try_tree_version_dir (t_uchar * cmd, arch_project_tree_t * tree);
extern void arch_start_tree_commit (arch_project_tree_t * tree, t_uchar * log);
extern void arch_finish_tree_commit (arch_project_tree_t * tree, t_uchar * archive, t_uchar * revision, t_uchar * changelog_loc);
extern void arch_abort_tree_commit (arch_project_tree_t * tree, t_uchar * archive, t_uchar * revision);
extern void arch_project_tree_init (arch_project_tree_t *tree);
extern arch_project_tree_t * arch_project_tree_new (void * context, t_uchar const * tree_root);
extern arch_project_tree_t * arch_project_tree_new_exact (void * context, t_uchar const * tree_root);
extern arch_project_tree_t * arch_project_tree_new_ext (void * context, t_uchar const * tree_root, int null_ok, int exact);
extern void arch_project_tree_finalise (arch_project_tree_t *tree);
#define arch_project_tree_delete(tree) talloc_free ((tree))
extern t_uchar * arch_project_tree_file_contents(struct arch_project_tree *tree, t_uchar const *rel_path);
extern int arch_project_tree_file_exists(struct arch_project_tree *tree, t_uchar const *rel_path);
extern rel_table arch_project_tree_ancestry (struct arch_project_tree *tree);
extern int arch_project_tree_has_patch (arch_project_tree_t *tree, t_uchar const *patch_id);
extern t_uchar * arch_project_tree_patch_filename (arch_project_tree_t *tree, t_uchar const *patch_id);
extern inventory_entry_t * arch_project_tree_path_inventory (arch_project_tree_t * tree, t_uchar const * const path, struct stat * known_lstat);
extern void arch_project_tree_changeset_inventory_traversal (arch_project_tree_t * tree, struct arch_inventory_options * options, inv_callback callback, void * closure);
extern void arch_project_tree_mutated (arch_project_tree_t * tree);
/* this s here due to layering not being fully reorganised */
extern t_uchar * arch_highest_patch_level_before (arch_project_tree_t * tree, t_uchar const *fqrevision_before);
extern t_uchar * arch_project_tree_patch_log (arch_project_tree_t * tree, t_uchar const * fqrevision);
extern t_uchar * arch_project_tree_rel_path_from_user_input (arch_project_tree_t * tree, t_uchar const * const filename);
extern t_uchar * arch_project_tree_rel_path_from_abs (arch_project_tree_t * tree, t_uchar const * const abs_path);
extern void arch_project_tree_check_name (arch_project_tree_t * tree, arch_archive_t ** arch, t_uchar ** namespace, t_uchar const * const name);
extern void arch_project_tree_check_commitable_name (arch_project_tree_t * tree, arch_archive_t ** arch, t_uchar ** namespace, t_uchar const * const name);
/* private to tla-project-tree.c, to move later RBC 20050321 */
extern inventory_entry_t * tla_path_id (arch_project_tree_t * tree, int * errn, t_uchar const * const path, struct stat * known_lstat);
#endif  /* INCLUDE__LIBARCH__PROJECT_TREE_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (project-tree.h)
 */
