/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <klocale.h>
#include <kopenwith.h>

#include "variouswidgets.h"

/** RunCommandRequester */

RunCommandRequester::RunCommandRequester(const QString &runCommand, const QString &message, QWidget *parent, const char *name)
 : QWidget(parent, name)
{
	m_message = message;

	QHBoxLayout *layout = new QHBoxLayout(this, 0, 6);
	m_runCommand        = new QLineEdit(runCommand, this);
	QPushButton *pb     = new QPushButton(i18n("C&hoose..."), this);

	layout->addWidget(m_runCommand);
	layout->addWidget(pb);

	connect( pb, SIGNAL(clicked()), this, SLOT(slotSelCommand()) );
}

RunCommandRequester::~RunCommandRequester()
{
}

void RunCommandRequester::slotSelCommand()
{
	KOpenWithDlg *dlg =  new KOpenWithDlg(KURL::List(), m_message, m_runCommand->text(), this);
	dlg->exec();
	if ( ! dlg->text().isEmpty() )
		m_runCommand->setText(dlg->text());
}

QString RunCommandRequester::runCommand()
{
	return m_runCommand->text();
}

void RunCommandRequester::setRunCommand(const QString &runCommand)
{
	m_runCommand->setText(runCommand);
}

/** IconSizeCombo */

IconSizeCombo::IconSizeCombo(bool rw, QWidget *parent, const char *name)
 : QComboBox(rw, parent, name)
{
	insertItem(i18n("16x16 pixels"));
	insertItem(i18n("22x22 pixels"));
	insertItem(i18n("32x32 pixels"));
	insertItem(i18n("48x48 pixels"));
	insertItem(i18n("64x64 pixels"));
	setCurrentItem(2);
}

IconSizeCombo::~IconSizeCombo()
{
}

int IconSizeCombo::iconSize()
{
	switch (currentItem()) {
		case 0: return 16;
		case 1: return 22;
		case 2: return 32;
		case 3: return 48;
		case 4: return 64;
	}
	return 0;
}

void IconSizeCombo::setSize(int size)
{
	switch (size) {
		case 16: setCurrentItem(0); break;
		case 22: setCurrentItem(1); break;
		case 32: setCurrentItem(2); break;
		case 48: setCurrentItem(3); break;
		case 64: setCurrentItem(4); break;
	}
}

#include "variouswidgets.moc"
