/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ITEMFACTORY_H
#define ITEMFACTORY_H

#include <qobject.h>
#include <kservice.h>
#include <qevent.h>
#include <kurl.h>
#include <qstringlist.h>

class QString;
class QPixmap;
class QColor;

class Basket;
class Item;

/**Factory class to create (new, drop, past) or load BasketIem, and eventuelly save them (?)
  *@author Sbastien Laot
  */
namespace ItemFactory
{
	/** Functions to create a new item from a content */
	// TODO: rename to createText(), createHtml(), createLink()...
	Item* createItemText(  const QString &text,    Basket *parent, const QString &annotations = QString() );
	Item* createItemHtml(  const QString &html,    Basket *parent, const QString &annotations = QString() );
	Item* createItemLink(  const KURL    &url,     Basket *parent, const QString &annotations = QString() );
	Item* createItemImage( const QPixmap &image,   Basket *parent, const QString &annotations = QString() );
	Item* createItemColor( const QColor  &color,   Basket *parent, const QString &annotations = QString() );
	Item* createItem(      const QString &content, Basket *parent, const QString &annotations = QString() );
	                       // Find automatically the type (from a text)
	Item* createItemLink(  const KURL    &url,     const QString &title, Basket *parent, const QString &annotations = "" );
//	Item* createItemLauncher(KService::Ptr service, Basket *parent );
	Item* createItemLauncher(const KURL  &url,     Basket *parent);
	Item* createItemLauncher(const QString &command, const QString &name, const QString &icon, Basket *parent);
	QString createItemLauncherFile(const QString &command, const QString &name, const QString &icon, Basket *parent);
	Item* createItemUnknow(QMimeSource *source,    Basket *parent, const QString &annotations = QString() );
	/** Functions to create derived items from a content */         //service helps to guess title and icon
	Item* createItemLinkOrLauncher( const KURL &url, Basket *parent );
//	Item* loadFromFile(             const KURL &url, Basket *parent, bool copy = true );
//	Item* loadFromFile(             const QString &fileName, Basket *parent,
//	                                KURL *urlToLoadFrom = 0, const QString &annotations = QString());
	Item* copyFileAndLoad( const KURL &url,         Basket *parent );
	Item* moveFileAndLoad( const KURL &url,         Basket *parent );
	Item* loadFile(        const QString &fileName, Basket *parent, const QString &annotations = "" );
	Item::Type typeForURL(const KURL &url, Basket *parent);
	/** Functions to create a new item from a drop or past event */
	void dropItem(QMimeSource *source, Basket *parent,
	              bool fromDrop = false, QDropEvent::Action action = QDropEvent::Copy, Item *itemSource = 0);
	void dropURLs(KURL::List urls, Basket *parent, QDropEvent::Action action, bool fromDrop);
	/** Other useful functions */
	bool    maybeText(const KURL &url);
	bool    maybeHtml(const KURL &url);
	bool    maybeImageOrAnimation(const KURL &url);
	bool    maybeAnimation(const KURL &url);
	bool    maybeSound(const KURL &url);
	bool    maybeLauncher(const KURL &url);
	QString fileNameForNewFile(const QString &wantedName, const QString &destFolder);
	QString fileNameForNewItem(Basket *parent, const QString &wantedName);
	QString createFileForNewItem(Basket *parent, const QString &extension, const QString &wantedName = "");
	QFont   fontForFontType(int type);
	QString titleForURL(const KURL &url);
	QString iconForURL(const KURL &url);
	QString iconForCommand(const QString &command);
	bool    isIconExist(const QString &icon);
	QStringList textToURLList(const QString &text); // Contain {url1, title1, url2, title2, url3, title3...}
	/** Insert GUI menu */
	void insertEmpty(  int type, Basket *parent ); // Insert empty if of type Item::Type
	void insertWizard( int type, Basket *parent ); // Open a wizard to import an item
}

#endif // ITEMFACTORY_H
