# Balazar
# Copyright (C) 2003-2005 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os, os.path, pickle

import tofu, soya, soya.tofu4soya as tofu4soya

import balazar, balazar.item, balazar.level, balazar.globdef as globdef
from balazar.hero import Balazar


class Player(tofu4soya.Player):
  def __init__(self, filename, password, client_side_data = ""):
    tofu4soya.Player.__init__(self, filename, password)
    
    level     = balazar.level.Level.get_by_pos(0, 0)
    #level     = balazar.level.Level.get_by_pos(4, -1)
    #level     = balazar.level.Level.get_by_pos(-1000, 0)
    character = Balazar()
    #from balazar.morkul import MorkulChief
    #character = MorkulChief()
    #from balazar.echassian import Echassian
    #character = Echassian()
    #character.set_xyz(216.160568237, -3.0, 213.817764282)
    #character.set_xyz(60.28622150421, 27.9200000763, 81.356338501)
    character.bot = 0

    character.set_xyz(level.bridge_2_1.x, level.bridge_2_1.y + 26.0, level.bridge_2_1.z)
    #character.set_xyz(50.0, 50.0, 50.0)
    
    character.rotate_lateral(90.0)
    
    #for m in level.mobiles:
    #  if isinstance(m, balazar.trap.GridOpener) and m.typ == 1:
    #    character.move(m)
    #    character.y += 3.0
    
    character.is_new_player = 1
    
    level.add_mobile(character)
    self .add_mobile(character)
    
    self.save_pos()

  def kill(self, last_mobile):
    self.logout(0)
    
    # Some items have been ejected when killed !
    # => we need to get the items of the killed mobile

    # Get the items still present
    items = [item for item in last_mobile.items]
    for item in items: item.set_owner(None)
    
    self.mobiles = pickle.loads(self.saved_data)
    if getattr(self.mobiles[0], "is_new_player", 0): del self.mobiles[0].is_new_player
    self.mobiles[0].life = 1.0
    
    # Remove the items that have been dropped at death
    for item in self.mobiles[0].items[:]:
      if item.equiped: item.set_equiped(0)
      
    self.mobiles[0].items = []
    for item in items: self.mobiles[0].add_item(item)
    
    # Loaded from string => new objects => need to recompute Unique IDs
    for mobile in self.mobiles: mobile.loaded()
    
    # Save after the item's removal
    self.save_pos()
    
    #open(os.path.join(tofu.path[0], self.DIRNAME, self.filename.replace("/", os.sep)) + ".data", "wb").write(self.saved_data)
    
    self.discard()
    
  def loaded(self):
    tofu4soya.Player.loaded(self)
    
    if getattr(self.mobiles[0], "is_new_player", 0): del self.mobiles[0].is_new_player
      
  def save_pos(self):
    #store = self.notifier, self.address
    #self.notifier, self.address = None, None
    
    #tofu._SAVING = self
    self.saved_data = pickle.dumps(self.mobiles, 1)
    #tofu._SAVING = None
    
    #self.notifier, self.address = store
