/*
 * Copyright 2002 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef BAKERY_GNOMEUI_CONFIGURATION_DIALOG_PREFERENCES_H
#define BAKERY_GNOMEUI_CONFIGURATION_DIALOG_PREFERENCES_H

#include <bakery/Configuration/Dialog_Preferences.h>

namespace Bakery
{

/** Preferences Dialog
 * In the Glade file:
 * - The vbox should contain a widget called "vbox".
 *
 * Use connect_widget(conf_key, widget_name) in the constructor.
 */

class Dialog_Preferences_GnomeUI : public Dialog_Preferences
{
public:
  Dialog_Preferences_GnomeUI(Gtk::Window& parent, const Glib::ustring& configuration_directory, const Glib::ustring& glade_filename, const Glib::ustring& widget_name = "vbox", bool instant = false);
  virtual ~Dialog_Preferences_GnomeUI();
};

} //namespace Bakery

#endif //BAKERY_GNOMEUI_CONFIGURATION_DIALOG_PREFERENCES_H
