/*
 * Copyright 2000 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef BAKERY_GNOMEUI_APP_WITHDOC_GTK_H
#define BAKERY_GNOMEUI_APP_WITHDOC_GTK_H

#include <bakery_gnomeui/App/App_GnomeUI.h>
#include <bakery/App/App_WithDoc.h>

namespace Bakery
{

/** Main Window which supports documents.
 * Features:
 * - Derive from this class
 * - 1 document per application instance. Uses Document-derived class polymorphically.
 * - Override pure virtual method to create new blank document.
 * - Appropriate Default handling of document open, save, save as.
 * - Appropriate checking of document 'modified' status - asks user about unsaved changes.
 * - Asks user about overwriting existing documents.
 * - Override methods to add/change menus/toolbars/statusbar.
 *   - Default is basic File, Edit, Help menus and toolbar icons.
 * - Shows document name (or 'untitled') in window title.
 * - Shows * in title bar for unsaved docs. Overridable to e.g. shade a Save icon.
 * - Enforces a file extension.
 * - Recent Documents menu item
 *
 *
 * TODO:
 * Bonobo integration - when Bonobo is ready. (An App subclass?)
 * - Printing - GnomePrint?
 *  - Print Setup
 *  - Print Preview
 *  - Multiple document-types:
 *  - File/New sub menu
 *  - Some way to associate a view with a document type: class factory.
 */
class App_WithDoc_GnomeUI
    //These are virtual base classes, with shared shared App and SigC::Object base classes:
  : public App_WithDoc,
    public App_GnomeUI
{
public: 
  ///Don't forget to call init() too.
  App_WithDoc_GnomeUI(const Glib::ustring& appname, const Glib::ustring& title);
  virtual ~App_WithDoc_GnomeUI();

  virtual void init(); //Unique final overrider.
   
protected:
  virtual void init_menus_file(); //overridden to add open/save/save as.
  virtual void init_toolbars(); //overridden to add open/save
  virtual void init_menus(); //overriden to get widget pointers.


  //Signal handlers:

  //Session Client:
  virtual bool on_session_save_yourself(int phase, Gnome::UI::SaveStyle save_style, bool is_shutdown, Gnome::UI::InteractStyle interact_style, bool is_fast); //override
 
  void session_load_documents_open();
  static void session_save_documents_open();
  
  virtual void update_window_title();
  virtual void show_document_history();

  //Overrides:
  virtual void ui_warning(const Glib::ustring& text);
  virtual Glib::ustring ui_file_select_open();
  virtual Glib::ustring ui_file_select_save(const Glib::ustring& old_filepath);
  virtual void ui_show_modification_status();
  virtual enumSaveChanges ui_offer_to_save_changes();
  virtual bool ui_ask_overwrite(const std::string& filepath);
  
  //Menu stuff:
  guint m_iMenuPos_File, m_iMenuPos_File_Save;
  Gtk::Widget* m_pMenuItem_File_Save;
  Gtk::Widget* m_pToolbarItem_Save;

  bool m_bMenuOpenRecentCreated;
};

} //namespace

#endif //BAKERY_GNOMEUI_APP_WITHDOC_GTK_H
