# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Create(AAZCommand):
    """Create the specified application gateway.
    """

    _aaz_info = {
        "version": "2022-05-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/applicationgateways/{}", "2022-05-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the application gateway.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "Parameters"

        _args_schema = cls._args_schema
        _args_schema.identity = AAZObjectArg(
            options=["--identity"],
            arg_group="Parameters",
            help="The identity of the application gateway, if configured.",
        )
        _args_schema.location = AAZResourceLocationArg(
            arg_group="Parameters",
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            arg_group="Parameters",
            help="Resource tags.",
        )
        _args_schema.zones = AAZListArg(
            options=["--zones"],
            arg_group="Parameters",
            help="A list of availability zones denoting where the resource needs to come from.",
        )

        identity = cls._args_schema.identity
        identity.type = AAZStrArg(
            options=["type"],
            help="The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.",
            enum={"None": "None", "SystemAssigned": "SystemAssigned", "SystemAssigned, UserAssigned": "SystemAssigned, UserAssigned", "UserAssigned": "UserAssigned"},
        )
        identity.user_assigned_identities = AAZDictArg(
            options=["user-assigned-identities"],
            help="The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.",
        )

        user_assigned_identities = cls._args_schema.identity.user_assigned_identities
        user_assigned_identities.Element = AAZObjectArg(
            blank={},
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        zones = cls._args_schema.zones
        zones.Element = AAZStrArg()

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.authentication_certificates = AAZListArg(
            options=["--authentication-certificates"],
            arg_group="Properties",
            help="Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.autoscale_configuration = AAZObjectArg(
            options=["--autoscale-configuration"],
            arg_group="Properties",
            help="Autoscale Configuration.",
        )
        _args_schema.backend_address_pools = AAZListArg(
            options=["--backend-address-pools"],
            arg_group="Properties",
            help="Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.backend_http_settings_collection = AAZListArg(
            options=["--backend-http-settings-collection"],
            arg_group="Properties",
            help="Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.backend_settings_collection = AAZListArg(
            options=["--backend-settings-collection"],
            arg_group="Properties",
            help="Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.custom_error_configurations = AAZListArg(
            options=["--custom-error-configurations"],
            arg_group="Properties",
            help="Custom error configurations of the application gateway resource.",
        )
        _args_schema.enable_fips = AAZBoolArg(
            options=["--enable-fips"],
            arg_group="Properties",
            help="Whether FIPS is enabled on the application gateway resource.",
        )
        _args_schema.enable_http2 = AAZBoolArg(
            options=["--enable-http2"],
            arg_group="Properties",
            help="Whether HTTP2 is enabled on the application gateway resource.",
        )
        _args_schema.firewall_policy = AAZObjectArg(
            options=["--firewall-policy"],
            arg_group="Properties",
            help="Reference to the FirewallPolicy resource.",
        )
        cls._build_args_sub_resource_create(_args_schema.firewall_policy)
        _args_schema.force_firewall_policy_association = AAZBoolArg(
            options=["--force-firewall-policy-association"],
            arg_group="Properties",
            help="If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config.",
        )
        _args_schema.frontend_ip_configurations = AAZListArg(
            options=["--frontend-ip-configurations"],
            arg_group="Properties",
            help="Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.frontend_ports = AAZListArg(
            options=["--frontend-ports"],
            arg_group="Properties",
            help="Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.gateway_ip_configurations = AAZListArg(
            options=["--gateway-ip-configurations"],
            arg_group="Properties",
            help="Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.global_configuration = AAZObjectArg(
            options=["--global-configuration"],
            arg_group="Properties",
            help="Global Configuration.",
        )
        _args_schema.http_listeners = AAZListArg(
            options=["--http-listeners"],
            arg_group="Properties",
            help="Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.listeners = AAZListArg(
            options=["--listeners"],
            arg_group="Properties",
            help="Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.load_distribution_policies = AAZListArg(
            options=["--load-distribution-policies"],
            arg_group="Properties",
            help="Load distribution policies of the application gateway resource.",
        )
        _args_schema.private_link_configurations = AAZListArg(
            options=["--private-link-configurations"],
            arg_group="Properties",
            help="PrivateLink configurations on application gateway.",
        )
        _args_schema.probes = AAZListArg(
            options=["--probes"],
            arg_group="Properties",
            help="Probes of the application gateway resource.",
        )
        _args_schema.redirect_configurations = AAZListArg(
            options=["--redirect-configurations"],
            arg_group="Properties",
            help="Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.request_routing_rules = AAZListArg(
            options=["--request-routing-rules"],
            arg_group="Properties",
            help="Request routing rules of the application gateway resource.",
        )
        _args_schema.rewrite_rule_sets = AAZListArg(
            options=["--rewrite-rule-sets"],
            arg_group="Properties",
            help="Rewrite rules for the application gateway resource.",
        )
        _args_schema.routing_rules = AAZListArg(
            options=["--routing-rules"],
            arg_group="Properties",
            help="Routing rules of the application gateway resource.",
        )
        _args_schema.sku = AAZObjectArg(
            options=["--sku"],
            arg_group="Properties",
            help="SKU of the application gateway resource.",
        )
        _args_schema.ssl_certificates = AAZListArg(
            options=["--ssl-certificates"],
            arg_group="Properties",
            help="SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.ssl_policy = AAZObjectArg(
            options=["--ssl-policy"],
            arg_group="Properties",
            help="SSL policy of the application gateway resource.",
        )
        cls._build_args_application_gateway_ssl_policy_create(_args_schema.ssl_policy)
        _args_schema.ssl_profiles = AAZListArg(
            options=["--ssl-profiles"],
            arg_group="Properties",
            help="SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.trusted_client_certificates = AAZListArg(
            options=["--trusted-client-certificates"],
            arg_group="Properties",
            help="Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.trusted_root_certificates = AAZListArg(
            options=["--trusted-root-certificates"],
            arg_group="Properties",
            help="Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.url_path_maps = AAZListArg(
            options=["--url-path-maps"],
            arg_group="Properties",
            help="URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).",
        )
        _args_schema.web_application_firewall_configuration = AAZObjectArg(
            options=["--web-application-firewall-configuration"],
            arg_group="Properties",
            help="Web application firewall configuration.",
        )

        authentication_certificates = cls._args_schema.authentication_certificates
        authentication_certificates.Element = AAZObjectArg()

        _element = cls._args_schema.authentication_certificates.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the authentication certificate that is unique within an Application Gateway.",
        )
        _element.data = AAZStrArg(
            options=["data"],
            help="Certificate public data.",
        )

        autoscale_configuration = cls._args_schema.autoscale_configuration
        autoscale_configuration.max_capacity = AAZIntArg(
            options=["max-capacity"],
            help="Upper bound on number of Application Gateway capacity.",
            fmt=AAZIntArgFormat(
                minimum=2,
            ),
        )
        autoscale_configuration.min_capacity = AAZIntArg(
            options=["min-capacity"],
            help="Lower bound on number of Application Gateway capacity.",
            required=True,
            fmt=AAZIntArgFormat(
                minimum=0,
            ),
        )

        backend_address_pools = cls._args_schema.backend_address_pools
        backend_address_pools.Element = AAZObjectArg()

        _element = cls._args_schema.backend_address_pools.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the backend address pool that is unique within an Application Gateway.",
        )
        _element.backend_addresses = AAZListArg(
            options=["backend-addresses"],
            help="Backend addresses.",
        )

        backend_addresses = cls._args_schema.backend_address_pools.Element.backend_addresses
        backend_addresses.Element = AAZObjectArg()

        _element = cls._args_schema.backend_address_pools.Element.backend_addresses.Element
        _element.fqdn = AAZStrArg(
            options=["fqdn"],
            help="Fully qualified domain name (FQDN).",
        )
        _element.ip_address = AAZStrArg(
            options=["ip-address"],
            help="IP address.",
        )

        backend_http_settings_collection = cls._args_schema.backend_http_settings_collection
        backend_http_settings_collection.Element = AAZObjectArg()

        _element = cls._args_schema.backend_http_settings_collection.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the backend http settings that is unique within an Application Gateway.",
        )
        _element.affinity_cookie_name = AAZStrArg(
            options=["affinity-cookie-name"],
            help="Cookie name to use for the affinity cookie.",
        )
        _element.authentication_certificates = AAZListArg(
            options=["authentication-certificates"],
            help="Array of references to application gateway authentication certificates.",
        )
        _element.connection_draining = AAZObjectArg(
            options=["connection-draining"],
            help="Connection draining of the backend http settings resource.",
        )
        _element.cookie_based_affinity = AAZStrArg(
            options=["cookie-based-affinity"],
            help="Cookie based affinity.",
            enum={"Disabled": "Disabled", "Enabled": "Enabled"},
        )
        _element.host_name = AAZStrArg(
            options=["host-name"],
            help="Host header to be sent to the backend servers.",
        )
        _element.path = AAZStrArg(
            options=["path"],
            help="Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.",
        )
        _element.pick_host_name_from_backend_address = AAZBoolArg(
            options=["pick-host-name-from-backend-address"],
            help="Whether to pick host header should be picked from the host name of the backend server. Default value is false.",
        )
        _element.port = AAZIntArg(
            options=["port"],
            help="The destination port on the backend.",
        )
        _element.probe = AAZObjectArg(
            options=["probe"],
            help="Probe resource of an application gateway.",
        )
        cls._build_args_sub_resource_create(_element.probe)
        _element.probe_enabled = AAZBoolArg(
            options=["probe-enabled"],
            help="Whether the probe is enabled. Default value is false.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The protocol used to communicate with the backend.",
            enum={"Http": "Http", "Https": "Https", "Tcp": "Tcp", "Tls": "Tls"},
        )
        _element.request_timeout = AAZIntArg(
            options=["request-timeout"],
            help="Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.",
        )
        _element.trusted_root_certificates = AAZListArg(
            options=["trusted-root-certificates"],
            help="Array of references to application gateway trusted root certificates.",
        )

        authentication_certificates = cls._args_schema.backend_http_settings_collection.Element.authentication_certificates
        authentication_certificates.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(authentication_certificates.Element)

        connection_draining = cls._args_schema.backend_http_settings_collection.Element.connection_draining
        connection_draining.drain_timeout_in_sec = AAZIntArg(
            options=["drain-timeout-in-sec"],
            help="The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.",
            required=True,
            fmt=AAZIntArgFormat(
                maximum=3600,
                minimum=1,
            ),
        )
        connection_draining.enabled = AAZBoolArg(
            options=["enabled"],
            help="Whether connection draining is enabled or not.",
            required=True,
        )

        trusted_root_certificates = cls._args_schema.backend_http_settings_collection.Element.trusted_root_certificates
        trusted_root_certificates.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(trusted_root_certificates.Element)

        backend_settings_collection = cls._args_schema.backend_settings_collection
        backend_settings_collection.Element = AAZObjectArg()

        _element = cls._args_schema.backend_settings_collection.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the backend settings that is unique within an Application Gateway.",
        )
        _element.host_name = AAZStrArg(
            options=["host-name"],
            help="Server name indication to be sent to the backend servers for Tls protocol.",
        )
        _element.pick_host_name_from_backend_address = AAZBoolArg(
            options=["pick-host-name-from-backend-address"],
            help="Whether to pick server name indication from the host name of the backend server for Tls protocol. Default value is false.",
        )
        _element.port = AAZIntArg(
            options=["port"],
            help="The destination port on the backend.",
        )
        _element.probe = AAZObjectArg(
            options=["probe"],
            help="Probe resource of an application gateway.",
        )
        cls._build_args_sub_resource_create(_element.probe)
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The protocol used to communicate with the backend.",
            enum={"Http": "Http", "Https": "Https", "Tcp": "Tcp", "Tls": "Tls"},
        )
        _element.timeout = AAZIntArg(
            options=["timeout"],
            help="Connection timeout in seconds. Application Gateway will fail the request if response is not received within ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds.",
        )
        _element.trusted_root_certificates = AAZListArg(
            options=["trusted-root-certificates"],
            help="Array of references to application gateway trusted root certificates.",
        )

        trusted_root_certificates = cls._args_schema.backend_settings_collection.Element.trusted_root_certificates
        trusted_root_certificates.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(trusted_root_certificates.Element)

        custom_error_configurations = cls._args_schema.custom_error_configurations
        custom_error_configurations.Element = AAZObjectArg()
        cls._build_args_application_gateway_custom_error_create(custom_error_configurations.Element)

        frontend_ip_configurations = cls._args_schema.frontend_ip_configurations
        frontend_ip_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.frontend_ip_configurations.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the frontend IP configuration that is unique within an Application Gateway.",
        )
        _element.private_ip_address = AAZStrArg(
            options=["private-ip-address"],
            help="PrivateIPAddress of the network interface IP Configuration.",
        )
        _element.private_ip_allocation_method = AAZStrArg(
            options=["private-ip-allocation-method"],
            help="The private IP address allocation method.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        _element.private_link_configuration = AAZObjectArg(
            options=["private-link-configuration"],
            help="Reference to the application gateway private link configuration.",
        )
        cls._build_args_sub_resource_create(_element.private_link_configuration)
        _element.public_ip_address = AAZObjectArg(
            options=["public-ip-address"],
            help="Reference to the PublicIP resource.",
        )
        cls._build_args_sub_resource_create(_element.public_ip_address)
        _element.subnet = AAZObjectArg(
            options=["subnet"],
            help="Reference to the subnet resource.",
        )
        cls._build_args_sub_resource_create(_element.subnet)

        frontend_ports = cls._args_schema.frontend_ports
        frontend_ports.Element = AAZObjectArg()

        _element = cls._args_schema.frontend_ports.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the frontend port that is unique within an Application Gateway.",
        )
        _element.port = AAZIntArg(
            options=["port"],
            help="Frontend port.",
        )

        gateway_ip_configurations = cls._args_schema.gateway_ip_configurations
        gateway_ip_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.gateway_ip_configurations.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the IP configuration that is unique within an Application Gateway.",
        )
        _element.subnet = AAZObjectArg(
            options=["subnet"],
            help="Reference to the subnet resource. A subnet from where application gateway gets its private address.",
        )
        cls._build_args_sub_resource_create(_element.subnet)

        global_configuration = cls._args_schema.global_configuration
        global_configuration.enable_request_buffering = AAZBoolArg(
            options=["enable-request-buffering"],
            help="Enable request buffering.",
        )
        global_configuration.enable_response_buffering = AAZBoolArg(
            options=["enable-response-buffering"],
            help="Enable response buffering.",
        )

        http_listeners = cls._args_schema.http_listeners
        http_listeners.Element = AAZObjectArg()

        _element = cls._args_schema.http_listeners.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the HTTP listener that is unique within an Application Gateway.",
        )
        _element.custom_error_configurations = AAZListArg(
            options=["custom-error-configurations"],
            help="Custom error configurations of the HTTP listener.",
        )
        _element.firewall_policy = AAZObjectArg(
            options=["firewall-policy"],
            help="Reference to the FirewallPolicy resource.",
        )
        cls._build_args_sub_resource_create(_element.firewall_policy)
        _element.frontend_ip_configuration = AAZObjectArg(
            options=["frontend-ip-configuration"],
            help="Frontend IP configuration resource of an application gateway.",
        )
        cls._build_args_sub_resource_create(_element.frontend_ip_configuration)
        _element.frontend_port = AAZObjectArg(
            options=["frontend-port"],
            help="Frontend port resource of an application gateway.",
        )
        cls._build_args_sub_resource_create(_element.frontend_port)
        _element.host_name = AAZStrArg(
            options=["host-name"],
            help="Host name of HTTP listener.",
        )
        _element.host_names = AAZListArg(
            options=["host-names"],
            help="List of Host names for HTTP Listener that allows special wildcard characters as well.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="Protocol of the HTTP listener.",
            enum={"Http": "Http", "Https": "Https", "Tcp": "Tcp", "Tls": "Tls"},
        )
        _element.require_server_name_indication = AAZBoolArg(
            options=["require-server-name-indication"],
            help="Applicable only if protocol is https. Enables SNI for multi-hosting.",
        )
        _element.ssl_certificate = AAZObjectArg(
            options=["ssl-certificate"],
            help="SSL certificate resource of an application gateway.",
        )
        cls._build_args_sub_resource_create(_element.ssl_certificate)
        _element.ssl_profile = AAZObjectArg(
            options=["ssl-profile"],
            help="SSL profile resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.ssl_profile)

        custom_error_configurations = cls._args_schema.http_listeners.Element.custom_error_configurations
        custom_error_configurations.Element = AAZObjectArg()
        cls._build_args_application_gateway_custom_error_create(custom_error_configurations.Element)

        host_names = cls._args_schema.http_listeners.Element.host_names
        host_names.Element = AAZStrArg()

        listeners = cls._args_schema.listeners
        listeners.Element = AAZObjectArg()

        _element = cls._args_schema.listeners.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the listener that is unique within an Application Gateway.",
        )
        _element.frontend_ip_configuration = AAZObjectArg(
            options=["frontend-ip-configuration"],
            help="Frontend IP configuration resource of an application gateway.",
        )
        cls._build_args_sub_resource_create(_element.frontend_ip_configuration)
        _element.frontend_port = AAZObjectArg(
            options=["frontend-port"],
            help="Frontend port resource of an application gateway.",
        )
        cls._build_args_sub_resource_create(_element.frontend_port)
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="Protocol of the listener.",
            enum={"Http": "Http", "Https": "Https", "Tcp": "Tcp", "Tls": "Tls"},
        )
        _element.ssl_certificate = AAZObjectArg(
            options=["ssl-certificate"],
            help="SSL certificate resource of an application gateway.",
        )
        cls._build_args_sub_resource_create(_element.ssl_certificate)
        _element.ssl_profile = AAZObjectArg(
            options=["ssl-profile"],
            help="SSL profile resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.ssl_profile)

        load_distribution_policies = cls._args_schema.load_distribution_policies
        load_distribution_policies.Element = AAZObjectArg()

        _element = cls._args_schema.load_distribution_policies.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the load distribution policy that is unique within an Application Gateway.",
        )
        _element.load_distribution_algorithm = AAZStrArg(
            options=["load-distribution-algorithm"],
            help="Load Distribution Targets resource of an application gateway.",
            enum={"IpHash": "IpHash", "LeastConnections": "LeastConnections", "RoundRobin": "RoundRobin"},
        )
        _element.load_distribution_targets = AAZListArg(
            options=["load-distribution-targets"],
            help="Load Distribution Targets resource of an application gateway.",
        )

        load_distribution_targets = cls._args_schema.load_distribution_policies.Element.load_distribution_targets
        load_distribution_targets.Element = AAZObjectArg()

        _element = cls._args_schema.load_distribution_policies.Element.load_distribution_targets.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the load distribution policy that is unique within an Application Gateway.",
        )
        _element.backend_address_pool = AAZObjectArg(
            options=["backend-address-pool"],
            help="Backend address pool resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.backend_address_pool)
        _element.weight_per_server = AAZIntArg(
            options=["weight-per-server"],
            help="Weight per server. Range between 1 and 100.",
            fmt=AAZIntArgFormat(
                maximum=100,
                minimum=1,
            ),
        )

        private_link_configurations = cls._args_schema.private_link_configurations
        private_link_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.private_link_configurations.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the private link configuration that is unique within an Application Gateway.",
        )
        _element.ip_configurations = AAZListArg(
            options=["ip-configurations"],
            help="An array of application gateway private link ip configurations.",
        )

        ip_configurations = cls._args_schema.private_link_configurations.Element.ip_configurations
        ip_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.private_link_configurations.Element.ip_configurations.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of application gateway private link ip configuration.",
        )
        _element.primary = AAZBoolArg(
            options=["primary"],
            help="Whether the ip configuration is primary or not.",
        )
        _element.private_ip_address = AAZStrArg(
            options=["private-ip-address"],
            help="The private IP address of the IP configuration.",
        )
        _element.private_ip_allocation_method = AAZStrArg(
            options=["private-ip-allocation-method"],
            help="The private IP address allocation method.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        _element.subnet = AAZObjectArg(
            options=["subnet"],
            help="Reference to the subnet resource.",
        )
        cls._build_args_sub_resource_create(_element.subnet)

        probes = cls._args_schema.probes
        probes.Element = AAZObjectArg()

        _element = cls._args_schema.probes.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the probe that is unique within an Application Gateway.",
        )
        _element.host = AAZStrArg(
            options=["host"],
            help="Host name to send the probe to.",
        )
        _element.interval = AAZIntArg(
            options=["interval"],
            help="The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.",
        )
        _element.match = AAZObjectArg(
            options=["match"],
            help="Criterion for classifying a healthy probe response.",
        )
        _element.min_servers = AAZIntArg(
            options=["min-servers"],
            help="Minimum number of servers that are always marked healthy. Default value is 0.",
        )
        _element.path = AAZStrArg(
            options=["path"],
            help="Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.",
        )
        _element.pick_host_name_from_backend_http_settings = AAZBoolArg(
            options=["pick-host-name-from-backend-http-settings"],
            help="Whether the host header should be picked from the backend http settings. Default value is false.",
        )
        _element.pick_host_name_from_backend_settings = AAZBoolArg(
            options=["pick-host-name-from-backend-settings"],
            help="Whether the server name indication should be picked from the backend settings for Tls protocol. Default value is false.",
        )
        _element.port = AAZIntArg(
            options=["port"],
            help="Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only.",
            fmt=AAZIntArgFormat(
                maximum=65535,
                minimum=1,
            ),
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The protocol used for the probe.",
            enum={"Http": "Http", "Https": "Https", "Tcp": "Tcp", "Tls": "Tls"},
        )
        _element.timeout = AAZIntArg(
            options=["timeout"],
            help="The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.",
        )
        _element.unhealthy_threshold = AAZIntArg(
            options=["unhealthy-threshold"],
            help="The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.",
        )

        match = cls._args_schema.probes.Element.match
        match.body = AAZStrArg(
            options=["body"],
            help="Body that must be contained in the health response. Default value is empty.",
        )
        match.status_codes = AAZListArg(
            options=["status-codes"],
            help="Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.",
        )

        status_codes = cls._args_schema.probes.Element.match.status_codes
        status_codes.Element = AAZStrArg()

        redirect_configurations = cls._args_schema.redirect_configurations
        redirect_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.redirect_configurations.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the redirect configuration that is unique within an Application Gateway.",
        )
        _element.include_path = AAZBoolArg(
            options=["include-path"],
            help="Include path in the redirected url.",
        )
        _element.include_query_string = AAZBoolArg(
            options=["include-query-string"],
            help="Include query string in the redirected url.",
        )
        _element.path_rules = AAZListArg(
            options=["path-rules"],
            help="Path rules specifying redirect configuration.",
        )
        _element.redirect_type = AAZStrArg(
            options=["redirect-type"],
            help="HTTP redirection type.",
            enum={"Found": "Found", "Permanent": "Permanent", "SeeOther": "SeeOther", "Temporary": "Temporary"},
        )
        _element.request_routing_rules = AAZListArg(
            options=["request-routing-rules"],
            help="Request routing specifying redirect configuration.",
        )
        _element.target_listener = AAZObjectArg(
            options=["target-listener"],
            help="Reference to a listener to redirect the request to.",
        )
        cls._build_args_sub_resource_create(_element.target_listener)
        _element.target_url = AAZStrArg(
            options=["target-url"],
            help="Url to redirect the request to.",
        )
        _element.url_path_maps = AAZListArg(
            options=["url-path-maps"],
            help="Url path maps specifying default redirect configuration.",
        )

        path_rules = cls._args_schema.redirect_configurations.Element.path_rules
        path_rules.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(path_rules.Element)

        request_routing_rules = cls._args_schema.redirect_configurations.Element.request_routing_rules
        request_routing_rules.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(request_routing_rules.Element)

        url_path_maps = cls._args_schema.redirect_configurations.Element.url_path_maps
        url_path_maps.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(url_path_maps.Element)

        request_routing_rules = cls._args_schema.request_routing_rules
        request_routing_rules.Element = AAZObjectArg()

        _element = cls._args_schema.request_routing_rules.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the request routing rule that is unique within an Application Gateway.",
        )
        _element.backend_address_pool = AAZObjectArg(
            options=["backend-address-pool"],
            help="Backend address pool resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.backend_address_pool)
        _element.backend_http_settings = AAZObjectArg(
            options=["backend-http-settings"],
            help="Backend http settings resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.backend_http_settings)
        _element.http_listener = AAZObjectArg(
            options=["http-listener"],
            help="Http listener resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.http_listener)
        _element.load_distribution_policy = AAZObjectArg(
            options=["load-distribution-policy"],
            help="Load Distribution Policy resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.load_distribution_policy)
        _element.priority = AAZIntArg(
            options=["priority"],
            help="Priority of the request routing rule.",
            fmt=AAZIntArgFormat(
                maximum=20000,
                minimum=1,
            ),
        )
        _element.redirect_configuration = AAZObjectArg(
            options=["redirect-configuration"],
            help="Redirect configuration resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.redirect_configuration)
        _element.rewrite_rule_set = AAZObjectArg(
            options=["rewrite-rule-set"],
            help="Rewrite Rule Set resource in Basic rule of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.rewrite_rule_set)
        _element.rule_type = AAZStrArg(
            options=["rule-type"],
            help="Rule type.",
            enum={"Basic": "Basic", "PathBasedRouting": "PathBasedRouting"},
        )
        _element.url_path_map = AAZObjectArg(
            options=["url-path-map"],
            help="URL path map resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.url_path_map)

        rewrite_rule_sets = cls._args_schema.rewrite_rule_sets
        rewrite_rule_sets.Element = AAZObjectArg()

        _element = cls._args_schema.rewrite_rule_sets.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the rewrite rule set that is unique within an Application Gateway.",
        )
        _element.rewrite_rules = AAZListArg(
            options=["rewrite-rules"],
            help="Rewrite rules in the rewrite rule set.",
        )

        rewrite_rules = cls._args_schema.rewrite_rule_sets.Element.rewrite_rules
        rewrite_rules.Element = AAZObjectArg()

        _element = cls._args_schema.rewrite_rule_sets.Element.rewrite_rules.Element
        _element.action_set = AAZObjectArg(
            options=["action-set"],
            help="Set of actions to be done as part of the rewrite Rule.",
        )
        _element.conditions = AAZListArg(
            options=["conditions"],
            help="Conditions based on which the action set execution will be evaluated.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the rewrite rule that is unique within an Application Gateway.",
        )
        _element.rule_sequence = AAZIntArg(
            options=["rule-sequence"],
            help="Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.",
        )

        action_set = cls._args_schema.rewrite_rule_sets.Element.rewrite_rules.Element.action_set
        action_set.request_header_configurations = AAZListArg(
            options=["request-header-configurations"],
            help="Request Header Actions in the Action Set.",
        )
        action_set.response_header_configurations = AAZListArg(
            options=["response-header-configurations"],
            help="Response Header Actions in the Action Set.",
        )
        action_set.url_configuration = AAZObjectArg(
            options=["url-configuration"],
            help="Url Configuration Action in the Action Set.",
        )

        request_header_configurations = cls._args_schema.rewrite_rule_sets.Element.rewrite_rules.Element.action_set.request_header_configurations
        request_header_configurations.Element = AAZObjectArg()
        cls._build_args_application_gateway_header_configuration_create(request_header_configurations.Element)

        response_header_configurations = cls._args_schema.rewrite_rule_sets.Element.rewrite_rules.Element.action_set.response_header_configurations
        response_header_configurations.Element = AAZObjectArg()
        cls._build_args_application_gateway_header_configuration_create(response_header_configurations.Element)

        url_configuration = cls._args_schema.rewrite_rule_sets.Element.rewrite_rules.Element.action_set.url_configuration
        url_configuration.modified_path = AAZStrArg(
            options=["modified-path"],
            help="Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.",
        )
        url_configuration.modified_query_string = AAZStrArg(
            options=["modified-query-string"],
            help="Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.",
        )
        url_configuration.reroute = AAZBoolArg(
            options=["reroute"],
            help="If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path. Default value is false.",
        )

        conditions = cls._args_schema.rewrite_rule_sets.Element.rewrite_rules.Element.conditions
        conditions.Element = AAZObjectArg()

        _element = cls._args_schema.rewrite_rule_sets.Element.rewrite_rules.Element.conditions.Element
        _element.ignore_case = AAZBoolArg(
            options=["ignore-case"],
            help="Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.",
        )
        _element.negate = AAZBoolArg(
            options=["negate"],
            help="Setting this value as truth will force to check the negation of the condition given by the user.",
        )
        _element.pattern = AAZStrArg(
            options=["pattern"],
            help="The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.",
        )
        _element.variable = AAZStrArg(
            options=["variable"],
            help="The condition parameter of the RewriteRuleCondition.",
        )

        routing_rules = cls._args_schema.routing_rules
        routing_rules.Element = AAZObjectArg()

        _element = cls._args_schema.routing_rules.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the routing rule that is unique within an Application Gateway.",
        )
        _element.backend_address_pool = AAZObjectArg(
            options=["backend-address-pool"],
            help="Backend address pool resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.backend_address_pool)
        _element.backend_settings = AAZObjectArg(
            options=["backend-settings"],
            help="Backend settings resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.backend_settings)
        _element.listener = AAZObjectArg(
            options=["listener"],
            help="Listener resource of the application gateway.",
        )
        cls._build_args_sub_resource_create(_element.listener)
        _element.priority = AAZIntArg(
            options=["priority"],
            help="Priority of the routing rule.",
            fmt=AAZIntArgFormat(
                maximum=20000,
                minimum=1,
            ),
        )
        _element.rule_type = AAZStrArg(
            options=["rule-type"],
            help="Rule type.",
            enum={"Basic": "Basic", "PathBasedRouting": "PathBasedRouting"},
        )

        sku = cls._args_schema.sku
        sku.capacity = AAZIntArg(
            options=["capacity"],
            help="Capacity (instance count) of an application gateway.",
        )
        sku.name = AAZStrArg(
            options=["name"],
            help="Name of an application gateway SKU.",
            enum={"Standard_Large": "Standard_Large", "Standard_Medium": "Standard_Medium", "Standard_Small": "Standard_Small", "Standard_v2": "Standard_v2", "WAF_Large": "WAF_Large", "WAF_Medium": "WAF_Medium", "WAF_v2": "WAF_v2"},
        )
        sku.tier = AAZStrArg(
            options=["tier"],
            help="Tier of an application gateway.",
            enum={"Standard": "Standard", "Standard_v2": "Standard_v2", "WAF": "WAF", "WAF_v2": "WAF_v2"},
        )

        ssl_certificates = cls._args_schema.ssl_certificates
        ssl_certificates.Element = AAZObjectArg()

        _element = cls._args_schema.ssl_certificates.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the SSL certificate that is unique within an Application Gateway.",
        )
        _element.data = AAZStrArg(
            options=["data"],
            help="Base-64 encoded pfx certificate. Only applicable in PUT Request.",
        )
        _element.key_vault_secret_id = AAZStrArg(
            options=["key-vault-secret-id"],
            help="Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.",
        )
        _element.password = AAZStrArg(
            options=["password"],
            help="Password for the pfx file specified in data. Only applicable in PUT request.",
        )

        ssl_profiles = cls._args_schema.ssl_profiles
        ssl_profiles.Element = AAZObjectArg()

        _element = cls._args_schema.ssl_profiles.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the SSL profile that is unique within an Application Gateway.",
        )
        _element.client_auth_configuration = AAZObjectArg(
            options=["client-auth-configuration"],
            help="Client authentication configuration of the application gateway resource.",
        )
        _element.ssl_policy = AAZObjectArg(
            options=["ssl-policy"],
            help="SSL policy of the application gateway resource.",
        )
        cls._build_args_application_gateway_ssl_policy_create(_element.ssl_policy)
        _element.trusted_client_certificates = AAZListArg(
            options=["trusted-client-certificates"],
            help="Array of references to application gateway trusted client certificates.",
        )

        client_auth_configuration = cls._args_schema.ssl_profiles.Element.client_auth_configuration
        client_auth_configuration.verify_client_cert_issuer_dn = AAZBoolArg(
            options=["verify-client-cert-issuer-dn"],
            help="Verify client certificate issuer name on the application gateway.",
        )
        client_auth_configuration.verify_client_revocation = AAZStrArg(
            options=["verify-client-revocation"],
            help="Verify client certificate revocation status.",
            enum={"None": "None", "OCSP": "OCSP"},
        )

        trusted_client_certificates = cls._args_schema.ssl_profiles.Element.trusted_client_certificates
        trusted_client_certificates.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(trusted_client_certificates.Element)

        trusted_client_certificates = cls._args_schema.trusted_client_certificates
        trusted_client_certificates.Element = AAZObjectArg()

        _element = cls._args_schema.trusted_client_certificates.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the trusted client certificate that is unique within an Application Gateway.",
        )
        _element.data = AAZStrArg(
            options=["data"],
            help="Certificate public data.",
        )

        trusted_root_certificates = cls._args_schema.trusted_root_certificates
        trusted_root_certificates.Element = AAZObjectArg()

        _element = cls._args_schema.trusted_root_certificates.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the trusted root certificate that is unique within an Application Gateway.",
        )
        _element.data = AAZStrArg(
            options=["data"],
            help="Certificate public data.",
        )
        _element.key_vault_secret_id = AAZStrArg(
            options=["key-vault-secret-id"],
            help="Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.",
        )

        url_path_maps = cls._args_schema.url_path_maps
        url_path_maps.Element = AAZObjectArg()

        _element = cls._args_schema.url_path_maps.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the URL path map that is unique within an Application Gateway.",
        )
        _element.default_backend_address_pool = AAZObjectArg(
            options=["default-backend-address-pool"],
            help="Default backend address pool resource of URL path map.",
        )
        cls._build_args_sub_resource_create(_element.default_backend_address_pool)
        _element.default_backend_http_settings = AAZObjectArg(
            options=["default-backend-http-settings"],
            help="Default backend http settings resource of URL path map.",
        )
        cls._build_args_sub_resource_create(_element.default_backend_http_settings)
        _element.default_load_distribution_policy = AAZObjectArg(
            options=["default-load-distribution-policy"],
            help="Default Load Distribution Policy resource of URL path map.",
        )
        cls._build_args_sub_resource_create(_element.default_load_distribution_policy)
        _element.default_redirect_configuration = AAZObjectArg(
            options=["default-redirect-configuration"],
            help="Default redirect configuration resource of URL path map.",
        )
        cls._build_args_sub_resource_create(_element.default_redirect_configuration)
        _element.default_rewrite_rule_set = AAZObjectArg(
            options=["default-rewrite-rule-set"],
            help="Default Rewrite rule set resource of URL path map.",
        )
        cls._build_args_sub_resource_create(_element.default_rewrite_rule_set)
        _element.path_rules = AAZListArg(
            options=["path-rules"],
            help="Path rule of URL path map resource.",
        )

        path_rules = cls._args_schema.url_path_maps.Element.path_rules
        path_rules.Element = AAZObjectArg()

        _element = cls._args_schema.url_path_maps.Element.path_rules.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the path rule that is unique within an Application Gateway.",
        )
        _element.backend_address_pool = AAZObjectArg(
            options=["backend-address-pool"],
            help="Backend address pool resource of URL path map path rule.",
        )
        cls._build_args_sub_resource_create(_element.backend_address_pool)
        _element.backend_http_settings = AAZObjectArg(
            options=["backend-http-settings"],
            help="Backend http settings resource of URL path map path rule.",
        )
        cls._build_args_sub_resource_create(_element.backend_http_settings)
        _element.firewall_policy = AAZObjectArg(
            options=["firewall-policy"],
            help="Reference to the FirewallPolicy resource.",
        )
        cls._build_args_sub_resource_create(_element.firewall_policy)
        _element.load_distribution_policy = AAZObjectArg(
            options=["load-distribution-policy"],
            help="Load Distribution Policy resource of URL path map path rule.",
        )
        cls._build_args_sub_resource_create(_element.load_distribution_policy)
        _element.paths = AAZListArg(
            options=["paths"],
            help="Path rules of URL path map.",
        )
        _element.redirect_configuration = AAZObjectArg(
            options=["redirect-configuration"],
            help="Redirect configuration resource of URL path map path rule.",
        )
        cls._build_args_sub_resource_create(_element.redirect_configuration)
        _element.rewrite_rule_set = AAZObjectArg(
            options=["rewrite-rule-set"],
            help="Rewrite rule set resource of URL path map path rule.",
        )
        cls._build_args_sub_resource_create(_element.rewrite_rule_set)

        paths = cls._args_schema.url_path_maps.Element.path_rules.Element.paths
        paths.Element = AAZStrArg()

        web_application_firewall_configuration = cls._args_schema.web_application_firewall_configuration
        web_application_firewall_configuration.disabled_rule_groups = AAZListArg(
            options=["disabled-rule-groups"],
            help="The disabled rule groups.",
        )
        web_application_firewall_configuration.enabled = AAZBoolArg(
            options=["enabled"],
            help="Whether the web application firewall is enabled or not.",
            required=True,
        )
        web_application_firewall_configuration.exclusions = AAZListArg(
            options=["exclusions"],
            help="The exclusion list.",
        )
        web_application_firewall_configuration.file_upload_limit_in_mb = AAZIntArg(
            options=["file-upload-limit-in-mb"],
            help="Maximum file upload size in Mb for WAF.",
            fmt=AAZIntArgFormat(
                minimum=0,
            ),
        )
        web_application_firewall_configuration.firewall_mode = AAZStrArg(
            options=["firewall-mode"],
            help="Web application firewall mode.",
            required=True,
            enum={"Detection": "Detection", "Prevention": "Prevention"},
        )
        web_application_firewall_configuration.max_request_body_size = AAZIntArg(
            options=["max-request-body-size"],
            help="Maximum request body size for WAF.",
            fmt=AAZIntArgFormat(
                maximum=128,
                minimum=8,
            ),
        )
        web_application_firewall_configuration.max_request_body_size_in_kb = AAZIntArg(
            options=["max-request-body-size-in-kb"],
            help="Maximum request body size in Kb for WAF.",
            fmt=AAZIntArgFormat(
                maximum=128,
                minimum=8,
            ),
        )
        web_application_firewall_configuration.request_body_check = AAZBoolArg(
            options=["request-body-check"],
            help="Whether allow WAF to check request Body.",
        )
        web_application_firewall_configuration.rule_set_type = AAZStrArg(
            options=["rule-set-type"],
            help="The type of the web application firewall rule set. Possible values are: 'OWASP'.",
            required=True,
        )
        web_application_firewall_configuration.rule_set_version = AAZStrArg(
            options=["rule-set-version"],
            help="The version of the rule set type.",
            required=True,
        )

        disabled_rule_groups = cls._args_schema.web_application_firewall_configuration.disabled_rule_groups
        disabled_rule_groups.Element = AAZObjectArg()

        _element = cls._args_schema.web_application_firewall_configuration.disabled_rule_groups.Element
        _element.rule_group_name = AAZStrArg(
            options=["rule-group-name"],
            help="The name of the rule group that will be disabled.",
            required=True,
        )
        _element.rules = AAZListArg(
            options=["rules"],
            help="The list of rules that will be disabled. If null, all rules of the rule group will be disabled.",
        )

        rules = cls._args_schema.web_application_firewall_configuration.disabled_rule_groups.Element.rules
        rules.Element = AAZIntArg()

        exclusions = cls._args_schema.web_application_firewall_configuration.exclusions
        exclusions.Element = AAZObjectArg()

        _element = cls._args_schema.web_application_firewall_configuration.exclusions.Element
        _element.match_variable = AAZStrArg(
            options=["match-variable"],
            help="The variable to be excluded.",
            required=True,
        )
        _element.selector = AAZStrArg(
            options=["selector"],
            help="When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.",
            required=True,
        )
        _element.selector_match_operator = AAZStrArg(
            options=["selector-match-operator"],
            help="When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.",
            required=True,
        )
        return cls._args_schema

    _args_application_gateway_custom_error_create = None

    @classmethod
    def _build_args_application_gateway_custom_error_create(cls, _schema):
        if cls._args_application_gateway_custom_error_create is not None:
            _schema.custom_error_page_url = cls._args_application_gateway_custom_error_create.custom_error_page_url
            _schema.status_code = cls._args_application_gateway_custom_error_create.status_code
            return

        cls._args_application_gateway_custom_error_create = AAZObjectArg()

        application_gateway_custom_error_create = cls._args_application_gateway_custom_error_create
        application_gateway_custom_error_create.custom_error_page_url = AAZStrArg(
            options=["custom-error-page-url"],
            help="Error page URL of the application gateway customer error.",
        )
        application_gateway_custom_error_create.status_code = AAZStrArg(
            options=["status-code"],
            help="Status code of the application gateway customer error.",
            enum={"HttpStatus403": "HttpStatus403", "HttpStatus502": "HttpStatus502"},
        )

        _schema.custom_error_page_url = cls._args_application_gateway_custom_error_create.custom_error_page_url
        _schema.status_code = cls._args_application_gateway_custom_error_create.status_code

    _args_application_gateway_header_configuration_create = None

    @classmethod
    def _build_args_application_gateway_header_configuration_create(cls, _schema):
        if cls._args_application_gateway_header_configuration_create is not None:
            _schema.header_name = cls._args_application_gateway_header_configuration_create.header_name
            _schema.header_value = cls._args_application_gateway_header_configuration_create.header_value
            return

        cls._args_application_gateway_header_configuration_create = AAZObjectArg()

        application_gateway_header_configuration_create = cls._args_application_gateway_header_configuration_create
        application_gateway_header_configuration_create.header_name = AAZStrArg(
            options=["header-name"],
            help="Header name of the header configuration.",
        )
        application_gateway_header_configuration_create.header_value = AAZStrArg(
            options=["header-value"],
            help="Header value of the header configuration.",
        )

        _schema.header_name = cls._args_application_gateway_header_configuration_create.header_name
        _schema.header_value = cls._args_application_gateway_header_configuration_create.header_value

    _args_application_gateway_ssl_policy_create = None

    @classmethod
    def _build_args_application_gateway_ssl_policy_create(cls, _schema):
        if cls._args_application_gateway_ssl_policy_create is not None:
            _schema.cipher_suites = cls._args_application_gateway_ssl_policy_create.cipher_suites
            _schema.disabled_ssl_protocols = cls._args_application_gateway_ssl_policy_create.disabled_ssl_protocols
            _schema.min_protocol_version = cls._args_application_gateway_ssl_policy_create.min_protocol_version
            _schema.policy_name = cls._args_application_gateway_ssl_policy_create.policy_name
            _schema.policy_type = cls._args_application_gateway_ssl_policy_create.policy_type
            return

        cls._args_application_gateway_ssl_policy_create = AAZObjectArg()

        application_gateway_ssl_policy_create = cls._args_application_gateway_ssl_policy_create
        application_gateway_ssl_policy_create.cipher_suites = AAZListArg(
            options=["cipher-suites"],
            help="Ssl cipher suites to be enabled in the specified order to application gateway.",
        )
        application_gateway_ssl_policy_create.disabled_ssl_protocols = AAZListArg(
            options=["disabled-ssl-protocols"],
            help="Ssl protocols to be disabled on application gateway.",
        )
        application_gateway_ssl_policy_create.min_protocol_version = AAZStrArg(
            options=["min-protocol-version"],
            help="Minimum version of Ssl protocol to be supported on application gateway.",
            enum={"TLSv1_0": "TLSv1_0", "TLSv1_1": "TLSv1_1", "TLSv1_2": "TLSv1_2", "TLSv1_3": "TLSv1_3"},
        )
        application_gateway_ssl_policy_create.policy_name = AAZStrArg(
            options=["policy-name"],
            help="Name of Ssl predefined policy.",
            enum={"AppGwSslPolicy20150501": "AppGwSslPolicy20150501", "AppGwSslPolicy20170401": "AppGwSslPolicy20170401", "AppGwSslPolicy20170401S": "AppGwSslPolicy20170401S", "AppGwSslPolicy20220101": "AppGwSslPolicy20220101", "AppGwSslPolicy20220101S": "AppGwSslPolicy20220101S"},
        )
        application_gateway_ssl_policy_create.policy_type = AAZStrArg(
            options=["policy-type"],
            help="Type of Ssl Policy.",
            enum={"Custom": "Custom", "CustomV2": "CustomV2", "Predefined": "Predefined"},
        )

        cipher_suites = cls._args_application_gateway_ssl_policy_create.cipher_suites
        cipher_suites.Element = AAZStrArg(
            enum={"TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA": "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA": "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256": "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA": "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256": "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA": "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256": "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA": "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384": "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA": "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256": "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256": "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA": "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384": "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384": "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA": "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256": "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256": "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA": "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384": "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384": "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_3DES_EDE_CBC_SHA": "TLS_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA": "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256": "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_GCM_SHA256": "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA": "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA256": "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384": "TLS_RSA_WITH_AES_256_GCM_SHA384"},
        )

        disabled_ssl_protocols = cls._args_application_gateway_ssl_policy_create.disabled_ssl_protocols
        disabled_ssl_protocols.Element = AAZStrArg(
            enum={"TLSv1_0": "TLSv1_0", "TLSv1_1": "TLSv1_1", "TLSv1_2": "TLSv1_2", "TLSv1_3": "TLSv1_3"},
        )

        _schema.cipher_suites = cls._args_application_gateway_ssl_policy_create.cipher_suites
        _schema.disabled_ssl_protocols = cls._args_application_gateway_ssl_policy_create.disabled_ssl_protocols
        _schema.min_protocol_version = cls._args_application_gateway_ssl_policy_create.min_protocol_version
        _schema.policy_name = cls._args_application_gateway_ssl_policy_create.policy_name
        _schema.policy_type = cls._args_application_gateway_ssl_policy_create.policy_type

    _args_sub_resource_create = None

    @classmethod
    def _build_args_sub_resource_create(cls, _schema):
        if cls._args_sub_resource_create is not None:
            _schema.id = cls._args_sub_resource_create.id
            return

        cls._args_sub_resource_create = AAZObjectArg()

        sub_resource_create = cls._args_sub_resource_create
        sub_resource_create.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )

        _schema.id = cls._args_sub_resource_create.id

    def _execute_operations(self):
        self.pre_operations()
        yield self.ApplicationGatewaysCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class ApplicationGatewaysCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "applicationGatewayName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("identity", AAZObjectType, ".identity")
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")
            _builder.set_prop("zones", AAZListType, ".zones")

            identity = _builder.get(".identity")
            if identity is not None:
                identity.set_prop("type", AAZStrType, ".type")
                identity.set_prop("userAssignedIdentities", AAZDictType, ".user_assigned_identities")

            user_assigned_identities = _builder.get(".identity.userAssignedIdentities")
            if user_assigned_identities is not None:
                user_assigned_identities.set_elements(AAZObjectType, ".")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("authenticationCertificates", AAZListType, ".authentication_certificates")
                properties.set_prop("autoscaleConfiguration", AAZObjectType, ".autoscale_configuration")
                properties.set_prop("backendAddressPools", AAZListType, ".backend_address_pools")
                properties.set_prop("backendHttpSettingsCollection", AAZListType, ".backend_http_settings_collection")
                properties.set_prop("backendSettingsCollection", AAZListType, ".backend_settings_collection")
                properties.set_prop("customErrorConfigurations", AAZListType, ".custom_error_configurations")
                properties.set_prop("enableFips", AAZBoolType, ".enable_fips")
                properties.set_prop("enableHttp2", AAZBoolType, ".enable_http2")
                _build_schema_sub_resource_create(properties.set_prop("firewallPolicy", AAZObjectType, ".firewall_policy"))
                properties.set_prop("forceFirewallPolicyAssociation", AAZBoolType, ".force_firewall_policy_association")
                properties.set_prop("frontendIPConfigurations", AAZListType, ".frontend_ip_configurations")
                properties.set_prop("frontendPorts", AAZListType, ".frontend_ports")
                properties.set_prop("gatewayIPConfigurations", AAZListType, ".gateway_ip_configurations")
                properties.set_prop("globalConfiguration", AAZObjectType, ".global_configuration")
                properties.set_prop("httpListeners", AAZListType, ".http_listeners")
                properties.set_prop("listeners", AAZListType, ".listeners")
                properties.set_prop("loadDistributionPolicies", AAZListType, ".load_distribution_policies")
                properties.set_prop("privateLinkConfigurations", AAZListType, ".private_link_configurations")
                properties.set_prop("probes", AAZListType, ".probes")
                properties.set_prop("redirectConfigurations", AAZListType, ".redirect_configurations")
                properties.set_prop("requestRoutingRules", AAZListType, ".request_routing_rules")
                properties.set_prop("rewriteRuleSets", AAZListType, ".rewrite_rule_sets")
                properties.set_prop("routingRules", AAZListType, ".routing_rules")
                properties.set_prop("sku", AAZObjectType, ".sku")
                properties.set_prop("sslCertificates", AAZListType, ".ssl_certificates")
                _build_schema_application_gateway_ssl_policy_create(properties.set_prop("sslPolicy", AAZObjectType, ".ssl_policy"))
                properties.set_prop("sslProfiles", AAZListType, ".ssl_profiles")
                properties.set_prop("trustedClientCertificates", AAZListType, ".trusted_client_certificates")
                properties.set_prop("trustedRootCertificates", AAZListType, ".trusted_root_certificates")
                properties.set_prop("urlPathMaps", AAZListType, ".url_path_maps")
                properties.set_prop("webApplicationFirewallConfiguration", AAZObjectType, ".web_application_firewall_configuration")

            authentication_certificates = _builder.get(".properties.authenticationCertificates")
            if authentication_certificates is not None:
                authentication_certificates.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.authenticationCertificates[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.authenticationCertificates[].properties")
            if properties is not None:
                properties.set_prop("data", AAZStrType, ".data")

            autoscale_configuration = _builder.get(".properties.autoscaleConfiguration")
            if autoscale_configuration is not None:
                autoscale_configuration.set_prop("maxCapacity", AAZIntType, ".max_capacity")
                autoscale_configuration.set_prop("minCapacity", AAZIntType, ".min_capacity", typ_kwargs={"flags": {"required": True}})

            backend_address_pools = _builder.get(".properties.backendAddressPools")
            if backend_address_pools is not None:
                backend_address_pools.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.backendAddressPools[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.backendAddressPools[].properties")
            if properties is not None:
                properties.set_prop("backendAddresses", AAZListType, ".backend_addresses")

            backend_addresses = _builder.get(".properties.backendAddressPools[].properties.backendAddresses")
            if backend_addresses is not None:
                backend_addresses.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.backendAddressPools[].properties.backendAddresses[]")
            if _elements is not None:
                _elements.set_prop("fqdn", AAZStrType, ".fqdn")
                _elements.set_prop("ipAddress", AAZStrType, ".ip_address")

            backend_http_settings_collection = _builder.get(".properties.backendHttpSettingsCollection")
            if backend_http_settings_collection is not None:
                backend_http_settings_collection.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.backendHttpSettingsCollection[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.backendHttpSettingsCollection[].properties")
            if properties is not None:
                properties.set_prop("affinityCookieName", AAZStrType, ".affinity_cookie_name")
                properties.set_prop("authenticationCertificates", AAZListType, ".authentication_certificates")
                properties.set_prop("connectionDraining", AAZObjectType, ".connection_draining")
                properties.set_prop("cookieBasedAffinity", AAZStrType, ".cookie_based_affinity")
                properties.set_prop("hostName", AAZStrType, ".host_name")
                properties.set_prop("path", AAZStrType, ".path")
                properties.set_prop("pickHostNameFromBackendAddress", AAZBoolType, ".pick_host_name_from_backend_address")
                properties.set_prop("port", AAZIntType, ".port")
                _build_schema_sub_resource_create(properties.set_prop("probe", AAZObjectType, ".probe"))
                properties.set_prop("probeEnabled", AAZBoolType, ".probe_enabled")
                properties.set_prop("protocol", AAZStrType, ".protocol")
                properties.set_prop("requestTimeout", AAZIntType, ".request_timeout")
                properties.set_prop("trustedRootCertificates", AAZListType, ".trusted_root_certificates")

            authentication_certificates = _builder.get(".properties.backendHttpSettingsCollection[].properties.authenticationCertificates")
            if authentication_certificates is not None:
                _build_schema_sub_resource_create(authentication_certificates.set_elements(AAZObjectType, "."))

            connection_draining = _builder.get(".properties.backendHttpSettingsCollection[].properties.connectionDraining")
            if connection_draining is not None:
                connection_draining.set_prop("drainTimeoutInSec", AAZIntType, ".drain_timeout_in_sec", typ_kwargs={"flags": {"required": True}})
                connection_draining.set_prop("enabled", AAZBoolType, ".enabled", typ_kwargs={"flags": {"required": True}})

            trusted_root_certificates = _builder.get(".properties.backendHttpSettingsCollection[].properties.trustedRootCertificates")
            if trusted_root_certificates is not None:
                _build_schema_sub_resource_create(trusted_root_certificates.set_elements(AAZObjectType, "."))

            backend_settings_collection = _builder.get(".properties.backendSettingsCollection")
            if backend_settings_collection is not None:
                backend_settings_collection.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.backendSettingsCollection[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.backendSettingsCollection[].properties")
            if properties is not None:
                properties.set_prop("hostName", AAZStrType, ".host_name")
                properties.set_prop("pickHostNameFromBackendAddress", AAZBoolType, ".pick_host_name_from_backend_address")
                properties.set_prop("port", AAZIntType, ".port")
                _build_schema_sub_resource_create(properties.set_prop("probe", AAZObjectType, ".probe"))
                properties.set_prop("protocol", AAZStrType, ".protocol")
                properties.set_prop("timeout", AAZIntType, ".timeout")
                properties.set_prop("trustedRootCertificates", AAZListType, ".trusted_root_certificates")

            trusted_root_certificates = _builder.get(".properties.backendSettingsCollection[].properties.trustedRootCertificates")
            if trusted_root_certificates is not None:
                _build_schema_sub_resource_create(trusted_root_certificates.set_elements(AAZObjectType, "."))

            custom_error_configurations = _builder.get(".properties.customErrorConfigurations")
            if custom_error_configurations is not None:
                _build_schema_application_gateway_custom_error_create(custom_error_configurations.set_elements(AAZObjectType, "."))

            frontend_ip_configurations = _builder.get(".properties.frontendIPConfigurations")
            if frontend_ip_configurations is not None:
                frontend_ip_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.frontendIPConfigurations[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.frontendIPConfigurations[].properties")
            if properties is not None:
                properties.set_prop("privateIPAddress", AAZStrType, ".private_ip_address")
                properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
                _build_schema_sub_resource_create(properties.set_prop("privateLinkConfiguration", AAZObjectType, ".private_link_configuration"))
                _build_schema_sub_resource_create(properties.set_prop("publicIPAddress", AAZObjectType, ".public_ip_address"))
                _build_schema_sub_resource_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

            frontend_ports = _builder.get(".properties.frontendPorts")
            if frontend_ports is not None:
                frontend_ports.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.frontendPorts[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.frontendPorts[].properties")
            if properties is not None:
                properties.set_prop("port", AAZIntType, ".port")

            gateway_ip_configurations = _builder.get(".properties.gatewayIPConfigurations")
            if gateway_ip_configurations is not None:
                gateway_ip_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.gatewayIPConfigurations[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.gatewayIPConfigurations[].properties")
            if properties is not None:
                _build_schema_sub_resource_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

            global_configuration = _builder.get(".properties.globalConfiguration")
            if global_configuration is not None:
                global_configuration.set_prop("enableRequestBuffering", AAZBoolType, ".enable_request_buffering")
                global_configuration.set_prop("enableResponseBuffering", AAZBoolType, ".enable_response_buffering")

            http_listeners = _builder.get(".properties.httpListeners")
            if http_listeners is not None:
                http_listeners.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.httpListeners[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.httpListeners[].properties")
            if properties is not None:
                properties.set_prop("customErrorConfigurations", AAZListType, ".custom_error_configurations")
                _build_schema_sub_resource_create(properties.set_prop("firewallPolicy", AAZObjectType, ".firewall_policy"))
                _build_schema_sub_resource_create(properties.set_prop("frontendIPConfiguration", AAZObjectType, ".frontend_ip_configuration"))
                _build_schema_sub_resource_create(properties.set_prop("frontendPort", AAZObjectType, ".frontend_port"))
                properties.set_prop("hostName", AAZStrType, ".host_name")
                properties.set_prop("hostNames", AAZListType, ".host_names")
                properties.set_prop("protocol", AAZStrType, ".protocol")
                properties.set_prop("requireServerNameIndication", AAZBoolType, ".require_server_name_indication")
                _build_schema_sub_resource_create(properties.set_prop("sslCertificate", AAZObjectType, ".ssl_certificate"))
                _build_schema_sub_resource_create(properties.set_prop("sslProfile", AAZObjectType, ".ssl_profile"))

            custom_error_configurations = _builder.get(".properties.httpListeners[].properties.customErrorConfigurations")
            if custom_error_configurations is not None:
                _build_schema_application_gateway_custom_error_create(custom_error_configurations.set_elements(AAZObjectType, "."))

            host_names = _builder.get(".properties.httpListeners[].properties.hostNames")
            if host_names is not None:
                host_names.set_elements(AAZStrType, ".")

            listeners = _builder.get(".properties.listeners")
            if listeners is not None:
                listeners.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.listeners[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.listeners[].properties")
            if properties is not None:
                _build_schema_sub_resource_create(properties.set_prop("frontendIPConfiguration", AAZObjectType, ".frontend_ip_configuration"))
                _build_schema_sub_resource_create(properties.set_prop("frontendPort", AAZObjectType, ".frontend_port"))
                properties.set_prop("protocol", AAZStrType, ".protocol")
                _build_schema_sub_resource_create(properties.set_prop("sslCertificate", AAZObjectType, ".ssl_certificate"))
                _build_schema_sub_resource_create(properties.set_prop("sslProfile", AAZObjectType, ".ssl_profile"))

            load_distribution_policies = _builder.get(".properties.loadDistributionPolicies")
            if load_distribution_policies is not None:
                load_distribution_policies.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.loadDistributionPolicies[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.loadDistributionPolicies[].properties")
            if properties is not None:
                properties.set_prop("loadDistributionAlgorithm", AAZStrType, ".load_distribution_algorithm")
                properties.set_prop("loadDistributionTargets", AAZListType, ".load_distribution_targets")

            load_distribution_targets = _builder.get(".properties.loadDistributionPolicies[].properties.loadDistributionTargets")
            if load_distribution_targets is not None:
                load_distribution_targets.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.loadDistributionPolicies[].properties.loadDistributionTargets[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.loadDistributionPolicies[].properties.loadDistributionTargets[].properties")
            if properties is not None:
                _build_schema_sub_resource_create(properties.set_prop("backendAddressPool", AAZObjectType, ".backend_address_pool"))
                properties.set_prop("weightPerServer", AAZIntType, ".weight_per_server")

            private_link_configurations = _builder.get(".properties.privateLinkConfigurations")
            if private_link_configurations is not None:
                private_link_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.privateLinkConfigurations[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.privateLinkConfigurations[].properties")
            if properties is not None:
                properties.set_prop("ipConfigurations", AAZListType, ".ip_configurations")

            ip_configurations = _builder.get(".properties.privateLinkConfigurations[].properties.ipConfigurations")
            if ip_configurations is not None:
                ip_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.privateLinkConfigurations[].properties.ipConfigurations[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.privateLinkConfigurations[].properties.ipConfigurations[].properties")
            if properties is not None:
                properties.set_prop("primary", AAZBoolType, ".primary")
                properties.set_prop("privateIPAddress", AAZStrType, ".private_ip_address")
                properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
                _build_schema_sub_resource_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

            probes = _builder.get(".properties.probes")
            if probes is not None:
                probes.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.probes[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.probes[].properties")
            if properties is not None:
                properties.set_prop("host", AAZStrType, ".host")
                properties.set_prop("interval", AAZIntType, ".interval")
                properties.set_prop("match", AAZObjectType, ".match")
                properties.set_prop("minServers", AAZIntType, ".min_servers")
                properties.set_prop("path", AAZStrType, ".path")
                properties.set_prop("pickHostNameFromBackendHttpSettings", AAZBoolType, ".pick_host_name_from_backend_http_settings")
                properties.set_prop("pickHostNameFromBackendSettings", AAZBoolType, ".pick_host_name_from_backend_settings")
                properties.set_prop("port", AAZIntType, ".port")
                properties.set_prop("protocol", AAZStrType, ".protocol")
                properties.set_prop("timeout", AAZIntType, ".timeout")
                properties.set_prop("unhealthyThreshold", AAZIntType, ".unhealthy_threshold")

            match = _builder.get(".properties.probes[].properties.match")
            if match is not None:
                match.set_prop("body", AAZStrType, ".body")
                match.set_prop("statusCodes", AAZListType, ".status_codes")

            status_codes = _builder.get(".properties.probes[].properties.match.statusCodes")
            if status_codes is not None:
                status_codes.set_elements(AAZStrType, ".")

            redirect_configurations = _builder.get(".properties.redirectConfigurations")
            if redirect_configurations is not None:
                redirect_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.redirectConfigurations[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.redirectConfigurations[].properties")
            if properties is not None:
                properties.set_prop("includePath", AAZBoolType, ".include_path")
                properties.set_prop("includeQueryString", AAZBoolType, ".include_query_string")
                properties.set_prop("pathRules", AAZListType, ".path_rules")
                properties.set_prop("redirectType", AAZStrType, ".redirect_type")
                properties.set_prop("requestRoutingRules", AAZListType, ".request_routing_rules")
                _build_schema_sub_resource_create(properties.set_prop("targetListener", AAZObjectType, ".target_listener"))
                properties.set_prop("targetUrl", AAZStrType, ".target_url")
                properties.set_prop("urlPathMaps", AAZListType, ".url_path_maps")

            path_rules = _builder.get(".properties.redirectConfigurations[].properties.pathRules")
            if path_rules is not None:
                _build_schema_sub_resource_create(path_rules.set_elements(AAZObjectType, "."))

            request_routing_rules = _builder.get(".properties.redirectConfigurations[].properties.requestRoutingRules")
            if request_routing_rules is not None:
                _build_schema_sub_resource_create(request_routing_rules.set_elements(AAZObjectType, "."))

            url_path_maps = _builder.get(".properties.redirectConfigurations[].properties.urlPathMaps")
            if url_path_maps is not None:
                _build_schema_sub_resource_create(url_path_maps.set_elements(AAZObjectType, "."))

            request_routing_rules = _builder.get(".properties.requestRoutingRules")
            if request_routing_rules is not None:
                request_routing_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.requestRoutingRules[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.requestRoutingRules[].properties")
            if properties is not None:
                _build_schema_sub_resource_create(properties.set_prop("backendAddressPool", AAZObjectType, ".backend_address_pool"))
                _build_schema_sub_resource_create(properties.set_prop("backendHttpSettings", AAZObjectType, ".backend_http_settings"))
                _build_schema_sub_resource_create(properties.set_prop("httpListener", AAZObjectType, ".http_listener"))
                _build_schema_sub_resource_create(properties.set_prop("loadDistributionPolicy", AAZObjectType, ".load_distribution_policy"))
                properties.set_prop("priority", AAZIntType, ".priority")
                _build_schema_sub_resource_create(properties.set_prop("redirectConfiguration", AAZObjectType, ".redirect_configuration"))
                _build_schema_sub_resource_create(properties.set_prop("rewriteRuleSet", AAZObjectType, ".rewrite_rule_set"))
                properties.set_prop("ruleType", AAZStrType, ".rule_type")
                _build_schema_sub_resource_create(properties.set_prop("urlPathMap", AAZObjectType, ".url_path_map"))

            rewrite_rule_sets = _builder.get(".properties.rewriteRuleSets")
            if rewrite_rule_sets is not None:
                rewrite_rule_sets.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.rewriteRuleSets[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.rewriteRuleSets[].properties")
            if properties is not None:
                properties.set_prop("rewriteRules", AAZListType, ".rewrite_rules")

            rewrite_rules = _builder.get(".properties.rewriteRuleSets[].properties.rewriteRules")
            if rewrite_rules is not None:
                rewrite_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.rewriteRuleSets[].properties.rewriteRules[]")
            if _elements is not None:
                _elements.set_prop("actionSet", AAZObjectType, ".action_set")
                _elements.set_prop("conditions", AAZListType, ".conditions")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("ruleSequence", AAZIntType, ".rule_sequence")

            action_set = _builder.get(".properties.rewriteRuleSets[].properties.rewriteRules[].actionSet")
            if action_set is not None:
                action_set.set_prop("requestHeaderConfigurations", AAZListType, ".request_header_configurations")
                action_set.set_prop("responseHeaderConfigurations", AAZListType, ".response_header_configurations")
                action_set.set_prop("urlConfiguration", AAZObjectType, ".url_configuration")

            request_header_configurations = _builder.get(".properties.rewriteRuleSets[].properties.rewriteRules[].actionSet.requestHeaderConfigurations")
            if request_header_configurations is not None:
                _build_schema_application_gateway_header_configuration_create(request_header_configurations.set_elements(AAZObjectType, "."))

            response_header_configurations = _builder.get(".properties.rewriteRuleSets[].properties.rewriteRules[].actionSet.responseHeaderConfigurations")
            if response_header_configurations is not None:
                _build_schema_application_gateway_header_configuration_create(response_header_configurations.set_elements(AAZObjectType, "."))

            url_configuration = _builder.get(".properties.rewriteRuleSets[].properties.rewriteRules[].actionSet.urlConfiguration")
            if url_configuration is not None:
                url_configuration.set_prop("modifiedPath", AAZStrType, ".modified_path")
                url_configuration.set_prop("modifiedQueryString", AAZStrType, ".modified_query_string")
                url_configuration.set_prop("reroute", AAZBoolType, ".reroute")

            conditions = _builder.get(".properties.rewriteRuleSets[].properties.rewriteRules[].conditions")
            if conditions is not None:
                conditions.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.rewriteRuleSets[].properties.rewriteRules[].conditions[]")
            if _elements is not None:
                _elements.set_prop("ignoreCase", AAZBoolType, ".ignore_case")
                _elements.set_prop("negate", AAZBoolType, ".negate")
                _elements.set_prop("pattern", AAZStrType, ".pattern")
                _elements.set_prop("variable", AAZStrType, ".variable")

            routing_rules = _builder.get(".properties.routingRules")
            if routing_rules is not None:
                routing_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.routingRules[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.routingRules[].properties")
            if properties is not None:
                _build_schema_sub_resource_create(properties.set_prop("backendAddressPool", AAZObjectType, ".backend_address_pool"))
                _build_schema_sub_resource_create(properties.set_prop("backendSettings", AAZObjectType, ".backend_settings"))
                _build_schema_sub_resource_create(properties.set_prop("listener", AAZObjectType, ".listener"))
                properties.set_prop("priority", AAZIntType, ".priority", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("ruleType", AAZStrType, ".rule_type")

            sku = _builder.get(".properties.sku")
            if sku is not None:
                sku.set_prop("capacity", AAZIntType, ".capacity")
                sku.set_prop("name", AAZStrType, ".name")
                sku.set_prop("tier", AAZStrType, ".tier")

            ssl_certificates = _builder.get(".properties.sslCertificates")
            if ssl_certificates is not None:
                ssl_certificates.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.sslCertificates[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.sslCertificates[].properties")
            if properties is not None:
                properties.set_prop("data", AAZStrType, ".data")
                properties.set_prop("keyVaultSecretId", AAZStrType, ".key_vault_secret_id")
                properties.set_prop("password", AAZStrType, ".password")

            ssl_profiles = _builder.get(".properties.sslProfiles")
            if ssl_profiles is not None:
                ssl_profiles.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.sslProfiles[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.sslProfiles[].properties")
            if properties is not None:
                properties.set_prop("clientAuthConfiguration", AAZObjectType, ".client_auth_configuration")
                _build_schema_application_gateway_ssl_policy_create(properties.set_prop("sslPolicy", AAZObjectType, ".ssl_policy"))
                properties.set_prop("trustedClientCertificates", AAZListType, ".trusted_client_certificates")

            client_auth_configuration = _builder.get(".properties.sslProfiles[].properties.clientAuthConfiguration")
            if client_auth_configuration is not None:
                client_auth_configuration.set_prop("verifyClientCertIssuerDN", AAZBoolType, ".verify_client_cert_issuer_dn")
                client_auth_configuration.set_prop("verifyClientRevocation", AAZStrType, ".verify_client_revocation")

            trusted_client_certificates = _builder.get(".properties.sslProfiles[].properties.trustedClientCertificates")
            if trusted_client_certificates is not None:
                _build_schema_sub_resource_create(trusted_client_certificates.set_elements(AAZObjectType, "."))

            trusted_client_certificates = _builder.get(".properties.trustedClientCertificates")
            if trusted_client_certificates is not None:
                trusted_client_certificates.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.trustedClientCertificates[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.trustedClientCertificates[].properties")
            if properties is not None:
                properties.set_prop("data", AAZStrType, ".data")

            trusted_root_certificates = _builder.get(".properties.trustedRootCertificates")
            if trusted_root_certificates is not None:
                trusted_root_certificates.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.trustedRootCertificates[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.trustedRootCertificates[].properties")
            if properties is not None:
                properties.set_prop("data", AAZStrType, ".data")
                properties.set_prop("keyVaultSecretId", AAZStrType, ".key_vault_secret_id")

            url_path_maps = _builder.get(".properties.urlPathMaps")
            if url_path_maps is not None:
                url_path_maps.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.urlPathMaps[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.urlPathMaps[].properties")
            if properties is not None:
                _build_schema_sub_resource_create(properties.set_prop("defaultBackendAddressPool", AAZObjectType, ".default_backend_address_pool"))
                _build_schema_sub_resource_create(properties.set_prop("defaultBackendHttpSettings", AAZObjectType, ".default_backend_http_settings"))
                _build_schema_sub_resource_create(properties.set_prop("defaultLoadDistributionPolicy", AAZObjectType, ".default_load_distribution_policy"))
                _build_schema_sub_resource_create(properties.set_prop("defaultRedirectConfiguration", AAZObjectType, ".default_redirect_configuration"))
                _build_schema_sub_resource_create(properties.set_prop("defaultRewriteRuleSet", AAZObjectType, ".default_rewrite_rule_set"))
                properties.set_prop("pathRules", AAZListType, ".path_rules")

            path_rules = _builder.get(".properties.urlPathMaps[].properties.pathRules")
            if path_rules is not None:
                path_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.urlPathMaps[].properties.pathRules[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.urlPathMaps[].properties.pathRules[].properties")
            if properties is not None:
                _build_schema_sub_resource_create(properties.set_prop("backendAddressPool", AAZObjectType, ".backend_address_pool"))
                _build_schema_sub_resource_create(properties.set_prop("backendHttpSettings", AAZObjectType, ".backend_http_settings"))
                _build_schema_sub_resource_create(properties.set_prop("firewallPolicy", AAZObjectType, ".firewall_policy"))
                _build_schema_sub_resource_create(properties.set_prop("loadDistributionPolicy", AAZObjectType, ".load_distribution_policy"))
                properties.set_prop("paths", AAZListType, ".paths")
                _build_schema_sub_resource_create(properties.set_prop("redirectConfiguration", AAZObjectType, ".redirect_configuration"))
                _build_schema_sub_resource_create(properties.set_prop("rewriteRuleSet", AAZObjectType, ".rewrite_rule_set"))

            paths = _builder.get(".properties.urlPathMaps[].properties.pathRules[].properties.paths")
            if paths is not None:
                paths.set_elements(AAZStrType, ".")

            web_application_firewall_configuration = _builder.get(".properties.webApplicationFirewallConfiguration")
            if web_application_firewall_configuration is not None:
                web_application_firewall_configuration.set_prop("disabledRuleGroups", AAZListType, ".disabled_rule_groups")
                web_application_firewall_configuration.set_prop("enabled", AAZBoolType, ".enabled", typ_kwargs={"flags": {"required": True}})
                web_application_firewall_configuration.set_prop("exclusions", AAZListType, ".exclusions")
                web_application_firewall_configuration.set_prop("fileUploadLimitInMb", AAZIntType, ".file_upload_limit_in_mb")
                web_application_firewall_configuration.set_prop("firewallMode", AAZStrType, ".firewall_mode", typ_kwargs={"flags": {"required": True}})
                web_application_firewall_configuration.set_prop("maxRequestBodySize", AAZIntType, ".max_request_body_size")
                web_application_firewall_configuration.set_prop("maxRequestBodySizeInKb", AAZIntType, ".max_request_body_size_in_kb")
                web_application_firewall_configuration.set_prop("requestBodyCheck", AAZBoolType, ".request_body_check")
                web_application_firewall_configuration.set_prop("ruleSetType", AAZStrType, ".rule_set_type", typ_kwargs={"flags": {"required": True}})
                web_application_firewall_configuration.set_prop("ruleSetVersion", AAZStrType, ".rule_set_version", typ_kwargs={"flags": {"required": True}})

            disabled_rule_groups = _builder.get(".properties.webApplicationFirewallConfiguration.disabledRuleGroups")
            if disabled_rule_groups is not None:
                disabled_rule_groups.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.webApplicationFirewallConfiguration.disabledRuleGroups[]")
            if _elements is not None:
                _elements.set_prop("ruleGroupName", AAZStrType, ".rule_group_name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("rules", AAZListType, ".rules")

            rules = _builder.get(".properties.webApplicationFirewallConfiguration.disabledRuleGroups[].rules")
            if rules is not None:
                rules.set_elements(AAZIntType, ".")

            exclusions = _builder.get(".properties.webApplicationFirewallConfiguration.exclusions")
            if exclusions is not None:
                exclusions.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.webApplicationFirewallConfiguration.exclusions[]")
            if _elements is not None:
                _elements.set_prop("matchVariable", AAZStrType, ".match_variable", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("selector", AAZStrType, ".selector", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("selectorMatchOperator", AAZStrType, ".selector_match_operator", typ_kwargs={"flags": {"required": True}})

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            zones = _builder.get(".zones")
            if zones is not None:
                zones.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.etag = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.id = AAZStrType()
            _schema_on_200_201.identity = AAZObjectType()
            _schema_on_200_201.location = AAZStrType()
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200_201.tags = AAZDictType()
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.zones = AAZListType()

            identity = cls._schema_on_200_201.identity
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType()
            identity.user_assigned_identities = AAZDictType(
                serialized_name="userAssignedIdentities",
            )

            user_assigned_identities = cls._schema_on_200_201.identity.user_assigned_identities
            user_assigned_identities.Element = AAZObjectType()

            _element = cls._schema_on_200_201.identity.user_assigned_identities.Element
            _element.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.authentication_certificates = AAZListType(
                serialized_name="authenticationCertificates",
            )
            properties.autoscale_configuration = AAZObjectType(
                serialized_name="autoscaleConfiguration",
            )
            properties.backend_address_pools = AAZListType(
                serialized_name="backendAddressPools",
            )
            properties.backend_http_settings_collection = AAZListType(
                serialized_name="backendHttpSettingsCollection",
            )
            properties.backend_settings_collection = AAZListType(
                serialized_name="backendSettingsCollection",
            )
            properties.custom_error_configurations = AAZListType(
                serialized_name="customErrorConfigurations",
            )
            properties.enable_fips = AAZBoolType(
                serialized_name="enableFips",
            )
            properties.enable_http2 = AAZBoolType(
                serialized_name="enableHttp2",
            )
            properties.firewall_policy = AAZObjectType(
                serialized_name="firewallPolicy",
            )
            _build_schema_sub_resource_read(properties.firewall_policy)
            properties.force_firewall_policy_association = AAZBoolType(
                serialized_name="forceFirewallPolicyAssociation",
            )
            properties.frontend_ip_configurations = AAZListType(
                serialized_name="frontendIPConfigurations",
            )
            properties.frontend_ports = AAZListType(
                serialized_name="frontendPorts",
            )
            properties.gateway_ip_configurations = AAZListType(
                serialized_name="gatewayIPConfigurations",
            )
            properties.global_configuration = AAZObjectType(
                serialized_name="globalConfiguration",
            )
            properties.http_listeners = AAZListType(
                serialized_name="httpListeners",
            )
            properties.listeners = AAZListType()
            properties.load_distribution_policies = AAZListType(
                serialized_name="loadDistributionPolicies",
            )
            properties.operational_state = AAZStrType(
                serialized_name="operationalState",
                flags={"read_only": True},
            )
            properties.private_endpoint_connections = AAZListType(
                serialized_name="privateEndpointConnections",
                flags={"read_only": True},
            )
            properties.private_link_configurations = AAZListType(
                serialized_name="privateLinkConfigurations",
            )
            properties.probes = AAZListType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.redirect_configurations = AAZListType(
                serialized_name="redirectConfigurations",
            )
            properties.request_routing_rules = AAZListType(
                serialized_name="requestRoutingRules",
            )
            properties.resource_guid = AAZStrType(
                serialized_name="resourceGuid",
                flags={"read_only": True},
            )
            properties.rewrite_rule_sets = AAZListType(
                serialized_name="rewriteRuleSets",
            )
            properties.routing_rules = AAZListType(
                serialized_name="routingRules",
            )
            properties.sku = AAZObjectType()
            properties.ssl_certificates = AAZListType(
                serialized_name="sslCertificates",
            )
            properties.ssl_policy = AAZObjectType(
                serialized_name="sslPolicy",
            )
            _build_schema_application_gateway_ssl_policy_read(properties.ssl_policy)
            properties.ssl_profiles = AAZListType(
                serialized_name="sslProfiles",
            )
            properties.trusted_client_certificates = AAZListType(
                serialized_name="trustedClientCertificates",
            )
            properties.trusted_root_certificates = AAZListType(
                serialized_name="trustedRootCertificates",
            )
            properties.url_path_maps = AAZListType(
                serialized_name="urlPathMaps",
            )
            properties.web_application_firewall_configuration = AAZObjectType(
                serialized_name="webApplicationFirewallConfiguration",
            )

            authentication_certificates = cls._schema_on_200_201.properties.authentication_certificates
            authentication_certificates.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.authentication_certificates.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.authentication_certificates.Element.properties
            properties.data = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            autoscale_configuration = cls._schema_on_200_201.properties.autoscale_configuration
            autoscale_configuration.max_capacity = AAZIntType(
                serialized_name="maxCapacity",
            )
            autoscale_configuration.min_capacity = AAZIntType(
                serialized_name="minCapacity",
                flags={"required": True},
            )

            backend_address_pools = cls._schema_on_200_201.properties.backend_address_pools
            backend_address_pools.Element = AAZObjectType()
            _build_schema_application_gateway_backend_address_pool_read(backend_address_pools.Element)

            backend_http_settings_collection = cls._schema_on_200_201.properties.backend_http_settings_collection
            backend_http_settings_collection.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.backend_http_settings_collection.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.backend_http_settings_collection.Element.properties
            properties.affinity_cookie_name = AAZStrType(
                serialized_name="affinityCookieName",
            )
            properties.authentication_certificates = AAZListType(
                serialized_name="authenticationCertificates",
            )
            properties.connection_draining = AAZObjectType(
                serialized_name="connectionDraining",
            )
            properties.cookie_based_affinity = AAZStrType(
                serialized_name="cookieBasedAffinity",
            )
            properties.host_name = AAZStrType(
                serialized_name="hostName",
            )
            properties.path = AAZStrType()
            properties.pick_host_name_from_backend_address = AAZBoolType(
                serialized_name="pickHostNameFromBackendAddress",
            )
            properties.port = AAZIntType()
            properties.probe = AAZObjectType()
            _build_schema_sub_resource_read(properties.probe)
            properties.probe_enabled = AAZBoolType(
                serialized_name="probeEnabled",
            )
            properties.protocol = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.request_timeout = AAZIntType(
                serialized_name="requestTimeout",
            )
            properties.trusted_root_certificates = AAZListType(
                serialized_name="trustedRootCertificates",
            )

            authentication_certificates = cls._schema_on_200_201.properties.backend_http_settings_collection.Element.properties.authentication_certificates
            authentication_certificates.Element = AAZObjectType()
            _build_schema_sub_resource_read(authentication_certificates.Element)

            connection_draining = cls._schema_on_200_201.properties.backend_http_settings_collection.Element.properties.connection_draining
            connection_draining.drain_timeout_in_sec = AAZIntType(
                serialized_name="drainTimeoutInSec",
                flags={"required": True},
            )
            connection_draining.enabled = AAZBoolType(
                flags={"required": True},
            )

            trusted_root_certificates = cls._schema_on_200_201.properties.backend_http_settings_collection.Element.properties.trusted_root_certificates
            trusted_root_certificates.Element = AAZObjectType()
            _build_schema_sub_resource_read(trusted_root_certificates.Element)

            backend_settings_collection = cls._schema_on_200_201.properties.backend_settings_collection
            backend_settings_collection.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.backend_settings_collection.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.backend_settings_collection.Element.properties
            properties.host_name = AAZStrType(
                serialized_name="hostName",
            )
            properties.pick_host_name_from_backend_address = AAZBoolType(
                serialized_name="pickHostNameFromBackendAddress",
            )
            properties.port = AAZIntType()
            properties.probe = AAZObjectType()
            _build_schema_sub_resource_read(properties.probe)
            properties.protocol = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.timeout = AAZIntType()
            properties.trusted_root_certificates = AAZListType(
                serialized_name="trustedRootCertificates",
            )

            trusted_root_certificates = cls._schema_on_200_201.properties.backend_settings_collection.Element.properties.trusted_root_certificates
            trusted_root_certificates.Element = AAZObjectType()
            _build_schema_sub_resource_read(trusted_root_certificates.Element)

            custom_error_configurations = cls._schema_on_200_201.properties.custom_error_configurations
            custom_error_configurations.Element = AAZObjectType()
            _build_schema_application_gateway_custom_error_read(custom_error_configurations.Element)

            frontend_ip_configurations = cls._schema_on_200_201.properties.frontend_ip_configurations
            frontend_ip_configurations.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.frontend_ip_configurations.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.frontend_ip_configurations.Element.properties
            properties.private_ip_address = AAZStrType(
                serialized_name="privateIPAddress",
            )
            properties.private_ip_allocation_method = AAZStrType(
                serialized_name="privateIPAllocationMethod",
            )
            properties.private_link_configuration = AAZObjectType(
                serialized_name="privateLinkConfiguration",
            )
            _build_schema_sub_resource_read(properties.private_link_configuration)
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.public_ip_address = AAZObjectType(
                serialized_name="publicIPAddress",
            )
            _build_schema_sub_resource_read(properties.public_ip_address)
            properties.subnet = AAZObjectType()
            _build_schema_sub_resource_read(properties.subnet)

            frontend_ports = cls._schema_on_200_201.properties.frontend_ports
            frontend_ports.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.frontend_ports.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.frontend_ports.Element.properties
            properties.port = AAZIntType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            gateway_ip_configurations = cls._schema_on_200_201.properties.gateway_ip_configurations
            gateway_ip_configurations.Element = AAZObjectType()
            _build_schema_application_gateway_ip_configuration_read(gateway_ip_configurations.Element)

            global_configuration = cls._schema_on_200_201.properties.global_configuration
            global_configuration.enable_request_buffering = AAZBoolType(
                serialized_name="enableRequestBuffering",
            )
            global_configuration.enable_response_buffering = AAZBoolType(
                serialized_name="enableResponseBuffering",
            )

            http_listeners = cls._schema_on_200_201.properties.http_listeners
            http_listeners.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.http_listeners.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.http_listeners.Element.properties
            properties.custom_error_configurations = AAZListType(
                serialized_name="customErrorConfigurations",
            )
            properties.firewall_policy = AAZObjectType(
                serialized_name="firewallPolicy",
            )
            _build_schema_sub_resource_read(properties.firewall_policy)
            properties.frontend_ip_configuration = AAZObjectType(
                serialized_name="frontendIPConfiguration",
            )
            _build_schema_sub_resource_read(properties.frontend_ip_configuration)
            properties.frontend_port = AAZObjectType(
                serialized_name="frontendPort",
            )
            _build_schema_sub_resource_read(properties.frontend_port)
            properties.host_name = AAZStrType(
                serialized_name="hostName",
            )
            properties.host_names = AAZListType(
                serialized_name="hostNames",
            )
            properties.protocol = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.require_server_name_indication = AAZBoolType(
                serialized_name="requireServerNameIndication",
            )
            properties.ssl_certificate = AAZObjectType(
                serialized_name="sslCertificate",
            )
            _build_schema_sub_resource_read(properties.ssl_certificate)
            properties.ssl_profile = AAZObjectType(
                serialized_name="sslProfile",
            )
            _build_schema_sub_resource_read(properties.ssl_profile)

            custom_error_configurations = cls._schema_on_200_201.properties.http_listeners.Element.properties.custom_error_configurations
            custom_error_configurations.Element = AAZObjectType()
            _build_schema_application_gateway_custom_error_read(custom_error_configurations.Element)

            host_names = cls._schema_on_200_201.properties.http_listeners.Element.properties.host_names
            host_names.Element = AAZStrType()

            listeners = cls._schema_on_200_201.properties.listeners
            listeners.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.listeners.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.listeners.Element.properties
            properties.frontend_ip_configuration = AAZObjectType(
                serialized_name="frontendIPConfiguration",
            )
            _build_schema_sub_resource_read(properties.frontend_ip_configuration)
            properties.frontend_port = AAZObjectType(
                serialized_name="frontendPort",
            )
            _build_schema_sub_resource_read(properties.frontend_port)
            properties.protocol = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.ssl_certificate = AAZObjectType(
                serialized_name="sslCertificate",
            )
            _build_schema_sub_resource_read(properties.ssl_certificate)
            properties.ssl_profile = AAZObjectType(
                serialized_name="sslProfile",
            )
            _build_schema_sub_resource_read(properties.ssl_profile)

            load_distribution_policies = cls._schema_on_200_201.properties.load_distribution_policies
            load_distribution_policies.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.load_distribution_policies.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.load_distribution_policies.Element.properties
            properties.load_distribution_algorithm = AAZStrType(
                serialized_name="loadDistributionAlgorithm",
            )
            properties.load_distribution_targets = AAZListType(
                serialized_name="loadDistributionTargets",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            load_distribution_targets = cls._schema_on_200_201.properties.load_distribution_policies.Element.properties.load_distribution_targets
            load_distribution_targets.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.load_distribution_policies.Element.properties.load_distribution_targets.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.load_distribution_policies.Element.properties.load_distribution_targets.Element.properties
            properties.backend_address_pool = AAZObjectType(
                serialized_name="backendAddressPool",
            )
            _build_schema_sub_resource_read(properties.backend_address_pool)
            properties.weight_per_server = AAZIntType(
                serialized_name="weightPerServer",
            )

            private_endpoint_connections = cls._schema_on_200_201.properties.private_endpoint_connections
            private_endpoint_connections.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.private_endpoint_connections.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.private_endpoint_connections.Element.properties
            properties.link_identifier = AAZStrType(
                serialized_name="linkIdentifier",
                flags={"read_only": True},
            )
            properties.private_endpoint = AAZObjectType(
                serialized_name="privateEndpoint",
            )
            _build_schema_private_endpoint_read(properties.private_endpoint)
            properties.private_link_service_connection_state = AAZObjectType(
                serialized_name="privateLinkServiceConnectionState",
            )
            _build_schema_private_link_service_connection_state_read(properties.private_link_service_connection_state)
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            private_link_configurations = cls._schema_on_200_201.properties.private_link_configurations
            private_link_configurations.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.private_link_configurations.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.private_link_configurations.Element.properties
            properties.ip_configurations = AAZListType(
                serialized_name="ipConfigurations",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            ip_configurations = cls._schema_on_200_201.properties.private_link_configurations.Element.properties.ip_configurations
            ip_configurations.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.private_link_configurations.Element.properties.ip_configurations.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.private_link_configurations.Element.properties.ip_configurations.Element.properties
            properties.primary = AAZBoolType()
            properties.private_ip_address = AAZStrType(
                serialized_name="privateIPAddress",
            )
            properties.private_ip_allocation_method = AAZStrType(
                serialized_name="privateIPAllocationMethod",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.subnet = AAZObjectType()
            _build_schema_sub_resource_read(properties.subnet)

            probes = cls._schema_on_200_201.properties.probes
            probes.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.probes.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.probes.Element.properties
            properties.host = AAZStrType()
            properties.interval = AAZIntType()
            properties.match = AAZObjectType()
            properties.min_servers = AAZIntType(
                serialized_name="minServers",
            )
            properties.path = AAZStrType()
            properties.pick_host_name_from_backend_http_settings = AAZBoolType(
                serialized_name="pickHostNameFromBackendHttpSettings",
            )
            properties.pick_host_name_from_backend_settings = AAZBoolType(
                serialized_name="pickHostNameFromBackendSettings",
            )
            properties.port = AAZIntType()
            properties.protocol = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.timeout = AAZIntType()
            properties.unhealthy_threshold = AAZIntType(
                serialized_name="unhealthyThreshold",
            )

            match = cls._schema_on_200_201.properties.probes.Element.properties.match
            match.body = AAZStrType()
            match.status_codes = AAZListType(
                serialized_name="statusCodes",
            )

            status_codes = cls._schema_on_200_201.properties.probes.Element.properties.match.status_codes
            status_codes.Element = AAZStrType()

            redirect_configurations = cls._schema_on_200_201.properties.redirect_configurations
            redirect_configurations.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.redirect_configurations.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.redirect_configurations.Element.properties
            properties.include_path = AAZBoolType(
                serialized_name="includePath",
            )
            properties.include_query_string = AAZBoolType(
                serialized_name="includeQueryString",
            )
            properties.path_rules = AAZListType(
                serialized_name="pathRules",
            )
            properties.redirect_type = AAZStrType(
                serialized_name="redirectType",
            )
            properties.request_routing_rules = AAZListType(
                serialized_name="requestRoutingRules",
            )
            properties.target_listener = AAZObjectType(
                serialized_name="targetListener",
            )
            _build_schema_sub_resource_read(properties.target_listener)
            properties.target_url = AAZStrType(
                serialized_name="targetUrl",
            )
            properties.url_path_maps = AAZListType(
                serialized_name="urlPathMaps",
            )

            path_rules = cls._schema_on_200_201.properties.redirect_configurations.Element.properties.path_rules
            path_rules.Element = AAZObjectType()
            _build_schema_sub_resource_read(path_rules.Element)

            request_routing_rules = cls._schema_on_200_201.properties.redirect_configurations.Element.properties.request_routing_rules
            request_routing_rules.Element = AAZObjectType()
            _build_schema_sub_resource_read(request_routing_rules.Element)

            url_path_maps = cls._schema_on_200_201.properties.redirect_configurations.Element.properties.url_path_maps
            url_path_maps.Element = AAZObjectType()
            _build_schema_sub_resource_read(url_path_maps.Element)

            request_routing_rules = cls._schema_on_200_201.properties.request_routing_rules
            request_routing_rules.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.request_routing_rules.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.request_routing_rules.Element.properties
            properties.backend_address_pool = AAZObjectType(
                serialized_name="backendAddressPool",
            )
            _build_schema_sub_resource_read(properties.backend_address_pool)
            properties.backend_http_settings = AAZObjectType(
                serialized_name="backendHttpSettings",
            )
            _build_schema_sub_resource_read(properties.backend_http_settings)
            properties.http_listener = AAZObjectType(
                serialized_name="httpListener",
            )
            _build_schema_sub_resource_read(properties.http_listener)
            properties.load_distribution_policy = AAZObjectType(
                serialized_name="loadDistributionPolicy",
            )
            _build_schema_sub_resource_read(properties.load_distribution_policy)
            properties.priority = AAZIntType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.redirect_configuration = AAZObjectType(
                serialized_name="redirectConfiguration",
            )
            _build_schema_sub_resource_read(properties.redirect_configuration)
            properties.rewrite_rule_set = AAZObjectType(
                serialized_name="rewriteRuleSet",
            )
            _build_schema_sub_resource_read(properties.rewrite_rule_set)
            properties.rule_type = AAZStrType(
                serialized_name="ruleType",
            )
            properties.url_path_map = AAZObjectType(
                serialized_name="urlPathMap",
            )
            _build_schema_sub_resource_read(properties.url_path_map)

            rewrite_rule_sets = cls._schema_on_200_201.properties.rewrite_rule_sets
            rewrite_rule_sets.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.rewrite_rule_sets.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200_201.properties.rewrite_rule_sets.Element.properties
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.rewrite_rules = AAZListType(
                serialized_name="rewriteRules",
            )

            rewrite_rules = cls._schema_on_200_201.properties.rewrite_rule_sets.Element.properties.rewrite_rules
            rewrite_rules.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element
            _element.action_set = AAZObjectType(
                serialized_name="actionSet",
            )
            _element.conditions = AAZListType()
            _element.name = AAZStrType()
            _element.rule_sequence = AAZIntType(
                serialized_name="ruleSequence",
            )

            action_set = cls._schema_on_200_201.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.action_set
            action_set.request_header_configurations = AAZListType(
                serialized_name="requestHeaderConfigurations",
            )
            action_set.response_header_configurations = AAZListType(
                serialized_name="responseHeaderConfigurations",
            )
            action_set.url_configuration = AAZObjectType(
                serialized_name="urlConfiguration",
            )

            request_header_configurations = cls._schema_on_200_201.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.action_set.request_header_configurations
            request_header_configurations.Element = AAZObjectType()
            _build_schema_application_gateway_header_configuration_read(request_header_configurations.Element)

            response_header_configurations = cls._schema_on_200_201.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.action_set.response_header_configurations
            response_header_configurations.Element = AAZObjectType()
            _build_schema_application_gateway_header_configuration_read(response_header_configurations.Element)

            url_configuration = cls._schema_on_200_201.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.action_set.url_configuration
            url_configuration.modified_path = AAZStrType(
                serialized_name="modifiedPath",
            )
            url_configuration.modified_query_string = AAZStrType(
                serialized_name="modifiedQueryString",
            )
            url_configuration.reroute = AAZBoolType()

            conditions = cls._schema_on_200_201.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.conditions
            conditions.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.rewrite_rule_sets.Element.properties.rewrite_rules.Element.conditions.Element
            _element.ignore_case = AAZBoolType(
                serialized_name="ignoreCase",
            )
            _element.negate = AAZBoolType()
            _element.pattern = AAZStrType()
            _element.variable = AAZStrType()

            routing_rules = cls._schema_on_200_201.properties.routing_rules
            routing_rules.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.routing_rules.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.routing_rules.Element.properties
            properties.backend_address_pool = AAZObjectType(
                serialized_name="backendAddressPool",
            )
            _build_schema_sub_resource_read(properties.backend_address_pool)
            properties.backend_settings = AAZObjectType(
                serialized_name="backendSettings",
            )
            _build_schema_sub_resource_read(properties.backend_settings)
            properties.listener = AAZObjectType()
            _build_schema_sub_resource_read(properties.listener)
            properties.priority = AAZIntType(
                flags={"required": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.rule_type = AAZStrType(
                serialized_name="ruleType",
            )

            sku = cls._schema_on_200_201.properties.sku
            sku.capacity = AAZIntType()
            sku.name = AAZStrType()
            sku.tier = AAZStrType()

            ssl_certificates = cls._schema_on_200_201.properties.ssl_certificates
            ssl_certificates.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.ssl_certificates.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.ssl_certificates.Element.properties
            properties.data = AAZStrType()
            properties.key_vault_secret_id = AAZStrType(
                serialized_name="keyVaultSecretId",
            )
            properties.password = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.public_cert_data = AAZStrType(
                serialized_name="publicCertData",
                flags={"read_only": True},
            )

            ssl_profiles = cls._schema_on_200_201.properties.ssl_profiles
            ssl_profiles.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.ssl_profiles.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.ssl_profiles.Element.properties
            properties.client_auth_configuration = AAZObjectType(
                serialized_name="clientAuthConfiguration",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.ssl_policy = AAZObjectType(
                serialized_name="sslPolicy",
            )
            _build_schema_application_gateway_ssl_policy_read(properties.ssl_policy)
            properties.trusted_client_certificates = AAZListType(
                serialized_name="trustedClientCertificates",
            )

            client_auth_configuration = cls._schema_on_200_201.properties.ssl_profiles.Element.properties.client_auth_configuration
            client_auth_configuration.verify_client_cert_issuer_dn = AAZBoolType(
                serialized_name="verifyClientCertIssuerDN",
            )
            client_auth_configuration.verify_client_revocation = AAZStrType(
                serialized_name="verifyClientRevocation",
            )

            trusted_client_certificates = cls._schema_on_200_201.properties.ssl_profiles.Element.properties.trusted_client_certificates
            trusted_client_certificates.Element = AAZObjectType()
            _build_schema_sub_resource_read(trusted_client_certificates.Element)

            trusted_client_certificates = cls._schema_on_200_201.properties.trusted_client_certificates
            trusted_client_certificates.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.trusted_client_certificates.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.trusted_client_certificates.Element.properties
            properties.client_cert_issuer_dn = AAZStrType(
                serialized_name="clientCertIssuerDN",
                flags={"read_only": True},
            )
            properties.data = AAZStrType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.validated_cert_data = AAZStrType(
                serialized_name="validatedCertData",
                flags={"read_only": True},
            )

            trusted_root_certificates = cls._schema_on_200_201.properties.trusted_root_certificates
            trusted_root_certificates.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.trusted_root_certificates.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.trusted_root_certificates.Element.properties
            properties.data = AAZStrType()
            properties.key_vault_secret_id = AAZStrType(
                serialized_name="keyVaultSecretId",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            url_path_maps = cls._schema_on_200_201.properties.url_path_maps
            url_path_maps.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.url_path_maps.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.url_path_maps.Element.properties
            properties.default_backend_address_pool = AAZObjectType(
                serialized_name="defaultBackendAddressPool",
            )
            _build_schema_sub_resource_read(properties.default_backend_address_pool)
            properties.default_backend_http_settings = AAZObjectType(
                serialized_name="defaultBackendHttpSettings",
            )
            _build_schema_sub_resource_read(properties.default_backend_http_settings)
            properties.default_load_distribution_policy = AAZObjectType(
                serialized_name="defaultLoadDistributionPolicy",
            )
            _build_schema_sub_resource_read(properties.default_load_distribution_policy)
            properties.default_redirect_configuration = AAZObjectType(
                serialized_name="defaultRedirectConfiguration",
            )
            _build_schema_sub_resource_read(properties.default_redirect_configuration)
            properties.default_rewrite_rule_set = AAZObjectType(
                serialized_name="defaultRewriteRuleSet",
            )
            _build_schema_sub_resource_read(properties.default_rewrite_rule_set)
            properties.path_rules = AAZListType(
                serialized_name="pathRules",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            path_rules = cls._schema_on_200_201.properties.url_path_maps.Element.properties.path_rules
            path_rules.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.url_path_maps.Element.properties.path_rules.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.url_path_maps.Element.properties.path_rules.Element.properties
            properties.backend_address_pool = AAZObjectType(
                serialized_name="backendAddressPool",
            )
            _build_schema_sub_resource_read(properties.backend_address_pool)
            properties.backend_http_settings = AAZObjectType(
                serialized_name="backendHttpSettings",
            )
            _build_schema_sub_resource_read(properties.backend_http_settings)
            properties.firewall_policy = AAZObjectType(
                serialized_name="firewallPolicy",
            )
            _build_schema_sub_resource_read(properties.firewall_policy)
            properties.load_distribution_policy = AAZObjectType(
                serialized_name="loadDistributionPolicy",
            )
            _build_schema_sub_resource_read(properties.load_distribution_policy)
            properties.paths = AAZListType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.redirect_configuration = AAZObjectType(
                serialized_name="redirectConfiguration",
            )
            _build_schema_sub_resource_read(properties.redirect_configuration)
            properties.rewrite_rule_set = AAZObjectType(
                serialized_name="rewriteRuleSet",
            )
            _build_schema_sub_resource_read(properties.rewrite_rule_set)

            paths = cls._schema_on_200_201.properties.url_path_maps.Element.properties.path_rules.Element.properties.paths
            paths.Element = AAZStrType()

            web_application_firewall_configuration = cls._schema_on_200_201.properties.web_application_firewall_configuration
            web_application_firewall_configuration.disabled_rule_groups = AAZListType(
                serialized_name="disabledRuleGroups",
            )
            web_application_firewall_configuration.enabled = AAZBoolType(
                flags={"required": True},
            )
            web_application_firewall_configuration.exclusions = AAZListType()
            web_application_firewall_configuration.file_upload_limit_in_mb = AAZIntType(
                serialized_name="fileUploadLimitInMb",
            )
            web_application_firewall_configuration.firewall_mode = AAZStrType(
                serialized_name="firewallMode",
                flags={"required": True},
            )
            web_application_firewall_configuration.max_request_body_size = AAZIntType(
                serialized_name="maxRequestBodySize",
            )
            web_application_firewall_configuration.max_request_body_size_in_kb = AAZIntType(
                serialized_name="maxRequestBodySizeInKb",
            )
            web_application_firewall_configuration.request_body_check = AAZBoolType(
                serialized_name="requestBodyCheck",
            )
            web_application_firewall_configuration.rule_set_type = AAZStrType(
                serialized_name="ruleSetType",
                flags={"required": True},
            )
            web_application_firewall_configuration.rule_set_version = AAZStrType(
                serialized_name="ruleSetVersion",
                flags={"required": True},
            )

            disabled_rule_groups = cls._schema_on_200_201.properties.web_application_firewall_configuration.disabled_rule_groups
            disabled_rule_groups.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.web_application_firewall_configuration.disabled_rule_groups.Element
            _element.rule_group_name = AAZStrType(
                serialized_name="ruleGroupName",
                flags={"required": True},
            )
            _element.rules = AAZListType()

            rules = cls._schema_on_200_201.properties.web_application_firewall_configuration.disabled_rule_groups.Element.rules
            rules.Element = AAZIntType()

            exclusions = cls._schema_on_200_201.properties.web_application_firewall_configuration.exclusions
            exclusions.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.web_application_firewall_configuration.exclusions.Element
            _element.match_variable = AAZStrType(
                serialized_name="matchVariable",
                flags={"required": True},
            )
            _element.selector = AAZStrType(
                flags={"required": True},
            )
            _element.selector_match_operator = AAZStrType(
                serialized_name="selectorMatchOperator",
                flags={"required": True},
            )

            tags = cls._schema_on_200_201.tags
            tags.Element = AAZStrType()

            zones = cls._schema_on_200_201.zones
            zones.Element = AAZStrType()

            return cls._schema_on_200_201


def _build_schema_application_gateway_custom_error_create(_builder):
    if _builder is None:
        return
    _builder.set_prop("customErrorPageUrl", AAZStrType, ".custom_error_page_url")
    _builder.set_prop("statusCode", AAZStrType, ".status_code")


def _build_schema_application_gateway_header_configuration_create(_builder):
    if _builder is None:
        return
    _builder.set_prop("headerName", AAZStrType, ".header_name")
    _builder.set_prop("headerValue", AAZStrType, ".header_value")


def _build_schema_application_gateway_ssl_policy_create(_builder):
    if _builder is None:
        return
    _builder.set_prop("cipherSuites", AAZListType, ".cipher_suites")
    _builder.set_prop("disabledSslProtocols", AAZListType, ".disabled_ssl_protocols")
    _builder.set_prop("minProtocolVersion", AAZStrType, ".min_protocol_version")
    _builder.set_prop("policyName", AAZStrType, ".policy_name")
    _builder.set_prop("policyType", AAZStrType, ".policy_type")

    cipher_suites = _builder.get(".cipherSuites")
    if cipher_suites is not None:
        cipher_suites.set_elements(AAZStrType, ".")

    disabled_ssl_protocols = _builder.get(".disabledSslProtocols")
    if disabled_ssl_protocols is not None:
        disabled_ssl_protocols.set_elements(AAZStrType, ".")


def _build_schema_sub_resource_create(_builder):
    if _builder is None:
        return
    _builder.set_prop("id", AAZStrType, ".id")


_schema_application_gateway_backend_address_pool_read = None


def _build_schema_application_gateway_backend_address_pool_read(_schema):
    global _schema_application_gateway_backend_address_pool_read
    if _schema_application_gateway_backend_address_pool_read is not None:
        _schema.etag = _schema_application_gateway_backend_address_pool_read.etag
        _schema.id = _schema_application_gateway_backend_address_pool_read.id
        _schema.name = _schema_application_gateway_backend_address_pool_read.name
        _schema.properties = _schema_application_gateway_backend_address_pool_read.properties
        _schema.type = _schema_application_gateway_backend_address_pool_read.type
        return

    _schema_application_gateway_backend_address_pool_read = AAZObjectType()

    application_gateway_backend_address_pool_read = _schema_application_gateway_backend_address_pool_read
    application_gateway_backend_address_pool_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    application_gateway_backend_address_pool_read.id = AAZStrType()
    application_gateway_backend_address_pool_read.name = AAZStrType()
    application_gateway_backend_address_pool_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    application_gateway_backend_address_pool_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_application_gateway_backend_address_pool_read.properties
    properties.backend_addresses = AAZListType(
        serialized_name="backendAddresses",
    )
    properties.backend_ip_configurations = AAZListType(
        serialized_name="backendIPConfigurations",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    backend_addresses = _schema_application_gateway_backend_address_pool_read.properties.backend_addresses
    backend_addresses.Element = AAZObjectType()

    _element = _schema_application_gateway_backend_address_pool_read.properties.backend_addresses.Element
    _element.fqdn = AAZStrType()
    _element.ip_address = AAZStrType(
        serialized_name="ipAddress",
    )

    backend_ip_configurations = _schema_application_gateway_backend_address_pool_read.properties.backend_ip_configurations
    backend_ip_configurations.Element = AAZObjectType()
    _build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

    _schema.etag = _schema_application_gateway_backend_address_pool_read.etag
    _schema.id = _schema_application_gateway_backend_address_pool_read.id
    _schema.name = _schema_application_gateway_backend_address_pool_read.name
    _schema.properties = _schema_application_gateway_backend_address_pool_read.properties
    _schema.type = _schema_application_gateway_backend_address_pool_read.type


_schema_application_gateway_custom_error_read = None


def _build_schema_application_gateway_custom_error_read(_schema):
    global _schema_application_gateway_custom_error_read
    if _schema_application_gateway_custom_error_read is not None:
        _schema.custom_error_page_url = _schema_application_gateway_custom_error_read.custom_error_page_url
        _schema.status_code = _schema_application_gateway_custom_error_read.status_code
        return

    _schema_application_gateway_custom_error_read = AAZObjectType()

    application_gateway_custom_error_read = _schema_application_gateway_custom_error_read
    application_gateway_custom_error_read.custom_error_page_url = AAZStrType(
        serialized_name="customErrorPageUrl",
    )
    application_gateway_custom_error_read.status_code = AAZStrType(
        serialized_name="statusCode",
    )

    _schema.custom_error_page_url = _schema_application_gateway_custom_error_read.custom_error_page_url
    _schema.status_code = _schema_application_gateway_custom_error_read.status_code


_schema_application_gateway_header_configuration_read = None


def _build_schema_application_gateway_header_configuration_read(_schema):
    global _schema_application_gateway_header_configuration_read
    if _schema_application_gateway_header_configuration_read is not None:
        _schema.header_name = _schema_application_gateway_header_configuration_read.header_name
        _schema.header_value = _schema_application_gateway_header_configuration_read.header_value
        return

    _schema_application_gateway_header_configuration_read = AAZObjectType()

    application_gateway_header_configuration_read = _schema_application_gateway_header_configuration_read
    application_gateway_header_configuration_read.header_name = AAZStrType(
        serialized_name="headerName",
    )
    application_gateway_header_configuration_read.header_value = AAZStrType(
        serialized_name="headerValue",
    )

    _schema.header_name = _schema_application_gateway_header_configuration_read.header_name
    _schema.header_value = _schema_application_gateway_header_configuration_read.header_value


_schema_application_gateway_ip_configuration_read = None


def _build_schema_application_gateway_ip_configuration_read(_schema):
    global _schema_application_gateway_ip_configuration_read
    if _schema_application_gateway_ip_configuration_read is not None:
        _schema.etag = _schema_application_gateway_ip_configuration_read.etag
        _schema.id = _schema_application_gateway_ip_configuration_read.id
        _schema.name = _schema_application_gateway_ip_configuration_read.name
        _schema.properties = _schema_application_gateway_ip_configuration_read.properties
        _schema.type = _schema_application_gateway_ip_configuration_read.type
        return

    _schema_application_gateway_ip_configuration_read = AAZObjectType()

    application_gateway_ip_configuration_read = _schema_application_gateway_ip_configuration_read
    application_gateway_ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    application_gateway_ip_configuration_read.id = AAZStrType()
    application_gateway_ip_configuration_read.name = AAZStrType()
    application_gateway_ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    application_gateway_ip_configuration_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_application_gateway_ip_configuration_read.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType()
    _build_schema_sub_resource_read(properties.subnet)

    _schema.etag = _schema_application_gateway_ip_configuration_read.etag
    _schema.id = _schema_application_gateway_ip_configuration_read.id
    _schema.name = _schema_application_gateway_ip_configuration_read.name
    _schema.properties = _schema_application_gateway_ip_configuration_read.properties
    _schema.type = _schema_application_gateway_ip_configuration_read.type


_schema_application_gateway_ssl_policy_read = None


def _build_schema_application_gateway_ssl_policy_read(_schema):
    global _schema_application_gateway_ssl_policy_read
    if _schema_application_gateway_ssl_policy_read is not None:
        _schema.cipher_suites = _schema_application_gateway_ssl_policy_read.cipher_suites
        _schema.disabled_ssl_protocols = _schema_application_gateway_ssl_policy_read.disabled_ssl_protocols
        _schema.min_protocol_version = _schema_application_gateway_ssl_policy_read.min_protocol_version
        _schema.policy_name = _schema_application_gateway_ssl_policy_read.policy_name
        _schema.policy_type = _schema_application_gateway_ssl_policy_read.policy_type
        return

    _schema_application_gateway_ssl_policy_read = AAZObjectType()

    application_gateway_ssl_policy_read = _schema_application_gateway_ssl_policy_read
    application_gateway_ssl_policy_read.cipher_suites = AAZListType(
        serialized_name="cipherSuites",
    )
    application_gateway_ssl_policy_read.disabled_ssl_protocols = AAZListType(
        serialized_name="disabledSslProtocols",
    )
    application_gateway_ssl_policy_read.min_protocol_version = AAZStrType(
        serialized_name="minProtocolVersion",
    )
    application_gateway_ssl_policy_read.policy_name = AAZStrType(
        serialized_name="policyName",
    )
    application_gateway_ssl_policy_read.policy_type = AAZStrType(
        serialized_name="policyType",
    )

    cipher_suites = _schema_application_gateway_ssl_policy_read.cipher_suites
    cipher_suites.Element = AAZStrType()

    disabled_ssl_protocols = _schema_application_gateway_ssl_policy_read.disabled_ssl_protocols
    disabled_ssl_protocols.Element = AAZStrType()

    _schema.cipher_suites = _schema_application_gateway_ssl_policy_read.cipher_suites
    _schema.disabled_ssl_protocols = _schema_application_gateway_ssl_policy_read.disabled_ssl_protocols
    _schema.min_protocol_version = _schema_application_gateway_ssl_policy_read.min_protocol_version
    _schema.policy_name = _schema_application_gateway_ssl_policy_read.policy_name
    _schema.policy_type = _schema_application_gateway_ssl_policy_read.policy_type


_schema_application_security_group_read = None


def _build_schema_application_security_group_read(_schema):
    global _schema_application_security_group_read
    if _schema_application_security_group_read is not None:
        _schema.etag = _schema_application_security_group_read.etag
        _schema.id = _schema_application_security_group_read.id
        _schema.location = _schema_application_security_group_read.location
        _schema.name = _schema_application_security_group_read.name
        _schema.properties = _schema_application_security_group_read.properties
        _schema.tags = _schema_application_security_group_read.tags
        _schema.type = _schema_application_security_group_read.type
        return

    _schema_application_security_group_read = AAZObjectType()

    application_security_group_read = _schema_application_security_group_read
    application_security_group_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.id = AAZStrType()
    application_security_group_read.location = AAZStrType()
    application_security_group_read.name = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    application_security_group_read.tags = AAZDictType()
    application_security_group_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_application_security_group_read.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )

    tags = _schema_application_security_group_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_application_security_group_read.etag
    _schema.id = _schema_application_security_group_read.id
    _schema.location = _schema_application_security_group_read.location
    _schema.name = _schema_application_security_group_read.name
    _schema.properties = _schema_application_security_group_read.properties
    _schema.tags = _schema_application_security_group_read.tags
    _schema.type = _schema_application_security_group_read.type


_schema_extended_location_read = None


def _build_schema_extended_location_read(_schema):
    global _schema_extended_location_read
    if _schema_extended_location_read is not None:
        _schema.name = _schema_extended_location_read.name
        _schema.type = _schema_extended_location_read.type
        return

    _schema_extended_location_read = AAZObjectType()

    extended_location_read = _schema_extended_location_read
    extended_location_read.name = AAZStrType()
    extended_location_read.type = AAZStrType()

    _schema.name = _schema_extended_location_read.name
    _schema.type = _schema_extended_location_read.type


_schema_frontend_ip_configuration_read = None


def _build_schema_frontend_ip_configuration_read(_schema):
    global _schema_frontend_ip_configuration_read
    if _schema_frontend_ip_configuration_read is not None:
        _schema.etag = _schema_frontend_ip_configuration_read.etag
        _schema.id = _schema_frontend_ip_configuration_read.id
        _schema.name = _schema_frontend_ip_configuration_read.name
        _schema.properties = _schema_frontend_ip_configuration_read.properties
        _schema.type = _schema_frontend_ip_configuration_read.type
        _schema.zones = _schema_frontend_ip_configuration_read.zones
        return

    _schema_frontend_ip_configuration_read = AAZObjectType()

    frontend_ip_configuration_read = _schema_frontend_ip_configuration_read
    frontend_ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    frontend_ip_configuration_read.id = AAZStrType()
    frontend_ip_configuration_read.name = AAZStrType()
    frontend_ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    frontend_ip_configuration_read.type = AAZStrType(
        flags={"read_only": True},
    )
    frontend_ip_configuration_read.zones = AAZListType()

    properties = _schema_frontend_ip_configuration_read.properties
    properties.gateway_load_balancer = AAZObjectType(
        serialized_name="gatewayLoadBalancer",
    )
    _build_schema_sub_resource_read(properties.gateway_load_balancer)
    properties.inbound_nat_pools = AAZListType(
        serialized_name="inboundNatPools",
        flags={"read_only": True},
    )
    properties.inbound_nat_rules = AAZListType(
        serialized_name="inboundNatRules",
        flags={"read_only": True},
    )
    properties.load_balancing_rules = AAZListType(
        serialized_name="loadBalancingRules",
        flags={"read_only": True},
    )
    properties.outbound_rules = AAZListType(
        serialized_name="outboundRules",
        flags={"read_only": True},
    )
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
    )
    properties.private_ip_address_version = AAZStrType(
        serialized_name="privateIPAddressVersion",
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
    )
    _build_schema_public_ip_address_read(properties.public_ip_address)
    properties.public_ip_prefix = AAZObjectType(
        serialized_name="publicIPPrefix",
    )
    _build_schema_sub_resource_read(properties.public_ip_prefix)
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)

    inbound_nat_pools = _schema_frontend_ip_configuration_read.properties.inbound_nat_pools
    inbound_nat_pools.Element = AAZObjectType()
    _build_schema_sub_resource_read(inbound_nat_pools.Element)

    inbound_nat_rules = _schema_frontend_ip_configuration_read.properties.inbound_nat_rules
    inbound_nat_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(inbound_nat_rules.Element)

    load_balancing_rules = _schema_frontend_ip_configuration_read.properties.load_balancing_rules
    load_balancing_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(load_balancing_rules.Element)

    outbound_rules = _schema_frontend_ip_configuration_read.properties.outbound_rules
    outbound_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(outbound_rules.Element)

    zones = _schema_frontend_ip_configuration_read.zones
    zones.Element = AAZStrType()

    _schema.etag = _schema_frontend_ip_configuration_read.etag
    _schema.id = _schema_frontend_ip_configuration_read.id
    _schema.name = _schema_frontend_ip_configuration_read.name
    _schema.properties = _schema_frontend_ip_configuration_read.properties
    _schema.type = _schema_frontend_ip_configuration_read.type
    _schema.zones = _schema_frontend_ip_configuration_read.zones


_schema_ip_configuration_read = None


def _build_schema_ip_configuration_read(_schema):
    global _schema_ip_configuration_read
    if _schema_ip_configuration_read is not None:
        _schema.etag = _schema_ip_configuration_read.etag
        _schema.id = _schema_ip_configuration_read.id
        _schema.name = _schema_ip_configuration_read.name
        _schema.properties = _schema_ip_configuration_read.properties
        return

    _schema_ip_configuration_read = AAZObjectType()

    ip_configuration_read = _schema_ip_configuration_read
    ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    ip_configuration_read.id = AAZStrType()
    ip_configuration_read.name = AAZStrType()
    ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )

    properties = _schema_ip_configuration_read.properties
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
    )
    _build_schema_public_ip_address_read(properties.public_ip_address)
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)

    _schema.etag = _schema_ip_configuration_read.etag
    _schema.id = _schema_ip_configuration_read.id
    _schema.name = _schema_ip_configuration_read.name
    _schema.properties = _schema_ip_configuration_read.properties


_schema_network_interface_ip_configuration_read = None


def _build_schema_network_interface_ip_configuration_read(_schema):
    global _schema_network_interface_ip_configuration_read
    if _schema_network_interface_ip_configuration_read is not None:
        _schema.etag = _schema_network_interface_ip_configuration_read.etag
        _schema.id = _schema_network_interface_ip_configuration_read.id
        _schema.name = _schema_network_interface_ip_configuration_read.name
        _schema.properties = _schema_network_interface_ip_configuration_read.properties
        _schema.type = _schema_network_interface_ip_configuration_read.type
        return

    _schema_network_interface_ip_configuration_read = AAZObjectType()

    network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read
    network_interface_ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_ip_configuration_read.id = AAZStrType()
    network_interface_ip_configuration_read.name = AAZStrType()
    network_interface_ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    network_interface_ip_configuration_read.type = AAZStrType()

    properties = _schema_network_interface_ip_configuration_read.properties
    properties.application_gateway_backend_address_pools = AAZListType(
        serialized_name="applicationGatewayBackendAddressPools",
    )
    properties.application_security_groups = AAZListType(
        serialized_name="applicationSecurityGroups",
    )
    properties.gateway_load_balancer = AAZObjectType(
        serialized_name="gatewayLoadBalancer",
    )
    _build_schema_sub_resource_read(properties.gateway_load_balancer)
    properties.load_balancer_backend_address_pools = AAZListType(
        serialized_name="loadBalancerBackendAddressPools",
    )
    properties.load_balancer_inbound_nat_rules = AAZListType(
        serialized_name="loadBalancerInboundNatRules",
    )
    properties.primary = AAZBoolType()
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
    )
    properties.private_ip_address_version = AAZStrType(
        serialized_name="privateIPAddressVersion",
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
    )
    properties.private_link_connection_properties = AAZObjectType(
        serialized_name="privateLinkConnectionProperties",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
    )
    _build_schema_public_ip_address_read(properties.public_ip_address)
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)
    properties.virtual_network_taps = AAZListType(
        serialized_name="virtualNetworkTaps",
    )

    application_gateway_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools
    application_gateway_backend_address_pools.Element = AAZObjectType()
    _build_schema_application_gateway_backend_address_pool_read(application_gateway_backend_address_pools.Element)

    application_security_groups = _schema_network_interface_ip_configuration_read.properties.application_security_groups
    application_security_groups.Element = AAZObjectType()
    _build_schema_application_security_group_read(application_security_groups.Element)

    load_balancer_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools
    load_balancer_backend_address_pools.Element = AAZObjectType()

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties
    properties.backend_ip_configurations = AAZListType(
        serialized_name="backendIPConfigurations",
        flags={"read_only": True},
    )
    properties.drain_period_in_seconds = AAZIntType(
        serialized_name="drainPeriodInSeconds",
    )
    properties.inbound_nat_rules = AAZListType(
        serialized_name="inboundNatRules",
        flags={"read_only": True},
    )
    properties.load_balancer_backend_addresses = AAZListType(
        serialized_name="loadBalancerBackendAddresses",
    )
    properties.load_balancing_rules = AAZListType(
        serialized_name="loadBalancingRules",
        flags={"read_only": True},
    )
    properties.location = AAZStrType()
    properties.outbound_rule = AAZObjectType(
        serialized_name="outboundRule",
    )
    _build_schema_sub_resource_read(properties.outbound_rule)
    properties.outbound_rules = AAZListType(
        serialized_name="outboundRules",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.tunnel_interfaces = AAZListType(
        serialized_name="tunnelInterfaces",
    )

    backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.backend_ip_configurations
    backend_ip_configurations.Element = AAZObjectType()
    _build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

    inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.inbound_nat_rules
    inbound_nat_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(inbound_nat_rules.Element)

    load_balancer_backend_addresses = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancer_backend_addresses
    load_balancer_backend_addresses.Element = AAZObjectType()

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancer_backend_addresses.Element
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancer_backend_addresses.Element.properties
    properties.admin_state = AAZStrType(
        serialized_name="adminState",
    )
    properties.inbound_nat_rules_port_mapping = AAZListType(
        serialized_name="inboundNatRulesPortMapping",
        flags={"read_only": True},
    )
    properties.ip_address = AAZStrType(
        serialized_name="ipAddress",
    )
    properties.load_balancer_frontend_ip_configuration = AAZObjectType(
        serialized_name="loadBalancerFrontendIPConfiguration",
    )
    _build_schema_sub_resource_read(properties.load_balancer_frontend_ip_configuration)
    properties.network_interface_ip_configuration = AAZObjectType(
        serialized_name="networkInterfaceIPConfiguration",
    )
    _build_schema_sub_resource_read(properties.network_interface_ip_configuration)
    properties.subnet = AAZObjectType()
    _build_schema_sub_resource_read(properties.subnet)
    properties.virtual_network = AAZObjectType(
        serialized_name="virtualNetwork",
    )
    _build_schema_sub_resource_read(properties.virtual_network)

    inbound_nat_rules_port_mapping = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancer_backend_addresses.Element.properties.inbound_nat_rules_port_mapping
    inbound_nat_rules_port_mapping.Element = AAZObjectType()

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancer_backend_addresses.Element.properties.inbound_nat_rules_port_mapping.Element
    _element.backend_port = AAZIntType(
        serialized_name="backendPort",
    )
    _element.frontend_port = AAZIntType(
        serialized_name="frontendPort",
    )
    _element.inbound_nat_rule_name = AAZStrType(
        serialized_name="inboundNatRuleName",
    )

    load_balancing_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancing_rules
    load_balancing_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(load_balancing_rules.Element)

    outbound_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.outbound_rules
    outbound_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(outbound_rules.Element)

    tunnel_interfaces = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.tunnel_interfaces
    tunnel_interfaces.Element = AAZObjectType()

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.tunnel_interfaces.Element
    _element.identifier = AAZIntType()
    _element.port = AAZIntType()
    _element.protocol = AAZStrType()
    _element.type = AAZStrType()

    load_balancer_inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules
    load_balancer_inbound_nat_rules.Element = AAZObjectType()

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element.properties
    properties.backend_address_pool = AAZObjectType(
        serialized_name="backendAddressPool",
    )
    _build_schema_sub_resource_read(properties.backend_address_pool)
    properties.backend_ip_configuration = AAZObjectType(
        serialized_name="backendIPConfiguration",
    )
    _build_schema_network_interface_ip_configuration_read(properties.backend_ip_configuration)
    properties.backend_port = AAZIntType(
        serialized_name="backendPort",
    )
    properties.enable_floating_ip = AAZBoolType(
        serialized_name="enableFloatingIP",
    )
    properties.enable_tcp_reset = AAZBoolType(
        serialized_name="enableTcpReset",
    )
    properties.frontend_ip_configuration = AAZObjectType(
        serialized_name="frontendIPConfiguration",
    )
    _build_schema_sub_resource_read(properties.frontend_ip_configuration)
    properties.frontend_port = AAZIntType(
        serialized_name="frontendPort",
    )
    properties.frontend_port_range_end = AAZIntType(
        serialized_name="frontendPortRangeEnd",
    )
    properties.frontend_port_range_start = AAZIntType(
        serialized_name="frontendPortRangeStart",
    )
    properties.idle_timeout_in_minutes = AAZIntType(
        serialized_name="idleTimeoutInMinutes",
    )
    properties.protocol = AAZStrType()
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    private_link_connection_properties = _schema_network_interface_ip_configuration_read.properties.private_link_connection_properties
    private_link_connection_properties.fqdns = AAZListType(
        flags={"read_only": True},
    )
    private_link_connection_properties.group_id = AAZStrType(
        serialized_name="groupId",
        flags={"read_only": True},
    )
    private_link_connection_properties.required_member_name = AAZStrType(
        serialized_name="requiredMemberName",
        flags={"read_only": True},
    )

    fqdns = _schema_network_interface_ip_configuration_read.properties.private_link_connection_properties.fqdns
    fqdns.Element = AAZStrType()

    virtual_network_taps = _schema_network_interface_ip_configuration_read.properties.virtual_network_taps
    virtual_network_taps.Element = AAZObjectType()
    _build_schema_virtual_network_tap_read(virtual_network_taps.Element)

    _schema.etag = _schema_network_interface_ip_configuration_read.etag
    _schema.id = _schema_network_interface_ip_configuration_read.id
    _schema.name = _schema_network_interface_ip_configuration_read.name
    _schema.properties = _schema_network_interface_ip_configuration_read.properties
    _schema.type = _schema_network_interface_ip_configuration_read.type


_schema_network_interface_tap_configuration_read = None


def _build_schema_network_interface_tap_configuration_read(_schema):
    global _schema_network_interface_tap_configuration_read
    if _schema_network_interface_tap_configuration_read is not None:
        _schema.etag = _schema_network_interface_tap_configuration_read.etag
        _schema.id = _schema_network_interface_tap_configuration_read.id
        _schema.name = _schema_network_interface_tap_configuration_read.name
        _schema.properties = _schema_network_interface_tap_configuration_read.properties
        _schema.type = _schema_network_interface_tap_configuration_read.type
        return

    _schema_network_interface_tap_configuration_read = AAZObjectType()

    network_interface_tap_configuration_read = _schema_network_interface_tap_configuration_read
    network_interface_tap_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_tap_configuration_read.id = AAZStrType()
    network_interface_tap_configuration_read.name = AAZStrType()
    network_interface_tap_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    network_interface_tap_configuration_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_tap_configuration_read.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.virtual_network_tap = AAZObjectType(
        serialized_name="virtualNetworkTap",
    )
    _build_schema_virtual_network_tap_read(properties.virtual_network_tap)

    _schema.etag = _schema_network_interface_tap_configuration_read.etag
    _schema.id = _schema_network_interface_tap_configuration_read.id
    _schema.name = _schema_network_interface_tap_configuration_read.name
    _schema.properties = _schema_network_interface_tap_configuration_read.properties
    _schema.type = _schema_network_interface_tap_configuration_read.type


_schema_network_interface_read = None


def _build_schema_network_interface_read(_schema):
    global _schema_network_interface_read
    if _schema_network_interface_read is not None:
        _schema.etag = _schema_network_interface_read.etag
        _schema.extended_location = _schema_network_interface_read.extended_location
        _schema.id = _schema_network_interface_read.id
        _schema.location = _schema_network_interface_read.location
        _schema.name = _schema_network_interface_read.name
        _schema.properties = _schema_network_interface_read.properties
        _schema.tags = _schema_network_interface_read.tags
        _schema.type = _schema_network_interface_read.type
        return

    _schema_network_interface_read = AAZObjectType()

    network_interface_read = _schema_network_interface_read
    network_interface_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_read.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
    )
    _build_schema_extended_location_read(network_interface_read.extended_location)
    network_interface_read.id = AAZStrType()
    network_interface_read.location = AAZStrType()
    network_interface_read.name = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    network_interface_read.tags = AAZDictType()
    network_interface_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties
    properties.auxiliary_mode = AAZStrType(
        serialized_name="auxiliaryMode",
    )
    properties.disable_tcp_state_tracking = AAZBoolType(
        serialized_name="disableTcpStateTracking",
    )
    properties.dns_settings = AAZObjectType(
        serialized_name="dnsSettings",
    )
    properties.dscp_configuration = AAZObjectType(
        serialized_name="dscpConfiguration",
    )
    _build_schema_sub_resource_read(properties.dscp_configuration)
    properties.enable_accelerated_networking = AAZBoolType(
        serialized_name="enableAcceleratedNetworking",
    )
    properties.enable_ip_forwarding = AAZBoolType(
        serialized_name="enableIPForwarding",
    )
    properties.hosted_workloads = AAZListType(
        serialized_name="hostedWorkloads",
        flags={"read_only": True},
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
    )
    properties.mac_address = AAZStrType(
        serialized_name="macAddress",
        flags={"read_only": True},
    )
    properties.migration_phase = AAZStrType(
        serialized_name="migrationPhase",
    )
    properties.network_security_group = AAZObjectType(
        serialized_name="networkSecurityGroup",
    )
    _build_schema_network_security_group_read(properties.network_security_group)
    properties.nic_type = AAZStrType(
        serialized_name="nicType",
    )
    properties.primary = AAZBoolType(
        flags={"read_only": True},
    )
    properties.private_endpoint = AAZObjectType(
        serialized_name="privateEndpoint",
    )
    _build_schema_private_endpoint_read(properties.private_endpoint)
    properties.private_link_service = AAZObjectType(
        serialized_name="privateLinkService",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.tap_configurations = AAZListType(
        serialized_name="tapConfigurations",
        flags={"read_only": True},
    )
    properties.virtual_machine = AAZObjectType(
        serialized_name="virtualMachine",
    )
    _build_schema_sub_resource_read(properties.virtual_machine)
    properties.vnet_encryption_supported = AAZBoolType(
        serialized_name="vnetEncryptionSupported",
        flags={"read_only": True},
    )
    properties.workload_type = AAZStrType(
        serialized_name="workloadType",
    )

    dns_settings = _schema_network_interface_read.properties.dns_settings
    dns_settings.applied_dns_servers = AAZListType(
        serialized_name="appliedDnsServers",
        flags={"read_only": True},
    )
    dns_settings.dns_servers = AAZListType(
        serialized_name="dnsServers",
    )
    dns_settings.internal_dns_name_label = AAZStrType(
        serialized_name="internalDnsNameLabel",
    )
    dns_settings.internal_domain_name_suffix = AAZStrType(
        serialized_name="internalDomainNameSuffix",
        flags={"read_only": True},
    )
    dns_settings.internal_fqdn = AAZStrType(
        serialized_name="internalFqdn",
        flags={"read_only": True},
    )

    applied_dns_servers = _schema_network_interface_read.properties.dns_settings.applied_dns_servers
    applied_dns_servers.Element = AAZStrType()

    dns_servers = _schema_network_interface_read.properties.dns_settings.dns_servers
    dns_servers.Element = AAZStrType()

    hosted_workloads = _schema_network_interface_read.properties.hosted_workloads
    hosted_workloads.Element = AAZStrType()

    ip_configurations = _schema_network_interface_read.properties.ip_configurations
    ip_configurations.Element = AAZObjectType()
    _build_schema_network_interface_ip_configuration_read(ip_configurations.Element)

    private_link_service = _schema_network_interface_read.properties.private_link_service
    private_link_service.etag = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
    )
    _build_schema_extended_location_read(private_link_service.extended_location)
    private_link_service.id = AAZStrType()
    private_link_service.location = AAZStrType()
    private_link_service.name = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    private_link_service.tags = AAZDictType()
    private_link_service.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties.private_link_service.properties
    properties.alias = AAZStrType(
        flags={"read_only": True},
    )
    properties.auto_approval = AAZObjectType(
        serialized_name="autoApproval",
    )
    properties.enable_proxy_protocol = AAZBoolType(
        serialized_name="enableProxyProtocol",
    )
    properties.fqdns = AAZListType()
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
    )
    properties.load_balancer_frontend_ip_configurations = AAZListType(
        serialized_name="loadBalancerFrontendIpConfigurations",
    )
    properties.network_interfaces = AAZListType(
        serialized_name="networkInterfaces",
        flags={"read_only": True},
    )
    properties.private_endpoint_connections = AAZListType(
        serialized_name="privateEndpointConnections",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.visibility = AAZObjectType()

    auto_approval = _schema_network_interface_read.properties.private_link_service.properties.auto_approval
    auto_approval.subscriptions = AAZListType()

    subscriptions = _schema_network_interface_read.properties.private_link_service.properties.auto_approval.subscriptions
    subscriptions.Element = AAZStrType()

    fqdns = _schema_network_interface_read.properties.private_link_service.properties.fqdns
    fqdns.Element = AAZStrType()

    ip_configurations = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations
    ip_configurations.Element = AAZObjectType()

    _element = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations.Element.properties
    properties.primary = AAZBoolType()
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
    )
    properties.private_ip_address_version = AAZStrType(
        serialized_name="privateIPAddressVersion",
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)

    load_balancer_frontend_ip_configurations = _schema_network_interface_read.properties.private_link_service.properties.load_balancer_frontend_ip_configurations
    load_balancer_frontend_ip_configurations.Element = AAZObjectType()
    _build_schema_frontend_ip_configuration_read(load_balancer_frontend_ip_configurations.Element)

    network_interfaces = _schema_network_interface_read.properties.private_link_service.properties.network_interfaces
    network_interfaces.Element = AAZObjectType()
    _build_schema_network_interface_read(network_interfaces.Element)

    private_endpoint_connections = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections
    private_endpoint_connections.Element = AAZObjectType()

    _element = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections.Element.properties
    properties.link_identifier = AAZStrType(
        serialized_name="linkIdentifier",
        flags={"read_only": True},
    )
    properties.private_endpoint = AAZObjectType(
        serialized_name="privateEndpoint",
    )
    _build_schema_private_endpoint_read(properties.private_endpoint)
    properties.private_link_service_connection_state = AAZObjectType(
        serialized_name="privateLinkServiceConnectionState",
    )
    _build_schema_private_link_service_connection_state_read(properties.private_link_service_connection_state)
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    visibility = _schema_network_interface_read.properties.private_link_service.properties.visibility
    visibility.subscriptions = AAZListType()

    subscriptions = _schema_network_interface_read.properties.private_link_service.properties.visibility.subscriptions
    subscriptions.Element = AAZStrType()

    tags = _schema_network_interface_read.properties.private_link_service.tags
    tags.Element = AAZStrType()

    tap_configurations = _schema_network_interface_read.properties.tap_configurations
    tap_configurations.Element = AAZObjectType()
    _build_schema_network_interface_tap_configuration_read(tap_configurations.Element)

    tags = _schema_network_interface_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_network_interface_read.etag
    _schema.extended_location = _schema_network_interface_read.extended_location
    _schema.id = _schema_network_interface_read.id
    _schema.location = _schema_network_interface_read.location
    _schema.name = _schema_network_interface_read.name
    _schema.properties = _schema_network_interface_read.properties
    _schema.tags = _schema_network_interface_read.tags
    _schema.type = _schema_network_interface_read.type


_schema_network_security_group_read = None


def _build_schema_network_security_group_read(_schema):
    global _schema_network_security_group_read
    if _schema_network_security_group_read is not None:
        _schema.etag = _schema_network_security_group_read.etag
        _schema.id = _schema_network_security_group_read.id
        _schema.location = _schema_network_security_group_read.location
        _schema.name = _schema_network_security_group_read.name
        _schema.properties = _schema_network_security_group_read.properties
        _schema.tags = _schema_network_security_group_read.tags
        _schema.type = _schema_network_security_group_read.type
        return

    _schema_network_security_group_read = AAZObjectType()

    network_security_group_read = _schema_network_security_group_read
    network_security_group_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.id = AAZStrType()
    network_security_group_read.location = AAZStrType()
    network_security_group_read.name = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    network_security_group_read.tags = AAZDictType()
    network_security_group_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_security_group_read.properties
    properties.default_security_rules = AAZListType(
        serialized_name="defaultSecurityRules",
        flags={"read_only": True},
    )
    properties.flow_logs = AAZListType(
        serialized_name="flowLogs",
        flags={"read_only": True},
    )
    properties.flush_connection = AAZBoolType(
        serialized_name="flushConnection",
    )
    properties.network_interfaces = AAZListType(
        serialized_name="networkInterfaces",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.security_rules = AAZListType(
        serialized_name="securityRules",
    )
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    default_security_rules = _schema_network_security_group_read.properties.default_security_rules
    default_security_rules.Element = AAZObjectType()
    _build_schema_security_rule_read(default_security_rules.Element)

    flow_logs = _schema_network_security_group_read.properties.flow_logs
    flow_logs.Element = AAZObjectType()

    _element = _schema_network_security_group_read.properties.flow_logs.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.location = AAZStrType()
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.tags = AAZDictType()
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_security_group_read.properties.flow_logs.Element.properties
    properties.enabled = AAZBoolType()
    properties.flow_analytics_configuration = AAZObjectType(
        serialized_name="flowAnalyticsConfiguration",
    )
    properties.format = AAZObjectType()
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.retention_policy = AAZObjectType(
        serialized_name="retentionPolicy",
    )
    properties.storage_id = AAZStrType(
        serialized_name="storageId",
        flags={"required": True},
    )
    properties.target_resource_guid = AAZStrType(
        serialized_name="targetResourceGuid",
        flags={"read_only": True},
    )
    properties.target_resource_id = AAZStrType(
        serialized_name="targetResourceId",
        flags={"required": True},
    )

    flow_analytics_configuration = _schema_network_security_group_read.properties.flow_logs.Element.properties.flow_analytics_configuration
    flow_analytics_configuration.network_watcher_flow_analytics_configuration = AAZObjectType(
        serialized_name="networkWatcherFlowAnalyticsConfiguration",
    )

    network_watcher_flow_analytics_configuration = _schema_network_security_group_read.properties.flow_logs.Element.properties.flow_analytics_configuration.network_watcher_flow_analytics_configuration
    network_watcher_flow_analytics_configuration.enabled = AAZBoolType()
    network_watcher_flow_analytics_configuration.traffic_analytics_interval = AAZIntType(
        serialized_name="trafficAnalyticsInterval",
    )
    network_watcher_flow_analytics_configuration.workspace_id = AAZStrType(
        serialized_name="workspaceId",
    )
    network_watcher_flow_analytics_configuration.workspace_region = AAZStrType(
        serialized_name="workspaceRegion",
    )
    network_watcher_flow_analytics_configuration.workspace_resource_id = AAZStrType(
        serialized_name="workspaceResourceId",
    )

    format = _schema_network_security_group_read.properties.flow_logs.Element.properties.format
    format.type = AAZStrType()
    format.version = AAZIntType()

    retention_policy = _schema_network_security_group_read.properties.flow_logs.Element.properties.retention_policy
    retention_policy.days = AAZIntType()
    retention_policy.enabled = AAZBoolType()

    tags = _schema_network_security_group_read.properties.flow_logs.Element.tags
    tags.Element = AAZStrType()

    network_interfaces = _schema_network_security_group_read.properties.network_interfaces
    network_interfaces.Element = AAZObjectType()
    _build_schema_network_interface_read(network_interfaces.Element)

    security_rules = _schema_network_security_group_read.properties.security_rules
    security_rules.Element = AAZObjectType()
    _build_schema_security_rule_read(security_rules.Element)

    subnets = _schema_network_security_group_read.properties.subnets
    subnets.Element = AAZObjectType()
    _build_schema_subnet_read(subnets.Element)

    tags = _schema_network_security_group_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_network_security_group_read.etag
    _schema.id = _schema_network_security_group_read.id
    _schema.location = _schema_network_security_group_read.location
    _schema.name = _schema_network_security_group_read.name
    _schema.properties = _schema_network_security_group_read.properties
    _schema.tags = _schema_network_security_group_read.tags
    _schema.type = _schema_network_security_group_read.type


_schema_private_endpoint_read = None


def _build_schema_private_endpoint_read(_schema):
    global _schema_private_endpoint_read
    if _schema_private_endpoint_read is not None:
        _schema.etag = _schema_private_endpoint_read.etag
        _schema.extended_location = _schema_private_endpoint_read.extended_location
        _schema.id = _schema_private_endpoint_read.id
        _schema.location = _schema_private_endpoint_read.location
        _schema.name = _schema_private_endpoint_read.name
        _schema.properties = _schema_private_endpoint_read.properties
        _schema.tags = _schema_private_endpoint_read.tags
        _schema.type = _schema_private_endpoint_read.type
        return

    _schema_private_endpoint_read = AAZObjectType()

    private_endpoint_read = _schema_private_endpoint_read
    private_endpoint_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    private_endpoint_read.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
    )
    _build_schema_extended_location_read(private_endpoint_read.extended_location)
    private_endpoint_read.id = AAZStrType()
    private_endpoint_read.location = AAZStrType()
    private_endpoint_read.name = AAZStrType(
        flags={"read_only": True},
    )
    private_endpoint_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    private_endpoint_read.tags = AAZDictType()
    private_endpoint_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_private_endpoint_read.properties
    properties.application_security_groups = AAZListType(
        serialized_name="applicationSecurityGroups",
    )
    properties.custom_dns_configs = AAZListType(
        serialized_name="customDnsConfigs",
    )
    properties.custom_network_interface_name = AAZStrType(
        serialized_name="customNetworkInterfaceName",
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
    )
    properties.manual_private_link_service_connections = AAZListType(
        serialized_name="manualPrivateLinkServiceConnections",
    )
    properties.network_interfaces = AAZListType(
        serialized_name="networkInterfaces",
        flags={"read_only": True},
    )
    properties.private_link_service_connections = AAZListType(
        serialized_name="privateLinkServiceConnections",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)

    application_security_groups = _schema_private_endpoint_read.properties.application_security_groups
    application_security_groups.Element = AAZObjectType()
    _build_schema_application_security_group_read(application_security_groups.Element)

    custom_dns_configs = _schema_private_endpoint_read.properties.custom_dns_configs
    custom_dns_configs.Element = AAZObjectType()

    _element = _schema_private_endpoint_read.properties.custom_dns_configs.Element
    _element.fqdn = AAZStrType()
    _element.ip_addresses = AAZListType(
        serialized_name="ipAddresses",
    )

    ip_addresses = _schema_private_endpoint_read.properties.custom_dns_configs.Element.ip_addresses
    ip_addresses.Element = AAZStrType()

    ip_configurations = _schema_private_endpoint_read.properties.ip_configurations
    ip_configurations.Element = AAZObjectType()

    _element = _schema_private_endpoint_read.properties.ip_configurations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_private_endpoint_read.properties.ip_configurations.Element.properties
    properties.group_id = AAZStrType(
        serialized_name="groupId",
    )
    properties.member_name = AAZStrType(
        serialized_name="memberName",
    )
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
    )

    manual_private_link_service_connections = _schema_private_endpoint_read.properties.manual_private_link_service_connections
    manual_private_link_service_connections.Element = AAZObjectType()
    _build_schema_private_link_service_connection_read(manual_private_link_service_connections.Element)

    network_interfaces = _schema_private_endpoint_read.properties.network_interfaces
    network_interfaces.Element = AAZObjectType()
    _build_schema_network_interface_read(network_interfaces.Element)

    private_link_service_connections = _schema_private_endpoint_read.properties.private_link_service_connections
    private_link_service_connections.Element = AAZObjectType()
    _build_schema_private_link_service_connection_read(private_link_service_connections.Element)

    tags = _schema_private_endpoint_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_private_endpoint_read.etag
    _schema.extended_location = _schema_private_endpoint_read.extended_location
    _schema.id = _schema_private_endpoint_read.id
    _schema.location = _schema_private_endpoint_read.location
    _schema.name = _schema_private_endpoint_read.name
    _schema.properties = _schema_private_endpoint_read.properties
    _schema.tags = _schema_private_endpoint_read.tags
    _schema.type = _schema_private_endpoint_read.type


_schema_private_link_service_connection_state_read = None


def _build_schema_private_link_service_connection_state_read(_schema):
    global _schema_private_link_service_connection_state_read
    if _schema_private_link_service_connection_state_read is not None:
        _schema.actions_required = _schema_private_link_service_connection_state_read.actions_required
        _schema.description = _schema_private_link_service_connection_state_read.description
        _schema.status = _schema_private_link_service_connection_state_read.status
        return

    _schema_private_link_service_connection_state_read = AAZObjectType()

    private_link_service_connection_state_read = _schema_private_link_service_connection_state_read
    private_link_service_connection_state_read.actions_required = AAZStrType(
        serialized_name="actionsRequired",
    )
    private_link_service_connection_state_read.description = AAZStrType()
    private_link_service_connection_state_read.status = AAZStrType()

    _schema.actions_required = _schema_private_link_service_connection_state_read.actions_required
    _schema.description = _schema_private_link_service_connection_state_read.description
    _schema.status = _schema_private_link_service_connection_state_read.status


_schema_private_link_service_connection_read = None


def _build_schema_private_link_service_connection_read(_schema):
    global _schema_private_link_service_connection_read
    if _schema_private_link_service_connection_read is not None:
        _schema.etag = _schema_private_link_service_connection_read.etag
        _schema.id = _schema_private_link_service_connection_read.id
        _schema.name = _schema_private_link_service_connection_read.name
        _schema.properties = _schema_private_link_service_connection_read.properties
        _schema.type = _schema_private_link_service_connection_read.type
        return

    _schema_private_link_service_connection_read = AAZObjectType()

    private_link_service_connection_read = _schema_private_link_service_connection_read
    private_link_service_connection_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service_connection_read.id = AAZStrType()
    private_link_service_connection_read.name = AAZStrType()
    private_link_service_connection_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    private_link_service_connection_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_private_link_service_connection_read.properties
    properties.group_ids = AAZListType(
        serialized_name="groupIds",
    )
    properties.private_link_service_connection_state = AAZObjectType(
        serialized_name="privateLinkServiceConnectionState",
    )
    _build_schema_private_link_service_connection_state_read(properties.private_link_service_connection_state)
    properties.private_link_service_id = AAZStrType(
        serialized_name="privateLinkServiceId",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.request_message = AAZStrType(
        serialized_name="requestMessage",
    )

    group_ids = _schema_private_link_service_connection_read.properties.group_ids
    group_ids.Element = AAZStrType()

    _schema.etag = _schema_private_link_service_connection_read.etag
    _schema.id = _schema_private_link_service_connection_read.id
    _schema.name = _schema_private_link_service_connection_read.name
    _schema.properties = _schema_private_link_service_connection_read.properties
    _schema.type = _schema_private_link_service_connection_read.type


_schema_public_ip_address_read = None


def _build_schema_public_ip_address_read(_schema):
    global _schema_public_ip_address_read
    if _schema_public_ip_address_read is not None:
        _schema.etag = _schema_public_ip_address_read.etag
        _schema.extended_location = _schema_public_ip_address_read.extended_location
        _schema.id = _schema_public_ip_address_read.id
        _schema.location = _schema_public_ip_address_read.location
        _schema.name = _schema_public_ip_address_read.name
        _schema.properties = _schema_public_ip_address_read.properties
        _schema.sku = _schema_public_ip_address_read.sku
        _schema.tags = _schema_public_ip_address_read.tags
        _schema.type = _schema_public_ip_address_read.type
        _schema.zones = _schema_public_ip_address_read.zones
        return

    _schema_public_ip_address_read = AAZObjectType()

    public_ip_address_read = _schema_public_ip_address_read
    public_ip_address_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
    )
    _build_schema_extended_location_read(public_ip_address_read.extended_location)
    public_ip_address_read.id = AAZStrType()
    public_ip_address_read.location = AAZStrType()
    public_ip_address_read.name = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    public_ip_address_read.sku = AAZObjectType()
    public_ip_address_read.tags = AAZDictType()
    public_ip_address_read.type = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.zones = AAZListType()

    properties = _schema_public_ip_address_read.properties
    properties.ddos_settings = AAZObjectType(
        serialized_name="ddosSettings",
    )
    properties.delete_option = AAZStrType(
        serialized_name="deleteOption",
    )
    properties.dns_settings = AAZObjectType(
        serialized_name="dnsSettings",
    )
    properties.idle_timeout_in_minutes = AAZIntType(
        serialized_name="idleTimeoutInMinutes",
    )
    properties.ip_address = AAZStrType(
        serialized_name="ipAddress",
    )
    properties.ip_configuration = AAZObjectType(
        serialized_name="ipConfiguration",
    )
    _build_schema_ip_configuration_read(properties.ip_configuration)
    properties.ip_tags = AAZListType(
        serialized_name="ipTags",
    )
    properties.linked_public_ip_address = AAZObjectType(
        serialized_name="linkedPublicIPAddress",
    )
    _build_schema_public_ip_address_read(properties.linked_public_ip_address)
    properties.migration_phase = AAZStrType(
        serialized_name="migrationPhase",
    )
    properties.nat_gateway = AAZObjectType(
        serialized_name="natGateway",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address_version = AAZStrType(
        serialized_name="publicIPAddressVersion",
    )
    properties.public_ip_allocation_method = AAZStrType(
        serialized_name="publicIPAllocationMethod",
    )
    properties.public_ip_prefix = AAZObjectType(
        serialized_name="publicIPPrefix",
    )
    _build_schema_sub_resource_read(properties.public_ip_prefix)
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.service_public_ip_address = AAZObjectType(
        serialized_name="servicePublicIPAddress",
    )
    _build_schema_public_ip_address_read(properties.service_public_ip_address)

    ddos_settings = _schema_public_ip_address_read.properties.ddos_settings
    ddos_settings.ddos_protection_plan = AAZObjectType(
        serialized_name="ddosProtectionPlan",
    )
    _build_schema_sub_resource_read(ddos_settings.ddos_protection_plan)
    ddos_settings.protection_mode = AAZStrType(
        serialized_name="protectionMode",
    )

    dns_settings = _schema_public_ip_address_read.properties.dns_settings
    dns_settings.domain_name_label = AAZStrType(
        serialized_name="domainNameLabel",
    )
    dns_settings.fqdn = AAZStrType()
    dns_settings.reverse_fqdn = AAZStrType(
        serialized_name="reverseFqdn",
    )

    ip_tags = _schema_public_ip_address_read.properties.ip_tags
    ip_tags.Element = AAZObjectType()

    _element = _schema_public_ip_address_read.properties.ip_tags.Element
    _element.ip_tag_type = AAZStrType(
        serialized_name="ipTagType",
    )
    _element.tag = AAZStrType()

    nat_gateway = _schema_public_ip_address_read.properties.nat_gateway
    nat_gateway.etag = AAZStrType(
        flags={"read_only": True},
    )
    nat_gateway.id = AAZStrType()
    nat_gateway.location = AAZStrType()
    nat_gateway.name = AAZStrType(
        flags={"read_only": True},
    )
    nat_gateway.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    nat_gateway.sku = AAZObjectType()
    nat_gateway.tags = AAZDictType()
    nat_gateway.type = AAZStrType(
        flags={"read_only": True},
    )
    nat_gateway.zones = AAZListType()

    properties = _schema_public_ip_address_read.properties.nat_gateway.properties
    properties.idle_timeout_in_minutes = AAZIntType(
        serialized_name="idleTimeoutInMinutes",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_addresses = AAZListType(
        serialized_name="publicIpAddresses",
    )
    properties.public_ip_prefixes = AAZListType(
        serialized_name="publicIpPrefixes",
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    public_ip_addresses = _schema_public_ip_address_read.properties.nat_gateway.properties.public_ip_addresses
    public_ip_addresses.Element = AAZObjectType()
    _build_schema_sub_resource_read(public_ip_addresses.Element)

    public_ip_prefixes = _schema_public_ip_address_read.properties.nat_gateway.properties.public_ip_prefixes
    public_ip_prefixes.Element = AAZObjectType()
    _build_schema_sub_resource_read(public_ip_prefixes.Element)

    subnets = _schema_public_ip_address_read.properties.nat_gateway.properties.subnets
    subnets.Element = AAZObjectType()
    _build_schema_sub_resource_read(subnets.Element)

    sku = _schema_public_ip_address_read.properties.nat_gateway.sku
    sku.name = AAZStrType()

    tags = _schema_public_ip_address_read.properties.nat_gateway.tags
    tags.Element = AAZStrType()

    zones = _schema_public_ip_address_read.properties.nat_gateway.zones
    zones.Element = AAZStrType()

    sku = _schema_public_ip_address_read.sku
    sku.name = AAZStrType()
    sku.tier = AAZStrType()

    tags = _schema_public_ip_address_read.tags
    tags.Element = AAZStrType()

    zones = _schema_public_ip_address_read.zones
    zones.Element = AAZStrType()

    _schema.etag = _schema_public_ip_address_read.etag
    _schema.extended_location = _schema_public_ip_address_read.extended_location
    _schema.id = _schema_public_ip_address_read.id
    _schema.location = _schema_public_ip_address_read.location
    _schema.name = _schema_public_ip_address_read.name
    _schema.properties = _schema_public_ip_address_read.properties
    _schema.sku = _schema_public_ip_address_read.sku
    _schema.tags = _schema_public_ip_address_read.tags
    _schema.type = _schema_public_ip_address_read.type
    _schema.zones = _schema_public_ip_address_read.zones


_schema_security_rule_read = None


def _build_schema_security_rule_read(_schema):
    global _schema_security_rule_read
    if _schema_security_rule_read is not None:
        _schema.etag = _schema_security_rule_read.etag
        _schema.id = _schema_security_rule_read.id
        _schema.name = _schema_security_rule_read.name
        _schema.properties = _schema_security_rule_read.properties
        _schema.type = _schema_security_rule_read.type
        return

    _schema_security_rule_read = AAZObjectType()

    security_rule_read = _schema_security_rule_read
    security_rule_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    security_rule_read.id = AAZStrType()
    security_rule_read.name = AAZStrType()
    security_rule_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    security_rule_read.type = AAZStrType()

    properties = _schema_security_rule_read.properties
    properties.access = AAZStrType(
        flags={"required": True},
    )
    properties.description = AAZStrType()
    properties.destination_address_prefix = AAZStrType(
        serialized_name="destinationAddressPrefix",
    )
    properties.destination_address_prefixes = AAZListType(
        serialized_name="destinationAddressPrefixes",
    )
    properties.destination_application_security_groups = AAZListType(
        serialized_name="destinationApplicationSecurityGroups",
    )
    properties.destination_port_range = AAZStrType(
        serialized_name="destinationPortRange",
    )
    properties.destination_port_ranges = AAZListType(
        serialized_name="destinationPortRanges",
    )
    properties.direction = AAZStrType(
        flags={"required": True},
    )
    properties.priority = AAZIntType()
    properties.protocol = AAZStrType(
        flags={"required": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.source_address_prefix = AAZStrType(
        serialized_name="sourceAddressPrefix",
    )
    properties.source_address_prefixes = AAZListType(
        serialized_name="sourceAddressPrefixes",
    )
    properties.source_application_security_groups = AAZListType(
        serialized_name="sourceApplicationSecurityGroups",
    )
    properties.source_port_range = AAZStrType(
        serialized_name="sourcePortRange",
    )
    properties.source_port_ranges = AAZListType(
        serialized_name="sourcePortRanges",
    )

    destination_address_prefixes = _schema_security_rule_read.properties.destination_address_prefixes
    destination_address_prefixes.Element = AAZStrType()

    destination_application_security_groups = _schema_security_rule_read.properties.destination_application_security_groups
    destination_application_security_groups.Element = AAZObjectType()
    _build_schema_application_security_group_read(destination_application_security_groups.Element)

    destination_port_ranges = _schema_security_rule_read.properties.destination_port_ranges
    destination_port_ranges.Element = AAZStrType()

    source_address_prefixes = _schema_security_rule_read.properties.source_address_prefixes
    source_address_prefixes.Element = AAZStrType()

    source_application_security_groups = _schema_security_rule_read.properties.source_application_security_groups
    source_application_security_groups.Element = AAZObjectType()
    _build_schema_application_security_group_read(source_application_security_groups.Element)

    source_port_ranges = _schema_security_rule_read.properties.source_port_ranges
    source_port_ranges.Element = AAZStrType()

    _schema.etag = _schema_security_rule_read.etag
    _schema.id = _schema_security_rule_read.id
    _schema.name = _schema_security_rule_read.name
    _schema.properties = _schema_security_rule_read.properties
    _schema.type = _schema_security_rule_read.type


_schema_sub_resource_read = None


def _build_schema_sub_resource_read(_schema):
    global _schema_sub_resource_read
    if _schema_sub_resource_read is not None:
        _schema.id = _schema_sub_resource_read.id
        return

    _schema_sub_resource_read = AAZObjectType()

    sub_resource_read = _schema_sub_resource_read
    sub_resource_read.id = AAZStrType()

    _schema.id = _schema_sub_resource_read.id


_schema_subnet_read = None


def _build_schema_subnet_read(_schema):
    global _schema_subnet_read
    if _schema_subnet_read is not None:
        _schema.etag = _schema_subnet_read.etag
        _schema.id = _schema_subnet_read.id
        _schema.name = _schema_subnet_read.name
        _schema.properties = _schema_subnet_read.properties
        _schema.type = _schema_subnet_read.type
        return

    _schema_subnet_read = AAZObjectType()

    subnet_read = _schema_subnet_read
    subnet_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    subnet_read.id = AAZStrType()
    subnet_read.name = AAZStrType()
    subnet_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    subnet_read.type = AAZStrType()

    properties = _schema_subnet_read.properties
    properties.address_prefix = AAZStrType(
        serialized_name="addressPrefix",
    )
    properties.address_prefixes = AAZListType(
        serialized_name="addressPrefixes",
    )
    properties.application_gateway_ip_configurations = AAZListType(
        serialized_name="applicationGatewayIpConfigurations",
    )
    properties.delegations = AAZListType()
    properties.ip_allocations = AAZListType(
        serialized_name="ipAllocations",
    )
    properties.ip_configuration_profiles = AAZListType(
        serialized_name="ipConfigurationProfiles",
        flags={"read_only": True},
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
        flags={"read_only": True},
    )
    properties.nat_gateway = AAZObjectType(
        serialized_name="natGateway",
    )
    _build_schema_sub_resource_read(properties.nat_gateway)
    properties.network_security_group = AAZObjectType(
        serialized_name="networkSecurityGroup",
    )
    _build_schema_network_security_group_read(properties.network_security_group)
    properties.private_endpoint_network_policies = AAZStrType(
        serialized_name="privateEndpointNetworkPolicies",
    )
    properties.private_endpoints = AAZListType(
        serialized_name="privateEndpoints",
        flags={"read_only": True},
    )
    properties.private_link_service_network_policies = AAZStrType(
        serialized_name="privateLinkServiceNetworkPolicies",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.purpose = AAZStrType(
        flags={"read_only": True},
    )
    properties.resource_navigation_links = AAZListType(
        serialized_name="resourceNavigationLinks",
        flags={"read_only": True},
    )
    properties.route_table = AAZObjectType(
        serialized_name="routeTable",
    )
    properties.service_association_links = AAZListType(
        serialized_name="serviceAssociationLinks",
        flags={"read_only": True},
    )
    properties.service_endpoint_policies = AAZListType(
        serialized_name="serviceEndpointPolicies",
    )
    properties.service_endpoints = AAZListType(
        serialized_name="serviceEndpoints",
    )

    address_prefixes = _schema_subnet_read.properties.address_prefixes
    address_prefixes.Element = AAZStrType()

    application_gateway_ip_configurations = _schema_subnet_read.properties.application_gateway_ip_configurations
    application_gateway_ip_configurations.Element = AAZObjectType()
    _build_schema_application_gateway_ip_configuration_read(application_gateway_ip_configurations.Element)

    delegations = _schema_subnet_read.properties.delegations
    delegations.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.delegations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType()

    properties = _schema_subnet_read.properties.delegations.Element.properties
    properties.actions = AAZListType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.service_name = AAZStrType(
        serialized_name="serviceName",
    )

    actions = _schema_subnet_read.properties.delegations.Element.properties.actions
    actions.Element = AAZStrType()

    ip_allocations = _schema_subnet_read.properties.ip_allocations
    ip_allocations.Element = AAZObjectType()
    _build_schema_sub_resource_read(ip_allocations.Element)

    ip_configuration_profiles = _schema_subnet_read.properties.ip_configuration_profiles
    ip_configuration_profiles.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.ip_configuration_profiles.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.ip_configuration_profiles.Element.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)

    ip_configurations = _schema_subnet_read.properties.ip_configurations
    ip_configurations.Element = AAZObjectType()
    _build_schema_ip_configuration_read(ip_configurations.Element)

    private_endpoints = _schema_subnet_read.properties.private_endpoints
    private_endpoints.Element = AAZObjectType()
    _build_schema_private_endpoint_read(private_endpoints.Element)

    resource_navigation_links = _schema_subnet_read.properties.resource_navigation_links
    resource_navigation_links.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.resource_navigation_links.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.resource_navigation_links.Element.properties
    properties.link = AAZStrType()
    properties.linked_resource_type = AAZStrType(
        serialized_name="linkedResourceType",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    route_table = _schema_subnet_read.properties.route_table
    route_table.etag = AAZStrType(
        flags={"read_only": True},
    )
    route_table.id = AAZStrType()
    route_table.location = AAZStrType()
    route_table.name = AAZStrType(
        flags={"read_only": True},
    )
    route_table.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    route_table.tags = AAZDictType()
    route_table.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.route_table.properties
    properties.disable_bgp_route_propagation = AAZBoolType(
        serialized_name="disableBgpRoutePropagation",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.routes = AAZListType()
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    routes = _schema_subnet_read.properties.route_table.properties.routes
    routes.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.route_table.properties.routes.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType()

    properties = _schema_subnet_read.properties.route_table.properties.routes.Element.properties
    properties.address_prefix = AAZStrType(
        serialized_name="addressPrefix",
    )
    properties.has_bgp_override = AAZBoolType(
        serialized_name="hasBgpOverride",
    )
    properties.next_hop_ip_address = AAZStrType(
        serialized_name="nextHopIpAddress",
    )
    properties.next_hop_type = AAZStrType(
        serialized_name="nextHopType",
        flags={"required": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    subnets = _schema_subnet_read.properties.route_table.properties.subnets
    subnets.Element = AAZObjectType()
    _build_schema_subnet_read(subnets.Element)

    tags = _schema_subnet_read.properties.route_table.tags
    tags.Element = AAZStrType()

    service_association_links = _schema_subnet_read.properties.service_association_links
    service_association_links.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.service_association_links.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.service_association_links.Element.properties
    properties.allow_delete = AAZBoolType(
        serialized_name="allowDelete",
    )
    properties.link = AAZStrType()
    properties.linked_resource_type = AAZStrType(
        serialized_name="linkedResourceType",
    )
    properties.locations = AAZListType()
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    locations = _schema_subnet_read.properties.service_association_links.Element.properties.locations
    locations.Element = AAZStrType()

    service_endpoint_policies = _schema_subnet_read.properties.service_endpoint_policies
    service_endpoint_policies.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.service_endpoint_policies.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.kind = AAZStrType(
        flags={"read_only": True},
    )
    _element.location = AAZStrType()
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.tags = AAZDictType()
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties
    properties.contextual_service_endpoint_policies = AAZListType(
        serialized_name="contextualServiceEndpointPolicies",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.service_alias = AAZStrType(
        serialized_name="serviceAlias",
    )
    properties.service_endpoint_policy_definitions = AAZListType(
        serialized_name="serviceEndpointPolicyDefinitions",
    )
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    contextual_service_endpoint_policies = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.contextual_service_endpoint_policies
    contextual_service_endpoint_policies.Element = AAZStrType()

    service_endpoint_policy_definitions = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions
    service_endpoint_policy_definitions.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType()

    properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties
    properties.description = AAZStrType()
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.service = AAZStrType()
    properties.service_resources = AAZListType(
        serialized_name="serviceResources",
    )

    service_resources = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties.service_resources
    service_resources.Element = AAZStrType()

    subnets = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.subnets
    subnets.Element = AAZObjectType()
    _build_schema_subnet_read(subnets.Element)

    tags = _schema_subnet_read.properties.service_endpoint_policies.Element.tags
    tags.Element = AAZStrType()

    service_endpoints = _schema_subnet_read.properties.service_endpoints
    service_endpoints.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.service_endpoints.Element
    _element.locations = AAZListType()
    _element.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    _element.service = AAZStrType()

    locations = _schema_subnet_read.properties.service_endpoints.Element.locations
    locations.Element = AAZStrType()

    _schema.etag = _schema_subnet_read.etag
    _schema.id = _schema_subnet_read.id
    _schema.name = _schema_subnet_read.name
    _schema.properties = _schema_subnet_read.properties
    _schema.type = _schema_subnet_read.type


_schema_virtual_network_tap_read = None


def _build_schema_virtual_network_tap_read(_schema):
    global _schema_virtual_network_tap_read
    if _schema_virtual_network_tap_read is not None:
        _schema.etag = _schema_virtual_network_tap_read.etag
        _schema.id = _schema_virtual_network_tap_read.id
        _schema.location = _schema_virtual_network_tap_read.location
        _schema.name = _schema_virtual_network_tap_read.name
        _schema.properties = _schema_virtual_network_tap_read.properties
        _schema.tags = _schema_virtual_network_tap_read.tags
        _schema.type = _schema_virtual_network_tap_read.type
        return

    _schema_virtual_network_tap_read = AAZObjectType()

    virtual_network_tap_read = _schema_virtual_network_tap_read
    virtual_network_tap_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    virtual_network_tap_read.id = AAZStrType()
    virtual_network_tap_read.location = AAZStrType()
    virtual_network_tap_read.name = AAZStrType(
        flags={"read_only": True},
    )
    virtual_network_tap_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    virtual_network_tap_read.tags = AAZDictType()
    virtual_network_tap_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_virtual_network_tap_read.properties
    properties.destination_load_balancer_front_end_ip_configuration = AAZObjectType(
        serialized_name="destinationLoadBalancerFrontEndIPConfiguration",
    )
    _build_schema_frontend_ip_configuration_read(properties.destination_load_balancer_front_end_ip_configuration)
    properties.destination_network_interface_ip_configuration = AAZObjectType(
        serialized_name="destinationNetworkInterfaceIPConfiguration",
    )
    _build_schema_network_interface_ip_configuration_read(properties.destination_network_interface_ip_configuration)
    properties.destination_port = AAZIntType(
        serialized_name="destinationPort",
    )
    properties.network_interface_tap_configurations = AAZListType(
        serialized_name="networkInterfaceTapConfigurations",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )

    network_interface_tap_configurations = _schema_virtual_network_tap_read.properties.network_interface_tap_configurations
    network_interface_tap_configurations.Element = AAZObjectType()
    _build_schema_network_interface_tap_configuration_read(network_interface_tap_configurations.Element)

    tags = _schema_virtual_network_tap_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_virtual_network_tap_read.etag
    _schema.id = _schema_virtual_network_tap_read.id
    _schema.location = _schema_virtual_network_tap_read.location
    _schema.name = _schema_virtual_network_tap_read.name
    _schema.properties = _schema_virtual_network_tap_read.properties
    _schema.tags = _schema_virtual_network_tap_read.tags
    _schema.type = _schema_virtual_network_tap_read.type


__all__ = ["Create"]
