/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
/*
 * SocketTest.java
 *
 * Created on 29 October 2002, 16:03
 */

package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 *
 * @author  hamish
 */
public class QueryTest {
    
    /** Creates a new instance of SocketTest */
    public QueryTest() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws java.lang.Exception {

        //listAll();
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterExecuting   = 9999L;
        long tClosedConnection = 9999L;
        
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;

        try {
            echoSocket = new Socket("localhost", 22222);
            //echoSocket = new Socket("democritus.servers.catalyst.net.nz", 22223);
            //echoSocket = new Socket("192.168.4.20", 22223);
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(
                                        echoSocket.getInputStream()));
        } catch (UnknownHostException e) {
            System.err.println("Don't know about host: localhost.");
            System.exit(1);
        } catch (IOException e) {
            System.err.println("Couldn't get I/O for "
                               + "the connection to: localhost.");
            System.exit(1);
        }

        tOpenedConnection = System.currentTimeMillis();
        
//        String query = "QUERY\n" +
//                         "Application: sos\n" +
//                         "Query: Details:egypt\n" +
//                         "Query: Name:mouse\n" +
//                         "Return: Id Name\n" +
//                         "Query: Location:10 13\n" +
//                         "Range-Field: DisplayStartDate\nRange-From: 2002-01-01\nRange-To: 2002-03-01\nQuery: Cancelled:N\n" +
//                         //"Sort: SaleStartDate Name RANK\n" +
//                         "Limit: 5\n" +
//                         "END\n";

        
          String [] queries = {
              
//               "QUERY\nApplication: sos\nDefault-Field: Text\nRange-Field: DisplayStartDate\nRange-From: 1990/01/01\nRange-To: 1037234637\nRange-Field: EndDate\nRange-From: 1037234637\nRange-To: 2100/12/31\nReturn: Id Name\n" +
//                        "Query: (Name:goo*^2 Name:plan*^2 Teaser:goo* Teaser:plan* Details:goo* Details:plan*) AND NOT (Cancel:Y)\nLimit: 5\nEND",
//               "QUERY\nApplication: sos\nDefault-Field: Text\nRange-Field: DisplayStartDate\nRange-From: 1990/01/01\nRange-To: 1037234637\nRange-Field: EndDate\nRange-From: 1037234637\nRange-To: 2100/12/31\nReturn: Id Name\n" +                "Query: (Name:(goo*^2 OR plan*^2) Teaser:(goo* OR plan*) Details:(goo* OR plan*)) AND NOT (Cancel:Y)\nLimit: 5\nEND",



            // ~0 results
              "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2003-10-10\nQuery: (Name:super) OR (Teaser:super) OR (Details:super) AND (Cancelled:N)\nLimit: 5\nEND",
            // ~ 100 results
          //    "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-15\nRange-To: 2002-02-02\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",  
            // ~ 100 results (WITH SORT)
        //      "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-15\nRange-To: 2002-02-02\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nSort: Name\nLimit: 5\nEND",  
            // ~ 1000 results  
//            "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) AND (Teaser:free) OR (Details:(pharoah AND egypt AND river))) AND Cancelled:N\nLimit: 5\nEND",
            // ~ 1000 results  (WITH SORT)
  //          "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) AND (Teaser:free) OR (Details:(pharoah AND egypt AND river))) AND Cancelled:N\nSort: Name\nLimit: 5\nEND",
            // ~ 10000 results
    //        "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-06-10\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",
            // ~ 20000 results
      //      "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",
            // all results
            "QUERY\nApplication: sos\nQuery: \nQuery: Domain:sos\nLimit: 5\nEND"
            
          };
        for (int i = 0; i < queries.length; ++i) {
            System.out.println("================= QUERY (" + i + ") ==================================");
            System.out.println(queries[i]);
            doCount(queries[i], out, in);
            
            System.out.print("Timings: ");
            long total = 0L;
            for (int j = 0; j < 10; ++j) {
                long time = doQuery(queries[i], out, in);
                System.out.print("\t" + time + "ms");
                total += time;
            }
            System.out.println("");
            System.out.println("Average time: " + (total/10) + "ms");
        }
        
        tAfterExecuting = System.currentTimeMillis();
        
	out.close();
	in.close();
        
	echoSocket.close();
        
        tClosedConnection = System.currentTimeMillis();
        
        System.out.println("program has completed successfully");
        System.out.println("================= Time Statistics =================");
        System.out.println(" Opening Connection: " + (tOpenedConnection - tStart));
        System.out.println(" Executing:          " + (tAfterExecuting - tOpenedConnection));
        System.out.println(" Closing Connection: " + (tClosedConnection - tAfterExecuting));
        System.out.println("===================================================");
        
    }


    static long doQuery(String command, PrintWriter out, BufferedReader in) throws Exception {
        long tBefore = System.currentTimeMillis();
        out.println(command);
        String serverOutput;
        java.io.BufferedReader br = new java.io.BufferedReader(in);
        //while ( (serverOutput = br.readLine()) != null ) {
        while ( ((serverOutput = br.readLine()) != null && !serverOutput.startsWith("END"))  ) {            
            //System.out.println("from server: " + serverOutput);
        }
        long tAfter = System.currentTimeMillis();
        return tAfter - tBefore;
    }
    
    static void doCount(String command, PrintWriter out, BufferedReader in) throws Exception {
        long tBefore = System.currentTimeMillis();
        out.println(command);
        String serverOutput;
        java.io.BufferedReader br = new java.io.BufferedReader(in);
        while ( ((serverOutput = br.readLine()) != null && !serverOutput.startsWith("END"))  ) {            
            if (serverOutput.startsWith("Count:")) {
               System.out.println("Total Result " + serverOutput);
            }
        }
    }

    
}
