/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
/*
 * NewsQuestTest.java
 *
 * Created on 24 November 2002, 16:03
 */

package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 * This class is for testing NewsQuest functionality.
 *
 * Its search functions are more complex than Stuff On Sale see commented query
 * string definition below for more information and caveats.
 *
 * @author  hamish carpenter
 */
public class NewsQuestTest {
    
    /** Creates a new instance of NewsQuestTest */
    public NewsQuestTest() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws java.lang.Exception {

        //listAll();
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterExecuting   = 9999L;
        long tClosedConnection = 9999L;
        
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;

		System.out.println("About to start program...");
		System.err.println("About to start program...");
		
        try {
            //echoSocket = new Socket("localhost", 22222);
            //echoSocket = new Socket("democritus.servers.catalyst.net.nz", 22223);
            //echoSocket = new Socket("192.168.4.20", 22225); //NewsQuest server
        	echoSocket = new Socket("192.168.4.20", 22224); //democritus dev server
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(
                                        echoSocket.getInputStream()));
        } catch (UnknownHostException e) {
            System.err.println("Cannot resolve host.");
            System.exit(1);
        } catch (IOException e) {
            System.err.println("Connection refused.");
            System.exit(1);
        }

        tOpenedConnection = System.currentTimeMillis();
        
        String unindex = "UNINDEX\n" + 
                        "Application: nqst\n" +
                        "Id: 2\n" +
                        "END\n";
        //THIS WILL REMOVE ALL DOCUMENTS FOR THE NEWSQUEST APPLICATION
        String purge = "UNINDEX\n" + 
                        "Application: nqst\n" +
                        "Purge: true\n" +
                        "END\n";
        String optimize = "CONTROL\n" + "Sub-Command: OPTIMIZE\n" + "Application: nqst\n" + "END\n";        

        String query_count = "QUERY\n" + "Application: nqst\n" +  //THIS NEEDS TO SPECIFIED SO THE ALTERNATIVE DIRECTORY IS USED.
                         "Query: \n" + "Query: Domain:nqst\n" + "Limit: 0\nEND\n";
        String index_single = "INDEX\n" +
                              "Application: nqst\n" + //CASE SENSITIVE (same as filename newsquest.properties!)
                              "Id: 1\n" +
                              "Title: This is the first story\n" +
                              "StoryType: article\n" + //choose from: article, table or othertype
                              "Category: general\n" +  //choose from: general, sport, finance, mags etc...
                              "SubCategory: budget\n" + //varies on category above
                              "Source: nzbizmag\n" +   //nzbizmag, nzpa, othersrc
                              "Precis: blah blah blah this is the introduction i think\n" +
                              "Published: 2002-11-23\n" + //YYYY-MM-DD
                              "END\n";
        String index01 = "INDEX\nApplication: nqst\nId: 2\nStoryType: article\nCategory: general\nSubCategory: budget\nSource: nzpa\n" +
                              "Title: NewsQuest Archive Reaches Two Stories!\nPrecis: This is the second story to grace newsquest's lucene index.\n" +
                              "Published: 2002-11-24\nEND\n";
        String index02 = "INDEX\nApplication: nqst\nId: 3\nStoryType: table\nCategory: general\nSubCategory: computer\nSource: nzpa\n" +
                              "Title: This is a table document\nPrecis: I'm not exactly sure what a table is but this is an old table entry.\n" +
                              "Published: 2002-09-24\nEND\n";
        
        String query = "QUERY\n" +
                         "Application: nqst\n" +
    					 //"Query: category:sport\n" +
//				    	"Field-Name: date\n" +
///				    	"Field-Type: Date\n" +
	//			    	"Field-Indexed: Yes\n" +
	//			    	"Field-Stored: No\n" +
				    	// "Range-Field: date\n" +
  					 	// "Range-From: 2002-01-16\n" +
    					//"Range-To: 2003-01-16\n" +
                         //"Limit: 1000000\n" +
    //	"Query:  NOT (source:irn OR source:admediaf OR source:nzfimag OR source:onfilm) +Id:323664" +
    //uery: +slug:shuttle" +
    					//"Query:  NOT (source:irn OR source:admediaf OR source:nzfimag OR source:onfilm) AND (type:article) AND (Id:323664)" + //original
    	"Query:  NOT (source:irn OR source:admediaf OR source:nzfimag OR source:onfilm) AND (slug:peru) AND (type:article) AND (Id:323768)" + //original
    	
    					
                         "\n" +
                         "Return: type slug date\n" +
    					"Limit: 1\n" +
                         //"Sort: date:dsc\n"+ //Newest documents first (adds performance AND memory overhead).
    					//"Sort: Id:dsc\n"+
                         "END\n";

		String query_nqst2 = "QUERY\n" +
			"Application: nqst\n" +
			"Default-Field: Text\n" +
			"Field-Name: date\n" +
			"Field-Type: Date\n" +
			"Field-Indexed: Yes\n" +
			"Field-Stored: No\n" +
	    	"Field-Name: Text\n" +
	    	"Field-Type: Text\n" +
	    	"Field-Indexed: Yes\n" +
	    	"Field-Stored: No\n" +
	    	"Field-Name: category\n" +
	    	"Field-Type: Text\n" +
	    	"Field-Indexed: Yes\n" +
	    	"Field-Stored: No\n" +
			//"Sort: RANK:a\n" +
    		//"Sort: Id:a\n" +
			"Query: (category:intl) AND (snow)\n" +
			"Limit: 5000000\n" +
			"Range-Field: date\n" +
			"Range-From: 1039357439\n" +
			"END\n";

		String query_nqst = "QUERY\n" +
			"Application: nqst\n" +
			"Default-Field: Text\n" +
//			"Range-Field: Id\n" +
//			"Range-From: 295533\n" +
			//"Range-To: 999999999\n" +
			//"Sort: date:Desc\n" +
			"Query: NOT (category:summ) AND NOT (source:marktmag OR source:managmag OR " +
			"source:nzbizmag OR source:admedia) AND type:article AND (\"crown forestry " +
			"rental trust\")" +
//			"+Id:[295533 TO null]" +
//    		"+Id:[5-null]" +
			"\n" +
			"Limit: 20\n" +
			"END\n";
        String command = query;
                         //index_single;
       
	//send command to server.
        out.println(command);
                
        String serverOutput;
        java.io.BufferedReader br = new java.io.BufferedReader(in);
        while ( ((serverOutput = br.readLine()) != null && !serverOutput.startsWith("END"))  ) {          
            System.out.println(serverOutput);
        }
        if (serverOutput != null) System.out.println(serverOutput);
        	
        tAfterExecuting = System.currentTimeMillis();
        
	out.close();
        br.close();
	in.close();
	echoSocket.close();
        
        tClosedConnection = System.currentTimeMillis();
        
        System.out.println("program has completed successfully");
        System.out.println("================= Time Statistics =================");
        System.out.println(" Opening Connection: " + (tOpenedConnection - tStart));
        System.out.println(" Executing:          " + (tAfterExecuting - tOpenedConnection));
        System.out.println(" Closing Connection: " + (tClosedConnection - tAfterExecuting));
        System.out.println("===================================================");
        
    }

}
