/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;
import org.apache.lucene.document.Field;

/**
 * Lucene Field attributes.
 * 
 * The default settings for a field are:<br>
 * not stored<br>
 * indexed <br>
 * tokenised by whitespace <br>
 * not a date field <br>
 */

class FieldDef implements Cloneable, Constants
{
  final String name;
  Field.Store stored = Field.Store.YES;
  Field.Index indexed = Field.Index.TOKENIZED;
  boolean date = false;

  /**
   * Define a Field with default attributes.  The Id and Domain fields
   * have special characteristics.
   */

  FieldDef(String name)
  {
    this.name = name;
    if (name.equals(ID)) {
      stored = Field.Store.YES;
      indexed = Field.Index.UN_TOKENIZED;
    }
    else if (name.equals(DOMAIN)) {
      stored = Field.Store.YES;
      indexed = Field.Index.UN_TOKENIZED;
    }
  }
  
  public void defineStored(boolean is_stored) {
      if (is_stored) {
          stored = Field.Store.YES;
      }
      else {
          stored = Field.Store.NO;
      }
  }
  public void defineIndexed(boolean is_indexed) {
      if (is_indexed) {
          indexed = Field.Index.TOKENIZED;
      }
      else {
          indexed = Field.Index.NO;
      }
  }
  public void defineTokenized(boolean is_tokenized) {
      if (is_tokenized) {
          indexed = Field.Index.TOKENIZED;
      }
      else {
          indexed = Field.Index.UN_TOKENIZED;
      }
  }
  
  public void defineAsDate() {
      date = true;
      if (indexed != Field.Index.NO) {
          indexed = Field.Index.UN_TOKENIZED;
      }
  }
  
  public boolean equals(Object o)
  {
    if (this == o)
      return true;

    if (!(o instanceof FieldDef))
      return false;

    FieldDef that = (FieldDef)o;
    return this.name.equals(that.name);
  }

  public FieldDef copy()
  {
    try
    {
      return (FieldDef) clone();
    }
    catch (CloneNotSupportedException e)
    {
      // Can't happen
      return null;
    }
  }
}
