<!-- Untested and unsupported php lucene page

	PHP support for the luceneserver is now done 
	through the axyl library.
	-->
<html><body>

<?php


class Lucene
{

    var $host;
    var $port;
    var $fieldData;
    var $sd;
    var $error;

    function addField($name, $value)
    {
        $this->fieldData[$name] = $value;
    }

    function sendCommand($command)
    {
        $errno = 0;
        $errstr = "";
        $this->sd = fsockopen($this->host, $this->port, $errno, $errstr, 5);
        if ($this->sd === FALSE)
        {
            echo "$errno: $errstr";
            return "$errno: $errstr";
        }
        if (-1 == fwrite ($this->sd, "$command\n"))
        {
           echo "Error writing header\n";
           return;
        }

        foreach ($this->fieldData as $key => $value)
        {
            $line = rawurlencode($key) . ': ' . rawurlencode($value);
            if (-1 == fwrite($this->sd, "$line\n"))
            {
                echo "Error writing $line\n";
                return;
            }
        }
        if (-1 == fwrite($this->sd, "END\n"))
        {
            echo "Error writing END\n";
            return;
        }
    }

    function Lucene($host, $port, $application)
    {
        $this->host = $host;
        $this->port = $port;
        $this->addField('Application', $application);
    }

    function get()
    {
        if (FALSE === ($line = fgets($this->sd, 1000000)))
        {
            echo "Error reading response header\n";
            return NULL;
        }
        $line = trim($line);
        
        if (strtoupper($line) == "END")
        {
            return FALSE;
        }
        $data = explode(':', $line, 2);
        $key = urldecode(trim($data[0]));
        $value = urldecode(trim($data[1]));

        if ($key == 'Error')
        {
            echo $value, "  <br> \n";
            $this->error = $value;
        }
        return array($key, $value);
    }

    function close()
    {
        fclose($this->sd);
        // sleep(1);
    }
}

class LuceneQuery extends Lucene
{
    function LuceneQuery($host, $port, $application)
    {
        $this->Lucene($host, $port, $application);
    }

    function setDefaultField($field)
    {
        $this->addField('Default-Field', $field);
    }

    function query($query)
    {
        $this->addField('Query', $query);
        $this->sendCommand('QUERY');

        if (FALSE === ($line = fgets($this->sd, 1000000)))
        {
            echo "Error reading response\n";
            return;
        }
        $this->response = strtoupper(trim($line));
        $this->results = array();
        $this->error = NULL;

        $data = $this->get();
        if (!isset($data))
            return;
        
        if (FALSE === $data)
            return;

        if (isset($this->error))
        {
            echo "<b><font color=\"red\">Error: ",
                htmlspecialchars($this->error),
            "</font></b>";
            // return;
        }
        
        $count = (int)$data[1];
        echo "Number of hits: $count    <br>\n";
        $data = $this->get();

        echo "<table border=1>";
        for (;FALSE !== $data;)
        {
            echo "<tr>";
            do
            {
                echo "<td>".htmlspecialchars($data[1])."</td>";
                $data = $this->get();
            } while (FALSE !== $data && $data[0] != 'I');
            echo "</tr> \n";
        }
        echo "</table>\n";
    }
}

class LuceneIndex extends Lucene
{
    var $values;
    var $response;
    
    function LuceneIndex($host, $port, $application, $id)
    {
        $this->Lucene($host, $port, $application);
        $this->addField('Id', $id);
    }

    function send()
    {
        $this->sendCommand('INDEX');
        if (FALSE === ($line = fgets($this->sd, 1000000)))
        {
            echo "Error reading response\n";
            return;
        }
        $this->response = strtoupper(trim($line));
        $this->values = array();
        $this->error = NULL;

        for (;;)
        {
            $data = $this->get();
            if (!isset($data))
                return;

            if (FALSE === $data)
                break;

            $this->values[$data[0]] = $data[1];
        }

        if (isset($this->error))
            echo $this->error;
    }

    function debug()
    {
        echo "$this->response   <br>\n";
        foreach ($this->values as $key => $value)
        {
            echo "$key: $value   <br>\n";
        }
    }
}

// $index = new LuceneIndex("localhost", 22222, "test", "phpTest");
// $index->addField("Published", time());
// $index->addField("Text", 'The quick brown fox jumped over the lazy dog');
// $index->send();
// $index->debug();
// $index->close;

set_time_limit(600);
$query = new LuceneQuery("localhost", 22222, "test");
$query->query("+malawi");
$query->close();

?>
