/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.IOException;
import java.io.Reader;
import nz.net.catalyst.lucene.server.IPackage;

public class FiniteReader
extends Reader
implements IPackage {
    private long remaining;
    private Reader in;

    public FiniteReader(Reader in, long contentLength) {
        this.in = in;
        this.remaining = contentLength >= 0L ? contentLength : 0L;
    }

    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        int result;
        if (this.remaining == -1L) {
            throw new IOException("Illegal operation after close()");
        }
        if (this.remaining == 0L) {
            return -1;
        }
        if ((long)len > this.remaining) {
            len = (int)this.remaining;
        }
        this.remaining = (result = this.in.read(cbuf, off, len)) == -1 || (long)result >= this.remaining ? 0L : (this.remaining -= (long)result);
        return result;
    }

    public synchronized boolean ready() throws IOException {
        if (this.remaining == -1L) {
            throw new IOException("Illegal operation after close()");
        }
        return this.remaining == 0L || this.in.ready();
    }

    public synchronized void close() throws IOException {
        long skipped = 0L;
        while (this.remaining > 0L) {
            skipped = this.skip(this.remaining);
            this.remaining -= skipped;
        }
        this.remaining = -1L;
    }
}

