/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;

import java.io.IOException;

import nz.net.catalyst.Log;
import nz.net.catalyst.Main;
import nz.net.catalyst.RtException;
import nz.net.catalyst.SocketListener;

//Only needed it using the thread pooling classes.
//import com.holub.asynch.Socket_server;

/**
 * Lucene Server main entry point.  <p>
 *
 * As a sub-class of {@link Main}, this will read in the Server.config
 * (if it exists) for a list of start-up classes (default: this class)
 * and then will execute those classes' Start(String[]) method. <p>
 *
 * I (Hamish) have changed the start method to use a normal class rather than an
 * anonomous class.  I have also expanded some lines to make them more readable
 * (IMHO).
 * @see nz.net.catalyst.SocketListener
 */

public class Server extends Main implements IPackage
{
  private static final Server instance = new Server();
  public  static final int LISTENER_PORT = 22222;
  private static final String PORT_PROPERTY = PACKAGE + "port";
  private static SocketListener listener;

  //public static nz.net.catalyst.lucene.cache.IndexSearcherCache isc = new nz.net.catalyst.lucene.cache.IndexSearcherCache(new java.io.File("/lucene/test/index"));
  /**
   * Read config file and start the system.
   */
  public static void main(String args[])
  {
    // Force the use of just a linefeed as a output line terminator.
    // This may not work, depending on how tricky Java gets.
    System.setProperty("line.terminator", new String(new char[]{12}));

    instance.init(args);
  }

  /**
   * Called by startup sequence.  Invoke a TCP Socket listener and
   * await connections.  Each connection will activate a new thread
   * under the control of a {@link Session} instance.
   *
   * @param args Command line parameters (currently ignored).
   */
  public static void Start(String[] args) throws Exception {
      
    Log.info("\tStarting LuceneServer version 1.1");
    System.err.println("Server (re)started (" + new java.util.Date() + ")");  
    
    //get the port
    int port = Integer.getInteger(PORT_PROPERTY, LISTENER_PORT).intValue();
				/*  //WE ARE NOT USING THE THREAD POOLING.
				 	//REASON: NO IMPROVEMENT IN PERFORMANCE (under linux) 
				    //this code should probably be in a static initialiser but here for now.
				    //set up the socket server.
				
				    Socket_server socket_server = new Socket_server
				                    (   port,
				                        20, //number of threads to open into the pool.
				                        SocketAction.class,
				                        new Socket_server.Death()
				                        {   public void action( Exception e )
				                            { // performed when server aborts or
				                              // is killed
				                              //do nothing.
				                            }
				                        }
				                    );
				     socket_server.start();
				*/    
    // HAMISH'S SIMPLE CODE:
    listener = new SocketListener(port, null);
				/*  //DEPRECATED COMPLEX CODE THAT MADE UNDERSTANDING EVERYTHING HARDER    
				    //create the client factory
				    IClientFactory cf = (IClientFactory) new ClientFactory();
				    //create the listener
				    SocketClient sc = new SocketClient(cf);
				    
				    listener = new SocketListener(port, sc);
				                        /*  NOTE: Unsure why this is here?!?! Maybe to override the getBufferedReader
				                         *        to        return the
				                         * encoding standard specified.  I was
				                         * confused by this code (hamish).
				                              {
				                                protected BufferedReader getBufferedReader(InputStream input)
				                                  throws IOException
				                                {
				                                  return new BufferedReader(new InputStreamReader(input, "UTF-8"));
				                                }
				                              }
				                         */
  

    try {
      //bind listener to the socket.
      listener.bind();
    } catch (IOException e) {
      Log.error("Unable to bind socket (to port " + port + ") on server startup.");
      throw new RtException("Unable to bind to socket on port " + port, e);
    }

    //start the listener thread to listen for incoming connections
    listener.startListener();
  }


}
